/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.VXU_V04_INSURANCE;
import ca.uhn.hl7v2.model.v28.group.VXU_V04_ORDER;
import ca.uhn.hl7v2.model.v28.group.VXU_V04_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v28.group.VXU_V04_PERSON_OBSERVATION;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.GT1;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.NK1;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class VXU_V04
extends AbstractMessage {
    public VXU_V04() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public VXU_V04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(ARV.class, false, true);
            this.add(VXU_V04_PATIENT_VISIT.class, false, false);
            this.add(GT1.class, false, true);
            this.add(VXU_V04_INSURANCE.class, false, true);
            this.add(VXU_V04_PERSON_OBSERVATION.class, false, true);
            this.add(VXU_V04_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXU_V04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public ARV getARV() {
        return (ARV)this.getTyped("ARV", ARV.class);
    }

    public ARV getARV(int rep) {
        return (ARV)this.getTyped("ARV", rep, ARV.class);
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", (Structure)structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public VXU_V04_PATIENT_VISIT getPATIENT_VISIT() {
        return (VXU_V04_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", VXU_V04_PATIENT_VISIT.class);
    }

    public GT1 getGT1() {
        return (GT1)this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return (GT1)this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public VXU_V04_INSURANCE getINSURANCE() {
        return (VXU_V04_INSURANCE)this.getTyped("INSURANCE", VXU_V04_INSURANCE.class);
    }

    public VXU_V04_INSURANCE getINSURANCE(int rep) {
        return (VXU_V04_INSURANCE)this.getTyped("INSURANCE", rep, VXU_V04_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<VXU_V04_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", VXU_V04_INSURANCE.class);
    }

    public void insertINSURANCE(VXU_V04_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public VXU_V04_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (VXU_V04_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public VXU_V04_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (VXU_V04_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public VXU_V04_PERSON_OBSERVATION getPERSON_OBSERVATION() {
        return (VXU_V04_PERSON_OBSERVATION)this.getTyped("PERSON_OBSERVATION", VXU_V04_PERSON_OBSERVATION.class);
    }

    public VXU_V04_PERSON_OBSERVATION getPERSON_OBSERVATION(int rep) {
        return (VXU_V04_PERSON_OBSERVATION)this.getTyped("PERSON_OBSERVATION", rep, VXU_V04_PERSON_OBSERVATION.class);
    }

    public int getPERSON_OBSERVATIONReps() {
        return this.getReps("PERSON_OBSERVATION");
    }

    public List<VXU_V04_PERSON_OBSERVATION> getPERSON_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PERSON_OBSERVATION", VXU_V04_PERSON_OBSERVATION.class);
    }

    public void insertPERSON_OBSERVATION(VXU_V04_PERSON_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PERSON_OBSERVATION", (Structure)structure, rep);
    }

    public VXU_V04_PERSON_OBSERVATION insertPERSON_OBSERVATION(int rep) throws HL7Exception {
        return (VXU_V04_PERSON_OBSERVATION)super.insertRepetition("PERSON_OBSERVATION", rep);
    }

    public VXU_V04_PERSON_OBSERVATION removePERSON_OBSERVATION(int rep) throws HL7Exception {
        return (VXU_V04_PERSON_OBSERVATION)super.removeRepetition("PERSON_OBSERVATION", rep);
    }

    public VXU_V04_ORDER getORDER() {
        return (VXU_V04_ORDER)this.getTyped("ORDER", VXU_V04_ORDER.class);
    }

    public VXU_V04_ORDER getORDER(int rep) {
        return (VXU_V04_ORDER)this.getTyped("ORDER", rep, VXU_V04_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<VXU_V04_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", VXU_V04_ORDER.class);
    }

    public void insertORDER(VXU_V04_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public VXU_V04_ORDER insertORDER(int rep) throws HL7Exception {
        return (VXU_V04_ORDER)super.insertRepetition("ORDER", rep);
    }

    public VXU_V04_ORDER removeORDER(int rep) throws HL7Exception {
        return (VXU_V04_ORDER)super.removeRepetition("ORDER", rep);
    }
}

