/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CP;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.MO;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRC
extends AbstractSegment {
    public PRC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Primary Key Value - PRC");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Facility ID - PRC");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Department");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Valid Patient Classes");
            this.add(CP.class, false, 0, 0, new Object[]{this.getMessage()}, "Price");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Formula");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Minimum Quantity");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Maximum Quantity");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Minimum Price");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Maximum Price");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Start Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective End Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Price Override Flag");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Billing Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Chargeable Flag");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Cost");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Charge on Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getPrimaryKeyValuePRC() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getPrc1_PrimaryKeyValuePRC() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getFacilityIDPRC() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPrc2_FacilityIDPRC() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public int getFacilityIDPRCReps() {
        return this.getReps(2);
    }

    public CWE getFacilityIDPRC(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getPrc2_FacilityIDPRC(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPrc2_FacilityIDPRCReps() {
        return this.getReps(2);
    }

    public CWE insertFacilityIDPRC(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertPrc2_FacilityIDPRC(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeFacilityIDPRC(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removePrc2_FacilityIDPRC(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE[] getDepartment() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPrc3_Department() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public int getDepartmentReps() {
        return this.getReps(3);
    }

    public CWE getDepartment(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getPrc3_Department(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPrc3_DepartmentReps() {
        return this.getReps(3);
    }

    public CWE insertDepartment(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertPrc3_Department(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeDepartment(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removePrc3_Department(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE[] getValidPatientClasses() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPrc4_ValidPatientClasses() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public int getValidPatientClassesReps() {
        return this.getReps(4);
    }

    public CWE getValidPatientClasses(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getPrc4_ValidPatientClasses(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPrc4_ValidPatientClassesReps() {
        return this.getReps(4);
    }

    public CWE insertValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertPrc4_ValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removePrc4_ValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CP[] getPrice() {
        CP[] retVal = (CP[])this.getTypedField(5, (Type[])new CP[0]);
        return retVal;
    }

    public CP[] getPrc5_Price() {
        CP[] retVal = (CP[])this.getTypedField(5, (Type[])new CP[0]);
        return retVal;
    }

    public int getPriceReps() {
        return this.getReps(5);
    }

    public CP getPrice(int rep) {
        CP retVal = (CP)this.getTypedField(5, rep);
        return retVal;
    }

    public CP getPrc5_Price(int rep) {
        CP retVal = (CP)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPrc5_PriceReps() {
        return this.getReps(5);
    }

    public CP insertPrice(int rep) throws HL7Exception {
        return (CP)super.insertRepetition(5, rep);
    }

    public CP insertPrc5_Price(int rep) throws HL7Exception {
        return (CP)super.insertRepetition(5, rep);
    }

    public CP removePrice(int rep) throws HL7Exception {
        return (CP)super.removeRepetition(5, rep);
    }

    public CP removePrc5_Price(int rep) throws HL7Exception {
        return (CP)super.removeRepetition(5, rep);
    }

    public ST[] getFormula() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getPrc6_Formula() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public int getFormulaReps() {
        return this.getReps(6);
    }

    public ST getFormula(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getPrc6_Formula(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPrc6_FormulaReps() {
        return this.getReps(6);
    }

    public ST insertFormula(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertPrc6_Formula(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeFormula(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removePrc6_Formula(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public NM getMinimumQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPrc7_MinimumQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getMaximumQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getPrc8_MaximumQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public MO getMinimumPrice() {
        MO retVal = (MO)this.getTypedField(9, 0);
        return retVal;
    }

    public MO getPrc9_MinimumPrice() {
        MO retVal = (MO)this.getTypedField(9, 0);
        return retVal;
    }

    public MO getMaximumPrice() {
        MO retVal = (MO)this.getTypedField(10, 0);
        return retVal;
    }

    public MO getPrc10_MaximumPrice() {
        MO retVal = (MO)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getEffectiveStartDate() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getPrc11_EffectiveStartDate() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getEffectiveEndDate() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getPrc12_EffectiveEndDate() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getPriceOverrideFlag() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPrc13_PriceOverrideFlag() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE[] getBillingCategory() {
        CWE[] retVal = (CWE[])this.getTypedField(14, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPrc14_BillingCategory() {
        CWE[] retVal = (CWE[])this.getTypedField(14, (Type[])new CWE[0]);
        return retVal;
    }

    public int getBillingCategoryReps() {
        return this.getReps(14);
    }

    public CWE getBillingCategory(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public CWE getPrc14_BillingCategory(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPrc14_BillingCategoryReps() {
        return this.getReps(14);
    }

    public CWE insertBillingCategory(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE insertPrc14_BillingCategory(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE removeBillingCategory(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public CWE removePrc14_BillingCategory(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public ID getChargeableFlag() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getPrc15_ChargeableFlag() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getPrc16_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public MO getCost() {
        MO retVal = (MO)this.getTypedField(17, 0);
        return retVal;
    }

    public MO getPrc17_Cost() {
        MO retVal = (MO)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getChargeOnIndicator() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getPrc18_ChargeOnIndicator() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CP(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new MO(this.getMessage());
            }
            case 9: {
                return new MO(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new DTM(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 16: {
                return new MO(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

