/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.ColorPanel;
import ij.gui.GenericDialog;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ColorChooser
implements TextListener,
AdjustmentListener {
    Vector colors;
    Vector sliders;
    ColorPanel panel;
    Color initialColor;
    int red;
    int green;
    int blue;
    boolean useHSB;
    String title;

    public ColorChooser(String title, Color initialColor, boolean useHSB) {
        this.title = title;
        if (initialColor == null) {
            initialColor = Color.black;
        }
        this.initialColor = initialColor;
        this.red = initialColor.getRed();
        this.green = initialColor.getGreen();
        this.blue = initialColor.getBlue();
        this.useHSB = useHSB;
    }

    public Color getColor() {
        int i;
        GenericDialog gd = new GenericDialog(this.title);
        gd.addSlider("Red:", 0.0, 255.0, this.red);
        gd.addSlider("Green:", 0.0, 255.0, this.green);
        gd.addSlider("Blue:", 0.0, 255.0, this.blue);
        this.panel = new ColorPanel(this.initialColor);
        gd.addPanel(this.panel, 10, new Insets(10, 0, 0, 0));
        this.colors = gd.getNumericFields();
        for (i = 0; i < this.colors.size(); ++i) {
            ((TextField)this.colors.elementAt(i)).addTextListener(this);
        }
        this.sliders = gd.getSliders();
        for (i = 0; i < this.sliders.size(); ++i) {
            ((Scrollbar)this.sliders.elementAt(i)).addAdjustmentListener(this);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        int red = (int)gd.getNextNumber();
        int green = (int)gd.getNextNumber();
        int blue = (int)gd.getNextNumber();
        return new Color(red, green, blue);
    }

    public void textValueChanged(TextEvent e) {
        int red = (int)Tools.parseDouble(((TextField)this.colors.elementAt(0)).getText());
        int green = (int)Tools.parseDouble(((TextField)this.colors.elementAt(1)).getText());
        int blue = (int)Tools.parseDouble(((TextField)this.colors.elementAt(2)).getText());
        if (red < 0) {
            red = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (blue > 255) {
            blue = 255;
        }
        this.panel.setColor(new Color(red, green, blue));
        this.panel.repaint();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.sliders.size(); ++i) {
            if (source != this.sliders.elementAt(i)) continue;
            Scrollbar sb = (Scrollbar)source;
            TextField tf = (TextField)this.colors.elementAt(i);
        }
    }
}

