/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class StackLabeler
implements ExtendedPlugInFilter,
DialogListener {
    private static final int flags = 63;
    private ImagePlus imp;
    private double time;
    private static int x = 5;
    private static int y = 20;
    private static int fontSize = 18;
    private int maxWidth;
    private Font font;
    private static double start = 0.0;
    private static double interval = 1.0;
    private static String text = "";
    private static int decimalPlaces = 0;
    private static boolean textBeforeNumber;
    private int fieldWidth;
    private Color color;

    public int setup(String arg, ImagePlus imp) {
        if (imp != null && imp.isHyperStack()) {
            IJ.error("StackLabeler", "This command does not currently work with hyperstacks.");
            return 4096;
        }
        this.imp = imp;
        return 63;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
            fontSize = (int)(((double)roi.height - 1.10526) / 0.934211);
            if (fontSize < 7) {
                fontSize = 7;
            }
            if (fontSize > 80) {
                fontSize = 80;
            }
        }
        GenericDialog gd = new GenericDialog("StackLabeler");
        gd.setInsets(2, 5, 0);
        gd.addStringField("Starting value:", IJ.d2s(start, decimalPlaces));
        gd.addStringField("Interval:", "" + IJ.d2s(interval, decimalPlaces));
        gd.addNumericField("X location:", x, 0);
        gd.addNumericField("Y location:", y, 0);
        gd.addNumericField("Font size:", fontSize, 0);
        gd.addStringField("Text:", text, 10);
        gd.setInsets(10, 20, 0);
        gd.addCheckbox("Text first", textBeforeNumber);
        gd.addPreviewCheckbox(pfr);
        gd.addHelp("http://rsb.info.nih.gov/ij/docs/menus/image.html#label");
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        return 63;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        start = Tools.parseDouble(gd.getNextString());
        String str = gd.getNextString();
        interval = Tools.parseDouble(str);
        x = (int)gd.getNextNumber();
        y = (int)gd.getNextNumber();
        fontSize = (int)gd.getNextNumber();
        text = gd.getNextString();
        textBeforeNumber = gd.getNextBoolean();
        int index = str.indexOf(".");
        decimalPlaces = index != -1 ? str.length() - index - 1 : 0;
        if (gd.invalidNumber()) {
            return false;
        }
        this.font = new Font("SansSerif", 0, fontSize);
        this.time = start;
        if (y < fontSize) {
            y = fontSize + 5;
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(this.font);
        int stackSize = this.imp.getStackSize();
        this.maxWidth = ip.getStringWidth(this.getString(start + interval * (double)stackSize));
        this.fieldWidth = 1;
        if (stackSize >= 10) {
            this.fieldWidth = 2;
        }
        if (stackSize >= 100) {
            this.fieldWidth = 3;
        }
        if (stackSize >= 1000) {
            this.fieldWidth = 4;
        }
        if (stackSize >= 10000) {
            this.fieldWidth = 5;
        }
        return true;
    }

    public void run(ImageProcessor ip) {
        ip.setFont(this.font);
        String s = this.getString(this.time);
        int textWidth = ip.getStringWidth(s);
        if (this.color == null) {
            this.color = Toolbar.getForegroundColor();
            if ((this.color.getRGB() & 0xFFFFFF) == 0) {
                ip.setRoi(x, y - fontSize, this.maxWidth + textWidth, fontSize);
                double mean = ImageStatistics.getStatistics((ImageProcessor)ip, (int)2, null).mean;
                if (mean < 50.0 && !ip.isInvertedLut()) {
                    this.color = Color.white;
                }
                ip.resetRoi();
            }
        }
        ip.setColor(this.color);
        ip.setAntialiasedText(fontSize >= 18);
        ip.moveTo(x + this.maxWidth - textWidth, y);
        ip.drawString(s);
        this.time += interval;
    }

    String getString(double time) {
        if (interval == 0.0) {
            return text;
        }
        if (textBeforeNumber && decimalPlaces == 0) {
            return text + this.zeroFill((int)time);
        }
        if (textBeforeNumber) {
            return text + IJ.d2s(time, decimalPlaces);
        }
        return IJ.d2s(time, decimalPlaces) + " " + text;
    }

    String zeroFill(int n) {
        String str = "" + n;
        while (str.length() < this.fieldWidth) {
            str = "0" + str;
        }
        return str;
    }

    public void setNPasses(int nPasses) {
    }
}

