/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.serverlog;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ForbiddenException;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.plugins.DashboardTabPlugin;
import com.mirth.connect.plugins.DashboardTablePlugin;
import com.mirth.connect.plugins.serverlog.ServerLogItem;
import com.mirth.connect.plugins.serverlog.ServerLogPanel;
import com.mirth.connect.plugins.serverlog.ServerLogServletInterface;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class ServerLogClient
extends DashboardTabPlugin {
    private ServerLogPanel serverLogPanel;
    private LinkedList<ServerLogItem> serverLogs = new LinkedList();
    private static final ServerLogItem unauthorizedLog = new ServerLogItem("You are not authorized to view the server log.");
    private int currentServerLogSize;
    private boolean receivedNewLogs;
    private Long lastLogId;
    private String currentServerId;

    public ServerLogClient(String name) {
        super(name);
        this.serverLogPanel = new ServerLogPanel(this);
        this.currentServerLogSize = this.serverLogPanel.getCurrentServerLogSize();
    }

    public void clearLog() {
        this.serverLogs.clear();
        this.serverLogPanel.updateTable(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetServerLogSize(int newServerLogSize) {
        if (newServerLogSize < this.currentServerLogSize) {
            ServerLogClient serverLogClient = this;
            synchronized (serverLogClient) {
                while (newServerLogSize < this.serverLogs.size()) {
                    this.serverLogs.removeLast();
                }
            }
            this.serverLogPanel.updateTable(this.serverLogs);
        }
        this.currentServerLogSize = newServerLogSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareData() throws ClientException {
        this.receivedNewLogs = false;
        if (!this.serverLogPanel.isPaused()) {
            List serverLogReceived = new ArrayList();
            try {
                serverLogReceived = ((ServerLogServletInterface)PlatformUI.MIRTH_FRAME.mirthClient.getServlet(ServerLogServletInterface.class)).getServerLogs(this.currentServerLogSize, this.lastLogId);
            }
            catch (ClientException e) {
                if (e instanceof ForbiddenException) {
                    LinkedList<ServerLogItem> unauthorizedLogs = new LinkedList<ServerLogItem>();
                    if (this.serverLogs.isEmpty() || !this.serverLogs.getLast().equals(unauthorizedLog)) {
                        unauthorizedLogs.add(unauthorizedLog);
                    }
                    serverLogReceived = unauthorizedLogs;
                    this.parent.alertThrowable((Component)this.parent, (Throwable)e, false);
                }
                throw e;
            }
            if (serverLogReceived.size() > 0) {
                this.receivedNewLogs = true;
                ServerLogItem latestItem = (ServerLogItem)serverLogReceived.get(0);
                if (latestItem.getId() != null && latestItem.getId() > 0L) {
                    this.lastLogId = latestItem.getId();
                }
                ServerLogClient serverLogClient = this;
                synchronized (serverLogClient) {
                    for (int i = serverLogReceived.size() - 1; i >= 0; --i) {
                        while (this.currentServerLogSize <= this.serverLogs.size()) {
                            this.serverLogs.removeLast();
                        }
                        this.serverLogs.addFirst((ServerLogItem)serverLogReceived.get(i));
                    }
                }
            }
        }
    }

    public void prepareData(List<DashboardStatus> statuses) throws ClientException {
        this.prepareData();
    }

    public void update() {
        DashboardTablePlugin plugin;
        boolean serverIdChanged = false;
        String serverId = null;
        Iterator iterator = LoadedExtensions.getInstance().getDashboardTablePlugins().values().iterator();
        while (iterator.hasNext() && (serverId = (plugin = (DashboardTablePlugin)iterator.next()).getServerId()) == null) {
        }
        if (this.currentServerId != serverId) {
            this.currentServerId = serverId;
            serverIdChanged = true;
        }
        if (!this.serverLogPanel.isPaused() && (this.receivedNewLogs || serverIdChanged)) {
            this.serverLogPanel.updateTable(this.serverLogs);
        }
    }

    public void update(List<DashboardStatus> statuses) {
        this.update();
    }

    public JComponent getTabComponent() {
        return this.serverLogPanel;
    }

    public void start() {
    }

    public void stop() {
        this.reset();
    }

    public void reset() {
        this.clearLog();
    }

    public String getPluginPointName() {
        return "Server Log";
    }
}

