/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.doc;

import com.mirth.connect.connectors.doc.Unit;
import org.apache.commons.lang3.text.WordUtils;

public enum PageSize {
    LETTER(8.5f, 11.0f, Unit.INCHES),
    LEGAL(8.5f, 14.0f, Unit.INCHES),
    LEDGER(11.0f, 17.0f, Unit.INCHES),
    TABLOID(17.0f, 11.0f, Unit.INCHES),
    EXECUTIVE(7.25f, 10.55f, Unit.INCHES),
    ANSI_C(22.0f, 17.0f, Unit.INCHES, "ANSI C"),
    ANSI_D(34.0f, 22.0f, Unit.INCHES, "ANSI D"),
    ANSI_E(44.0f, 34.0f, Unit.INCHES, "ANSI E"),
    A0(841.0f, 1189.0f, Unit.MM),
    A1(594.0f, 841.0f, Unit.MM),
    A2(420.0f, 594.0f, Unit.MM),
    A3(297.0f, 420.0f, Unit.MM),
    A4(210.0f, 297.0f, Unit.MM),
    A5(148.0f, 210.0f, Unit.MM),
    A6(105.0f, 148.0f, Unit.MM),
    A7(74.0f, 105.0f, Unit.MM),
    A8(52.0f, 74.0f, Unit.MM),
    A9(37.0f, 52.0f, Unit.MM),
    A10(26.0f, 37.0f, Unit.MM),
    B0(1000.0f, 1414.0f, Unit.MM),
    B1(707.0f, 1000.0f, Unit.MM),
    B2(500.0f, 707.0f, Unit.MM),
    B3(353.0f, 500.0f, Unit.MM),
    B4(250.0f, 343.0f, Unit.MM),
    B5(176.0f, 250.0f, Unit.MM),
    B6(125.0f, 176.0f, Unit.MM),
    B7(88.0f, 125.0f, Unit.MM),
    B8(62.0f, 88.0f, Unit.MM),
    B9(44.0f, 62.0f, Unit.MM),
    B10(31.0f, 44.0f, Unit.MM),
    CUSTOM(0.0f, 0.0f, Unit.MM);

    private float width;
    private float height;
    private Unit unit;
    private String name;

    private PageSize(float width, float height, Unit unit) {
        this(width, height, unit, null);
    }

    private PageSize(float width, float height, Unit unit, String name) {
        this.width = width;
        this.height = height;
        this.unit = unit;
        this.name = name;
    }

    public double getWidth() {
        return this.width;
    }

    public double getWidth(Unit unit) {
        return this.unit.convertTo(this.width, unit);
    }

    public double getHeight() {
        return this.height;
    }

    public double getHeight(Unit unit) {
        return this.unit.convertTo(this.height, unit);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return WordUtils.capitalizeFully((String)super.toString().replace("_", " "));
    }
}

