/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.doc;

public enum Unit {
    INCHES("in"),
    MM("mm"),
    TWIPS("twips");

    private String value;

    private Unit(String value) {
        this.value = value;
    }

    public double convertTo(double value, Unit unit) {
        return this.getConversionRate(unit) * value;
    }

    private double getConversionRate(Unit unit) {
        if (this == INCHES) {
            if (unit == MM) {
                return 25.4;
            }
            if (unit == TWIPS) {
                return 1440.0;
            }
        } else if (this == MM) {
            if (unit == INCHES) {
                return 0.03937007874015748;
            }
            if (unit == TWIPS) {
                return 56.69291338582678;
            }
        } else {
            if (unit == INCHES) {
                return 6.944444444444445E-4;
            }
            if (unit == MM) {
                return 0.017638888888888888;
            }
        }
        return 1.0;
    }

    public String toString() {
        return this.value;
    }
}

