/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.model.AbstractSettings;
import com.mirth.connect.model.Auditable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@XStreamAlias(value="encryptionSettings")
public class EncryptionSettings
extends AbstractSettings
implements Serializable,
Auditable {
    private static final long serialVersionUID = 1L;
    public static final String ENCRYPTION_PREFIX = "{enc}";
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String DEFAULT_ENCRYPTION_CHARSET = "UTF-8";
    public static final Integer DEFAULT_ENCRYPTION_KEY_LENGTH = 128;
    public static final String DEFAULT_DIGEST_ALGORITHM = "PBKDF2WithHmacSHA256";
    public static final Integer DEFAULT_DIGEST_SALT_SIZE = 8;
    public static final Integer DEFAULT_DIGEST_ITERATIONS = 600000;
    public static final Boolean DEFAULT_DIGEST_USE_PBE = true;
    public static final Integer DEFAULT_DIGEST_KEY_SIZE = 256;
    public static final String DEFAULT_SECURITY_PROVIDER = BouncyCastleProvider.class.getName();
    private static final String ENCRYPTION_EXPORT = "encryption.export";
    private static final String ENCRYPTION_PROPERTIES = "encryption.properties";
    private static final String ENCRYPTION_ALGORITHM = "encryption.algorithm";
    private static final String ENCRYPTION_CHARSET = "encryption.charset";
    private static final String ENCRYPTION_FALLBACK_ALGORITHM = "encryption.fallback.algorithm";
    private static final String ENCRYPTION_FALLBACK_CHARSET = "encryption.fallback.charset";
    private static final String ENCRYPTION_KEY_LENGTH = "encryption.keylength";
    private static final String DIGEST_ALGORITHM = "digest.algorithm";
    private static final String DIGEST_SALT_SIZE = "digest.saltsizeinbytes";
    private static final String DIGEST_ITERATIONS = "digest.iterations";
    private static final String DIGEST_USE_PBE = "digest.usepbe";
    private static final String DIGEST_KEY_SIZE = "digest.keysizeinbits";
    private static final String DIGEST_FALLBACK_ALGORITHM = "digest.fallback.algorithm";
    private static final String DIGEST_FALLBACK_SALT_SIZE = "digest.fallback.saltsizeinbytes";
    private static final String DIGEST_FALLBACK_ITERATIONS = "digest.fallback.iterations";
    private static final String DIGEST_FALLBACK_USE_PBE = "digest.fallback.usepbe";
    private static final String DIGEST_FALLBACK_KEY_SIZE = "digest.fallback.keysizeinbits";
    private static final String SECURITY_PROVIDER = "security.provider";
    private Boolean encryptExport;
    private Boolean encryptProperties;
    private String encryptionAlgorithm;
    private String encryptionCharset;
    private String encryptionFallbackAlgorithm;
    private String encryptionFallbackCharset;
    private Integer encryptionKeyLength;
    private String digestAlgorithm;
    private Integer digestSaltSize;
    private Integer digestIterations;
    private Boolean digestUsePBE;
    private Integer digestKeySize;
    private String digestFallbackAlgorithm;
    private Integer digestFallbackSaltSize;
    private Integer digestFallbackIterations;
    private Boolean digestFallbackUsePBE;
    private Integer digestFallbackKeySize;
    private String securityProvider;
    private byte[] secretKey;

    public EncryptionSettings() {
    }

    public EncryptionSettings(Properties properties) {
        this.setProperties(properties);
    }

    public Boolean getEncryptExport() {
        return this.encryptExport;
    }

    public void setEncryptExport(Boolean encryptExport) {
        this.encryptExport = encryptExport;
    }

    public Boolean getEncryptProperties() {
        return this.encryptProperties;
    }

    public void setEncryptProperties(Boolean encryptProperties) {
        this.encryptProperties = encryptProperties;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getEncryptionBaseAlgorithm() {
        int index;
        if (StringUtils.isNotBlank((CharSequence)this.encryptionAlgorithm) && (index = StringUtils.indexOf((CharSequence)this.encryptionAlgorithm, (int)47)) >= 0) {
            return this.encryptionAlgorithm.substring(0, index);
        }
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getEncryptionCharset() {
        return this.encryptionCharset;
    }

    public void setEncryptionCharset(String encryptionCharset) {
        this.encryptionCharset = encryptionCharset;
    }

    public String getEncryptionFallbackAlgorithm() {
        return this.encryptionFallbackAlgorithm;
    }

    public void setEncryptionFallbackAlgorithm(String encryptionFallbackAlgorithm) {
        this.encryptionFallbackAlgorithm = encryptionFallbackAlgorithm;
    }

    public String getEncryptionFallbackCharset() {
        return this.encryptionFallbackCharset;
    }

    public void setEncryptionFallbackCharset(String encryptionFallbackCharset) {
        this.encryptionFallbackCharset = encryptionFallbackCharset;
    }

    public Integer getEncryptionKeyLength() {
        return this.encryptionKeyLength;
    }

    public void setEncryptionKeyLength(Integer encryptionKeyLength) {
        this.encryptionKeyLength = encryptionKeyLength;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public Integer getDigestSaltSize() {
        return this.digestSaltSize;
    }

    public void setDigestSaltSize(Integer digestSaltSize) {
        this.digestSaltSize = digestSaltSize;
    }

    public Integer getDigestIterations() {
        return this.digestIterations;
    }

    public void setDigestIterations(Integer digestIterations) {
        this.digestIterations = digestIterations;
    }

    public Boolean getDigestUsePBE() {
        return this.digestUsePBE;
    }

    public void setDigestUsePBE(Boolean digestUsePBE) {
        this.digestUsePBE = digestUsePBE;
    }

    public Integer getDigestKeySize() {
        return this.digestKeySize;
    }

    public void setDigestKeySize(Integer digestKeySize) {
        this.digestKeySize = digestKeySize;
    }

    public String getDigestFallbackAlgorithm() {
        return this.digestFallbackAlgorithm;
    }

    public void setDigestFallbackAlgorithm(String digestFallbackAlgorithm) {
        this.digestFallbackAlgorithm = digestFallbackAlgorithm;
    }

    public Integer getDigestFallbackSaltSize() {
        return this.digestFallbackSaltSize;
    }

    public void setDigestFallbackSaltSize(Integer digestFallbackSaltSize) {
        this.digestFallbackSaltSize = digestFallbackSaltSize;
    }

    public Integer getDigestFallbackIterations() {
        return this.digestFallbackIterations;
    }

    public void setDigestFallbackIterations(Integer digestFallbackIterations) {
        this.digestFallbackIterations = digestFallbackIterations;
    }

    public Boolean getDigestFallbackUsePBE() {
        return this.digestFallbackUsePBE;
    }

    public void setDigestFallbackUsePBE(Boolean digestFallbackUsePBE) {
        this.digestFallbackUsePBE = digestFallbackUsePBE;
    }

    public Integer getDigestFallbackKeySize() {
        return this.digestFallbackKeySize;
    }

    public void setDigestFallbackKeySize(Integer digestFallbackKeySize) {
        this.digestFallbackKeySize = digestFallbackKeySize;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public void setProperties(Properties properties) {
        this.setEncryptExport(this.intToBooleanObject(properties.getProperty(ENCRYPTION_EXPORT), false));
        this.setEncryptProperties(this.intToBooleanObject(properties.getProperty(ENCRYPTION_PROPERTIES), false));
        this.setEncryptionAlgorithm(properties.getProperty(ENCRYPTION_ALGORITHM, DEFAULT_ENCRYPTION_ALGORITHM));
        this.setEncryptionCharset(properties.getProperty(ENCRYPTION_CHARSET, DEFAULT_ENCRYPTION_CHARSET));
        this.setEncryptionFallbackAlgorithm(properties.getProperty(ENCRYPTION_FALLBACK_ALGORITHM, "AES"));
        this.setEncryptionFallbackCharset(properties.getProperty(ENCRYPTION_FALLBACK_CHARSET, DEFAULT_ENCRYPTION_CHARSET));
        this.setEncryptionKeyLength(this.toIntegerObject(properties.getProperty(ENCRYPTION_KEY_LENGTH), DEFAULT_ENCRYPTION_KEY_LENGTH));
        this.setDigestAlgorithm(properties.getProperty(DIGEST_ALGORITHM, DEFAULT_DIGEST_ALGORITHM));
        this.setDigestSaltSize(this.toIntegerObject(properties.getProperty(DIGEST_SALT_SIZE), DEFAULT_DIGEST_SALT_SIZE));
        this.setDigestIterations(this.toIntegerObject(properties.getProperty(DIGEST_ITERATIONS), DEFAULT_DIGEST_ITERATIONS));
        this.setDigestUsePBE(this.intToBooleanObject(properties.getProperty(DIGEST_USE_PBE), DEFAULT_DIGEST_USE_PBE));
        this.setDigestKeySize(this.toIntegerObject(properties.getProperty(DIGEST_KEY_SIZE), DEFAULT_DIGEST_KEY_SIZE));
        this.setDigestFallbackAlgorithm(properties.getProperty(DIGEST_FALLBACK_ALGORITHM, "SHA256"));
        this.setDigestFallbackSaltSize(this.toIntegerObject(properties.getProperty(DIGEST_FALLBACK_SALT_SIZE), 8));
        this.setDigestFallbackIterations(this.toIntegerObject(properties.getProperty(DIGEST_FALLBACK_ITERATIONS), 1000));
        this.setDigestFallbackUsePBE(this.intToBooleanObject(properties.getProperty(DIGEST_FALLBACK_USE_PBE), false));
        this.setDigestFallbackKeySize(this.toIntegerObject(properties.getProperty(DIGEST_FALLBACK_KEY_SIZE), 256));
        this.setSecurityProvider(properties.getProperty(SECURITY_PROVIDER, DEFAULT_SECURITY_PROVIDER));
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.getEncryptExport() != null) {
            properties.put(ENCRYPTION_EXPORT, this.getEncryptExport());
        }
        if (this.getEncryptProperties() != null) {
            properties.put(ENCRYPTION_PROPERTIES, this.getEncryptProperties());
        }
        if (this.getEncryptionAlgorithm() != null) {
            properties.put(ENCRYPTION_ALGORITHM, this.getEncryptionAlgorithm());
        }
        if (this.getEncryptionCharset() != null) {
            properties.put(ENCRYPTION_CHARSET, this.getEncryptionCharset());
        }
        if (this.getEncryptionFallbackAlgorithm() != null) {
            properties.put(ENCRYPTION_FALLBACK_ALGORITHM, this.getEncryptionFallbackAlgorithm());
        }
        if (this.getEncryptionFallbackCharset() != null) {
            properties.put(ENCRYPTION_FALLBACK_CHARSET, this.getEncryptionFallbackCharset());
        }
        if (this.getEncryptionKeyLength() != null) {
            properties.put(ENCRYPTION_KEY_LENGTH, this.getEncryptionKeyLength().toString());
        }
        if (this.getDigestAlgorithm() != null) {
            properties.put(DIGEST_ALGORITHM, this.getDigestAlgorithm());
        }
        if (this.getDigestSaltSize() != null) {
            properties.put(DIGEST_SALT_SIZE, this.getDigestSaltSize());
        }
        if (this.getDigestIterations() != null) {
            properties.put(DIGEST_ITERATIONS, this.getDigestIterations());
        }
        if (this.getDigestUsePBE() != null) {
            properties.put(DIGEST_USE_PBE, this.getDigestUsePBE());
        }
        if (this.getDigestKeySize() != null) {
            properties.put(DIGEST_KEY_SIZE, this.getDigestKeySize());
        }
        if (this.getDigestFallbackAlgorithm() != null) {
            properties.put(DIGEST_FALLBACK_ALGORITHM, this.getDigestFallbackAlgorithm());
        }
        if (this.getDigestFallbackSaltSize() != null) {
            properties.put(DIGEST_FALLBACK_SALT_SIZE, this.getDigestFallbackSaltSize());
        }
        if (this.getDigestFallbackIterations() != null) {
            properties.put(DIGEST_FALLBACK_ITERATIONS, this.getDigestFallbackIterations());
        }
        if (this.getDigestFallbackUsePBE() != null) {
            properties.put(DIGEST_FALLBACK_USE_PBE, this.getDigestFallbackUsePBE());
        }
        if (this.getDigestFallbackKeySize() != null) {
            properties.put(DIGEST_FALLBACK_KEY_SIZE, this.getDigestFallbackKeySize());
        }
        if (this.getSecurityProvider() != null) {
            properties.put(SECURITY_PROVIDER, this.getSecurityProvider());
        }
        return properties;
    }

    @Override
    public String toAuditString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

