/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.Auditable;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ResourcePropertiesList;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.directoryresource.DirectoryResourceProperties;
import com.mirth.connect.util.ColorUtil;
import com.mirth.connect.util.ConfigurationProperty;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Color;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.swing.text.DateFormatter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@XStreamAlias(value="serverConfiguration")
public class ServerConfiguration
implements Serializable,
Migratable,
Auditable {
    private String date;
    private List<ChannelGroup> channelGroups = null;
    private List<Channel> channels = null;
    private Set<ChannelTag> channelTags = null;
    private List<User> users = null;
    private List<AlertModel> alerts = null;
    private List<CodeTemplateLibrary> codeTemplateLibraries = null;
    private ServerSettings serverSettings = null;
    private UpdateSettings updateSettings = null;
    private Map<String, String> globalScripts = null;
    private Map<String, Properties> pluginProperties = null;
    private ResourcePropertiesList resourceProperties = null;
    private Set<ChannelDependency> channelDependencies = null;
    private Map<String, ConfigurationProperty> configurationMap = null;

    public List<AlertModel> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(List<AlertModel> alerts) {
        this.alerts = alerts;
    }

    public List<ChannelGroup> getChannelGroups() {
        return this.channelGroups;
    }

    public void setChannelGroups(List<ChannelGroup> channelGroups) {
        this.channelGroups = channelGroups;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public Set<ChannelTag> getChannelTags() {
        return this.channelTags;
    }

    public void setChannelTags(Set<ChannelTag> channelTags) {
        this.channelTags = channelTags;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public UpdateSettings getUpdateSettings() {
        return this.updateSettings;
    }

    public void setUpdateSettings(UpdateSettings updateSettings) {
        this.updateSettings = updateSettings;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public List<CodeTemplateLibrary> getCodeTemplateLibraries() {
        return this.codeTemplateLibraries;
    }

    public void setCodeTemplateLibraries(List<CodeTemplateLibrary> codeTemplateLibraries) {
        this.codeTemplateLibraries = codeTemplateLibraries;
    }

    public Map<String, String> getGlobalScripts() {
        return this.globalScripts;
    }

    public void setGlobalScripts(Map<String, String> globalScripts) {
        this.globalScripts = globalScripts;
    }

    public Map<String, Properties> getPluginProperties() {
        return this.pluginProperties;
    }

    public void setPluginProperties(Map<String, Properties> pluginProperties) {
        this.pluginProperties = pluginProperties;
    }

    public ResourcePropertiesList getResourceProperties() {
        return this.resourceProperties;
    }

    public void setResourceProperties(ResourcePropertiesList resourceProperties) {
        this.resourceProperties = resourceProperties;
    }

    public Set<ChannelDependency> getChannelDependencies() {
        return this.channelDependencies;
    }

    public void setChannelDependencies(Set<ChannelDependency> channelDependencies) {
        this.channelDependencies = channelDependencies;
    }

    public Map<String, ConfigurationProperty> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<String, ConfigurationProperty> configurationMap) {
        this.configurationMap = configurationMap;
    }

    @Override
    public String toAuditString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append('[');
        builder.append("environmentName=").append(this.serverSettings.getEnvironmentName()).append(", ");
        builder.append("serverName=").append(this.serverSettings.getServerName()).append(", ");
        builder.append("date=").append(this.date).append(", ");
        builder.append("Number of channels=").append(CollectionUtils.size(this.channels)).append(", ");
        builder.append("Number of channel groups=").append(CollectionUtils.size(this.channelGroups)).append(", ");
        builder.append("Number of users=").append(CollectionUtils.size(this.users)).append(", ");
        builder.append("Number of alerts=").append(CollectionUtils.size(this.alerts)).append(", ");
        if (this.resourceProperties != null) {
            builder.append("Number of resource properties=").append(CollectionUtils.size(this.resourceProperties.getList())).append(", ");
        }
        builder.append("channelDependencies=").append(this.channelDependencies).append(", ");
        builder.append("Number of code template libraries=").append(CollectionUtils.size(this.codeTemplateLibraries)).append(", ");
        builder.append("configurationMap=").append(this.configurationMap).append("]");
        return builder.toString();
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        DonkeyElement globalScripts = element.getChildElement("globalScripts");
        if (globalScripts != null) {
            for (DonkeyElement entry : globalScripts.getChildElements()) {
                DonkeyElement keyString = entry.getChildElement("string");
                if (!keyString.getTextContent().equals("Shutdown")) continue;
                keyString.setTextContent("Undeploy");
            }
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
        ResourcePropertiesList list = new ResourcePropertiesList();
        DirectoryResourceProperties defaultResource = new DirectoryResourceProperties();
        defaultResource.setId("Default Resource");
        defaultResource.setName("[Default Resource]");
        defaultResource.setDescription("Loads libraries from the custom-lib folder in the BridgeLink home directory.");
        defaultResource.setIncludeWithGlobalScripts(true);
        defaultResource.setDirectory("custom-lib");
        list.getList().add((ResourceProperties)defaultResource);
        try {
            DonkeyElement resourcePropertiesElement = element.addChildElementFromXml(ObjectXMLSerializer.getInstance().serialize(list));
            resourcePropertiesElement.setNodeName("resourceProperties");
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new SerializerException("Failed to migrate server configuration.", (Throwable)e);
        }
    }

    public void migrate3_3_0(DonkeyElement element) {
        DonkeyElement librariesElement = element.addChildElement("codeTemplateLibraries");
        DonkeyElement libraryElement = librariesElement.addChildElement("codeTemplateLibrary");
        libraryElement.setAttribute("version", "3.3.0");
        libraryElement.addChildElement("id", UUID.randomUUID().toString());
        libraryElement.addChildElement("name", "Library 1");
        libraryElement.addChildElement("revision", "1");
        try {
            libraryElement.addChildElementFromXml(ObjectXMLSerializer.getInstance().serialize(Calendar.getInstance())).setNodeName("lastModified");
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new SerializerException("Failed to migrate code template library last modified date.", (Throwable)e);
        }
        libraryElement.addChildElement("description", "This library was added upon migration to version 3.3.0. It includes all pre-existing\ncode templates, and is set to be included on all pre-existing and new channels.\n\nYou should create your own new libraries and assign code templates to them as you\nsee fit. You should also link libraries to specific channels, so that you're not\nnecessarily including all code templates on all channels all the time.");
        libraryElement.addChildElement("includeNewChannels", "true");
        libraryElement.addChildElement("enabledChannelIds");
        libraryElement.addChildElement("disabledChannelIds");
        try {
            libraryElement.addChildElementFromXml(element.removeChild("codeTemplates").toXml());
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new SerializerException("Failed to migrate code templates.", (Throwable)e);
        }
        boolean enabled = true;
        String time = "";
        String interval = "";
        String dayOfWeek = "";
        String dayOfMonth = "1";
        DonkeyElement properties = null;
        DonkeyElement pluginProperties = element.getChildElement("pluginProperties");
        if (pluginProperties != null) {
            for (DonkeyElement childElement : pluginProperties.getChildElements()) {
                String entryKey = childElement.getChildElement("string").getTextContent();
                if (!entryKey.equals("Data Pruner")) continue;
                properties = childElement.getChildElement("properties");
                for (DonkeyElement property : properties.getChildElements()) {
                    String propertyName = property.getAttributes().item(0).getTextContent();
                    if (propertyName.equals("dayOfWeek")) {
                        dayOfWeek = property.getTextContent();
                        continue;
                    }
                    if (propertyName.equals("dayOfMonth")) {
                        dayOfMonth = property.getTextContent();
                        continue;
                    }
                    if (propertyName.equals("interval")) {
                        interval = property.getTextContent();
                        continue;
                    }
                    if (!propertyName.equals("time")) continue;
                    time = property.getTextContent();
                }
            }
            enabled = !interval.equals("disabled");
            String pollingType = "INTERVAL";
            String pollingHour = "12";
            String pollingMinute = "0";
            boolean weekly = !StringUtils.equals((CharSequence)interval, (CharSequence)"monthly");
            boolean[] activeDays = new boolean[]{true, true, true, true, true, true, true, true};
            if (enabled && !StringUtils.equals((CharSequence)interval, (CharSequence)"hourly")) {
                SimpleDateFormat timeDateFormat = new SimpleDateFormat("hh:mm aa");
                DateFormatter timeFormatter = new DateFormatter(timeDateFormat);
                Date timeDate = null;
                try {
                    timeDate = (Date)timeFormatter.stringToValue(time);
                    Calendar timeCalendar = Calendar.getInstance();
                    timeCalendar.setTime(timeDate);
                    pollingType = "TIME";
                    pollingHour = String.valueOf(timeCalendar.get(11));
                    pollingMinute = String.valueOf(timeCalendar.get(12));
                    if (StringUtils.equals((CharSequence)interval, (CharSequence)"weekly")) {
                        SimpleDateFormat dayDateFormat = new SimpleDateFormat("EEEEEEEE");
                        DateFormatter dayFormatter = new DateFormatter(dayDateFormat);
                        Date dayDate = (Date)dayFormatter.stringToValue(dayOfWeek);
                        Calendar dayCalendar = Calendar.getInstance();
                        dayCalendar.setTime(dayDate);
                        activeDays = new boolean[]{false, false, false, false, false, false, false, false};
                        activeDays[dayCalendar.get((int)7)] = true;
                    }
                }
                catch (Exception timeCalendar) {
                    // empty catch block
                }
            }
            try {
                DonkeyElement pollingProperties = new DonkeyElement("<com.mirth.connect.donkey.model.channel.PollConnectorProperties/>");
                pollingProperties.setAttribute("version", "3.3.0");
                pollingProperties.addChildElementIfNotExists("pollingType", pollingType);
                pollingProperties.addChildElementIfNotExists("pollOnStart", "false");
                pollingProperties.addChildElementIfNotExists("pollingFrequency", "3600000");
                pollingProperties.addChildElementIfNotExists("pollingHour", pollingHour);
                pollingProperties.addChildElementIfNotExists("pollingMinute", pollingMinute);
                pollingProperties.addChildElementIfNotExists("cronJobs");
                DonkeyElement advancedProperties = pollingProperties.addChildElementIfNotExists("pollConnectorPropertiesAdvanced");
                advancedProperties.addChildElementIfNotExists("weekly", weekly ? "true" : "false");
                DonkeyElement inactiveDays = advancedProperties.addChildElementIfNotExists("inactiveDays");
                if (inactiveDays != null) {
                    for (int index = 0; index < 8; ++index) {
                        inactiveDays.addChildElement("boolean", activeDays[index] ? "false" : "true");
                    }
                }
                advancedProperties.addChildElementIfNotExists("dayOfMonth", dayOfMonth);
                advancedProperties.addChildElementIfNotExists("allDay", "true");
                advancedProperties.addChildElementIfNotExists("startingHour", "8");
                advancedProperties.addChildElementIfNotExists("startingMinute", "0");
                advancedProperties.addChildElementIfNotExists("endingHour", "17");
                advancedProperties.addChildElementIfNotExists("endingMinute", "0");
                DonkeyElement prunerProperty = properties.addChildElementFromXml(ObjectXMLSerializer.getInstance().serialize(pollingProperties.toXml()));
                prunerProperty.setAttribute("name", "pollingProperties");
                DonkeyElement enabledProperty = properties.addChildElement("property", Boolean.toString(enabled));
                enabledProperty.setAttribute("name", "enabled");
            }
            catch (Exception e) {
                throw new SerializerException("Failed to migrate Data Pruner properties.", (Throwable)e);
            }
        }
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
        HashMap<String, Pair> migratedTagList = new HashMap<String, Pair>();
        DonkeyElement channelsElem = element.getChildElement("channels");
        if (channelsElem != null) {
            for (DonkeyElement channel : channelsElem.getChildElements()) {
                DonkeyElement tagsElem = channel.getChildElement("properties").getChildElement("tags");
                String channelId = channel.getChildElement("id").getTextContent();
                if (tagsElem == null) continue;
                for (Object tag : tagsElem.getChildElements()) {
                    String tagName = ChannelTag.fixName(tag.getTextContent());
                    Pair tagInfo = (Pair)migratedTagList.get(tagName.toLowerCase());
                    if (tagInfo == null) {
                        tagInfo = new ImmutablePair((Object)tagName, new ArrayList());
                        migratedTagList.put(tagName.toLowerCase(), tagInfo);
                    }
                    ((List)tagInfo.getRight()).add(channelId);
                }
            }
        }
        DonkeyElement tagsElement = element.addChildElementIfNotExists("channelTags");
        for (Pair tag : migratedTagList.values()) {
            DonkeyElement tagElement = tagsElement.addChildElement("channelTag");
            tagElement.addChildElement("id", UUID.randomUUID().toString());
            tagElement.addChildElement("name", ChannelTag.fixName((String)tag.getLeft()));
            DonkeyElement channelIds = tagElement.addChildElement("channelIds");
            for (String channelId : (List)tag.getRight()) {
                channelIds.addChildElement("string", channelId);
            }
            Color newColor = ColorUtil.getNewColor();
            DonkeyElement bgColor = tagElement.addChildElement("backgroundColor");
            bgColor.addChildElement("red", String.valueOf(newColor.getRed()));
            bgColor.addChildElement("blue", String.valueOf(newColor.getBlue()));
            bgColor.addChildElement("green", String.valueOf(newColor.getGreen()));
            bgColor.addChildElement("alpha", String.valueOf(newColor.getAlpha()));
        }
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }
}

