/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.alert;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XStreamAlias(value="alertStatus")
public class AlertStatus
implements Serializable {
    private String id;
    private String name;
    private boolean enabled;
    private Integer alertedCount;
    @XStreamOmitField
    private Logger logger = LogManager.getLogger(this.getClass());

    public AlertStatus() {
    }

    public AlertStatus(String id, String name, boolean enabled, Integer alertedCount) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.alertedCount = alertedCount;
    }

    public AlertStatus(ResultSet resultSet) {
        try {
            this.id = resultSet.getString(1);
            this.name = resultSet.getString(2);
            this.enabled = resultSet.getBoolean(3);
            if (this.enabled) {
                this.alertedCount = resultSet.getInt(4);
            }
        }
        catch (SQLException e) {
            this.logger.error("Error instantiating AlertStatus from database ResultSet", (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getAlertedCount() {
        return this.alertedCount;
    }

    public void setAlertedCount(Integer alertedCount) {
        this.alertedCount = alertedCount;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof AlertStatus)) {
            return false;
        }
        AlertStatus otherAlertStatus = (AlertStatus)otherObject;
        if (!Objects.equals(otherAlertStatus.getId(), this.id)) {
            return false;
        }
        if (!Objects.equals(otherAlertStatus.getName(), this.name)) {
            return false;
        }
        if (otherAlertStatus.isEnabled() != this.enabled) {
            return false;
        }
        return Objects.equals(otherAlertStatus.getAlertedCount(), this.alertedCount);
    }
}

