/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.PluginMetaData;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class PluginMetaDataConverter
extends ReflectionConverter {
    public PluginMetaDataConverter(Mapper mapper) {
        super(mapper, JVM.newReflectionProvider());
    }

    public boolean canConvert(Class type) {
        return type == PluginMetaData.class;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        super.marshal(value, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.underlyingReader() instanceof DocumentReader) {
            DonkeyElement controllerClassesElement;
            DonkeyElement clientClassesElement;
            DonkeyElement pluginMetaDataElement = new DonkeyElement((Element)((DocumentReader)reader.underlyingReader()).getCurrent());
            DonkeyElement serverClassesElement = pluginMetaDataElement.getChildElement("serverClasses");
            if (serverClassesElement != null) {
                for (DonkeyElement childElement : serverClassesElement.getChildElements()) {
                    if (!childElement.getNodeName().equals("string")) continue;
                    this.convertStringToPluginClass(childElement);
                }
            }
            if ((clientClassesElement = pluginMetaDataElement.getChildElement("clientClasses")) != null) {
                for (DonkeyElement childElement : clientClassesElement.getChildElements()) {
                    if (!childElement.getNodeName().equals("string")) continue;
                    this.convertStringToPluginClass(childElement);
                }
            }
            if ((controllerClassesElement = pluginMetaDataElement.getChildElement("controllerClasses")) != null) {
                for (DonkeyElement childElement : controllerClassesElement.getChildElements()) {
                    if (!childElement.getNodeName().equals("string")) continue;
                    this.convertStringToPluginClass(childElement);
                }
            }
        }
        return super.unmarshal(reader, context);
    }

    private void convertStringToPluginClass(DonkeyElement stringElement) {
        String className = stringElement.getTextContent();
        String weight = stringElement.getAttribute("weight");
        String conditionClass = stringElement.getAttribute("conditionClass");
        stringElement.setTextContent(null);
        stringElement.removeAttribute("weight");
        stringElement.removeAttribute("conditionClass");
        stringElement.setNodeName("pluginClass");
        stringElement.addChildElement("name", className);
        if (StringUtils.isNotBlank((CharSequence)weight)) {
            stringElement.addChildElement("weight", weight);
        }
        if (StringUtils.isNotBlank((CharSequence)conditionClass)) {
            stringElement.addChildElement("conditionClass", conditionClass);
        }
    }
}

