/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.transmission.batch;

import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexBatchStreamReader
extends BatchStreamReader {
    private Pattern delimiterRegex;
    private Charset charsetEncoding;
    private boolean includeDelimiter;

    public RegexBatchStreamReader(InputStream inputStream, String delimiterRegex, String charsetEncoding, boolean includeDelimiter) {
        super(inputStream);
        this.setDelimiterRegex(delimiterRegex);
        this.setCharsetEncoding(charsetEncoding);
        this.includeDelimiter = includeDelimiter;
    }

    public Pattern getDelimiterRegex() {
        return this.delimiterRegex;
    }

    public void setDelimiterRegex(String delimiterRegex) {
        this.delimiterRegex = Pattern.compile(delimiterRegex);
    }

    public Charset getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = Charset.forName(charsetEncoding);
    }

    public boolean isIncludeDelimiter() {
        return this.includeDelimiter;
    }

    public void setIncludeDelimiter(boolean includeDelimiter) {
        this.includeDelimiter = includeDelimiter;
    }

    public byte[] checkForIntermediateMessage(ByteArrayOutputStream capturedBytes, List<Byte> endBytesBuffer, int lastByte) throws IOException {
        String encodedString = new String(capturedBytes.toByteArray(), this.charsetEncoding);
        Matcher matcher = this.delimiterRegex.matcher(encodedString);
        if (matcher.find()) {
            return encodedString.substring(0, this.includeDelimiter ? matcher.end() : matcher.start()).getBytes(this.charsetEncoding);
        }
        return null;
    }
}

