/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.util;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.MigrationUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImportConverter {
    private static final String HL7V2 = "HL7V2";
    private static final String XML = "XML";
    private static Pattern matchVersion = Pattern.compile("<version>([\\.0-9]+?)<\\/version>");

    private static String convertPackageNames(String xml) {
        return xml.replaceAll("com.webreach.mirth", "com.mirth.connect");
    }

    public static Document convertServerConfiguration(String serverConfiguration) throws Exception {
        serverConfiguration = ImportConverter.convertPackageNames(serverConfiguration);
        DocumentBuilderFactory factory = ImportConverter.getSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(serverConfiguration)));
        Element documentElement = document.getDocumentElement();
        NodeList users = documentElement.getElementsByTagName("users");
        if (users != null && users.getLength() > 0) {
            documentElement.removeChild(users.item(0));
        }
        Element channelsRoot = (Element)document.getElementsByTagName("channels").item(0);
        NodeList channels = ImportConverter.getElements(document, "channel", "com.mirth.connect.model.Channel");
        ArrayList<Element> channelList = new ArrayList<Element>();
        int length = channels.getLength();
        for (int i = 0; i < length; ++i) {
            Element channel = (Element)channels.item(0);
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(channel), new StreamResult(sw));
            String channelDocXML = sw.toString();
            channelList.add(new DonkeyElement(ImportConverter.convertChannelString(channelDocXML)).getElement());
            channelsRoot.removeChild(channel);
        }
        for (Element channel : channelList) {
            channelsRoot.appendChild(document.importNode(channel, true));
        }
        NodeList codeTemplates = documentElement.getElementsByTagName("codeTemplates");
        int codeTemplateCount = codeTemplates.getLength();
        for (int i = 0; i < codeTemplateCount; ++i) {
            Element codeTemplate = (Element)codeTemplates.item(i);
            Element convertedCodeTemplate = ImportConverter.convertCodeTemplates(new DonkeyElement(codeTemplate).toXml()).getDocumentElement();
            documentElement.replaceChild(document.importNode(convertedCodeTemplate, true), codeTemplate);
        }
        return document;
    }

    public static Document convertCodeTemplates(String codeTemplatesXML) throws Exception {
        codeTemplatesXML = ImportConverter.convertPackageNames(codeTemplatesXML);
        codeTemplatesXML = ImportConverter.runStringConversions(codeTemplatesXML);
        DocumentBuilderFactory factory = ImportConverter.getSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(codeTemplatesXML)));
        NodeList codeTemplates = ImportConverter.getElements(document, "codeTemplate", "com.mirth.connect.model.CodeTemplate");
        int length = codeTemplates.getLength();
        for (int i = 0; i < length; ++i) {
            Element scope;
            int scopeValue;
            Element codeTemplate = (Element)codeTemplates.item(i);
            codeTemplate.getOwnerDocument().renameNode(codeTemplate, codeTemplate.getNamespaceURI(), "codeTemplate");
            NodeList versions = codeTemplate.getElementsByTagName("version");
            if (versions.getLength() != 0 || (scopeValue = Integer.parseInt((scope = (Element)codeTemplate.getElementsByTagName("scope").item(0)).getTextContent())) == 0) continue;
            scope.setTextContent(Integer.toString(++scopeValue));
        }
        return document;
    }

    public static String convertChannelString(String channel) throws Exception {
        channel = ImportConverter.convertPackageNames(channel);
        channel = ImportConverter.runStringConversions(channel);
        String contents = ImportConverter.removeInvalidHexChar(channel);
        DocumentBuilderFactory factory = ImportConverter.getSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(contents)));
        return ImportConverter.convertChannel(document);
    }

    private static String runStringConversions(String xmlData) {
        String versionData = ImportConverter.getComponentVersion(xmlData, "1.8.2");
        if (MigrationUtil.compareVersions(versionData, "2.0.0") < 0) {
            // empty if block
        }
        return xmlData;
    }

    private static String getComponentVersion(String xmlData, String defaultVersion) {
        Matcher matcher = matchVersion.matcher(xmlData);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return defaultVersion;
    }

    private static String convertChannel(Document document) throws Exception {
        String channelXML = "";
        Element channelRoot = document.getDocumentElement();
        String version = channelRoot.getElementsByTagName("version").item(0).getTextContent();
        int majorVersion = Integer.parseInt(version.split("\\.")[0]);
        int minorVersion = Integer.parseInt(version.split("\\.")[1]);
        int patchVersion = Integer.parseInt(version.split("\\.")[2]);
        if (majorVersion < 2) {
            if (minorVersion < 4) {
                Direction direction = null;
                Element sourceConnectorRoot = (Element)document.getDocumentElement().getElementsByTagName("sourceConnector").item(0);
                Element destinationConnectorRoot = (Element)document.getDocumentElement().getElementsByTagName("destinationConnectors").item(0);
                NodeList destinationsConnectors = ImportConverter.getElements(destinationConnectorRoot, "connector", "com.mirth.connect.model.Connector");
                Node channelDirection = channelRoot.getElementsByTagName("direction").item(0);
                if (channelDirection.getTextContent().equals("INBOUND")) {
                    direction = Direction.INBOUND;
                } else if (channelDirection.getTextContent().equals("OUTBOUND")) {
                    direction = Direction.OUTBOUND;
                }
                channelRoot.removeChild(channelDirection);
                NodeList modeElements = channelRoot.getElementsByTagName("mode");
                for (int i = 0; i < modeElements.getLength(); ++i) {
                    if (((Element)modeElements.item(i)).getParentNode() != channelRoot) continue;
                    channelRoot.removeChild(modeElements.item(i));
                }
                channelRoot.removeChild(channelRoot.getElementsByTagName("protocol").item(0));
                NodeList transportNames = channelRoot.getElementsByTagName("transportName");
                for (int i = 0; i < transportNames.getLength(); ++i) {
                    if (!transportNames.item(i).getTextContent().equals("PDF Writer")) continue;
                    transportNames.item(i).setTextContent("Document Writer");
                }
                NodeList properyNames = channelRoot.getElementsByTagName("property");
                for (int i = 0; i < properyNames.getLength(); ++i) {
                    Node nameAttribute = properyNames.item(i).getAttributes().getNamedItem("name");
                    if (properyNames.item(i).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("DataType") || !properyNames.item(i).getTextContent().equals("PDF Writer")) continue;
                    properyNames.item(i).setTextContent("Document Writer");
                }
                Element modeElement = document.createElement("mode");
                modeElement.setTextContent("SOURCE");
                sourceConnectorRoot.appendChild(modeElement);
                ImportConverter.updateFilterFor1_4((Element)sourceConnectorRoot.getElementsByTagName("filter").item(0));
                if (direction == Direction.OUTBOUND) {
                    ImportConverter.updateTransformerFor1_4(document, (Element)sourceConnectorRoot.getElementsByTagName("transformer").item(0), XML, XML);
                } else {
                    ImportConverter.updateTransformerFor1_4(document, (Element)sourceConnectorRoot.getElementsByTagName("transformer").item(0), HL7V2, HL7V2);
                }
                for (int i = 0; i < destinationsConnectors.getLength(); ++i) {
                    modeElement = document.createElement("mode");
                    modeElement.setTextContent("DESTINATION");
                    Element destinationsConnector = (Element)destinationsConnectors.item(i);
                    destinationsConnector.appendChild(modeElement);
                    ImportConverter.updateFilterFor1_4((Element)destinationsConnector.getElementsByTagName("filter").item(0));
                    if (direction == Direction.OUTBOUND) {
                        ImportConverter.updateTransformerFor1_4(document, (Element)destinationsConnector.getElementsByTagName("transformer").item(0), XML, HL7V2);
                        continue;
                    }
                    ImportConverter.updateTransformerFor1_4(document, (Element)destinationsConnector.getElementsByTagName("transformer").item(0), HL7V2, HL7V2);
                }
            }
            if (minorVersion < 5) {
                ImportConverter.updateTransformerFor1_5(document);
            }
            if (minorVersion < 6) {
                Element sourceConnectorRoot = (Element)document.getDocumentElement().getElementsByTagName("sourceConnector").item(0);
                Element destinationConnectorRoot = (Element)document.getDocumentElement().getElementsByTagName("destinationConnectors").item(0);
                NodeList destinationsConnectors = ImportConverter.getElements(destinationConnectorRoot, "connector", "com.mirth.connect.model.Connector");
                if (!ImportConverter.nodeChildrenContains(sourceConnectorRoot, "enabled")) {
                    Element enabledSource = document.createElement("enabled");
                    enabledSource.setTextContent("true");
                    sourceConnectorRoot.appendChild(enabledSource);
                } else {
                    ImportConverter.setBooleanNode(sourceConnectorRoot, "enabled", true);
                }
                for (int i = 0; i < destinationsConnectors.getLength(); ++i) {
                    Element destinationConnector = (Element)destinationsConnectors.item(i);
                    if (!ImportConverter.nodeChildrenContains(destinationConnector, "enabled")) {
                        Element enabledDestination = document.createElement("enabled");
                        enabledDestination.setTextContent("true");
                        destinationConnector.appendChild(enabledDestination);
                        continue;
                    }
                    ImportConverter.setBooleanNode(destinationConnector, "enabled", true);
                }
                if (!ImportConverter.nodeChildrenContains(channelRoot, "deployScript")) {
                    Element deployScript = document.createElement("deployScript");
                    deployScript.setTextContent("// This script executes once when the channel is deployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;");
                    channelRoot.appendChild(deployScript);
                }
                if (!ImportConverter.nodeChildrenContains(channelRoot, "shutdownScript")) {
                    Element shutdownScript = document.createElement("shutdownScript");
                    shutdownScript.setTextContent("// This script executes once when the channel is undeployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;");
                    channelRoot.appendChild(shutdownScript);
                }
                if (!ImportConverter.nodeChildrenContains(channelRoot, "postprocessingScript")) {
                    Element postprocessorScript = document.createElement("postprocessingScript");
                    postprocessorScript.setTextContent("// This script executes once after a message has been processed\nreturn;");
                    channelRoot.appendChild(postprocessorScript);
                }
            }
            if (minorVersion < 7) {
                if (!ImportConverter.nodeChildrenContains(channelRoot, "lastModified")) {
                    Element lastModified = document.createElement("lastModified");
                    Element time = document.createElement("time");
                    Element timezone = document.createElement("timezone");
                    Calendar calendar = Calendar.getInstance();
                    time.setTextContent("" + calendar.getTimeInMillis());
                    timezone.setTextContent(calendar.getTimeZone().getDisplayName());
                    lastModified.appendChild(time);
                    lastModified.appendChild(timezone);
                    channelRoot.appendChild(lastModified);
                }
                ImportConverter.updateFilterFor1_7(document);
                ImportConverter.updateTransformerFor1_7(document);
            }
            if (minorVersion < 8) {
                if (minorVersion < 7 || minorVersion == 7 && patchVersion < 1) {
                    ImportConverter.updateTransformerFor1_7_1(document);
                }
                ImportConverter.convertChannelConnectorsFor1_8(document, channelRoot);
            }
            if (minorVersion < 8 || minorVersion == 8 && patchVersion < 1) {
                ImportConverter.updateTransformerFor1_8_1(document);
            }
            if (channelRoot.getElementsByTagName("description").getLength() == 0) {
                Element descriptionElement = document.createElement("description");
                channelRoot.appendChild(descriptionElement);
            }
            ImportConverter.convertChannelConnectorsFor2_0(document, channelRoot);
            ImportConverter.updateFilterFor2_0(document);
        }
        if (majorVersion < 3 && minorVersion < 2) {
            ImportConverter.convertChannelConnectorsFor2_2(document, channelRoot);
        }
        DocumentSerializer docSerializer = new DocumentSerializer();
        channelXML = docSerializer.toXML(document);
        return ImportConverter.updateLocalAndGlobalVariables(channelXML);
    }

    private static void convertChannelConnectorsFor1_8(Document document, Element channelRoot) throws Exception {
        Element sourceConnectorRoot = (Element)channelRoot.getElementsByTagName("sourceConnector").item(0);
        Element destinationConnectorRoot = (Element)channelRoot.getElementsByTagName("destinationConnectors").item(0);
        NodeList destinationsConnectors = ImportConverter.getElements(destinationConnectorRoot, "connector", "com.mirth.connect.model.Connector");
        ImportConverter.convertOneConnectorFor1_8(document, sourceConnectorRoot);
        for (int i = 0; i < destinationsConnectors.getLength(); ++i) {
            Element destinationConnector = (Element)destinationsConnectors.item(i);
            ImportConverter.convertOneConnectorFor1_8(document, destinationConnector);
        }
    }

    private static void updateProperties(Document document, Element properties, Map<String, String> defaultProperties, Map<String, String> changeProperties) throws Exception {
        HashMap<String, String> missingProperties = new HashMap<String, String>();
        missingProperties.putAll(defaultProperties);
        missingProperties.putAll(changeProperties);
        NodeList existingProperties = properties.getElementsByTagName("property");
        for (int i = 0; i < existingProperties.getLength(); ++i) {
            Node existingProperty = existingProperties.item(i);
            Node existingPropertyNameAttribute = existingProperty.getAttributes().getNamedItem("name");
            String existingPropertyName = existingPropertyNameAttribute.getNodeValue();
            if (!missingProperties.containsKey(existingPropertyName)) continue;
            if (changeProperties.containsKey(existingPropertyName)) {
                existingProperty.setTextContent(changeProperties.get(existingPropertyName));
            }
            missingProperties.remove(existingPropertyName);
        }
        for (Map.Entry thisEntry : missingProperties.entrySet()) {
            Element newProperty = document.createElement("property");
            newProperty.setAttribute("name", (String)thisEntry.getKey());
            newProperty.setTextContent((String)thisEntry.getValue());
            properties.appendChild(newProperty);
        }
    }

    private static Node getConnectorTransportNode(Element connectorRoot) throws Exception {
        NodeList transportNames = connectorRoot.getElementsByTagName("transportName");
        return transportNames.item(0);
    }

    private static Element getPropertiesElement(Element connectorRoot) throws Exception {
        NodeList propertiesElements = connectorRoot.getElementsByTagName("properties");
        return (Element)propertiesElements.item(0);
    }

    private static void convertOneConnectorFor1_8(Document document, Element connectorRoot) throws Exception {
        Node transportNode = ImportConverter.getConnectorTransportNode(connectorRoot);
        String transportNameText = transportNode.getTextContent();
        Element propertiesElement = ImportConverter.getPropertiesElement(connectorRoot);
        HashMap<String, String> propertyDefaults = new HashMap<String, String>();
        propertyDefaults.put("charsetEncoding", "DEFAULT_ENCODING");
        propertyDefaults.put("FTPAnonymous", "1");
        propertyDefaults.put("outputAppend", "0");
        propertyDefaults.put("passive", "1");
        propertyDefaults.put("password", "anonymous");
        propertyDefaults.put("username", "anonymous");
        propertyDefaults.put("validateConnections", "1");
        HashMap<String, String> propertyChanges = new HashMap<String, String>();
        if (transportNameText.equals("File Reader")) {
            propertyDefaults.put("scheme", "file");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("File Writer")) {
            propertyDefaults.put("scheme", "file");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("FTP Reader")) {
            transportNode.setTextContent("File Reader");
            propertyDefaults.put("scheme", "ftp");
            propertyChanges.put("DataType", "File Reader");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("FTP Writer")) {
            transportNode.setTextContent("File Writer");
            propertyDefaults.put("scheme", "ftp");
            propertyChanges.put("DataType", "File Writer");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("SFTP Reader")) {
            transportNode.setTextContent("File Reader");
            propertyDefaults.put("scheme", "sftp");
            propertyDefaults.put("FTPAnonymous", "0");
            propertyChanges.put("DataType", "File Reader");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("SFTP Writer")) {
            transportNode.setTextContent("File Writer");
            propertyDefaults.put("scheme", "sftp");
            propertyDefaults.put("FTPAnonymous", "0");
            propertyChanges.put("DataType", "File Writer");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        }
    }

    private static void convertChannelConnectorsFor2_0(Document document, Element channelRoot) throws Exception {
        Element sourceConnectorRoot = (Element)channelRoot.getElementsByTagName("sourceConnector").item(0);
        Element destinationConnectorRoot = (Element)channelRoot.getElementsByTagName("destinationConnectors").item(0);
        NodeList destinationsConnectors = ImportConverter.getElements(destinationConnectorRoot, "connector", "com.mirth.connect.model.Connector");
        ImportConverter.convertSoapConnectorFor2_0(document, sourceConnectorRoot);
        ImportConverter.convertHttpConnectorFor2_0(document, sourceConnectorRoot);
        for (int i = 0; i < destinationsConnectors.getLength(); ++i) {
            Element destinationConnector = (Element)destinationsConnectors.item(i);
            ImportConverter.convertSoapConnectorFor2_0(document, destinationConnector);
            ImportConverter.convertHttpConnectorFor2_0(document, destinationConnector);
        }
    }

    private static void convertSoapConnectorFor2_0(Document document, Element connectorRoot) throws Exception {
        Node transportNode = ImportConverter.getConnectorTransportNode(connectorRoot);
        String transportNameText = transportNode.getTextContent();
        String attribute = "";
        String value = "";
        Element propertiesElement = ImportConverter.getPropertiesElement(connectorRoot);
        HashMap<String, String> propertyDefaults = new HashMap<String, String>();
        HashMap<String, String> propertyChanges = new HashMap<String, String>();
        if (transportNameText.equals("SOAP Listener")) {
            NodeList properties = connectorRoot.getElementsByTagName("property");
            propertyDefaults.put("DataType", "Web Service Listener");
            propertyDefaults.put("host", "0.0.0.0");
            propertyDefaults.put("port", "8081");
            propertyDefaults.put("receiverClassName", "com.mirth.connect.connectors.ws.DefaultAcceptMessage");
            propertyDefaults.put("receiverServiceName", "Mirth");
            propertyDefaults.put("receiverResponseValue", "None");
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            propertyDefaults.put("receiverUsernames", serializer.serialize(new ArrayList()));
            propertyDefaults.put("receiverPasswords", serializer.serialize(new ArrayList()));
            for (int i = 0; i < properties.getLength(); ++i) {
                attribute = properties.item(i).getAttributes().item(0).getTextContent();
                value = properties.item(i).getTextContent();
                if (attribute.equals("externalAddress")) {
                    propertyChanges.put("host", value);
                }
                if (attribute.equals("responseValue")) {
                    propertyChanges.put("receiverResponseValue", value);
                }
                if (!attribute.equals("serviceName")) continue;
                propertyChanges.put("receiverServiceName", value);
            }
            propertyChanges.put("DataType", "Web Service Listener");
            transportNode.setTextContent("Web Service Listener");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("SOAP Sender")) {
            NodeList properties = connectorRoot.getElementsByTagName("property");
            document.getElementsByTagName("enabled").item(0).setTextContent("false");
            propertyDefaults.put("DataType", "Web Service Sender");
            propertyDefaults.put("host", "");
            propertyDefaults.put("dispatcherWsdlCacheId", "");
            propertyDefaults.put("dispatcherWsdlUrl", "");
            propertyDefaults.put("dispatcherService", "");
            propertyDefaults.put("dispatcherPort", "");
            propertyDefaults.put("dispatcherOperation", "Press Get Operations");
            propertyDefaults.put("dispatcherUseAuthentication", "0");
            propertyDefaults.put("dispatcherUsername", "");
            propertyDefaults.put("dispatcherPassword", "");
            propertyDefaults.put("dispatcherEnvelope", "");
            propertyDefaults.put("dispatcherOneWay", "0");
            propertyDefaults.put("dispatcherUseMtom", "0");
            propertyDefaults.put("dispatcherReplyChannelId", "sink");
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            ArrayList<String> defaultOperations = new ArrayList<String>();
            defaultOperations.add("Press Get Operations");
            propertyDefaults.put("dispatcherWsdlOperations", serializer.serialize(defaultOperations));
            propertyDefaults.put("dispatcherAttachmentNames", serializer.serialize(new ArrayList()));
            propertyDefaults.put("dispatcherAttachmentContents", serializer.serialize(new ArrayList()));
            propertyDefaults.put("dispatcherAttachmentTypes", serializer.serialize(new ArrayList()));
            propertyDefaults.put("queuePollInterval", "200");
            for (int i = 0; i < properties.getLength(); ++i) {
                attribute = properties.item(i).getAttributes().item(0).getTextContent();
                value = properties.item(i).getTextContent();
                if (attribute.equals("attachmentNames")) {
                    propertyChanges.put("dispatcherAttachmentNames", value);
                    if (StringUtils.isNotBlank((CharSequence)value) && !value.trim().equals("<list/>")) {
                        propertyChanges.put("dispatcherUseMtom", "1");
                    }
                }
                if (attribute.equals("wsdlUrl")) {
                    propertyChanges.put("dispatcherWsdlUrl", value);
                }
                if (attribute.equals("soapActionURI")) {
                    propertyChanges.put("dispatcherSoapAction", value);
                }
                if (attribute.equals("method")) {
                    propertyChanges.put("dispatcherOperation", value);
                    if (StringUtils.isNotBlank((CharSequence)value)) {
                        defaultOperations.clear();
                        defaultOperations.add(value);
                        propertyChanges.put("dispatcherWsdlOperations", serializer.serialize(defaultOperations));
                    }
                }
                if (attribute.equals("replyChannelId")) {
                    propertyChanges.put("dispatcherReplyChannelId", value);
                }
                if (attribute.equals("attachmentContents")) {
                    propertyChanges.put("dispatcherAttachmentContents", value);
                }
                if (attribute.equals("soapEnvelope")) {
                    propertyChanges.put("dispatcherEnvelope", value);
                }
                if (!attribute.equals("attachmentTypes")) continue;
                propertyChanges.put("dispatcherAttachmentTypes", value);
            }
            propertyChanges.put("DataType", "Web Service Sender");
            transportNode.setTextContent("Web Service Sender");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        }
    }

    private static void convertHttpConnectorFor2_0(Document document, Element connectorRoot) throws Exception {
        Node transportNode = ImportConverter.getConnectorTransportNode(connectorRoot);
        String transportNameText = transportNode.getTextContent();
        String attribute = "";
        String value = "";
        Element propertiesElement = ImportConverter.getPropertiesElement(connectorRoot);
        HashMap<String, String> propertyDefaults = new HashMap<String, String>();
        HashMap<String, String> propertyChanges = new HashMap<String, String>();
        if (transportNameText.equals("HTTP Listener") || transportNameText.equals("HTTPS Listener")) {
            NodeList properties = connectorRoot.getElementsByTagName("property");
            propertyDefaults.put("DataType", "HTTP Listener");
            propertyDefaults.put("host", "0.0.0.0");
            propertyDefaults.put("port", "80");
            propertyDefaults.put("receiverResponse", "None");
            propertyDefaults.put("receiverBodyOnly", "1");
            propertyDefaults.put("HTTP_RESPONSE_CONTENT_TYPE", "text/plain");
            for (int i = 0; i < properties.getLength(); ++i) {
                attribute = properties.item(i).getAttributes().item(0).getTextContent();
                value = properties.item(i).getTextContent();
                if (attribute.equals("responseValue")) {
                    propertyChanges.put("receiverResponse", value);
                }
                if (!attribute.equals("appendPayload")) continue;
                propertyChanges.put("receiverBodyOnly", "1".equals(value) ? "0" : "1");
            }
            propertyChanges.put("host", "0.0.0.0");
            propertyChanges.put("DataType", "HTTP Listener");
            transportNode.setTextContent("HTTP Listener");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        } else if (transportNameText.equals("HTTP Sender") || transportNameText.equals("HTTPS Sender")) {
            String requestContent;
            NodeList properties = connectorRoot.getElementsByTagName("property");
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            propertyDefaults.put("DataType", "HTTP Sender");
            propertyDefaults.put("host", "");
            propertyDefaults.put("dispatcherMethod", "POST");
            propertyDefaults.put("dispatcherHeaders", serializer.serialize(new Properties()));
            propertyDefaults.put("dispatcherParameters", serializer.serialize(new Properties()));
            propertyDefaults.put("dispatcherReplyChannelId", "sink");
            propertyDefaults.put("dispatcherIncludeHeadersInResponse", "0");
            propertyDefaults.put("dispatcherMultipart", "0");
            propertyDefaults.put("dispatcherUseAuthentication", "0");
            propertyDefaults.put("dispatcherAuthenticationType", "Basic");
            propertyDefaults.put("dispatcherUsername", "");
            propertyDefaults.put("dispatcherPassword", "");
            propertyDefaults.put("dispatcherContent", "");
            propertyDefaults.put("dispatcherContentType", "text/plain");
            propertyDefaults.put("dispatcherCharset", "UTF-8");
            propertyDefaults.put("dispatcherSocketTimeout", "30000");
            propertyDefaults.put("queuePollInterval", "200");
            for (int i = 0; i < properties.getLength(); ++i) {
                attribute = properties.item(i).getAttributes().item(0).getTextContent();
                value = properties.item(i).getTextContent();
                if (attribute.equals("method")) {
                    propertyChanges.put("dispatcherMethod", value);
                }
                if (attribute.equals("requestVariables")) {
                    Properties tempProps = serializer.deserialize(value, Properties.class);
                    propertyChanges.put("dispatcherContent", tempProps.getProperty("$payload", ""));
                    tempProps.remove("$payload");
                    propertyChanges.put("dispatcherParameters", serializer.serialize(tempProps));
                }
                if (attribute.equals("replyChannelId")) {
                    propertyChanges.put("dispatcherReplyChannelId", value);
                }
                if (attribute.equals("headerVariables")) {
                    propertyChanges.put("dispatcherHeaders", value);
                }
                if (attribute.equals("excludeHeaders")) {
                    if (value.equals("0")) {
                        propertyChanges.put("dispatcherIncludeHeadersInResponse", "1");
                    } else {
                        propertyChanges.put("dispatcherIncludeHeadersInResponse", "0");
                    }
                }
                if (!attribute.equals("multipart")) continue;
                propertyChanges.put("dispatcherMultipart", value);
            }
            String requestMethod = propertyChanges.get("dispatcherMethod") == null ? (String)propertyDefaults.get("dispatcherMethod") : (String)propertyChanges.get("dispatcherMethod");
            String string = requestContent = propertyChanges.get("dispatcherContent") == null ? (String)propertyDefaults.get("dispatcherContent") : (String)propertyChanges.get("dispatcherContent");
            if (requestContent.length() == 0 && (requestMethod.equalsIgnoreCase("POST") || requestMethod.equalsIgnoreCase("PUT"))) {
                document.getElementsByTagName("enabled").item(0).setTextContent("false");
            }
            propertyChanges.put("DataType", "HTTP Sender");
            transportNode.setTextContent("HTTP Sender");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        }
    }

    private static void convertFileConnectorFor2_2(Document document, Element connectorRoot) throws Exception {
        Node transportNode = ImportConverter.getConnectorTransportNode(connectorRoot);
        String transportNameText = transportNode.getTextContent();
        Element propertiesElement = ImportConverter.getPropertiesElement(connectorRoot);
        HashMap<String, String> propertyDefaults = new HashMap<String, String>();
        HashMap<String, String> propertyChanges = new HashMap<String, String>();
        if (transportNameText.equals("File Reader")) {
            propertyDefaults.put("ignoreDot", "0");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        }
    }

    private static void convertEmailConnectorFor2_2(Document document, Element connectorRoot) throws Exception {
        Node transportNode = ImportConverter.getConnectorTransportNode(connectorRoot);
        String transportNameText = transportNode.getTextContent();
        String attribute = "";
        String value = "";
        Element propertiesElement = ImportConverter.getPropertiesElement(connectorRoot);
        HashMap<String, String> propertyDefaults = new HashMap<String, String>();
        HashMap<String, String> propertyChanges = new HashMap<String, String>();
        if (transportNameText.equals("Email Sender")) {
            NodeList properties = connectorRoot.getElementsByTagName("property");
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            propertyDefaults.put("DataType", "SMTP Sender");
            propertyDefaults.put("smtpHost", "");
            propertyDefaults.put("smtpPort", "25");
            propertyDefaults.put("timeout", "5000");
            propertyDefaults.put("encryption", "none");
            propertyDefaults.put("authentication", "0");
            propertyDefaults.put("username", "");
            propertyDefaults.put("password", "");
            propertyDefaults.put("to", "");
            propertyDefaults.put("from", "");
            propertyDefaults.put("headers", serializer.serialize(new LinkedHashMap()));
            propertyDefaults.put("subject", "");
            propertyDefaults.put("charsetEncoding", "DEFAULT_ENCODING");
            propertyDefaults.put("html", "0");
            propertyDefaults.put("body", "");
            propertyDefaults.put("attachments", "<list/>");
            List<String> attachmentNames = null;
            List<String> attachmentContents = null;
            List<String> attachmentTypes = null;
            for (int i = 0; i < properties.getLength(); ++i) {
                attribute = properties.item(i).getAttributes().item(0).getTextContent();
                value = properties.item(i).getTextContent();
                if (attribute.equals("hostname")) {
                    propertyChanges.put("smtpHost", value);
                    continue;
                }
                if (attribute.equals("emailSecure")) {
                    propertyChanges.put("encryption", value);
                    continue;
                }
                if (attribute.equals("useAuthentication")) {
                    propertyChanges.put("authentication", value);
                    continue;
                }
                if (attribute.equals("toAddresses")) {
                    propertyChanges.put("to", value);
                    continue;
                }
                if (attribute.equals("fromAddress")) {
                    propertyChanges.put("from", value);
                    continue;
                }
                if (attribute.equals("contentType")) {
                    if (value.equalsIgnoreCase("text/plain")) {
                        propertyChanges.put("html", "0");
                        continue;
                    }
                    propertyChanges.put("html", "1");
                    continue;
                }
                if (attribute.equals("attachmentNames")) {
                    attachmentNames = serializer.deserializeList(value, String.class);
                    continue;
                }
                if (attribute.equals("attachmentContents")) {
                    attachmentContents = serializer.deserializeList(value, String.class);
                    continue;
                }
                if (attribute.equals("attachmentTypes")) {
                    attachmentTypes = serializer.deserializeList(value, String.class);
                    continue;
                }
                if (!attribute.equals("useServerSettings") || !value.equalsIgnoreCase("1")) continue;
                document.getElementsByTagName("enabled").item(0).setTextContent("false");
            }
            DonkeyElement attachmentList = new DonkeyElement("<list/>");
            if (attachmentNames != null) {
                for (int i = 0; i < attachmentNames.size(); ++i) {
                    DonkeyElement attachment = attachmentList.addChildElement("com.mirth.connect.connectors.smtp.Attachment");
                    attachment.addChildElement("name", (String)attachmentNames.get(i));
                    attachment.addChildElement("content", (String)attachmentContents.get(i));
                    attachment.addChildElement("mimeType", (String)attachmentTypes.get(i));
                }
            }
            propertyChanges.put("attachments", attachmentList.toXml());
            propertyChanges.put("DataType", "SMTP Sender");
            transportNode.setTextContent("SMTP Sender");
            ImportConverter.updateProperties(document, propertiesElement, propertyDefaults, propertyChanges);
        }
    }

    private static void convertChannelConnectorsFor2_2(Document document, Element channelRoot) throws Exception {
        Element sourceConnectorRoot = (Element)channelRoot.getElementsByTagName("sourceConnector").item(0);
        Element destinationConnectorRoot = (Element)channelRoot.getElementsByTagName("destinationConnectors").item(0);
        NodeList destinationsConnectors = ImportConverter.getElements(destinationConnectorRoot, "connector", "com.mirth.connect.model.Connector");
        ImportConverter.convertFileConnectorFor2_2(document, sourceConnectorRoot);
        for (int i = 0; i < destinationsConnectors.getLength(); ++i) {
            Element destinationConnector = (Element)destinationsConnectors.item(i);
            ImportConverter.convertEmailConnectorFor2_2(document, destinationConnector);
        }
    }

    public static String convertFilter(String filterXml) throws Exception {
        filterXml = ImportConverter.convertPackageNames(filterXml);
        filterXml = ImportConverter.runStringConversions(filterXml);
        DocumentBuilderFactory factory = ImportConverter.getSecureDocumentBuilderFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(filterXml)));
            ImportConverter.updateFilterFor1_4(document.getDocumentElement());
            ImportConverter.updateFilterFor1_7(document);
            ImportConverter.updateFilterFor2_0(document);
            DocumentSerializer docSerializer = new DocumentSerializer();
            filterXml = docSerializer.toXML(document);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ImportConverter.updateLocalAndGlobalVariables(filterXml);
    }

    public static String convertConnector(String connectorXml) throws Exception {
        String versionData;
        connectorXml = ImportConverter.convertPackageNames(connectorXml);
        connectorXml = ImportConverter.runStringConversions(connectorXml);
        connectorXml = ImportConverter.removeInvalidHexChar(connectorXml);
        DocumentBuilderFactory factory = ImportConverter.getSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(connectorXml)));
        Element connectorRoot = document.getDocumentElement();
        Node transportNode = ImportConverter.getConnectorTransportNode(connectorRoot);
        String transportNameText = transportNode.getTextContent();
        if (transportNameText.equals("SOAP Sender") || transportNameText.equals("SOAP Listener")) {
            ImportConverter.convertSoapConnectorFor2_0(document, connectorRoot);
        }
        if ((transportNameText.equals("HTTP Sender") || transportNameText.equals("HTTP Listener") || transportNameText.equals("HTTPS Sender") || transportNameText.equals("HTTPS Listener")) && MigrationUtil.compareVersions(versionData = ImportConverter.getComponentVersion(connectorXml, "1.8.2"), "2.0.0") < 0) {
            ImportConverter.convertHttpConnectorFor2_0(document, connectorRoot);
        }
        if (MigrationUtil.compareVersions(versionData = ImportConverter.getComponentVersion(connectorXml, "2.1.1"), "2.2.0") < 0) {
            ImportConverter.convertFileConnectorFor2_2(document, connectorRoot);
            ImportConverter.convertEmailConnectorFor2_2(document, connectorRoot);
        }
        DocumentSerializer docSerializer = new DocumentSerializer();
        connectorXml = docSerializer.toXML(document);
        return connectorXml;
    }

    public static String convertTransformer(String transformerXml, String incoming, String outgoing) throws Exception {
        transformerXml = ImportConverter.convertPackageNames(transformerXml);
        transformerXml = ImportConverter.runStringConversions(transformerXml);
        DocumentBuilderFactory factory = ImportConverter.getSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(transformerXml)));
        Element transformerRoot = document.getDocumentElement();
        ImportConverter.updateTransformerFor1_4(document, transformerRoot, incoming, outgoing);
        ImportConverter.updateTransformerFor1_5(document);
        ImportConverter.updateTransformerFor1_7(document);
        ImportConverter.updateTransformerFor1_7_1(document);
        DocumentSerializer docSerializer = new DocumentSerializer();
        transformerXml = docSerializer.toXML(document);
        return ImportConverter.updateLocalAndGlobalVariables(transformerXml);
    }

    private static void updateFilterFor1_4(Element filterElement) {
        Element filterTemplate = null;
        if (filterElement.getElementsByTagName("template").getLength() > 0 && (filterTemplate = (Element)filterElement.getElementsByTagName("template").item(0)) != null) {
            filterElement.removeChild(filterElement.getElementsByTagName("template").item(0));
        }
    }

    private static void updateTransformerFor1_4(Document document, Element transformerRoot, String incoming, String outgoing) {
        String template = "";
        Element transformerTemplate = null;
        if (transformerRoot.getElementsByTagName("template").getLength() > 0 && (transformerTemplate = (Element)transformerRoot.getElementsByTagName("template").item(0)) != null) {
            template = transformerTemplate.getTextContent();
        }
        Element inboundTemplateElement = null;
        Element outboundTemplateElement = null;
        Element inboundProtocolElement = null;
        Element outboundProtocolElement = null;
        if (transformerRoot.getElementsByTagName("inboundTemplate").getLength() == 0) {
            inboundTemplateElement = document.createElement("inboundTemplate");
        }
        if (transformerRoot.getElementsByTagName("outboundTemplate").getLength() == 0) {
            outboundTemplateElement = document.createElement("outboundTemplate");
        }
        if (transformerRoot.getElementsByTagName("inboundProtocol").getLength() == 0) {
            inboundProtocolElement = document.createElement("inboundProtocol");
            inboundProtocolElement.setTextContent(incoming.toString());
        }
        if (transformerRoot.getElementsByTagName("outboundProtocol").getLength() == 0) {
            outboundProtocolElement = document.createElement("outboundProtocol");
            outboundProtocolElement.setTextContent(outgoing.toString());
        }
        if (transformerTemplate != null) {
            if (incoming.equals(HL7V2) && outgoing.equals(HL7V2)) {
                inboundTemplateElement.setTextContent(template);
            } else if (outgoing.equals(HL7V2)) {
                outboundTemplateElement.setTextContent(template);
            }
        }
        if (transformerRoot.getElementsByTagName("inboundTemplate").getLength() == 0) {
            transformerRoot.appendChild(inboundTemplateElement);
        }
        if (transformerRoot.getElementsByTagName("outboundTemplate").getLength() == 0) {
            transformerRoot.appendChild(outboundTemplateElement);
        }
        if (transformerRoot.getElementsByTagName("inboundProtocol").getLength() == 0) {
            transformerRoot.appendChild(inboundProtocolElement);
        }
        if (transformerRoot.getElementsByTagName("outboundProtocol").getLength() == 0) {
            transformerRoot.appendChild(outboundProtocolElement);
        }
        NodeList steps = ImportConverter.getElements(transformerRoot, "step", "com.mirth.connect.model.Step");
        for (int i = 0; i < steps.getLength(); ++i) {
            Element step = (Element)steps.item(i);
            NodeList stepTypesList = step.getElementsByTagName("type");
            if (stepTypesList.getLength() <= 0) continue;
            Element stepType = (Element)stepTypesList.item(0);
            if (stepType.getTextContent().equals("HL7 Message Builder")) {
                stepType.setTextContent("Message Builder");
            }
            if (!stepType.getTextContent().equals("Message Builder") && !stepType.getTextContent().equals("Mapper")) continue;
            boolean foundRegex = false;
            boolean foundDefaultValue = false;
            Element data = (Element)step.getElementsByTagName("data").item(0);
            NodeList entries = data.getElementsByTagName("entry");
            for (int j = 0; j < entries.getLength(); ++j) {
                NodeList strings = ((Element)entries.item(j)).getElementsByTagName("string");
                if (strings.getLength() <= 0) continue;
                if (strings.item(0).getTextContent().equals("RegularExpressions")) {
                    foundRegex = true;
                } else if (strings.item(0).getTextContent().equals("DefaultValue")) {
                    foundDefaultValue = true;
                }
                if (!strings.item(0).getTextContent().equals("isGlobal")) continue;
                if (strings.item(1).getTextContent().equals("0")) {
                    strings.item(1).setTextContent("channel");
                    continue;
                }
                if (!strings.item(1).getTextContent().equals("1")) continue;
                strings.item(1).setTextContent("global");
            }
            if (!foundRegex) {
                data.appendChild(ImportConverter.createRegexElement(document));
            }
            if (foundDefaultValue) continue;
            data.appendChild(ImportConverter.createDefaultValueElement(document));
        }
        if (transformerTemplate != null) {
            transformerRoot.removeChild(transformerTemplate);
        }
    }

    private static void updateTransformerFor1_5(Document document) {
        NodeList transformers = document.getElementsByTagName("transformer");
        for (int i = 0; i < transformers.getLength(); ++i) {
            Element useStrictParserProperty;
            Element useStrictValidationProperty;
            Element handleRepetitionsProperty;
            Element transformerRoot = (Element)transformers.item(i);
            if (transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals(HL7V2) && transformerRoot.getElementsByTagName("inboundProperties").getLength() == 0) {
                Element inboundPropertiesElement = document.createElement("inboundProperties");
                handleRepetitionsProperty = document.createElement("property");
                handleRepetitionsProperty.setAttribute("name", "handleRepetitions");
                handleRepetitionsProperty.setTextContent("false");
                useStrictValidationProperty = document.createElement("property");
                useStrictValidationProperty.setAttribute("name", "useStrictValidation");
                useStrictValidationProperty.setTextContent("false");
                useStrictParserProperty = document.createElement("property");
                useStrictParserProperty.setAttribute("name", "useStrictParser");
                useStrictParserProperty.setTextContent("false");
                inboundPropertiesElement.appendChild(handleRepetitionsProperty);
                inboundPropertiesElement.appendChild(useStrictValidationProperty);
                inboundPropertiesElement.appendChild(useStrictParserProperty);
                transformerRoot.appendChild(inboundPropertiesElement);
            }
            if (!transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals(HL7V2) || transformerRoot.getElementsByTagName("outboundProperties").getLength() != 0) continue;
            Element outboundPropertiesElement = document.createElement("outboundProperties");
            handleRepetitionsProperty = document.createElement("property");
            handleRepetitionsProperty.setAttribute("name", "handleRepetitions");
            handleRepetitionsProperty.setTextContent("false");
            useStrictValidationProperty = document.createElement("property");
            useStrictValidationProperty.setAttribute("name", "useStrictValidation");
            useStrictValidationProperty.setTextContent("false");
            useStrictParserProperty = document.createElement("property");
            useStrictParserProperty.setAttribute("name", "useStrictParser");
            useStrictParserProperty.setTextContent("false");
            outboundPropertiesElement.appendChild(handleRepetitionsProperty);
            outboundPropertiesElement.appendChild(useStrictValidationProperty);
            outboundPropertiesElement.appendChild(useStrictParserProperty);
            transformerRoot.appendChild(outboundPropertiesElement);
        }
    }

    private static void updateFilterFor1_7(Document document) {
        NodeList rules = ImportConverter.getElements(document, "rule", "com.mirth.connect.model.Rule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Element rule = (Element)rules.item(i);
            if (rule.getElementsByTagName("type").getLength() == 0) {
                Element typeElement = document.createElement("type");
                typeElement.setTextContent("JavaScript");
                rule.appendChild(typeElement);
            }
            if (rule.getElementsByTagName("data").getLength() != 0) continue;
            Element dataElement = document.createElement("data");
            dataElement.setAttribute("class", "map");
            Element entryElement = document.createElement("entry");
            Element keyElement = document.createElement("string");
            Element valueElement = document.createElement("string");
            keyElement.setTextContent("Script");
            valueElement.setTextContent(rule.getElementsByTagName("script").item(0).getTextContent());
            entryElement.appendChild(keyElement);
            entryElement.appendChild(valueElement);
            dataElement.appendChild(entryElement);
            rule.appendChild(dataElement);
        }
    }

    private static void updateTransformerFor1_7(Document document) {
        NodeList transformers = document.getElementsByTagName("transformer");
        for (int i = 0; i < transformers.getLength(); ++i) {
            Element outboundPropertiesElement;
            Element useStrictParserProperty;
            Element useStrictValidationProperty;
            Element handleRepetitionsProperty;
            Element encodeEntitiesProperty;
            Element convertLFtoCRProperty;
            Node nameAttribute;
            NodeList propertyNames;
            boolean hasEncodeEntities;
            Element transformerRoot = (Element)transformers.item(i);
            if (transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals(HL7V2)) {
                if (transformerRoot.getElementsByTagName("inboundProperties").getLength() != 0) {
                    inboundPropertiesElement = (Element)transformerRoot.getElementsByTagName("inboundProperties").item(0);
                    hasEncodeEntities = false;
                    propertyNames = inboundPropertiesElement.getElementsByTagName("property");
                    for (int j = 0; j < propertyNames.getLength(); ++j) {
                        nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                        if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("encodeEntities")) continue;
                        hasEncodeEntities = true;
                    }
                    if (!hasEncodeEntities) {
                        Element encodeEntities = document.createElement("property");
                        encodeEntities.setAttribute("name", "encodeEntities");
                        encodeEntities.setTextContent("true");
                        inboundPropertiesElement.appendChild(encodeEntities);
                    }
                    convertLFtoCRProperty = document.createElement("property");
                    convertLFtoCRProperty.setAttribute("name", "convertLFtoCR");
                    convertLFtoCRProperty.setTextContent("true");
                    inboundPropertiesElement.appendChild(convertLFtoCRProperty);
                } else {
                    inboundPropertiesElement = document.createElement("inboundProperties");
                    Element convertLFtoCRProperty2 = document.createElement("property");
                    convertLFtoCRProperty2.setAttribute("name", "convertLFtoCR");
                    convertLFtoCRProperty2.setTextContent("true");
                    encodeEntitiesProperty = document.createElement("property");
                    encodeEntitiesProperty.setAttribute("name", "encodeEntities");
                    encodeEntitiesProperty.setTextContent("true");
                    handleRepetitionsProperty = document.createElement("property");
                    handleRepetitionsProperty.setAttribute("name", "handleRepetitions");
                    handleRepetitionsProperty.setTextContent("false");
                    useStrictValidationProperty = document.createElement("property");
                    useStrictValidationProperty.setAttribute("name", "useStrictValidation");
                    useStrictValidationProperty.setTextContent("false");
                    useStrictParserProperty = document.createElement("property");
                    useStrictParserProperty.setAttribute("name", "useStrictParser");
                    useStrictParserProperty.setTextContent("false");
                    inboundPropertiesElement.appendChild(convertLFtoCRProperty2);
                    inboundPropertiesElement.appendChild(encodeEntitiesProperty);
                    inboundPropertiesElement.appendChild(handleRepetitionsProperty);
                    inboundPropertiesElement.appendChild(useStrictValidationProperty);
                    inboundPropertiesElement.appendChild(useStrictParserProperty);
                    transformerRoot.appendChild(inboundPropertiesElement);
                }
            }
            if (!transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals(HL7V2)) continue;
            if (transformerRoot.getElementsByTagName("outboundProperties").getLength() != 0) {
                outboundPropertiesElement = (Element)transformerRoot.getElementsByTagName("outboundProperties").item(0);
                hasEncodeEntities = false;
                propertyNames = outboundPropertiesElement.getElementsByTagName("property");
                for (int j = 0; j < propertyNames.getLength(); ++j) {
                    nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                    if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("encodeEntities")) continue;
                    hasEncodeEntities = true;
                }
                if (!hasEncodeEntities) {
                    Element encodeEntities = document.createElement("property");
                    encodeEntities.setAttribute("name", "encodeEntities");
                    encodeEntities.setTextContent("true");
                    outboundPropertiesElement.appendChild(encodeEntities);
                }
                convertLFtoCRProperty = document.createElement("property");
                convertLFtoCRProperty.setAttribute("name", "convertLFtoCR");
                convertLFtoCRProperty.setTextContent("true");
                outboundPropertiesElement.appendChild(convertLFtoCRProperty);
                continue;
            }
            outboundPropertiesElement = document.createElement("outboundProperties");
            Element convertLFtoCRProperty3 = document.createElement("property");
            convertLFtoCRProperty3.setAttribute("name", "convertLFtoCR");
            convertLFtoCRProperty3.setTextContent("true");
            encodeEntitiesProperty = document.createElement("property");
            encodeEntitiesProperty.setAttribute("name", "encodeEntities");
            encodeEntitiesProperty.setTextContent("true");
            handleRepetitionsProperty = document.createElement("property");
            handleRepetitionsProperty.setAttribute("name", "handleRepetitions");
            handleRepetitionsProperty.setTextContent("false");
            useStrictValidationProperty = document.createElement("property");
            useStrictValidationProperty.setAttribute("name", "useStrictValidation");
            useStrictValidationProperty.setTextContent("false");
            useStrictParserProperty = document.createElement("property");
            useStrictParserProperty.setAttribute("name", "useStrictParser");
            useStrictParserProperty.setTextContent("false");
            outboundPropertiesElement.appendChild(convertLFtoCRProperty3);
            outboundPropertiesElement.appendChild(encodeEntitiesProperty);
            outboundPropertiesElement.appendChild(handleRepetitionsProperty);
            outboundPropertiesElement.appendChild(useStrictValidationProperty);
            outboundPropertiesElement.appendChild(useStrictParserProperty);
            transformerRoot.appendChild(outboundPropertiesElement);
        }
    }

    private static void updateTransformerFor1_7_1(Document document) {
        NodeList transformers = document.getElementsByTagName("transformer");
        for (int i = 0; i < transformers.getLength(); ++i) {
            Node nameAttribute;
            int j;
            NodeList propertyNames;
            Element transformerRoot = (Element)transformers.item(i);
            if ((transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals(HL7V2) || transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals("EDI")) && transformerRoot.getElementsByTagName("inboundProperties").getLength() != 0) {
                Element inboundPropertiesElement = (Element)transformerRoot.getElementsByTagName("inboundProperties").item(0);
                propertyNames = inboundPropertiesElement.getElementsByTagName("property");
                for (j = 0; j < propertyNames.getLength(); ++j) {
                    nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                    if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("encodeEntities")) continue;
                    inboundPropertiesElement.removeChild(propertyNames.item(j));
                }
                propertyNames = inboundPropertiesElement.getElementsByTagName("property");
                for (j = 0; j < propertyNames.getLength(); ++j) {
                    nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                    if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("convertLFtoCR")) continue;
                    propertyNames.item(j).setTextContent("true");
                }
            }
            if (!transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals(HL7V2) && !transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals("EDI") || transformerRoot.getElementsByTagName("outboundProperties").getLength() == 0) continue;
            Element outboundPropertiesElement = (Element)transformerRoot.getElementsByTagName("outboundProperties").item(0);
            propertyNames = outboundPropertiesElement.getElementsByTagName("property");
            for (j = 0; j < propertyNames.getLength(); ++j) {
                nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("encodeEntities")) continue;
                outboundPropertiesElement.removeChild(propertyNames.item(j));
            }
            propertyNames = outboundPropertiesElement.getElementsByTagName("property");
            for (j = 0; j < propertyNames.getLength(); ++j) {
                nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("convertLFtoCR")) continue;
                propertyNames.item(j).setTextContent("true");
            }
        }
    }

    private static void updateTransformerFor1_8_1(Document document) {
        NodeList transformers = document.getElementsByTagName("transformer");
        for (int i = 0; i < transformers.getLength(); ++i) {
            Element outboundPropertiesElement;
            Element stripNamespacesProperty;
            Element transformerRoot = (Element)transformers.item(i);
            if (transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals(XML) || transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals(HL7V2) || transformerRoot.getElementsByTagName("inboundProtocol").item(0).getTextContent().equals("HL7V3")) {
                Element inboundPropertiesElement;
                if (transformerRoot.getElementsByTagName("inboundProperties").getLength() == 0) {
                    inboundPropertiesElement = document.createElement("inboundProperties");
                    transformerRoot.appendChild(inboundPropertiesElement);
                }
                inboundPropertiesElement = (Element)transformerRoot.getElementsByTagName("inboundProperties").item(0);
                stripNamespacesProperty = document.createElement("property");
                stripNamespacesProperty.setAttribute("name", "stripNamespaces");
                stripNamespacesProperty.setTextContent("true");
                NodeList propertyNames = document.getElementsByTagName("property");
                for (int j = 0; j < propertyNames.getLength(); ++j) {
                    Node nameAttribute = propertyNames.item(j).getAttributes().getNamedItem("name");
                    if (propertyNames.item(j).getAttributes().getLength() <= 0 || nameAttribute == null || !nameAttribute.getNodeValue().equals("removeNamespace")) continue;
                    stripNamespacesProperty.setTextContent(propertyNames.item(j).getTextContent());
                }
                inboundPropertiesElement.appendChild(stripNamespacesProperty);
            }
            if (!transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals(XML) && !transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals(HL7V2) && !transformerRoot.getElementsByTagName("outboundProtocol").item(0).getTextContent().equals("HL7V3")) continue;
            if (transformerRoot.getElementsByTagName("outboundProperties").getLength() == 0) {
                outboundPropertiesElement = document.createElement("outboundProperties");
                transformerRoot.appendChild(outboundPropertiesElement);
            }
            outboundPropertiesElement = (Element)transformerRoot.getElementsByTagName("outboundProperties").item(0);
            stripNamespacesProperty = document.createElement("property");
            stripNamespacesProperty.setAttribute("name", "stripNamespaces");
            stripNamespacesProperty.setTextContent("true");
            outboundPropertiesElement.appendChild(stripNamespacesProperty);
        }
    }

    private static void updateFilterFor2_0(Document document) {
        NodeList rules = ImportConverter.getElements(document, "rule", "com.mirth.connect.model.Rule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Element rule = (Element)rules.item(i);
            if (!rule.getElementsByTagName("type").item(0).getTextContent().equalsIgnoreCase("Rule Builder")) continue;
            boolean reject = false;
            NodeList entries = rule.getElementsByTagName("entry");
            for (int j = 0; j < entries.getLength(); ++j) {
                NodeList entry = ((Element)entries.item(j)).getElementsByTagName("string");
                if (entry.getLength() != 2 || !entry.item(0).getTextContent().equalsIgnoreCase("Accept") || !entry.item(1).getTextContent().equalsIgnoreCase("0")) continue;
                reject = true;
            }
            if (!reject) continue;
            rule.getElementsByTagName("type").item(0).setTextContent("JavaScript");
            rule.removeChild(rule.getElementsByTagName("data").item(0));
            Element dataElement = document.createElement("data");
            dataElement.setAttribute("class", "map");
            Element entryElement = document.createElement("entry");
            Element keyElement = document.createElement("string");
            Element valueElement = document.createElement("string");
            keyElement.setTextContent("Script");
            valueElement.setTextContent(rule.getElementsByTagName("script").item(0).getTextContent());
            entryElement.appendChild(keyElement);
            entryElement.appendChild(valueElement);
            dataElement.appendChild(entryElement);
            rule.appendChild(dataElement);
        }
    }

    private static Element createRegexElement(Document document) {
        Element entryElement = document.createElement("entry");
        Element regexElement = document.createElement("string");
        Element listElement = document.createElement("list");
        regexElement.setTextContent("RegularExpressions");
        entryElement.appendChild(regexElement);
        entryElement.appendChild(listElement);
        return entryElement;
    }

    private static Element createDefaultValueElement(Document document) {
        Element entryElement = document.createElement("entry");
        Element defaultValueElement = document.createElement("string");
        Element defaultValueValueElement = document.createElement("string");
        defaultValueElement.setTextContent("DefaultValue");
        entryElement.appendChild(defaultValueElement);
        entryElement.appendChild(defaultValueValueElement);
        return entryElement;
    }

    private static String updateLocalAndGlobalVariables(String xml) throws Exception {
        xml = xml.replaceAll("localMap.put", "channelMap.put");
        xml = xml.replaceAll("localMap.get", "channelMap.get");
        return xml;
    }

    private static String removeInvalidHexChar(String string) {
        char i;
        String result = string;
        for (i = '\u0000'; i <= '\b'; i = (char)(i + 1)) {
            result = result.replace(i, ' ');
        }
        for (i = '\u000b'; i <= '\f'; i = (char)(i + '\u0001')) {
            result = result.replace(i, ' ');
        }
        for (i = '\u000e'; i <= '\u001f'; i = (char)(i + '\u0001')) {
            result = result.replace(i, ' ');
        }
        return result;
    }

    private static boolean nodeChildrenContains(Node parent, String elementName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(elementName)) continue;
            return true;
        }
        return false;
    }

    private static void setBooleanNode(Node parent, String elementName, boolean value) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(elementName)) continue;
            child.setTextContent(Boolean.toString(value));
        }
    }

    private static NodeList getElements(Document document, String tagName, String ... oldTagNames) {
        NodeList elements = document.getElementsByTagName(tagName);
        for (int i = 0; elements.getLength() == 0 && i < oldTagNames.length; ++i) {
            elements = document.getElementsByTagName(oldTagNames[i]);
        }
        return elements;
    }

    private static NodeList getElements(Element element, String tagName, String ... oldTagNames) {
        NodeList elements = element.getElementsByTagName(tagName);
        for (int i = 0; elements.getLength() == 0 && i < oldTagNames.length; ++i) {
            elements = element.getElementsByTagName(oldTagNames[i]);
        }
        return elements;
    }

    private static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf;
    }

    private static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

