/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server;

import com.google.inject.Inject;
import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginClass;
import com.mirth.connect.model.PluginClassCondition;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.server.extprops.ExtensionStatuses;
import com.mirth.connect.server.tools.ClassPathResource;
import com.mirth.connect.server.util.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtensionLoader {
    @Inject
    private static ExtensionLoader instance = new ExtensionLoader();
    private Map<String, ConnectorMetaData> connectorMetaDataMap = new HashMap<String, ConnectorMetaData>();
    private Map<String, PluginMetaData> pluginMetaDataMap = new HashMap<String, PluginMetaData>();
    private Map<String, ConnectorMetaData> connectorProtocolsMap = new HashMap<String, ConnectorMetaData>();
    private Map<String, MetaData> invalidMetaDataMap = new HashMap<String, MetaData>();
    private boolean loadedExtensions = false;
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private static Logger logger = LogManager.getLogger(ExtensionLoader.class);

    public static ExtensionLoader getInstance() {
        return instance;
    }

    private ExtensionLoader() {
    }

    public Map<String, ConnectorMetaData> getConnectorMetaData() {
        this.loadExtensions();
        return this.connectorMetaDataMap;
    }

    public Map<String, PluginMetaData> getPluginMetaData() {
        this.loadExtensions();
        return this.pluginMetaDataMap;
    }

    public Map<String, ConnectorMetaData> getConnectorProtocols() {
        this.loadExtensions();
        return this.connectorProtocolsMap;
    }

    public Map<String, MetaData> getInvalidMetaData() {
        this.loadExtensions();
        return this.invalidMetaDataMap;
    }

    public <T> Class<T> getControllerClass(Class<T> abstractClass) {
        Class<?> overrideClass = null;
        PluginClass highestPluginClassModel = null;
        ExtensionStatuses extensionStatuses = ExtensionStatuses.getInstance();
        for (PluginMetaData pluginMetaData : this.getPluginMetaData().values()) {
            List<PluginClass> controllerClasses;
            if (!extensionStatuses.isEnabled(pluginMetaData.getName()) || (controllerClasses = pluginMetaData.getControllerClasses()) == null) continue;
            for (PluginClass controllerClassModel : controllerClasses) {
                boolean accept = true;
                String conditionClass = controllerClassModel.getConditionClass();
                if (StringUtils.isNotBlank((CharSequence)conditionClass)) {
                    try {
                        accept = ((PluginClassCondition)Class.forName(conditionClass).newInstance()).accept(controllerClassModel);
                    }
                    catch (Exception e) {
                        logger.warn("Error instantiating plugin condition class \"" + conditionClass + "\".");
                    }
                }
                if (!accept) continue;
                try {
                    Class<?> pluginClass = Class.forName(controllerClassModel.getName());
                    if (!abstractClass.isAssignableFrom(pluginClass) || highestPluginClassModel != null && highestPluginClassModel.getWeight() >= controllerClassModel.getWeight()) continue;
                    highestPluginClassModel = controllerClassModel;
                    overrideClass = pluginClass;
                }
                catch (Exception e) {
                    logger.error("An error occurred while attempting to load \"" + controllerClassModel.getName() + "\" from plugin: " + pluginMetaData.getName(), (Throwable)e);
                }
            }
        }
        return overrideClass;
    }

    public <T> T getControllerInstance(Class<T> abstractClass) {
        Class<T> overrideClass = this.getControllerClass(abstractClass);
        if (overrideClass != null) {
            try {
                T instance = overrideClass.newInstance();
                logger.debug("Using custom " + abstractClass.getSimpleName() + ": " + overrideClass.getName());
                return instance;
            }
            catch (Exception e) {
                logger.error("An error occurred while attempting to instantiate " + abstractClass.getSimpleName() + " implementation: " + overrideClass.getName(), (Throwable)e);
            }
        }
        logger.debug("Using default " + abstractClass.getSimpleName());
        return null;
    }

    public boolean isExtensionCompatible(MetaData metaData) {
        String serverMirthVersion;
        try {
            serverMirthVersion = this.getServerVersion();
        }
        catch (Exception e) {
            logger.error("An error occurred while attempting to determine the current server version.", (Throwable)e);
            return false;
        }
        String[] extensionMirthVersions = metaData.getMirthVersion().split(",");
        logger.debug("checking extension \"" + metaData.getName() + "\" version compatability: versions=" + ArrayUtils.toString((Object)extensionMirthVersions) + ", server=" + serverMirthVersion);
        if (serverMirthVersion.split("\\.").length == 4) {
            serverMirthVersion = serverMirthVersion.substring(0, serverMirthVersion.lastIndexOf(46));
        }
        for (int i = 0; i < extensionMirthVersions.length; ++i) {
            if (!extensionMirthVersions[i].trim().equals(serverMirthVersion)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadExtensions() {
        if (!this.loadedExtensions) {
            try {
                NameFileFilter nameFileFilter = new NameFileFilter(new String[]{"plugin.xml", "source.xml", "destination.xml"});
                AndFileFilter andFileFilter = new AndFileFilter((IOFileFilter)nameFileFilter, FileFilterUtils.fileFileFilter());
                File extensionPath = new File(this.getExtensionsPath());
                Collection extensionFiles = FileUtils.listFiles((File)extensionPath, (IOFileFilter)andFileFilter, (IOFileFilter)FileFilterUtils.trueFileFilter());
                for (File extensionFile : extensionFiles) {
                    try {
                        MetaData metaData = this.serializer.deserialize(FileUtils.readFileToString((File)extensionFile), MetaData.class);
                        if (this.isExtensionCompatible(metaData)) {
                            if (metaData instanceof ConnectorMetaData) {
                                ConnectorMetaData connectorMetaData = (ConnectorMetaData)metaData;
                                this.connectorMetaDataMap.put(connectorMetaData.getName(), connectorMetaData);
                                if (StringUtils.contains((CharSequence)connectorMetaData.getProtocol(), (CharSequence)":")) {
                                    for (String protocol : connectorMetaData.getProtocol().split(":")) {
                                        this.connectorProtocolsMap.put(protocol, connectorMetaData);
                                    }
                                    continue;
                                }
                                this.connectorProtocolsMap.put(connectorMetaData.getProtocol(), connectorMetaData);
                                continue;
                            }
                            if (!(metaData instanceof PluginMetaData)) continue;
                            this.pluginMetaDataMap.put(metaData.getName(), (PluginMetaData)metaData);
                            continue;
                        }
                        logger.error("Extension \"" + metaData.getName() + "\" is not compatible with this version of BridgeLink and was not loaded. Please install a compatible version.");
                        this.invalidMetaDataMap.put(metaData.getName(), metaData);
                    }
                    catch (Exception e) {
                        logger.error("Error reading or parsing extension metadata file: " + extensionFile.getName(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error loading extension metadata.", (Throwable)e);
            }
            finally {
                this.loadedExtensions = true;
            }
        }
    }

    private String getExtensionsPath() {
        if (ClassPathResource.getResourceURI("extensions") != null) {
            return ClassPathResource.getResourceURI("extensions").getPath() + File.separator;
        }
        return new File(ClassPathResource.getResourceURI("mirth.properties")).getParentFile().getParent() + File.separator + "extensions" + File.separator;
    }

    private String getServerVersion() throws FileNotFoundException, ConfigurationException {
        PropertiesConfiguration versionConfig = PropertiesConfigurationUtil.create();
        InputStream versionPropertiesStream = null;
        try {
            versionPropertiesStream = ResourceUtil.getResourceStream(ExtensionLoader.class, "version.properties");
            versionConfig = PropertiesConfigurationUtil.create((InputStream)versionPropertiesStream);
        }
        finally {
            ResourceUtil.closeResourceQuietly(versionPropertiesStream);
        }
        return versionConfig.getString("mirth.version");
    }
}

