/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server;

import com.mirth.connect.model.Channel;
import com.mirth.connect.server.controllers.ControllerFactory;
import org.mozilla.javascript.RhinoException;

public class MirthJavascriptTransformerException
extends Exception {
    private static final long serialVersionUID = 1L;
    String message;
    Exception exception;
    private String lineSeperator = System.getProperty("line.separator");

    public MirthJavascriptTransformerException(RhinoException e, String channelId, String connectorName, int lineOffset, String scriptSource, String sourceCode) {
        super((Throwable)e);
        Channel channel;
        this.exception = e;
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(this.lineSeperator);
        if (channelId != null && (channel = ControllerFactory.getFactory().createChannelController().getDeployedChannelById(channelId)) != null) {
            sBuilder.append("CHANNEL:\t").append(channel.getName());
            sBuilder.append(this.lineSeperator);
        }
        if (connectorName != null) {
            sBuilder.append("CONNECTOR:\t" + connectorName);
            sBuilder.append(this.lineSeperator);
        }
        if (scriptSource != null) {
            sBuilder.append("SCRIPT SOURCE:\t" + scriptSource);
            sBuilder.append(this.lineSeperator);
        }
        if (sourceCode != null) {
            sBuilder.append("SOURCE CODE:\t" + sourceCode);
            sBuilder.append(this.lineSeperator);
        }
        sBuilder.append("LINE NUMBER:\t").append(e.lineNumber() - lineOffset);
        sBuilder.append(this.lineSeperator);
        if (e.lineSource() != null) {
            sBuilder.append("LINE SOURCE:\t").append(e.lineSource());
            sBuilder.append(this.lineSeperator);
        }
        sBuilder.append("DETAILS:\t" + e.details() + "\n" + e.getScriptStackTrace().replaceAll("\\s+$", ""));
        this.message = sBuilder.toString();
    }

    @Override
    public Throwable getCause() {
        return this.exception.getCause();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.message;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.exception.getStackTrace();
    }
}

