/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.alert;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.server.controllers.ConfigurationController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.tools.generic.DateTool;

public class Alert {
    private Logger logger = LogManager.getLogger(this.getClass());
    public static Class<?> USER_PROTOCOL_CLASS;
    private AlertModel model;
    private Long enabledDateTime;
    private Long enabledNanoTime;
    private Map<Object, Object> properties;
    private AtomicInteger alertedCount;

    public Alert(AlertModel model) {
        this.model = model;
        this.enabledDateTime = System.currentTimeMillis();
        this.enabledNanoTime = System.nanoTime();
        this.alertedCount = new AtomicInteger(0);
        this.properties = new HashMap<Object, Object>();
    }

    public AlertModel getModel() {
        return this.model;
    }

    public Long getEnabledDateTime() {
        return this.enabledDateTime;
    }

    public Long getEnabledNanoTime() {
        return this.enabledNanoTime;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> createContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("alertId", this.model.getId());
        context.put("alertName", this.model.getName());
        context.put("serverId", ConfigurationController.getInstance().getServerId());
        context.putAll(this.getServerSettings());
        context.put("date", new DateTool());
        return context;
    }

    private Map<String, Object> getServerSettings() {
        try {
            ServerSettings settings = ConfigurationController.getInstance().getServerSettings();
            return Map.ofEntries(Map.entry("serverName", StringUtils.defaultString((String)settings.getServerName())), Map.entry("environmentName", StringUtils.defaultString((String)settings.getEnvironmentName())));
        }
        catch (ControllerException e) {
            this.logger.warn("Failed to retrieve server settings", (Throwable)e);
            return Map.of();
        }
    }

    public int getAlertedCount() {
        return this.alertedCount.get();
    }

    public void incrementAlertedCount() {
        this.alertedCount.incrementAndGet();
    }

    public void resetAlertedCount() {
        this.alertedCount.set(0);
    }
}

