/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.alert;

import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.alert.AlertAction;
import com.mirth.connect.model.alert.AlertActionGroup;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertStatus;
import com.mirth.connect.plugins.ServerPlugin;
import com.mirth.connect.server.alert.Alert;
import com.mirth.connect.server.alert.AlertActionAcceptor;
import com.mirth.connect.server.alert.action.Protocol;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.event.EventListener;
import com.mirth.connect.server.util.ServerSMTPConnectionFactory;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AlertWorker
extends EventListener
implements AlertActionAcceptor {
    private static final String DEFAULT_SUBJECT = "BridgeLink Alert";
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected ExecutorService actionExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    protected Map<String, Alert> enabledAlerts = new ConcurrentHashMap<String, Alert>();
    protected EventController eventController = ControllerFactory.getFactory().createEventController();
    protected ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private AlertController alertController;
    private String serverId = ControllerFactory.getFactory().createConfigurationController().getServerId();
    private List<AlertActionAcceptor> alertActionAcceptors = new ArrayList<AlertActionAcceptor>();

    public AlertWorker() {
        for (ServerPlugin serverPlugin : this.extensionController.getServerPlugins()) {
            if (!(serverPlugin instanceof AlertActionAcceptor)) continue;
            this.alertActionAcceptors.add((AlertActionAcceptor)((Object)serverPlugin));
        }
    }

    public void enableAlert(AlertModel alertModel) {
        Alert alert = new Alert(alertModel);
        this.enabledAlerts.put(alertModel.getId(), alert);
        this.alertEnabled(alert);
    }

    public void disableAlert(String alertId) {
        Alert alert = this.enabledAlerts.remove(alertId);
        if (alert != null) {
            this.alertDisabled(alert);
        }
    }

    public AlertStatus getAlertStatus(String alertId) {
        Alert alert = this.enabledAlerts.get(alertId);
        if (alert != null) {
            AlertStatus alertStatus = new AlertStatus();
            alertStatus.setAlertedCount(alert.getAlertedCount());
            return alertStatus;
        }
        return null;
    }

    public Alert getEnabledAlert(String alertId) {
        return this.enabledAlerts.get(alertId);
    }

    @Override
    public boolean acceptAlertAction(Alert alert, Map<String, Object> context) {
        for (AlertActionAcceptor acceptor : this.alertActionAcceptors) {
            if (acceptor.acceptAlertAction(alert, context)) continue;
            return false;
        }
        return true;
    }

    protected abstract void alertEnabled(Alert var1);

    protected abstract void alertDisabled(Alert var1);

    public abstract Class<?> getTriggerClass();

    protected abstract void triggerAction(Alert var1, Map<String, Object> var2);

    protected class ActionTask
    implements Callable<Void> {
        private String alertId;
        private AlertActionGroup actionGroup;
        private Map<String, Object> context;
        private long taskCreatedNanoTime;

        public ActionTask(String alertId, AlertActionGroup actionGroup, Map<String, Object> context) {
            this.alertId = alertId;
            this.actionGroup = actionGroup;
            this.context = context;
            this.taskCreatedNanoTime = System.nanoTime();
        }

        @Override
        public Void call() throws Exception {
            Alert alert = AlertWorker.this.enabledAlerts.get(this.alertId);
            if (alert != null && alert.getEnabledNanoTime() <= this.taskCreatedNanoTime) {
                TemplateValueReplacer replacer = new TemplateValueReplacer();
                String subject = null;
                String body = null;
                if (this.actionGroup.getSubject() != null) {
                    subject = replacer.replaceValues(this.actionGroup.getSubject(), this.context);
                }
                if (this.actionGroup.getTemplate() != null) {
                    body = replacer.replaceValues(this.actionGroup.getTemplate(), this.context);
                }
                if (StringUtils.isEmpty(subject)) {
                    subject = AlertWorker.DEFAULT_SUBJECT;
                }
                LinkedHashMap<String, ArrayList<String>> protocolRecipients = new LinkedHashMap<String, ArrayList<String>>();
                for (AlertAction alertAction : this.actionGroup.getActions()) {
                    String string = replacer.replaceValues(alertAction.getRecipient(), this.context);
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    ArrayList<String> recipients = (ArrayList<String>)protocolRecipients.get(alertAction.getProtocol());
                    if (recipients == null) {
                        recipients = new ArrayList<String>();
                        protocolRecipients.put(alertAction.getProtocol(), recipients);
                    }
                    recipients.add(string);
                }
                if (AlertWorker.this.alertController == null) {
                    AlertWorker.this.alertController = ControllerFactory.getFactory().createAlertController();
                }
                HashSet<String> emailAddresses = new HashSet<String>();
                for (Map.Entry entry : protocolRecipients.entrySet()) {
                    String protocolName = (String)entry.getKey();
                    try {
                        Protocol alertProtocol = AlertWorker.this.alertController.getAlertActionProtocol(protocolName);
                        if (alertProtocol == null) {
                            AlertWorker.this.logger.warn("Alert protocol '" + protocolName + "' is not currently installed, skipping.");
                            continue;
                        }
                        List recipients = (List)entry.getValue();
                        List<String> protocolEmailAddresses = alertProtocol.getEmailAddressesForDispatch(recipients);
                        alertProtocol.doCustomDispatch(recipients, subject, body);
                        if (!CollectionUtils.isNotEmpty(protocolEmailAddresses)) continue;
                        emailAddresses.addAll(protocolEmailAddresses);
                    }
                    catch (Exception e) {
                        AlertWorker.this.logger.error("An error occurred while attempting to dispatch '" + protocolName + "' alerts.", (Throwable)e);
                    }
                }
                if (!emailAddresses.isEmpty()) {
                    try {
                        ServerSMTPConnectionFactory.createSMTPConnection().send(StringUtils.join(emailAddresses, (String)","), null, subject, body);
                    }
                    catch (Exception exception) {
                        AlertWorker.this.logger.error("Error sending alert email.", (Throwable)exception);
                    }
                }
                ServerEvent serverEvent = new ServerEvent(AlertWorker.this.serverId, "Alert Dispatched");
                for (Map.Entry<String, Object> entry : this.context.entrySet()) {
                    String value = entry.getValue().toString();
                    serverEvent.addAttribute(entry.getKey(), value);
                }
                AlertWorker.this.eventController.dispatchEvent(serverEvent);
            }
            return null;
        }
    }
}

