/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.alert.action;

import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.model.Channel;
import com.mirth.connect.server.alert.action.Protocol;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelProtocol
implements Protocol {
    public static final String NAME = "Channel";
    private ChannelController channelController = ControllerFactory.getFactory().createChannelController();
    private EngineController engineController = ControllerFactory.getFactory().createEngineController();
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, String> getRecipientOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        for (Channel channelModel : ControllerFactory.getFactory().createChannelController().getChannels(null)) {
            options.put(channelModel.getId(), channelModel.getName());
        }
        return options;
    }

    @Override
    public List<String> getEmailAddressesForDispatch(List<String> channelIds) {
        return null;
    }

    @Override
    public void doCustomDispatch(List<String> channelIdsOrName, String subject, String content) {
        for (String channelIdOrName : channelIdsOrName) {
            Channel channel = this.channelController.getDeployedChannelById(channelIdOrName);
            if (channel == null) {
                channel = this.channelController.getDeployedChannelByName(channelIdOrName);
            }
            if (channel != null) {
                try {
                    this.engineController.dispatchRawMessage(channel.getId(), new RawMessage(content), false, true);
                }
                catch (Exception e) {
                    this.logger.warn("Could not send alert to channel " + channelIdOrName, (Throwable)e);
                }
                continue;
            }
            this.logger.warn("Could not send alert to channel " + channelIdOrName);
        }
    }
}

