/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.alert.action;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.User;
import com.mirth.connect.server.alert.action.Protocol;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.UserController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserProtocol
implements Protocol {
    private UserController userController = ControllerFactory.getFactory().createUserController();
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public String getName() {
        return "User";
    }

    @Override
    public Map<String, String> getRecipientOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        try {
            for (User user : UserController.getInstance().getAllUsers()) {
                options.put(user.getId().toString(), user.getUsername());
            }
        }
        catch (ControllerException e) {
            this.logger.error("An error occurred while attempting to fetch users.", (Throwable)e);
        }
        return options;
    }

    @Override
    public List<String> getEmailAddressesForDispatch(List<String> recipients) {
        try {
            LinkedHashSet<String> emailAddresses = new LinkedHashSet<String>();
            List<User> users = this.userController.getAllUsers();
            HashSet<Integer> userIds = new HashSet<Integer>();
            HashSet<String> usernames = new HashSet<String>();
            HashMap<Integer, String> userMap = new HashMap<Integer, String>();
            for (User user : users) {
                userMap.put(user.getId(), user.getUsername());
            }
            for (String recipient : recipients) {
                if (NumberUtils.isNumber((String)recipient) && userMap.containsKey(NumberUtils.toInt((String)recipient))) {
                    userIds.add(NumberUtils.toInt((String)recipient));
                    continue;
                }
                if (!userMap.containsValue(recipient)) continue;
                usernames.add(recipient);
            }
            for (User user : users) {
                if (!userIds.contains(user.getId()) && !usernames.contains(user.getUsername()) || !StringUtils.isNotBlank((CharSequence)user.getEmail())) continue;
                emailAddresses.add(user.getEmail());
            }
            return new ArrayList<String>(emailAddresses);
        }
        catch (Exception e) {
            this.logger.error("An error occurred while attempting to look up email addresses for users.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void doCustomDispatch(List<String> recipients, String subject, String content) {
    }
}

