/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.providers;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.Provider;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Provider
public class ApiOriginFilter
implements Filter {
    private String allowOrigin;
    private String allowCredentials;
    private String allowMethods;
    private String allowHeaders;
    private String exposeHeaders;
    private String maxAge;

    public ApiOriginFilter(PropertiesConfiguration mirthProperties) {
        this.allowOrigin = mirthProperties.getString("server.api.accesscontrolalloworigin");
        this.allowCredentials = mirthProperties.getString("server.api.accesscontrolallowcredentials");
        this.allowMethods = mirthProperties.getString("server.api.accesscontrolallowmethods");
        this.allowHeaders = mirthProperties.getString("server.api.accesscontrolallowheaders");
        this.exposeHeaders = mirthProperties.getString("server.api.accesscontrolexposeheaders");
        this.maxAge = mirthProperties.getString("server.api.accesscontrolmaxage");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        if (StringUtils.isNotBlank((CharSequence)this.allowOrigin)) {
            res.addHeader("Access-Control-Allow-Origin", this.allowOrigin);
        }
        if (StringUtils.isNotBlank((CharSequence)this.allowCredentials)) {
            res.addHeader("Access-Control-Allow-Credentials", Boolean.toString(BooleanUtils.toBoolean((String)this.allowCredentials)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.allowMethods)) {
            res.addHeader("Access-Control-Allow-Methods", this.allowMethods);
        }
        if (StringUtils.isNotBlank((CharSequence)this.allowHeaders)) {
            res.addHeader("Access-Control-Allow-Headers", this.allowHeaders);
        }
        if (StringUtils.isNotBlank((CharSequence)this.exposeHeaders)) {
            res.addHeader("Access-Control-Expose-Headers", this.exposeHeaders);
        }
        if (StringUtils.isNotBlank((CharSequence)this.maxAge)) {
            res.addHeader("Access-Control-Max-Age", Long.toString(NumberUtils.toLong((String)this.maxAge, (long)300L)));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

