/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.providers;

import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.CheckAuthorizedUserId;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

@Provider
public class MirthResourceInvocationHandlerProvider
implements ResourceMethodInvocationHandlerProvider {
    private static Map<Class<? extends MirthServlet>, Map<Method, MethodInfo>> infoMap = new ConcurrentHashMap<Class<? extends MirthServlet>, Map<Method, MethodInfo>>();

    public InvocationHandler create(Invocable method) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String originalThreadName = Thread.currentThread().getName();
                try {
                    if (proxy instanceof MirthServlet) {
                        try {
                            Operation operation;
                            MethodInfo methodInfo;
                            MirthServlet mirthServlet = (MirthServlet)proxy;
                            Map<Method, MethodInfo> methodMap = infoMap.get(proxy.getClass());
                            if (methodMap == null) {
                                methodMap = new ConcurrentHashMap<Method, MethodInfo>();
                                infoMap.put(mirthServlet.getClass(), methodMap);
                            }
                            if ((methodInfo = methodMap.get(method)) == null) {
                                methodInfo = new MethodInfo();
                                methodMap.put(method, methodInfo);
                            }
                            if ((operation = methodInfo.getOperation()) == null) {
                                block8: for (Class<?> clazz = proxy.getClass(); clazz != null && operation == null; clazz = clazz.getSuperclass()) {
                                    for (Class<?> interfaceClass : clazz.getInterfaces()) {
                                        if (!BaseServletInterface.class.isAssignableFrom(interfaceClass) || (operation = OperationUtil.getOperation(interfaceClass, (Method)method)) == null) continue;
                                        methodInfo.setOperation(operation);
                                        continue block8;
                                    }
                                }
                            }
                            mirthServlet.setOperation(operation);
                            Thread.currentThread().setName(mirthServlet.getClass().getSimpleName() + " Thread (" + operation.getDisplayName() + ") < " + originalThreadName);
                            Boolean checkAuthorized = methodInfo.getCheckAuthorized();
                            if (checkAuthorized == null) {
                                checkAuthorized = true;
                                Method matchingMethod = mirthServlet.getClass().getMethod(method.getName(), method.getParameterTypes());
                                if (matchingMethod != null) {
                                    checkAuthorized = matchingMethod.getAnnotation(DontCheckAuthorized.class) == null;
                                    methodInfo.setCheckAuthorizedChannelId(matchingMethod.getAnnotation(CheckAuthorizedChannelId.class));
                                    methodInfo.setCheckAuthorizedUserId(matchingMethod.getAnnotation(CheckAuthorizedUserId.class));
                                }
                                methodInfo.setCheckAuthorized(checkAuthorized);
                            }
                            if (checkAuthorized.booleanValue()) {
                                Integer channelIdIndex = methodInfo.getChannelIdIndex();
                                Integer userIdIndex = methodInfo.getUserIdIndex();
                                if (args.length > 0) {
                                    List<String> paramNames = methodInfo.getParamNames();
                                    if (paramNames == null) {
                                        paramNames = new ArrayList<String>();
                                        ArrayList<Integer> notFoundIndicies = new ArrayList<Integer>();
                                        int count = 0;
                                        for (Annotation[] paramAnnotations : method.getParameterAnnotations()) {
                                            boolean found = false;
                                            for (Annotation annotation : paramAnnotations) {
                                                if (!(annotation instanceof Param)) continue;
                                                Param param = (Param)annotation;
                                                paramNames.add(param.excludeFromAudit() ? null : param.value());
                                                found = true;
                                                break;
                                            }
                                            if (!found) {
                                                notFoundIndicies.add(count);
                                                paramNames.add(null);
                                            }
                                            ++count;
                                        }
                                        if (CollectionUtils.isNotEmpty(notFoundIndicies)) {
                                            for (Integer index : notFoundIndicies) {
                                                paramNames.set(index, MirthResourceInvocationHandlerProvider.this.getDefaultParamName(paramNames));
                                            }
                                        }
                                        methodInfo.setParamNames(paramNames);
                                    }
                                    for (int i = 0; i < args.length; ++i) {
                                        String paramName = paramNames.get(i);
                                        if (paramName == null) continue;
                                        mirthServlet.addToParameterMap(paramNames.get(i), args[i]);
                                    }
                                    if (channelIdIndex == null) {
                                        channelIdIndex = -1;
                                        if (methodInfo.getCheckAuthorizedChannelId() != null) {
                                            channelIdIndex = paramNames.indexOf(methodInfo.getCheckAuthorizedChannelId().paramName());
                                        }
                                        methodInfo.setChannelIdIndex(channelIdIndex);
                                    }
                                    if (userIdIndex == null) {
                                        userIdIndex = -1;
                                        if (methodInfo.getCheckAuthorizedUserId() != null) {
                                            userIdIndex = paramNames.indexOf(methodInfo.getCheckAuthorizedUserId().paramName());
                                        }
                                        methodInfo.setUserIdIndex(userIdIndex);
                                    }
                                }
                                if (channelIdIndex != null && channelIdIndex >= 0) {
                                    mirthServlet.checkUserAuthorized((String)args[channelIdIndex]);
                                } else if (userIdIndex != null && userIdIndex >= 0) {
                                    mirthServlet.checkUserAuthorized((Integer)args[userIdIndex], methodInfo.getCheckAuthorizedUserId().auditCurrentUser());
                                } else {
                                    mirthServlet.checkUserAuthorized();
                                }
                            }
                        }
                        catch (Throwable t) {
                            Throwable converted = MirthResourceInvocationHandlerProvider.this.convertThrowable(t, new HashSet<Throwable>());
                            if (converted != null) {
                                t = converted;
                            }
                            if (!(t instanceof WebApplicationException)) {
                                t = new MirthApiException(t);
                            }
                            throw new InvocationTargetException(t);
                        }
                    }
                    try {
                        Object t = method.invoke(proxy, args);
                        return t;
                    }
                    catch (InvocationTargetException e) {
                        Throwable converted = MirthResourceInvocationHandlerProvider.this.convertThrowable(e, new HashSet<Throwable>());
                        if (converted != null && converted instanceof InvocationTargetException) {
                            e = (InvocationTargetException)converted;
                        }
                        throw e;
                    }
                }
                finally {
                    Thread.currentThread().setName(originalThreadName);
                }
            }
        };
    }

    private Throwable convertThrowable(Throwable t, Set<Throwable> visited) {
        if (t == null || visited.contains(t)) {
            return null;
        }
        visited.add(t);
        Throwable cause = t.getCause();
        Throwable convertedCause = this.convertThrowable(cause, visited);
        if (t instanceof PersistenceException) {
            return new com.mirth.connect.client.core.api.PersistenceException(t.getMessage(), convertedCause != null ? convertedCause : cause);
        }
        if (t instanceof WebApplicationException) {
            Throwable convertedEntity;
            Object entity;
            Response response = ((WebApplicationException)t).getResponse();
            Response convertedResponse = null;
            if (response != null && response.hasEntity() && (entity = response.getEntity()) instanceof Throwable && (convertedEntity = this.convertThrowable((Throwable)entity, visited)) != null) {
                convertedResponse = Response.fromResponse((Response)response).entity((Object)convertedEntity).build();
            }
            if (convertedResponse != null) {
                return new MirthApiException(convertedResponse);
            }
            if (convertedCause != null) {
                return new MirthApiException(convertedCause);
            }
        } else if (t instanceof InvocationTargetException) {
            if (convertedCause != null) {
                if (!(convertedCause instanceof WebApplicationException)) {
                    convertedCause = new MirthApiException(convertedCause);
                }
                return new InvocationTargetException(convertedCause);
            }
            if (cause != null && !(cause instanceof WebApplicationException)) {
                return new InvocationTargetException((Throwable)new MirthApiException(cause));
            }
        } else if (convertedCause != null) {
            try {
                return (Throwable)t.getClass().getConstructor(String.class, Throwable.class).newInstance(t.getMessage(), convertedCause);
            }
            catch (Throwable throwable) {
                try {
                    return (Throwable)t.getClass().getConstructor(Throwable.class).newInstance(convertedCause);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String getDefaultParamName(List<String> paramNames) {
        String name;
        int count = 0;
        do {
            name = "arg" + count;
            ++count;
        } while (paramNames.contains(name));
        return name;
    }

    private class MethodInfo {
        private Operation operation;
        private Boolean checkAuthorized;
        private CheckAuthorizedChannelId checkAuthorizedChannelId;
        private CheckAuthorizedUserId checkAuthorizedUserId;
        private List<String> paramNames;
        private Integer channelIdIndex;
        private Integer userIdIndex;

        private MethodInfo() {
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public Boolean getCheckAuthorized() {
            return this.checkAuthorized;
        }

        public void setCheckAuthorized(Boolean checkAuthorized) {
            this.checkAuthorized = checkAuthorized;
        }

        public CheckAuthorizedChannelId getCheckAuthorizedChannelId() {
            return this.checkAuthorizedChannelId;
        }

        public void setCheckAuthorizedChannelId(CheckAuthorizedChannelId checkAuthorizedChannelId) {
            this.checkAuthorizedChannelId = checkAuthorizedChannelId;
        }

        public CheckAuthorizedUserId getCheckAuthorizedUserId() {
            return this.checkAuthorizedUserId;
        }

        public void setCheckAuthorizedUserId(CheckAuthorizedUserId checkAuthorizedUserId) {
            this.checkAuthorizedUserId = checkAuthorizedUserId;
        }

        public List<String> getParamNames() {
            return this.paramNames;
        }

        public void setParamNames(List<String> paramNames) {
            this.paramNames = paramNames;
        }

        public Integer getChannelIdIndex() {
            return this.channelIdIndex;
        }

        public void setChannelIdIndex(Integer channelIdIndex) {
            this.channelIdIndex = channelIdIndex;
        }

        public Integer getUserIdIndex() {
            return this.userIdIndex;
        }

        public void setUserIdIndex(Integer userIdIndex) {
            this.userIdIndex = userIdIndex;
        }
    }
}

