/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.CodeTemplateServletInterface;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.codetemplates.CodeTemplateSummary;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;

public class CodeTemplateServlet
extends MirthServlet
implements CodeTemplateServletInterface {
    private static final CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();

    public CodeTemplateServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    public List<CodeTemplateLibrary> getCodeTemplateLibraries(Set<String> libraryIds, boolean includeCodeTemplates) {
        try {
            if (CollectionUtils.isEmpty(libraryIds)) {
                libraryIds = null;
            }
            return codeTemplateController.getLibraries(libraryIds, includeCodeTemplates);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<CodeTemplateLibrary> getCodeTemplateLibrariesPost(Set<String> libraryIds, boolean includeCodeTemplates) {
        return this.getCodeTemplateLibraries(libraryIds, includeCodeTemplates);
    }

    public CodeTemplateLibrary getCodeTemplateLibrary(String libraryId, boolean includeCodeTemplates) {
        try {
            List<CodeTemplateLibrary> libraries = codeTemplateController.getLibraries(Collections.singleton(libraryId), includeCodeTemplates);
            if (CollectionUtils.isEmpty(libraries)) {
                throw new MirthApiException(Response.Status.NOT_FOUND);
            }
            return libraries.iterator().next();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public boolean updateCodeTemplateLibraries(List<CodeTemplateLibrary> libraries, boolean override) {
        try {
            return codeTemplateController.updateLibraries(libraries, this.context, override);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<CodeTemplate> getCodeTemplates(Set<String> codeTemplateIds) {
        try {
            if (CollectionUtils.isEmpty(codeTemplateIds)) {
                codeTemplateIds = null;
            }
            return codeTemplateController.getCodeTemplates(codeTemplateIds);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<CodeTemplate> getCodeTemplatesPost(Set<String> codeTemplateIds) {
        return this.getCodeTemplates(codeTemplateIds);
    }

    public CodeTemplate getCodeTemplate(String codeTemplateId) {
        try {
            List<CodeTemplate> codeTemplates = codeTemplateController.getCodeTemplates(Collections.singleton(codeTemplateId));
            if (CollectionUtils.isEmpty(codeTemplates)) {
                throw new MirthApiException(Response.Status.NOT_FOUND);
            }
            return codeTemplates.iterator().next();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public List<CodeTemplateSummary> getCodeTemplateSummary(Map<String, Integer> clientRevisions) {
        this.parameterMap.put("clientRevisions", clientRevisions);
        if (!this.isUserAuthorized()) {
            return new ArrayList<CodeTemplateSummary>();
        }
        try {
            return codeTemplateController.getCodeTemplateSummary(clientRevisions);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public boolean updateCodeTemplate(String codeTemplateId, CodeTemplate codeTemplate, boolean override) {
        try {
            return codeTemplateController.updateCodeTemplate(codeTemplate, this.context, override);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void removeCodeTemplate(String codeTemplateId) {
        try {
            codeTemplateController.removeCodeTemplate(codeTemplateId, this.context);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public CodeTemplateLibrarySaveResult updateLibrariesAndTemplates(List<CodeTemplateLibrary> libraries, Set<String> removedLibraryIds, List<CodeTemplate> updatedCodeTemplates, Set<String> removedCodeTemplateIds, boolean override) {
        return codeTemplateController.updateLibrariesAndTemplates(libraries, removedLibraryIds, updatedCodeTemplates, removedCodeTemplateIds, this.context, override);
    }
}

