/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.providers.MetaDataSearchParamConverterProvider;
import com.mirth.connect.client.core.api.servlets.ChannelStatisticsServletInterface;
import com.mirth.connect.client.core.api.servlets.MessageServletInterface;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.model.filters.elements.ContentSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchElement;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.api.servlets.ChannelStatisticsServlet;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.util.DICOMMessageUtil;
import com.mirth.connect.util.MessageImporter;
import com.mirth.connect.util.messagewriter.EncryptionType;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageServlet
extends MirthServlet
implements MessageServletInterface {
    private static final Logger logger = LogManager.getLogger(MessageServlet.class);
    private static MessageController messageController;
    private static EngineController engineController;
    private static ConfigurationController configurationController;
    private static EventController eventController;

    public MessageServlet(@Context HttpServletRequest request, @Context ContainerRequestContext containerRequestContext, @Context SecurityContext sc) {
        super(request, containerRequestContext, sc);
    }

    public MessageServlet(@Context HttpServletRequest request, @Context ContainerRequestContext containerRequestContext, @Context SecurityContext sc, ControllerFactory controllerFactory) {
        super(request, containerRequestContext, sc, controllerFactory);
    }

    @Override
    protected void initializeControllers() {
        super.initializeControllers();
        messageController = this.controllerFactory.createMessageController();
        engineController = this.controllerFactory.createEngineController();
        configurationController = this.controllerFactory.createConfigurationController();
        eventController = this.controllerFactory.createEventController();
    }

    @CheckAuthorizedChannelId
    public Long processMessage(String channelId, String rawData, Set<Integer> destinationMetaDataIds, Set<String> sourceMapEntries, boolean overwrite, boolean imported, Long originalMessageId) {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(sourceMapEntries)) {
            for (String entry : sourceMapEntries) {
                int index = entry.indexOf(61);
                if (index <= 0) continue;
                sourceMap.put(entry.substring(0, index).trim(), entry.substring(index + 1).trim());
            }
        }
        RawMessage rawMessage = new RawMessage(rawData, destinationMetaDataIds, sourceMap);
        rawMessage.setOverwrite(overwrite);
        rawMessage.setImported(imported);
        rawMessage.setOriginalMessageId(originalMessageId);
        return this.processMessage(channelId, rawMessage);
    }

    @CheckAuthorizedChannelId
    public Long processMessage(String channelId, RawMessage rawMessage) {
        try {
            DispatchResult result = engineController.dispatchRawMessage(channelId, rawMessage, true, true);
            if (result != null) {
                this.containerRequestContext.setProperty("responseCode", (Object)Response.Status.CREATED.getStatusCode());
                return result.getMessageId();
            }
        }
        catch (ChannelException result) {
        }
        catch (BatchMessageException e) {
            logger.error("Error processing batch message", (Throwable)e);
        }
        this.containerRequestContext.setProperty("responseCode", (Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        return null;
    }

    @CheckAuthorizedChannelId
    public Message getMessageContent(String channelId, Long messageId, List<Integer> metaDataIds) {
        return messageController.getMessageContent(channelId, messageId, metaDataIds);
    }

    @CheckAuthorizedChannelId
    public List<Attachment> getAttachmentsByMessageId(String channelId, Long messageId, boolean includeContent) {
        if (includeContent) {
            return messageController.getMessageAttachment(channelId, messageId, true);
        }
        return messageController.getMessageAttachmentIds(channelId, messageId, true);
    }

    @CheckAuthorizedChannelId
    public Attachment getAttachment(String channelId, Long messageId, String attachmentId) {
        return messageController.getMessageAttachment(channelId, attachmentId, messageId, true);
    }

    @CheckAuthorizedChannelId
    public String getDICOMMessage(String channelId, Long messageId, ConnectorMessage message) {
        return DICOMMessageUtil.getDICOMRawData(message);
    }

    @CheckAuthorizedChannelId
    public Long getMaxMessageId(String channelId) {
        return messageController.getMaxMessageId(channelId, true);
    }

    @CheckAuthorizedChannelId
    public List<Message> getMessages(String channelId, MessageFilter filter, Boolean includeContent, Integer offset, Integer limit) {
        return messageController.getMessages(filter, channelId, includeContent, offset, limit);
    }

    @CheckAuthorizedChannelId
    public List<Message> getMessages(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error, Boolean includeContent, Integer offset, Integer limit) {
        MessageFilter filter = this.getMessageFilter(minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
        return messageController.getMessages(filter, channelId, includeContent, offset, limit);
    }

    @CheckAuthorizedChannelId
    public Long getMessageCount(String channelId, MessageFilter filter) {
        return messageController.getMessageCount(filter, channelId);
    }

    @CheckAuthorizedChannelId
    public Long getMessageCount(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error) {
        MessageFilter filter = this.getMessageFilter(minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
        return messageController.getMessageCount(filter, channelId);
    }

    @CheckAuthorizedChannelId
    public void reprocessMessages(String channelId, MessageFilter filter, boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) {
        this.doReprocessMessages(channelId, filter, replace, filterDestinations, reprocessMetaDataIds);
    }

    @CheckAuthorizedChannelId
    public void reprocessMessages(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error, boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) {
        MessageFilter filter = this.getMessageFilter(minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
        this.doReprocessMessages(channelId, filter, replace, filterDestinations, reprocessMetaDataIds);
    }

    @CheckAuthorizedChannelId
    public void reprocessMessage(String channelId, Long messageId, boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) {
        MessageFilter filter = new MessageFilter();
        filter.setMinMessageId(messageId);
        filter.setMaxMessageId(messageId);
        this.doReprocessMessages(channelId, filter, replace, filterDestinations, reprocessMetaDataIds);
    }

    private void doReprocessMessages(final String channelId, final MessageFilter filter, final boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) {
        final Set<Integer> metaDataIds = filterDestinations ? reprocessMetaDataIds : null;
        Runnable reprocessTask = new Runnable(){

            @Override
            public void run() {
                try {
                    messageController.reprocessMessages(channelId, filter, replace, metaDataIds);
                }
                catch (ControllerException e) {
                    logger.error("Error reprocessing messages for channel " + channelId + ": " + e.getMessage(), (Throwable)e);
                }
            }
        };
        new Thread(reprocessTask, "Message Reprocess Thread < " + Thread.currentThread().getName()).start();
    }

    @CheckAuthorizedChannelId
    public void removeMessages(String channelId, MessageFilter filter) {
        messageController.removeMessages(channelId, filter);
    }

    @CheckAuthorizedChannelId
    public void removeMessages(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error) {
        MessageFilter filter = this.getMessageFilter(minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
        messageController.removeMessages(channelId, filter);
    }

    @CheckAuthorizedChannelId
    public void removeMessage(String channelId, Long messageId, Integer metaDataId, String patientId) {
        MessageFilter filter = new MessageFilter();
        filter.setMinMessageId(messageId);
        filter.setMaxMessageId(messageId);
        if (metaDataId != null) {
            ArrayList<Integer> metaDataIds = new ArrayList<Integer>();
            metaDataIds.add(metaDataId);
            filter.setIncludedMetaDataIds(metaDataIds);
        }
        messageController.removeMessages(channelId, filter);
    }

    @CheckAuthorizedChannelId
    public void removeAllMessages(String channelId, boolean restartRunningChannels, boolean clearStatistics) {
        if (clearStatistics) {
            this.checkClearStatisticsAuthorization();
        }
        engineController.removeAllMessages(Collections.singleton(channelId), restartRunningChannels, clearStatistics, null);
    }

    private void checkClearStatisticsAuthorization() {
        try {
            ChannelStatisticsServlet channelStatsServlet = new ChannelStatisticsServlet(this.request, this.sc, this.controllerFactory);
            Method matchingMethod = ChannelStatisticsServlet.class.getMethod("clearStatistics", Map.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            Operation operation = OperationUtil.getOperation(ChannelStatisticsServletInterface.class, (Method)matchingMethod);
            channelStatsServlet.setOperation(operation);
            channelStatsServlet.checkUserAuthorized();
        }
        catch (NoSuchMethodException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void removeAllMessages(Set<String> channelIds, boolean restartRunningChannels, boolean clearStatistics) {
        if (clearStatistics) {
            this.checkClearStatisticsAuthorization();
        }
        engineController.removeAllMessages(this.redactChannelIds(channelIds), restartRunningChannels, clearStatistics, null);
    }

    public void removeAllMessagesPost(Set<String> channelIds, boolean restartRunningChannels, boolean clearStatistics) {
        this.removeAllMessages(channelIds, restartRunningChannels, clearStatistics);
    }

    @CheckAuthorizedChannelId
    public void importMessage(String channelId, Message message) {
        try {
            messageController.importMessage(channelId, message);
        }
        catch (MessageImporter.MessageImportException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public MessageImportResult importMessagesServer(String channelId, String path, boolean includeSubfolders) {
        try {
            return messageController.importMessagesServer(channelId, path, includeSubfolders);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public int exportMessagesServer(String channelId, MessageFilter filter, int pageSize, MessageWriterOptions writerOptions) {
        try {
            return messageController.exportMessages(channelId, filter, pageSize, writerOptions);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public int exportMessagesServer(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error, int pageSize, ContentType contentType, boolean destinationContent, boolean encrypt, boolean includeAttachments, String baseFolder, String rootFolder, String filePattern, String archiveFileName, String archiveFormat, String compressFormat, String password, EncryptionType encryptionType) {
        MessageFilter filter = this.getMessageFilter(minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
        MessageWriterOptions writerOptions = this.getMessageWriterOptions(contentType, destinationContent, encrypt, includeAttachments, baseFolder, rootFolder, filePattern, archiveFileName, archiveFormat, compressFormat, password, encryptionType);
        try {
            return messageController.exportMessages(channelId, filter, pageSize, writerOptions);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public void exportAttachmentServer(String channelId, Long messageId, String attachmentId, String filePath, boolean binary) {
        try {
            messageController.exportAttachment(channelId, attachmentId, messageId, filePath, binary);
        }
        catch (IOException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public void auditAccessedPHIMessage(Map<String, String> auditMessageAttributesMap) {
        this.sendServerEventWithAttributes(auditMessageAttributesMap);
    }

    @DontCheckAuthorized
    public void auditQueriedPHIMessage(Map<String, String> auditMessageAttributesMap) {
        this.sendServerEventWithAttributes(auditMessageAttributesMap);
    }

    @DontCheckAuthorized
    public void auditExportMessages(Map<String, String> auditMessageAttributesMap) {
        this.sendServerEventWithAttributes(auditMessageAttributesMap);
    }

    @DontCheckAuthorized
    public void auditExportMessagesSuccess(Map<String, String> auditMessageAttributesMap) {
        this.sendServerEventWithAttributes(auditMessageAttributesMap);
    }

    @DontCheckAuthorized
    private void sendServerEventWithAttributes(Map<String, String> attributes) {
        ServerEvent event = new ServerEvent(configurationController.getServerId(), this.operation.getDisplayName());
        event.setUserId(this.getCurrentUserId());
        event.setIpAddress(this.getRequestIpAddress());
        event.setLevel(ServerEvent.Level.INFORMATION);
        event.setOutcome(ServerEvent.Outcome.SUCCESS);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            event.addAttribute(entry.getKey(), entry.getValue());
        }
        eventController.dispatchEvent(event);
    }

    private MessageFilter getMessageFilter(Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error) {
        MessageFilter filter = new MessageFilter();
        filter.setMinMessageId(minMessageId);
        filter.setMaxMessageId(maxMessageId);
        filter.setOriginalIdLower(minOriginalId);
        filter.setOriginalIdUpper(maxOriginalId);
        filter.setImportIdLower(minImportId);
        filter.setImportIdUpper(maxImportId);
        filter.setStartDate(startDate);
        filter.setEndDate(endDate);
        filter.setTextSearch(textSearch);
        filter.setTextSearchRegex(textSearchRegex);
        if (CollectionUtils.isNotEmpty(statuses)) {
            filter.setStatuses(statuses);
        }
        if (CollectionUtils.isNotEmpty(includedMetaDataIds)) {
            filter.setIncludedMetaDataIds(new ArrayList<Integer>(includedMetaDataIds));
        }
        if (CollectionUtils.isNotEmpty(excludedMetaDataIds)) {
            filter.setExcludedMetaDataIds(new ArrayList<Integer>(excludedMetaDataIds));
        }
        filter.setServerId(serverId);
        ArrayList<ContentSearchElement> contentSearchList = new ArrayList<ContentSearchElement>();
        if (CollectionUtils.isNotEmpty(rawContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.RAW.getContentTypeCode(), new ArrayList<String>(rawContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(processedRawContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.PROCESSED_RAW.getContentTypeCode(), new ArrayList<String>(processedRawContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(transformedContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.TRANSFORMED.getContentTypeCode(), new ArrayList<String>(transformedContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(encodedContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.ENCODED.getContentTypeCode(), new ArrayList<String>(encodedContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(sentContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.SENT.getContentTypeCode(), new ArrayList<String>(sentContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(responseContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.RESPONSE.getContentTypeCode(), new ArrayList<String>(responseContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(responseTransformedContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.RESPONSE_TRANSFORMED.getContentTypeCode(), new ArrayList<String>(responseTransformedContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(processedResponseContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.PROCESSED_RESPONSE.getContentTypeCode(), new ArrayList<String>(processedResponseContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(connectorMapContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.CONNECTOR_MAP.getContentTypeCode(), new ArrayList<String>(connectorMapContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(channelMapContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.CHANNEL_MAP.getContentTypeCode(), new ArrayList<String>(channelMapContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(sourceMapContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.SOURCE_MAP.getContentTypeCode(), new ArrayList<String>(sourceMapContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(responseMapContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.RESPONSE_MAP.getContentTypeCode(), new ArrayList<String>(responseMapContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(processingErrorContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.PROCESSING_ERROR.getContentTypeCode(), new ArrayList<String>(processingErrorContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(postprocessorErrorContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.POSTPROCESSOR_ERROR.getContentTypeCode(), new ArrayList<String>(postprocessorErrorContentSearches)));
        }
        if (CollectionUtils.isNotEmpty(responseErrorContentSearches)) {
            contentSearchList.add(new ContentSearchElement(ContentType.RESPONSE_ERROR.getContentTypeCode(), new ArrayList<String>(responseErrorContentSearches)));
        }
        filter.setContentSearch(contentSearchList);
        ArrayList<MetaDataSearchElement> metaDataSearchList = new ArrayList<MetaDataSearchElement>();
        if (CollectionUtils.isNotEmpty(metaDataSearches)) {
            for (MetaDataSearchParamConverterProvider.MetaDataSearch search : metaDataSearches) {
                metaDataSearchList.add(new MetaDataSearchElement(search.getColumnName(), search.getOperator().toFullString(), search.getValue(), false));
            }
        }
        if (CollectionUtils.isNotEmpty(metaDataCaseInsensitiveSearches)) {
            for (MetaDataSearchParamConverterProvider.MetaDataSearch search : metaDataCaseInsensitiveSearches) {
                metaDataSearchList.add(new MetaDataSearchElement(search.getColumnName(), search.getOperator().toFullString(), search.getValue(), true));
            }
        }
        filter.setMetaDataSearch(metaDataSearchList);
        filter.setTextSearchMetaDataColumns(new ArrayList<String>(textSearchMetaDataColumns));
        filter.setSendAttemptsLower(minSendAttempts);
        filter.setSendAttemptsUpper(maxSendAttempts);
        filter.setAttachment(attachment);
        filter.setError(error);
        return filter;
    }

    private MessageWriterOptions getMessageWriterOptions(ContentType contentType, boolean destinationContent, boolean encrypt, boolean includeAttachments, String baseFolder, String rootFolder, String filePattern, String archiveFileName, String archiveFormat, String compressFormat, String password, EncryptionType encryptionType) {
        MessageWriterOptions writerOptions = new MessageWriterOptions();
        writerOptions.setContentType(contentType);
        writerOptions.setDestinationContent(destinationContent);
        writerOptions.setEncrypt(encrypt);
        writerOptions.setIncludeAttachments(includeAttachments);
        if (StringUtils.isNotEmpty((CharSequence)baseFolder)) {
            writerOptions.setBaseFolder(baseFolder);
        } else {
            writerOptions.setBaseFolder(System.getProperty("user.dir"));
        }
        writerOptions.setRootFolder(rootFolder);
        writerOptions.setFilePattern(filePattern);
        writerOptions.setArchiveFileName(archiveFileName);
        writerOptions.setArchiveFormat(archiveFormat);
        writerOptions.setCompressFormat(compressFormat);
        writerOptions.setPassword(password);
        writerOptions.setEncryptionType(encryptionType);
        return writerOptions;
    }
}

