/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.servlets.SystemServletInterface;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDao;
import com.mirth.connect.model.SystemInfo;
import com.mirth.connect.model.SystemStats;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.sql.DatabaseMetaData;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemServlet
extends MirthServlet
implements SystemServletInterface {
    private static final Logger logger = LogManager.getLogger(SystemServlet.class);
    private static final ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();

    public SystemServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemInfo getInfo() throws ClientException {
        SystemInfo systemInfo;
        JdbcDao dao = (JdbcDao)Donkey.getInstance().getDaoFactory().getDao();
        try {
            DatabaseMetaData metaData = dao.getConnection().getMetaData();
            SystemInfo info = new SystemInfo();
            info.setDbName(metaData.getDatabaseProductName());
            info.setDbVersion(metaData.getDatabaseProductVersion());
            info.setJvmVersion(System.getProperty("java.version"));
            info.setOsName(System.getProperty("os.name"));
            info.setOsVersion(System.getProperty("os.version"));
            info.setOsArchitecture(System.getProperty("os.arch"));
            systemInfo = info;
        }
        catch (Throwable throwable) {
            try {
                dao.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ClientException((Throwable)e);
            }
        }
        dao.close();
        return systemInfo;
    }

    public SystemStats getStats() throws ClientException {
        SystemStats stats = new SystemStats();
        stats.setTimestamp(Calendar.getInstance());
        stats.setFreeMemoryBytes(Runtime.getRuntime().freeMemory());
        stats.setAllocatedMemoryBytes(Runtime.getRuntime().totalMemory());
        stats.setMaxMemoryBytes(Runtime.getRuntime().maxMemory());
        Object[] roots = File.listRoots();
        if (ArrayUtils.isNotEmpty((Object[])roots)) {
            Object root = roots[0];
            if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"Windows")) {
                try {
                    File baseDir = new File(configurationController.getBaseDir());
                    String[] path = StringUtils.split((String)baseDir.getCanonicalPath(), (char)File.separatorChar);
                    File pathRoot = new File(path[0] + File.separatorChar);
                    if (!pathRoot.exists()) {
                        throw new Exception("Root directory \"" + String.valueOf(pathRoot) + "\" does not exist.");
                    }
                    boolean found = false;
                    for (Object testRoot : roots) {
                        if (!((File)testRoot).equals(pathRoot)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new Exception("Root directory \"" + String.valueOf(pathRoot) + "\" exists, but does not match any of the filesystem roots reported by the JVM.");
                    }
                    root = pathRoot;
                }
                catch (Exception e) {
                    logger.warn("Unable to infer filesystem root from BridgeLink base directory, defaulting to: " + String.valueOf(root), (Throwable)e);
                }
            }
            stats.setDiskFreeBytes(((File)root).getFreeSpace());
            stats.setDiskTotalBytes(((File)root).getTotalSpace());
        }
        OperatingSystemMXBean osMxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        stats.setCpuUsagePct(osMxBean.getProcessCpuLoad());
        return stats;
    }
}

