/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.UserServletInterface;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.User;
import com.mirth.connect.server.api.CheckAuthorizedUserId;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.UserController;
import com.mirth.connect.server.util.UserSessionCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;

public class UserServlet
extends MirthServlet
implements UserServletInterface {
    private static final UserController userController = ControllerFactory.getFactory().createUserController();
    private static final EventController eventController = ControllerFactory.getFactory().createEventController();
    private static final ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();

    public UserServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, false);
    }

    @DontCheckAuthorized
    public LoginStatus login(String username, String password) {
        LoginStatus loginStatus = null;
        try {
            int tryCount = 0;
            int status = configurationController.getStatus();
            while (status != 3 && status != 0) {
                if (tryCount >= 5) {
                    loginStatus = new LoginStatus(LoginStatus.Status.FAIL, "Server is still starting or otherwise unavailable. Please try again shortly.");
                    break;
                }
                Thread.sleep(1000L);
                status = configurationController.getStatus();
                ++tryCount;
            }
            if (loginStatus == null) {
                String serverURL = this.request.getHeader("X-Mirth-Server-Url");
                String loginData = this.request.getHeader("X-Mirth-Login-Data");
                loginStatus = StringUtils.isNotBlank((CharSequence)loginData) && ControllerFactory.getFactory().createExtensionController().getMultiFactorAuthenticationPlugin() != null ? ControllerFactory.getFactory().createExtensionController().getMultiFactorAuthenticationPlugin().authenticate(loginData) : userController.authorizeUser(username, password, serverURL);
                ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
                HttpSession session = this.request.getSession();
                session.setMaxInactiveInterval(configurationController.getMaxInactiveSessionInterval());
                username = StringUtils.defaultString((String)loginStatus.getUpdatedUsername(), (String)username);
                User validUser = null;
                if (loginStatus.getStatus() == LoginStatus.Status.SUCCESS || loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD) {
                    validUser = userController.getUser(null, username);
                    if (validUser == null) {
                        loginStatus = new LoginStatus(LoginStatus.Status.FAIL, "Could not find a valid user with username: " + username);
                    } else {
                        session.setAttribute("user", (Object)validUser.getId());
                        session.setAttribute("authorized", (Object)true);
                        userController.loginUser(validUser);
                        UserSessionCache.getInstance().registerSessionForUser(session, validUser);
                    }
                }
                ServerEvent event = new ServerEvent(configurationController.getServerId(), this.operation.getDisplayName());
                if (validUser != null) {
                    event.setUserId(validUser.getId());
                }
                event.setIpAddress(this.getRequestIpAddress());
                event.setLevel(ServerEvent.Level.INFORMATION);
                event.setOutcome(loginStatus.getStatus() == LoginStatus.Status.SUCCESS || loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD ? ServerEvent.Outcome.SUCCESS : ServerEvent.Outcome.FAILURE);
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("username", username);
                event.setAttributes(attributes);
                eventController.dispatchEvent(event);
            }
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
        if (loginStatus.getStatus() != LoginStatus.Status.SUCCESS && loginStatus.getStatus() != LoginStatus.Status.SUCCESS_GRACE_PERIOD) {
            throw new MirthApiException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)loginStatus).build());
        }
        return loginStatus;
    }

    @DontCheckAuthorized
    public void logout() {
        this.isUserAuthorized();
        HttpSession session = this.request.getSession();
        Integer userId = (Integer)session.getAttribute("user");
        session.removeAttribute("user");
        session.removeAttribute("authorized");
        session.invalidate();
        User user = new User();
        user.setId(userId);
        try {
            userController.logoutUser(user);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public void inactivityLogout() {
        this.logout();
    }

    public void createUser(User user) {
        if (StringUtils.isBlank((CharSequence)user.getUsername())) {
            throw new MirthApiException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"username cannot be blank.").build());
        }
        try {
            userController.updateUser(user);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public List<User> getAllUsers() {
        try {
            if (!this.isUserAuthorized()) {
                ArrayList<User> users = new ArrayList<User>();
                users.add(userController.getUser(this.getCurrentUserId(), null));
                return users;
            }
            return userController.getAllUsers();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public User getUser(String userIdOrName) {
        this.parameterMap.put("userIdOrName", userIdOrName);
        try {
            String str = userIdOrName;
            Integer userId = null;
            User user = null;
            try {
                userId = Integer.parseInt(str);
                user = userController.getUser(userId, null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (user != null) {
                if (!this.isUserAuthorized() && !this.isCurrentUser(userId)) {
                    throw new MirthApiException(Response.Status.FORBIDDEN);
                }
                return user;
            }
            user = userController.getUser(null, str);
            if (user != null) {
                userId = user.getId();
                if (!this.isUserAuthorized() && !this.isCurrentUser(userId)) {
                    throw new MirthApiException(Response.Status.FORBIDDEN);
                }
                return user;
            }
            if (!this.isUserAuthorized()) {
                throw new MirthApiException(Response.Status.FORBIDDEN);
            }
            throw new MirthApiException(Response.Status.NOT_FOUND);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public User getCurrentUser() {
        try {
            return userController.getUser(this.getCurrentUserId(), null);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId
    public void updateUser(Integer userId, User user) {
        if (StringUtils.isBlank((CharSequence)user.getUsername())) {
            throw new MirthApiException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"username cannot be blank.").build());
        }
        try {
            userController.updateUser(user);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<String> checkUserPassword(String plainPassword) {
        try {
            return userController.checkOrUpdateUserPassword(null, plainPassword);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId
    public List<String> updateUserPassword(Integer userId, String plainPassword) {
        try {
            return userController.checkOrUpdateUserPassword(userId, plainPassword);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void removeUser(Integer userId) {
        try {
            userController.removeUser(userId, this.getCurrentUserId());
            UserSessionCache.getInstance().invalidateAllSessionsForUser(userId);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public boolean isUserLoggedIn(Integer userId) {
        try {
            return userController.isUserLoggedIn(userId);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId(auditCurrentUser=false)
    public Properties getUserPreferences(Integer userId, Set<String> names) {
        try {
            return userController.getUserPreferences(userId, names);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId(auditCurrentUser=false)
    public String getUserPreference(Integer userId, String name) {
        try {
            return userController.getUserPreference(userId, name);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId(auditCurrentUser=false)
    public void setUserPreferences(Integer userId, Properties properties) {
        try {
            userController.setUserPreferences(userId, properties);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId(auditCurrentUser=false)
    public void setUserPreference(Integer userId, String name, String value) {
        try {
            userController.setUserPreference(userId, name, value);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedUserId(auditCurrentUser=false)
    public void setUserNotificationAcknowledged(Integer userId) throws ClientException {
    }
}

