/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.StringUtil;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.util.DICOMMessageUtil;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.util.AttachmentUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MirthAttachmentHandlerProvider
implements AttachmentHandlerProvider {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final String DELIMITER = ":";
    private static final int ATTACHMENT_ID_LENGTH = 36;
    private static final int MESSAGE_ID_MAX_LENGTH = 20;
    private static final String ATTACHMENT_KEY = "ATTACH:";
    private static final String DICOM_KEY = "DICOMMESSAGE";
    private static final int KEY_DATA = 0;
    private static final int KEY_END_INDEX = 1;
    private Logger logger = LogManager.getLogger(this.getClass());
    private MessageController messageController;

    public MirthAttachmentHandlerProvider() {
    }

    public MirthAttachmentHandlerProvider(MessageController messageController) {
        this.messageController = messageController;
    }

    public byte[] reAttachMessage(String raw, ConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach) {
        return this.reAttachMessage(raw, connectorMessage, charsetEncoding, binary, reattach, false);
    }

    public byte[] reAttachMessage(String raw, ConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach, boolean localOnly) {
        return this.reAttachMessage(raw, connectorMessage, charsetEncoding, binary, reattach, localOnly, null);
    }

    public byte[] reAttachMessage(String raw, ConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach, boolean localOnly, Map<String, Attachment> remainingAttachments) {
        return this.reAttachMessage(raw, new ImmutableConnectorMessage(connectorMessage), charsetEncoding, binary, reattach, localOnly, remainingAttachments);
    }

    public String reAttachMessage(ConnectorMessage message, boolean reattach) {
        return this.reAttachMessage(new ImmutableConnectorMessage(message), reattach);
    }

    public String reAttachMessage(ImmutableConnectorMessage message, boolean reattach) {
        String messageData = null;
        if (message.getEncoded() != null && message.getEncoded().getContent() != null) {
            messageData = message.getEncoded().getContent();
        } else if (message.getRaw() != null) {
            messageData = message.getRaw().getContent();
        }
        return StringUtils.newString((byte[])this.reAttachMessage(messageData, message, "UTF-8", false, reattach), (String)"UTF-8");
    }

    public String reAttachMessage(String raw, ConnectorMessage message, boolean reattach) {
        return this.reAttachMessage(raw, new ImmutableConnectorMessage(message), reattach);
    }

    public String reAttachMessage(String raw, ImmutableConnectorMessage message, boolean reattach) {
        return StringUtils.newString((byte[])this.reAttachMessage(raw, message, "UTF-8", false, reattach), (String)"UTF-8");
    }

    public byte[] reAttachMessage(String raw, ImmutableConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach) {
        return this.reAttachMessage(raw, connectorMessage, charsetEncoding, binary, reattach, false);
    }

    public byte[] reAttachMessage(String raw, ImmutableConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach, boolean localOnly) {
        return this.reAttachMessage(raw, connectorMessage, charsetEncoding, binary, reattach, localOnly, null);
    }

    public byte[] reAttachMessage(String raw, ImmutableConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach, boolean localOnly, Map<String, Attachment> remainingAttachments) {
        try {
            byte[] combined;
            TreeMap replacementObjects = new TreeMap();
            int bufferSize = raw.length();
            int index = 0;
            byte[] dicomObject = null;
            Map<String, Attachment> attachmentMap = null;
            if (remainingAttachments != null) {
                attachmentMap = this.loadLocalAttachments(connectorMessage, remainingAttachments);
            }
            if (reattach && raw.trim().equals("${DICOMMESSAGE}")) {
                dicomObject = DICOMMessageUtil.getDICOMRawBytes(connectorMessage);
                if (!binary) {
                    dicomObject = Base64Util.encodeBase64((byte[])dicomObject);
                }
                return dicomObject;
            }
            while ((index = raw.indexOf(PREFIX, index)) != -1) {
                int endIndex;
                if (raw.startsWith("DICOMMESSAGE}", index + PREFIX.length())) {
                    endIndex = index + PREFIX.length() + DICOM_KEY.length() + SUFFIX.length();
                    if (reattach) {
                        if (dicomObject == null) {
                            dicomObject = Base64Util.encodeBase64((byte[])DICOMMessageUtil.getDICOMRawBytes(connectorMessage));
                        }
                        HashMap<Integer, Object> replacementMap = new HashMap<Integer, Object>();
                        replacementMap.put(1, endIndex);
                        replacementMap.put(0, dicomObject);
                        replacementObjects.put(index, replacementMap);
                        bufferSize += dicomObject.length;
                    }
                    index += endIndex - index;
                } else if (raw.startsWith(ATTACHMENT_KEY, index + PREFIX.length())) {
                    int idStartIndex = index + PREFIX.length() + ATTACHMENT_KEY.length();
                    endIndex = idStartIndex;
                    if (endIndex + 36 <= raw.length()) {
                        String attachmentOrChannelId = raw.substring(idStartIndex, endIndex += 36);
                        if (endIndex + SUFFIX.length() <= raw.length() && raw.substring(endIndex, endIndex + SUFFIX.length()).equals(SUFFIX)) {
                            HashMap<Integer, Object> replacementMap = new HashMap<Integer, Object>();
                            replacementMap.put(1, endIndex += SUFFIX.length());
                            if (reattach) {
                                if (attachmentMap == null) {
                                    attachmentMap = this.loadLocalAttachments(connectorMessage, remainingAttachments);
                                }
                                if (attachmentMap.containsKey(attachmentOrChannelId)) {
                                    Attachment attachment = attachmentMap.get(attachmentOrChannelId);
                                    attachment.setContent(this.replaceOutboundAttachment(attachment.getContent()));
                                    replacementMap.put(0, attachment.getContent());
                                    bufferSize += attachment.getContent().length;
                                    if (remainingAttachments != null) {
                                        remainingAttachments.remove(attachment.getId());
                                    }
                                } else {
                                    replacementMap.put(0, new byte[0]);
                                }
                            } else {
                                replacementMap.put(0, ("${ATTACH:" + connectorMessage.getChannelId() + DELIMITER + connectorMessage.getMessageId() + DELIMITER + attachmentOrChannelId + SUFFIX).getBytes("UTF-8"));
                            }
                            replacementObjects.put(index, replacementMap);
                        } else if (reattach && !localOnly && endIndex + DELIMITER.length() <= raw.length() && raw.substring(endIndex, endIndex + DELIMITER.length()).equals(DELIMITER)) {
                            int nextDelimIndex;
                            String channelId = attachmentOrChannelId;
                            if ((nextDelimIndex = StringUtil.indexOf((String)raw, (String)DELIMITER, (int)(endIndex += DELIMITER.length()), (int)(endIndex + 20))) != -1) {
                                String messageIdStr = raw.substring(endIndex, nextDelimIndex);
                                endIndex = nextDelimIndex + DELIMITER.length();
                                long messageId = NumberUtils.toLong((String)messageIdStr);
                                if (messageId > 0L && endIndex + 36 + SUFFIX.length() <= raw.length()) {
                                    attachmentOrChannelId = raw.substring(endIndex, endIndex + 36);
                                    if (raw.substring(endIndex += 36, endIndex + SUFFIX.length()).equals(SUFFIX)) {
                                        HashMap<Integer, Object> replacementMap = new HashMap<Integer, Object>();
                                        replacementMap.put(1, endIndex += SUFFIX.length());
                                        if (channelId.equals(connectorMessage.getChannelId()) && messageId == connectorMessage.getMessageId()) {
                                            if (attachmentMap == null) {
                                                attachmentMap = this.loadLocalAttachments(connectorMessage, remainingAttachments);
                                            }
                                            if (attachmentMap.containsKey(attachmentOrChannelId)) {
                                                attachment = attachmentMap.get(attachmentOrChannelId);
                                                attachment.setContent(this.replaceOutboundAttachment(attachment.getContent()));
                                                replacementMap.put(0, attachment.getContent());
                                                bufferSize += attachment.getContent().length;
                                                if (remainingAttachments != null) {
                                                    remainingAttachments.remove(attachment.getId());
                                                }
                                            } else {
                                                replacementMap.put(0, new byte[0]);
                                            }
                                        } else {
                                            attachment = this.getMessageAttachment(channelId, messageId, attachmentOrChannelId);
                                            if (attachmentOrChannelId.equals(attachment.getId())) {
                                                attachment.setContent(this.replaceOutboundAttachment(attachment.getContent()));
                                                replacementMap.put(0, attachment.getContent());
                                                bufferSize += attachment.getContent().length;
                                            } else {
                                                replacementMap.put(0, new byte[0]);
                                            }
                                        }
                                        replacementObjects.put(index, replacementMap);
                                    }
                                }
                            }
                        }
                    }
                } else {
                    endIndex = index + PREFIX.length();
                }
                index += endIndex - index;
            }
            dicomObject = null;
            attachmentMap = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
            int segmentStartIndex = 0;
            for (Map.Entry entry : replacementObjects.entrySet()) {
                int startReplacementIndex = (Integer)entry.getKey();
                int endReplacementIndex = (Integer)((Map)entry.getValue()).get(1);
                byte[] data = (byte[])((Map)entry.getValue()).get(0);
                ((Map)entry.getValue()).clear();
                byte[] templateSegment = binary ? StringUtils.getBytesUsAscii((String)raw.substring(segmentStartIndex, startReplacementIndex)) : StringUtil.getBytesUncheckedChunked((String)raw.substring(segmentStartIndex, startReplacementIndex), (String)"UTF-8");
                baos.write(templateSegment);
                baos.write(data);
                segmentStartIndex = endReplacementIndex;
            }
            byte[] templateSegment = binary ? StringUtils.getBytesUsAscii((String)raw.substring(segmentStartIndex)) : StringUtil.getBytesUncheckedChunked((String)raw.substring(segmentStartIndex), (String)"UTF-8");
            if (segmentStartIndex == 0) {
                combined = templateSegment;
            } else {
                baos.write(templateSegment);
                combined = baos.toByteArray();
                baos = null;
            }
            templateSegment = null;
            if (binary) {
                combined = Base64Util.decodeBase64((byte[])combined);
            } else if (charsetEncoding != null && !charsetEncoding.equalsIgnoreCase("UTF-8")) {
                String combinedString = StringUtils.newString((byte[])combined, (String)"UTF-8");
                combined = null;
                combined = StringUtil.getBytesUncheckedChunked((String)combinedString, (String)charsetEncoding);
            }
            return combined;
        }
        catch (Exception e) {
            this.logger.error("Error reattaching attachments", (Throwable)e);
            return null;
        }
    }

    public static boolean hasAttachmentKeys(String raw) {
        return raw.contains("${DICOMMESSAGE}") || raw.contains("${ATTACH:");
    }

    public List<String> getMessageAttachmentIds(ImmutableConnectorMessage message) throws MessageSerializerException {
        return this.getMessageAttachmentIds(message.getChannelId(), message.getMessageId());
    }

    public List<String> getMessageAttachmentIds(String channelId, Long messageId) throws MessageSerializerException {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        try {
            List<Attachment> attachments = this.messageController.getMessageAttachmentIds(channelId, messageId, false);
            for (Attachment attachment : attachments) {
                attachmentIds.add(attachment.getId());
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException(e.getMessage());
        }
        return attachmentIds;
    }

    public List<Attachment> getMessageAttachments(ImmutableConnectorMessage message) throws MessageSerializerException {
        return this.getMessageAttachments(message.getChannelId(), message.getMessageId());
    }

    public List<Attachment> getMessageAttachments(ImmutableConnectorMessage message, boolean base64Decode) throws MessageSerializerException {
        return this.getMessageAttachments(message.getChannelId(), message.getMessageId(), base64Decode);
    }

    public List<Attachment> getMessageAttachments(String channelId, Long messageId) throws MessageSerializerException {
        return this.getMessageAttachments(channelId, messageId, false);
    }

    public List<Attachment> getMessageAttachments(String channelId, Long messageId, boolean base64Decode) throws MessageSerializerException {
        List<Attachment> attachments;
        try {
            attachments = this.messageController.getMessageAttachment(channelId, messageId, false);
            if (base64Decode) {
                AttachmentUtil.decodeBase64(attachments);
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException(e.getMessage());
        }
        return attachments;
    }

    public Attachment getMessageAttachment(String channelId, Long messageId, String attachmentId) throws MessageSerializerException {
        return this.getMessageAttachment(channelId, messageId, attachmentId, false);
    }

    public Attachment getMessageAttachment(String channelId, Long messageId, String attachmentId, boolean base64Decode) throws MessageSerializerException {
        try {
            Attachment attachment = this.messageController.getMessageAttachment(channelId, attachmentId, messageId, false);
            if (base64Decode) {
                AttachmentUtil.decodeBase64(attachment);
            }
            return attachment;
        }
        catch (Exception e) {
            throw new MessageSerializerException(e.getMessage());
        }
    }

    private Map<String, Attachment> loadLocalAttachments(ImmutableConnectorMessage connectorMessage, Map<String, Attachment> remainingAttachments) throws MessageSerializerException {
        List<Attachment> list = this.getMessageAttachments(connectorMessage);
        HashMap<String, Attachment> attachmentMap = new HashMap<String, Attachment>();
        for (Attachment attachment : list) {
            attachmentMap.put(attachment.getId(), attachment);
            if (remainingAttachments == null) continue;
            remainingAttachments.put(attachment.getId(), attachment);
        }
        return attachmentMap;
    }
}

