/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments.identity;

import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentException;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.StringUtil;
import com.mirth.connect.server.attachments.identity.IdentityAttachmentHandlerProvider;
import com.mirth.connect.server.util.ServerUUIDGenerator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class IdentityAttachmentHandler
implements AttachmentHandler {
    private IdentityAttachmentHandlerProvider provider;
    private Attachment attachment;
    private String finalMessage;

    public IdentityAttachmentHandler(IdentityAttachmentHandlerProvider provider) {
        this.provider = provider;
    }

    public void initialize(RawMessage message, Channel channel) throws AttachmentException {
        try {
            String uuid = ServerUUIDGenerator.getUUID();
            String mimeType = this.provider.getReplacer().replaceValues(this.provider.getMimeType(), channel.getChannelId(), channel.getName(), message.getSourceMap());
            if (StringUtils.isBlank((CharSequence)mimeType)) {
                mimeType = "text/plain";
            }
            byte[] attachmentData = message.isBinary() != false ? Base64Util.encodeBase64((byte[])message.getRawBytes()) : StringUtil.getBytesUncheckedChunked((String)message.getRawData(), (String)"UTF-8");
            message.clearMessage();
            if (ArrayUtils.isNotEmpty((byte[])attachmentData)) {
                this.attachment = new Attachment(uuid, attachmentData, mimeType);
                this.finalMessage = this.attachment.getAttachmentId();
            } else {
                this.finalMessage = "";
            }
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }

    public Attachment nextAttachment() throws AttachmentException {
        Attachment attachment = this.attachment;
        this.attachment = null;
        return attachment;
    }

    public String shutdown() throws AttachmentException {
        return this.finalMessage;
    }
}

