/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments.regex;

import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.server.attachments.MirthAttachmentHandlerProvider;
import com.mirth.connect.server.attachments.regex.RegexAttachmentHandler;
import com.mirth.connect.server.attachments.regex.RegexInfo;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class RegexAttachmentHandlerProvider
extends MirthAttachmentHandlerProvider {
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private String channelId;
    private String channelName;
    private List<RegexInfo> regexInfoList = new ArrayList<RegexInfo>();
    private Map<String, String> inboundReplacements = new HashMap<String, String>();
    private Map<String, String> outboundReplacements = new HashMap<String, String>();

    public RegexAttachmentHandlerProvider(MessageController messageController) {
        super(messageController);
    }

    TemplateValueReplacer getReplacer() {
        return this.replacer;
    }

    String getChannelId() {
        return this.channelId;
    }

    String getChannelName() {
        return this.channelName;
    }

    List<RegexInfo> getRegexInfo() {
        return this.regexInfoList;
    }

    Map<String, String> getInboundReplacements() {
        return this.inboundReplacements;
    }

    Map<String, String> getOutboundReplacements() {
        return this.outboundReplacements;
    }

    public void setProperties(Channel channel, AttachmentHandlerProperties attachmentProperties) {
        this.channelId = channel.getChannelId();
        this.channelName = channel.getName();
        if (attachmentProperties.getProperties().containsKey("regex.pattern")) {
            String regex = (String)attachmentProperties.getProperties().get("regex.pattern");
            String mimeType = (String)attachmentProperties.getProperties().get("regex.mimetype");
            if (StringUtils.isBlank((CharSequence)mimeType)) {
                mimeType = "text/plain";
            }
            this.regexInfoList.add(new RegexInfo(Pattern.compile(regex), mimeType));
        }
        int count = 0;
        while (attachmentProperties.getProperties().containsKey("regex.pattern" + count)) {
            String regex = (String)attachmentProperties.getProperties().get("regex.pattern" + count);
            String mimeType = (String)attachmentProperties.getProperties().get("regex.mimetype" + count);
            if (StringUtils.isBlank((CharSequence)mimeType)) {
                mimeType = "text/plain";
            }
            this.regexInfoList.add(new RegexInfo(Pattern.compile(regex), mimeType));
            ++count;
        }
        count = 0;
        while (attachmentProperties.getProperties().containsKey("regex.replaceKey" + count)) {
            this.inboundReplacements.put(StringEscapeUtils.unescapeJava((String)((String)attachmentProperties.getProperties().get("regex.replaceKey" + count))), StringEscapeUtils.unescapeJava((String)((String)attachmentProperties.getProperties().get("regex.replaceValue" + count))));
            ++count;
        }
        count = 0;
        while (attachmentProperties.getProperties().containsKey("outbound.regex.replaceKey" + count)) {
            this.outboundReplacements.put(StringEscapeUtils.unescapeJava((String)((String)attachmentProperties.getProperties().get("outbound.regex.replaceKey" + count))), StringEscapeUtils.unescapeJava((String)((String)attachmentProperties.getProperties().get("outbound.regex.replaceValue" + count))));
            ++count;
        }
    }

    public boolean canExtractAttachments() {
        return true;
    }

    public byte[] replaceOutboundAttachment(byte[] content) throws Exception {
        String attachmentString = "";
        attachmentString = new String(content, "UTF-8");
        for (Map.Entry<String, String> replacementEntry : this.outboundReplacements.entrySet()) {
            String replaceKey = replacementEntry.getKey();
            String replaceValue = replacementEntry.getValue();
            if (replaceKey == null || replaceValue == null) continue;
            replaceKey = this.replacer.replaceValues(replaceKey, this.channelId, this.channelName);
            replaceValue = this.replacer.replaceValues(replaceValue, this.channelId, this.channelName);
            attachmentString = attachmentString.replace(replaceKey, replaceValue);
        }
        return attachmentString.getBytes("UTF-8");
    }

    public AttachmentHandler getHandler() {
        return new RegexAttachmentHandler(this);
    }
}

