/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.builders;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.message.SerializationType;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.Step;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.message.DataTypeFactory;
import com.mirth.connect.util.CodeTemplateUtil;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaScriptBuilder {
    private static Logger logger = LogManager.getLogger(JavaScriptBuilder.class);
    private static ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private static CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();

    public static String generateGlobalSealedScript() {
        StringBuilder script = new StringBuilder();
        script.append("String.prototype.trim = function() { return this.replace(/^\\s+|\\s+$/g,\"\").replace(/^\\t+|\\t+$/g,\"\"); };");
        for (MetaData metaData : extensionController.getConnectorMetaData().values()) {
            if (!extensionController.isExtensionEnabled(metaData.getName()) || !CollectionUtils.isNotEmpty(metaData.getUserutilPackages())) continue;
            for (String packageName : metaData.getUserutilPackages()) {
                script.append("importPackage(").append(packageName).append(");\n");
            }
        }
        for (MetaData metaData : extensionController.getPluginMetaData().values()) {
            if (!extensionController.isExtensionEnabled(metaData.getName()) || !CollectionUtils.isNotEmpty(metaData.getUserutilPackages())) continue;
            for (String packageName : metaData.getUserutilPackages()) {
                script.append("importPackage(").append(packageName).append(");\n");
            }
        }
        script.append("importPackage(Packages.com.mirth.connect.userutil);\n");
        script.append("importPackage(Packages.com.mirth.connect.server.userutil);\n");
        script.append("regex = new RegExp('');\n");
        script.append("xml = new XML('');\n");
        script.append("xmllist = new XMLList();\n");
        script.append("namespace = new Namespace();\n");
        script.append("qname = new QName();\n");
        script.append("XML.ignoreWhitespace=true;");
        script.append("XML.prettyPrinting=false;");
        return script.toString();
    }

    public static String generateScript(String channelId, String script, Set<String> scriptOptions, ContextType contextType) {
        StringBuilder builder = new StringBuilder();
        JavaScriptBuilder.appendMapFunctions(builder);
        JavaScriptBuilder.appendAttachmentFunctions(builder, scriptOptions);
        JavaScriptBuilder.appendCodeTemplates(builder, channelId, contextType);
        JavaScriptBuilder.appendMiscFunctions(builder);
        builder.append("function doScript() {\n" + script + " \n}\n");
        builder.append("doScript();\n");
        return builder.toString();
    }

    public static String generateDefaultKeyScript(String key) {
        return JavaScriptBuilder.generateDefaultKeyScript(key, true);
    }

    public static String generateDefaultKeyScript(String key, boolean isGlobal) {
        String script = null;
        StringBuilder builder = new StringBuilder();
        if (key.equals("Deploy")) {
            JavaScriptBuilder.appendDefaultDeployScript(builder, isGlobal);
            script = builder.toString();
        } else if (key.equals("Undeploy")) {
            JavaScriptBuilder.appendDefaultUndeployScript(builder, isGlobal);
            script = builder.toString();
        } else if (key.equals("Preprocessor")) {
            JavaScriptBuilder.appendDefaultPreprocessorScript(builder, isGlobal);
            script = builder.toString();
        } else if (key.equals("Postprocessor")) {
            JavaScriptBuilder.appendDefaultPostprocessorScript(builder, isGlobal);
            script = builder.toString();
        } else if (key.equals("Attachment")) {
            JavaScriptBuilder.appendDefaultAttachmentScript(builder);
            script = builder.toString();
        }
        return script;
    }

    public static String generateFilterTransformerScript(Filter filter, Transformer transformer) throws ScriptBuilderException {
        logger.debug("generating script");
        StringBuilder builder = new StringBuilder();
        SerializationType inboundSerializationType = DataTypeFactory.getSerializationType(transformer.getInboundDataType(), transformer.getInboundProperties(), true);
        switch (inboundSerializationType) {
            case JSON: {
                builder.append("msg = JSON.parse(connectorMessage.getTransformedData());\n");
                break;
            }
            case XML: {
                builder.append("msg = new XML(connectorMessage.getTransformedData());\n");
                builder.append("if (msg.namespace('') != undefined) { default xml namespace = msg.namespace(''); } else { default xml namespace = ''; }\n");
                break;
            }
            case RAW: {
                builder.append("if (connectorMessage.getProcessedRawData() != null) { msg = new String(connectorMessage.getProcessedRawData()); } else { msg = new String(connectorMessage.getRawData()); } \n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)transformer.getOutboundTemplate())) {
            SerializationType templateSerializationType = DataTypeFactory.getSerializationType(transformer.getOutboundDataType(), transformer.getOutboundProperties(), true);
            switch (templateSerializationType) {
                case JSON: {
                    builder.append("tmp = JSON.parse(template);\n");
                    break;
                }
                case XML: {
                    builder.append("tmp = new XML(template);\n");
                    break;
                }
                case RAW: {
                    builder.append("tmp = template;\n");
                }
            }
        }
        JavaScriptBuilder.appendFilterScript(builder, filter);
        JavaScriptBuilder.appendTransformerScript(builder, transformer, false);
        builder.append("if (doFilter() == true) { doTransform(); return true; } else { return false; }");
        return builder.toString();
    }

    public static String generateResponseTransformerScript(Transformer transformer) throws ScriptBuilderException {
        logger.debug("Generating response transformer script...");
        StringBuilder builder = new StringBuilder();
        SerializationType inboundSerializationType = DataTypeFactory.getSerializationType(transformer.getInboundDataType(), transformer.getInboundProperties(), true);
        switch (inboundSerializationType) {
            case JSON: {
                builder.append("msg = JSON.parse(connectorMessage.getResponseTransformedData());\n");
                break;
            }
            case XML: {
                builder.append("msg = new XML(connectorMessage.getResponseTransformedData());\n");
                builder.append("if (msg.namespace('') != undefined) { default xml namespace = msg.namespace(''); } else { default xml namespace = ''; }\n");
                break;
            }
            case RAW: {
                builder.append("msg = new String(response.getMessage()) \n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)transformer.getOutboundTemplate())) {
            SerializationType templateSerializationType = DataTypeFactory.getSerializationType(transformer.getOutboundDataType(), transformer.getOutboundProperties(), true);
            switch (templateSerializationType) {
                case JSON: {
                    builder.append("tmp = JSON.parse(template);\n");
                    break;
                }
                case XML: {
                    builder.append("tmp = new XML(template);\n");
                    break;
                }
                case RAW: {
                    builder.append("tmp = template;\n");
                }
            }
        }
        JavaScriptBuilder.appendTransformerScript(builder, transformer, true);
        builder.append("doTransform();");
        return builder.toString();
    }

    private static void appendDefaultDeployScript(StringBuilder builder, boolean isGlobal) {
        if (isGlobal) {
            builder.append("// This script executes once for each deploy or redeploy task\n// You only have access to the globalMap here to persist data\nreturn;");
        } else {
            builder.append("// This script executes once when the channel is deployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;");
        }
    }

    private static void appendDefaultUndeployScript(StringBuilder builder, boolean isGlobal) {
        if (isGlobal) {
            builder.append("// This script executes once for each deploy, undeploy, or redeploy task\n// if at least one channel was undeployed\n// You only have access to the globalMap here to persist data\nreturn;");
        } else {
            builder.append("// This script executes once when the channel is undeployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;");
        }
    }

    private static void appendDefaultPreprocessorScript(StringBuilder builder, boolean isGlobal) {
        if (isGlobal) {
            builder.append("// Modify the message variable below to pre process data\n// This script applies across all channels\nreturn message;");
        } else {
            builder.append("// Modify the message variable below to pre process data\nreturn message;");
        }
    }

    private static void appendDefaultPostprocessorScript(StringBuilder builder, boolean isGlobal) {
        if (isGlobal) {
            builder.append("// This script executes once after a message has been processed\n// This script applies across all channels\n// Responses returned from here will be stored as \"Postprocessor\" in the response map\n// You have access to \"response\", if returned from the channel postprocessor\nreturn;");
        } else {
            builder.append("// This script executes once after a message has been processed\n// Responses returned from here will be stored as \"Postprocessor\" in the response map\nreturn;");
        }
    }

    private static void appendDefaultAttachmentScript(StringBuilder builder) {
        builder.append("// Modify the message variable below to create attachments\nreturn message;");
    }

    protected static void appendFilterScript(StringBuilder builder, Filter filter) throws ScriptBuilderException {
        List enabledElements = filter.getEnabledElements();
        logger.debug("building javascript filter: enabled rule count=" + enabledElements.size());
        if (enabledElements.isEmpty()) {
            logger.debug("filter is empty, setting to accept all messages");
            builder.append("function doFilter() { phase[0] = 'filter'; return true; }");
        } else {
            Rule rule;
            ListIterator iter = enabledElements.listIterator();
            while (iter.hasNext()) {
                rule = (Rule)iter.next();
                builder.append("function filterRule" + iter.nextIndex() + "() {\n" + rule.getScript(true) + "\n}");
            }
            builder.append("function doFilter() { phase[0] = 'filter'; return (");
            iter = enabledElements.listIterator();
            while (iter.hasNext()) {
                rule = (Rule)iter.next();
                String operator = "";
                if (Objects.equals((Object)rule.getOperator(), (Object)Rule.Operator.AND)) {
                    operator = " && ";
                } else if (Objects.equals((Object)rule.getOperator(), (Object)Rule.Operator.OR)) {
                    operator = " || ";
                }
                builder.append(operator + "(filterRule" + iter.nextIndex() + "() == true)");
            }
            builder.append("); }\n");
        }
    }

    protected static void appendTransformerScript(StringBuilder builder, Transformer transformer, boolean response) throws ScriptBuilderException {
        List enabledElements = transformer.getEnabledElements();
        logger.debug("building javascript transformer: enabled step count=" + enabledElements.size());
        builder.append("function doTransform() {");
        if (!response) {
            builder.append(" phase[0] = 'transformer'; logger = Packages.org.apache.log4j.Logger.getLogger(phase[0]);");
        }
        builder.append("\n\n\n");
        for (Step step : enabledElements) {
            logger.debug("adding step: " + step.getName());
            builder.append(step.getScript(true) + "\n");
        }
        builder.append("if ('xml' === typeof msg) {\n");
        builder.append("    if (msg.hasSimpleContent()) {\n");
        builder.append("        msg = msg.toXMLString();\n");
        builder.append("    }\n");
        builder.append("} else if ('undefined' !== typeof msg && msg !== null) {\n");
        builder.append("    var toStringResult = Object.prototype.toString.call(msg);\n");
        builder.append("    if (toStringResult == '[object Object]' || toStringResult == '[object Array]') {\n");
        builder.append("        msg = JSON.stringify(msg);\n");
        builder.append("    }\n");
        builder.append("}\n");
        builder.append("if ('xml' === typeof tmp) {\n");
        builder.append("    if (tmp.hasSimpleContent()) {\n");
        builder.append("        tmp = tmp.toXMLString();\n");
        builder.append("    }\n");
        builder.append("} else if ('undefined' !== typeof tmp && tmp !== null) {\n");
        builder.append("    var toStringResult = Object.prototype.toString.call(tmp);\n");
        builder.append("    if (toStringResult == '[object Object]' || toStringResult == '[object Array]') {\n");
        builder.append("        tmp = JSON.stringify(tmp);\n");
        builder.append("    }\n");
        builder.append("}\n");
        builder.append("}\n");
    }

    private static void appendMiscFunctions(StringBuilder builder) {
        builder.append("function validate(mapping, defaultValue, replacement) {\n");
        builder.append("    var result = mapping;\n");
        builder.append("    if ((result == undefined) || (result.toString().length == 0)) {\n");
        builder.append("        if (defaultValue == undefined) {\n");
        builder.append("            defaultValue = '';\n");
        builder.append("        }\n");
        builder.append("        result = defaultValue;\n");
        builder.append("    }\n");
        builder.append("    if ('string' === typeof result || result instanceof java.lang.String || 'xml' === typeof result) {\n");
        builder.append("        result = new java.lang.String(result.toString());\n");
        builder.append("        if (replacement != undefined) {\n");
        builder.append("            for (var i = 0; i < replacement.length; i++) { ");
        builder.append("                var entry = replacement[i];\n");
        builder.append("                result = result.replaceAll(entry[0], entry[1]);\n");
        builder.append("            }\n");
        builder.append("        }\n");
        builder.append("    }\n");
        builder.append("    return result;\n");
        builder.append("}\n");
        builder.append("function createSegment(name, msgObj, index) {");
        builder.append("if (arguments.length == 1) { return new XML('<' + name + '></' + name + '>'); };");
        builder.append("if (arguments.length == 2) { index = 0; };");
        builder.append("msgObj[name][index] = new XML('<' + name + '></' + name + '>');");
        builder.append("return msgObj[name][index];");
        builder.append("}\n");
        builder.append("function createSegmentAfter(name, segment) {");
        builder.append("var msgObj = segment;");
        builder.append("while (msgObj.parent() != undefined) { msgObj = msgObj.parent(); }");
        builder.append("msgObj.insertChildAfter(segment[0], new XML('<' + name + '></' + name + '>'));");
        builder.append("return msgObj.child(segment[0].childIndex() + 1);");
        builder.append("}\n");
        builder.append("function getArrayOrXmlLength(obj) {\n");
        builder.append("    if (typeof obj == 'xml' || obj instanceof java.lang.String) {\n");
        builder.append("        return obj.length();\n");
        builder.append("    } else if (typeof obj != 'undefined' && obj != null) {\n");
        builder.append("        return obj.length || 0;\n");
        builder.append("    }\n");
        builder.append("    return 0;\n");
        builder.append("}\n");
        builder.append("function newStringOrUndefined(value) {\n");
        builder.append("    if ('undefined' !== typeof value && value != null) {\n");
        builder.append("        value = new String(value);\n");
        builder.append("    }\n");
        builder.append("    return value;\n");
        builder.append("}\n");
        builder.append("function newBooleanOrUndefined(value) {\n");
        builder.append("    if ('undefined' !== typeof value && value != null) {\n");
        builder.append("        value = new Boolean(value);\n");
        builder.append("    }\n");
        builder.append("    return value;\n");
        builder.append("}\n");
        builder.append("function newNumberOrUndefined(value) {\n");
        builder.append("    if ('undefined' !== typeof value && value != null) {\n");
        builder.append("        value = new Number(value);\n");
        builder.append("    }\n");
        builder.append("    return value;\n");
        builder.append("}\n");
        builder.append("importClass = function() {\n");
        builder.append("    logger.error('The importClass method has been deprecated and will soon be removed. Please use importPackage or the fully-qualified class name instead.');\n");
        builder.append("    for each (argument in arguments) {\n");
        builder.append("        var className = new Packages.java.lang.String(argument);\n");
        builder.append("        if (className.startsWith('class ')) {\n");
        builder.append("            className = className.substring(6);\n");
        builder.append("        }\n");
        builder.append("        eval('importPackage(' + Packages.java.lang.Class.forName(className).getPackage().getName() + ')');\n");
        builder.append("    }\n");
        builder.append("}\n");
    }

    private static void appendMapFunctions(StringBuilder builder) {
        builder.append("function $co(key, value) { if (arguments.length == 1) { return connectorMap.get(key); } else { return connectorMap.put(key, value); } }\n");
        builder.append("function $c(key, value) { if (arguments.length == 1) { return channelMap.get(key); } else { return channelMap.put(key, value); } }\n");
        builder.append("function $s(key, value) { if (arguments.length == 1) { return sourceMap.get(key); } else { return sourceMap.put(key, value); } }\n");
        builder.append("function $gc(key, value) { if (arguments.length == 1) { return globalChannelMap.get(key); } else { return globalChannelMap.put(key, value); } }\n");
        builder.append("function $g(key, value) { if (arguments.length == 1) { return globalMap.get(key); } else { return globalMap.put(key, value); } }\n");
        builder.append("function $cfg(key, value) { if (arguments.length == 1) { return configurationMap.get(key); } else { return configurationMap.put(key, value); } }\n");
        builder.append("function $r(key, value) { if (arguments.length == 1) { return responseMap.get(key); } else { return responseMap.put(key, value); } }\n");
        builder.append("function $(string) { ");
        builder.append("try { if(responseMap.containsKey(string)) { return $r(string); } } catch(e){}");
        builder.append("try { if(connectorMap.containsKey(string)) { return $co(string); } } catch(e){}");
        builder.append("try { if(channelMap.containsKey(string)) { return $c(string); } } catch(e){}");
        builder.append("try { if(sourceMap.containsKey(string)) { return $s(string); } } catch(e){}");
        builder.append("try { if(globalChannelMap.containsKey(string)) { return $gc(string); } } catch(e){}");
        builder.append("try { if(globalMap.containsKey(string)) { return $g(string); } } catch(e){}");
        builder.append("try { if(configurationMap.containsKey(string)) { return $cfg(string); } } catch(e){}");
        builder.append("try { if(resultMap.containsKey(string)) { return resultMap.get(string); } } catch(e){}");
        builder.append("return ''; }\n");
    }

    private static void appendAttachmentFunctions(StringBuilder builder, Set<String> scriptOptions) {
        builder.append("function getAttachmentIds(channelId, messageId) {\n");
        builder.append("    if (arguments.length == 2) {\n");
        builder.append("        return AttachmentUtil.getMessageAttachmentIds(channelId, messageId);\n");
        builder.append("    } else {\n");
        builder.append("        return AttachmentUtil.getMessageAttachmentIds(connectorMessage);\n");
        builder.append("    }\n");
        builder.append("}\n");
        builder.append("function getAttachments(base64Decode) {\n");
        builder.append("    return AttachmentUtil.getMessageAttachments(connectorMessage, !!base64Decode || false);\n");
        builder.append("}\n");
        builder.append("function getAttachment() {\n");
        builder.append("    if (arguments.length >= 3) {\n");
        builder.append("        return AttachmentUtil.getMessageAttachment(arguments[0], arguments[1], arguments[2], !!arguments[3] || false);\n");
        builder.append("    } else {\n");
        builder.append("        return AttachmentUtil.getMessageAttachment(connectorMessage, arguments[0], !!arguments[1] || false);\n");
        builder.append("    }\n");
        builder.append("}\n");
        builder.append("function updateAttachment() {\n");
        builder.append("    if (arguments.length >= 5) {\n");
        builder.append("        return AttachmentUtil.updateAttachment(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], !!arguments[5] || false);\n");
        builder.append("    } else if (arguments.length >= 3) {\n");
        builder.append("        if (arguments[2] && arguments[2] instanceof Attachment) {\n");
        builder.append("            return AttachmentUtil.updateAttachment(arguments[0], arguments[1], arguments[2], !!arguments[3] || false);\n");
        builder.append("        } else {\n");
        builder.append("            return AttachmentUtil.updateAttachment(connectorMessage, arguments[0], arguments[1], arguments[2], !!arguments[3] || false);\n");
        builder.append("        }\n");
        builder.append("    } else {\n");
        builder.append("        return AttachmentUtil.updateAttachment(connectorMessage, arguments[0], !!arguments[1] || false);\n");
        builder.append("    }\n");
        builder.append("}\n");
        if (scriptOptions != null && scriptOptions.contains("useAttachmentList")) {
            builder.append("function addAttachment(data, type, base64Encode) {\n");
            builder.append("return AttachmentUtil.addAttachment(mirth_attachments, data, type, !!base64Encode || false);\n");
            builder.append("}\n");
        } else {
            builder.append("function addAttachment(data, type, base64Encode) {\n");
            builder.append("return AttachmentUtil.createAttachment(connectorMessage, data, type, !!base64Encode || false);\n");
            builder.append("}\n");
        }
    }

    private static void appendCodeTemplates(StringBuilder builder, String channelId, ContextType contextType) {
        try {
            HashMap<String, CodeTemplate> codeTemplateMap = new HashMap<String, CodeTemplate>();
            for (CodeTemplate template : codeTemplateController.getCodeTemplates(null)) {
                codeTemplateMap.put(template.getId(), template);
            }
            for (CodeTemplateLibrary library : codeTemplateController.getLibraries(null, false)) {
                for (CodeTemplate template : library.getCodeTemplates()) {
                    CodeTemplate serverCodeTemplate;
                    if (codeTemplateMap.containsKey(template.getId()) && (channelId == null || library.getEnabledChannelIds().contains(channelId) || !library.getDisabledChannelIds().contains(channelId) && library.isIncludeNewChannels()) && (serverCodeTemplate = (CodeTemplate)codeTemplateMap.get(template.getId())).isAddToScripts() && serverCodeTemplate.getContextSet().contains((Object)contextType)) {
                        builder.append(CodeTemplateUtil.stripDocumentation(serverCodeTemplate.getCode()));
                        builder.append('\n');
                    }
                    codeTemplateMap.remove(template.getId());
                }
            }
        }
        catch (ControllerException e) {
            logger.error("Could not append code templates.", (Throwable)e);
        }
    }
}

