/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.channel;

import com.mirth.connect.server.channel.ChannelFuture;
import com.mirth.connect.server.channel.ChannelTaskHandler;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public abstract class ChannelTask
implements Callable<Void> {
    protected String channelId;
    protected Integer metaDataId;
    private ChannelTaskHandler handler;

    public ChannelTask(String channelId) {
        this(channelId, null);
    }

    public ChannelTask(String channelId, Integer metaDataId) {
        this.channelId = channelId;
        this.metaDataId = metaDataId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Integer getMetaDataId() {
        return this.metaDataId;
    }

    public ChannelTaskHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ChannelTaskHandler handler) {
        this.handler = handler;
    }

    public ChannelFuture submitTo(ExecutorService executor) throws RejectedExecutionException {
        return new ChannelFuture(this.channelId, this.metaDataId, executor.submit(this), this.handler);
    }

    @Override
    public final Void call() throws Exception {
        String originalThreadName = Thread.currentThread().getName();
        try {
            if (this.metaDataId != null) {
                Thread.currentThread().setName("Channel " + this.getClass().getSimpleName() + " Thread on (" + this.channelId + ") connector (" + this.metaDataId + ") < " + originalThreadName);
            } else {
                Thread.currentThread().setName("Channel " + this.getClass().getSimpleName() + " Thread on (" + this.channelId + ") < " + originalThreadName);
            }
            if (this.handler == null) {
                this.handler = new ChannelTaskHandler();
            }
            try {
                this.handler.taskStarted(this.channelId, this.metaDataId);
                this.execute();
                this.handler.taskCompleted(this.channelId, this.metaDataId);
            }
            catch (Exception e) {
                this.handler.taskErrored(this.channelId, this.metaDataId, e);
            }
            Void void_ = null;
            return void_;
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public abstract Void execute() throws Exception;
}

