/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.channel;

import com.mirth.connect.server.channel.ChannelTaskHandler;
import com.mirth.connect.server.channel.LoggingTaskHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.commons.collections4.MapUtils;

public class DelegateErrorTaskHandler
extends ChannelTaskHandler {
    private ChannelTaskHandler delegate;
    private Map<String, Exception> errorMap;

    public DelegateErrorTaskHandler(ChannelTaskHandler delegate) {
        if (delegate == null) {
            delegate = new LoggingTaskHandler();
        }
        this.delegate = delegate;
    }

    public Map<String, Exception> getErrorMap() {
        return this.errorMap;
    }

    public boolean isErrored() {
        return MapUtils.isNotEmpty(this.errorMap);
    }

    @Override
    public void taskStarted(String channelId, Integer metaDataId) {
        this.delegate.taskStarted(channelId, metaDataId);
    }

    @Override
    public void taskCompleted(String channelId, Integer metaDataId) {
        this.delegate.taskCompleted(channelId, metaDataId);
    }

    @Override
    public void taskErrored(String channelId, Integer metaDataId, Exception e) {
        this.delegate.taskErrored(channelId, metaDataId, e);
        if (this.errorMap == null) {
            this.errorMap = new HashMap<String, Exception>();
        }
        this.errorMap.put(channelId, e);
    }

    @Override
    public void taskCancelled(String channelId, Integer metaDataId, CancellationException e) {
        this.delegate.taskCancelled(channelId, metaDataId, e);
        if (this.errorMap == null) {
            this.errorMap = new HashMap<String, Exception>();
        }
        this.errorMap.put(channelId, e);
    }
}

