/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.Cacheable;
import com.mirth.connect.server.util.SqlConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cache<V extends Cacheable<V>> {
    private Logger logger = LogManager.getLogger(this.getClass());
    private String cacheName;
    private String selectRevisionsQueryId;
    private String selectQueryId;
    private boolean nameUnique;
    protected Map<String, V> cacheById = new ConcurrentHashMap<String, V>();
    protected Map<String, V> cacheByName;

    public Cache(String cacheName, String selectRevisionsQueryId, String selectQueryId) {
        this(cacheName, selectRevisionsQueryId, selectQueryId, true);
    }

    public Cache(String cacheName, String selectRevisionsQueryId, String selectQueryId, boolean nameUnique) {
        this.cacheName = cacheName;
        this.selectRevisionsQueryId = selectRevisionsQueryId;
        this.selectQueryId = selectQueryId;
        this.nameUnique = nameUnique;
        if (nameUnique) {
            this.cacheByName = new ConcurrentHashMap<String, V>();
        }
    }

    public Map<String, V> getAllItems() {
        this.refreshCache();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.nameUnique) {
            for (Cacheable item : new TreeMap<String, V>(this.cacheByName).values()) {
                map.put(item.getId(), item.cloneIfNeeded());
            }
        } else {
            ArrayList<V> list = new ArrayList<V>(this.cacheById.values());
            Collections.sort(list, new Comparator<V>(){

                @Override
                public int compare(V o1, V o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (Cacheable item : list) {
                map.put(item.getId(), item);
            }
        }
        return map;
    }

    public V getCachedItemById(String id) {
        this.refreshCache();
        return (V)this.cloneIfNeeded((Cacheable)this.cacheById.get(id));
    }

    public V getCachedItemByName(String name) {
        if (this.nameUnique) {
            this.refreshCache();
            return (V)this.cloneIfNeeded((Cacheable)this.cacheByName.get(name));
        }
        throw new UnsupportedOperationException();
    }

    public Set<String> getCachedIds() {
        this.refreshCache();
        return new LinkedHashSet<String>(this.cacheById.keySet());
    }

    public Set<String> getCachedNames() {
        if (this.nameUnique) {
            this.refreshCache();
            return new LinkedHashSet<String>(this.cacheByName.keySet());
        }
        throw new UnsupportedOperationException();
    }

    protected synchronized void refreshCache() {
        try {
            Map<String, Integer> databaseRevisions = this.getRevisions();
            for (String string : this.cacheById.keySet()) {
                if (databaseRevisions.containsKey(string)) continue;
                Cacheable item = (Cacheable)this.cacheById.remove(string);
                if (!this.nameUnique) continue;
                this.cacheByName.remove(item.getName());
            }
            for (Map.Entry entry : databaseRevisions.entrySet()) {
                String id = (String)entry.getKey();
                if (this.cacheById.containsKey(id) && (Integer)entry.getValue() <= ((Cacheable)this.cacheById.get(id)).getRevision()) continue;
                V item = this.getItem(id);
                if (item != null) {
                    String oldName;
                    String name = item.getName();
                    Cacheable oldItem = (Cacheable)this.cacheById.get(id);
                    this.cacheById.put(id, item);
                    if (!this.nameUnique) continue;
                    this.cacheByName.put(name, item);
                    if (oldItem == null || (oldName = oldItem.getName()).equals(name)) continue;
                    this.cacheByName.remove(oldName);
                    continue;
                }
                if (!this.cacheById.containsKey(id)) continue;
                Cacheable oldItem = (Cacheable)this.cacheById.remove(id);
                if (!this.nameUnique) continue;
                this.cacheByName.remove(oldItem.getName());
            }
        }
        catch (Exception e) {
            this.logger.error("Error refreshing " + this.cacheName + " cache", (Throwable)e);
        }
    }

    private V cloneIfNeeded(V item) {
        return (V)(item != null ? item.cloneIfNeeded() : item);
    }

    private V getItem(String id) {
        try {
            return (V)((Cacheable)this.getSqlSessionManager().selectOne(this.selectQueryId, (Object)id));
        }
        catch (Exception e) {
            this.logger.error(this.cacheName + " cache: Failed to load item " + id + " from the database", (Throwable)e);
            return null;
        }
    }

    private Map<String, Integer> getRevisions() throws ControllerException {
        try {
            List results = this.getSqlSessionManager().selectList(this.selectRevisionsQueryId);
            HashMap<String, Integer> revisionMap = new HashMap<String, Integer>();
            for (Map result : results) {
                revisionMap.put((String)result.get("id"), (Integer)result.get("revision"));
            }
            return revisionMap;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    private SqlSessionManager getSqlSessionManager() {
        if (SqlConfig.getInstance().isSplitReadWrite() && !SqlConfig.getInstance().isWritePoolCache()) {
            return SqlConfig.getInstance().getReadOnlySqlSessionManager();
        }
        return SqlConfig.getInstance().getSqlSessionManager();
    }
}

