/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.google.common.base.Strings;
import com.mirth.commons.encryption.Digester;
import com.mirth.commons.encryption.Encryptor;
import com.mirth.commons.encryption.KeyEncryptor;
import com.mirth.commons.encryption.Output;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DatabaseSettings;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.EncryptionSettings;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ResourcePropertiesList;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.directoryresource.DirectoryResourceProperties;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.MigrationController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.controllers.ServerConfigurationRestorer;
import com.mirth.connect.server.mybatis.KeyValuePair;
import com.mirth.connect.server.tools.ClassPathResource;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.PasswordRequirementsChecker;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import com.mirth.connect.util.ChannelDependencyException;
import com.mirth.connect.util.ChannelDependencyGraph;
import com.mirth.connect.util.ConfigurationProperty;
import com.mirth.connect.util.ConnectionTestResponse;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.MigrationUtil;
import com.mirth.connect.util.MirthSSLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DefaultConfigurationController
extends ConfigurationController {
    public static final String PROPERTIES_CORE = "core";
    public static final String PROPERTIES_RESOURCES = "resources";
    public static final String PROPERTIES_DEPENDENCIES = "channelDependencies";
    public static final String PROPERTIES_CHANNEL_METADATA = "channelMetadata";
    public static final String PROPERTIES_CHANNEL_TAGS = "channelTags";
    public static final String PROPERTIES_DATABASE_DRIVERS = "databaseDrivers";
    public static final String SECRET_KEY_ALIAS = "encryption";
    public static final String VACUUM_LOCK_STATEMENT_ID = "Configuration.vacuumConfigurationTable";
    private Logger logger = LogManager.getLogger(this.getClass());
    private String appDataDir = null;
    private String baseDir = null;
    private String configurationFile = null;
    private static String serverId = null;
    private String serverName = null;
    private int status = 1;
    private ScriptController scriptController = ControllerFactory.getFactory().createScriptController();
    private PasswordRequirements passwordRequirements;
    private int maxInactiveSessionInterval;
    private String[] httpsClientProtocols;
    private String[] httpsServerProtocols;
    private String[] httpsCipherSuites;
    private boolean startupDeploy;
    private volatile Map<String, String> configurationMap = Collections.unmodifiableMap(new HashMap());
    private volatile Map<String, String> commentMap = Collections.unmodifiableMap(new HashMap());
    private static PropertiesConfiguration versionConfig = PropertiesConfigurationUtil.create();
    private static FileBasedConfigurationBuilder<PropertiesConfiguration> mirthConfigBuilder = PropertiesConfigurationUtil.createBuilder();
    protected static PropertiesConfiguration mirthConfig = PropertiesConfigurationUtil.create();
    private static EncryptionSettings encryptionConfig;
    private static DatabaseSettings databaseConfig;
    private static String apiBypassword;
    private static int statsUpdateInterval;
    private static Integer rhinoLanguageVersion;
    private static int startupLockSleep;
    protected volatile boolean configMapLoaded = false;
    private static KeyEncryptor encryptor;
    private static Digester digester;
    private static final String CHARSET = "ca.uhn.hl7v2.llp.charset";
    private static final String PROPERTY_TEMP_DIR = "dir.tempdata";
    private static final String PROPERTY_APP_DATA_DIR = "dir.appdata";
    public static final String CONFIGURATION_MAP_PATH = "configurationmap.path";
    public static final String CONFIGURATION_MAP_LOCATION = "configurationmap.location";
    private static final String MAX_INACTIVE_SESSION_INTERVAL = "server.api.sessionmaxinactiveinterval";
    private static final String HTTPS_CLIENT_PROTOCOLS = "https.client.protocols";
    private static final String HTTPS_SERVER_PROTOCOLS = "https.server.protocols";
    private static final String HTTPS_CIPHER_SUITES = "https.ciphersuites";
    private static final String STARTUP_DEPLOY = "server.startupdeploy";
    private static final String API_BYPASSWORD = "server.api.bypassword";
    private static final String STATS_UPDATE_INTERVAL = "donkey.statsupdateinterval";
    private static final String RHINO_LANGUAGE_VERSION = "rhino.languageversion";
    private static final String SERVER_STARTUP_LOCK_SLEEP = "server.startuplocksleep";
    private static final String XSTREAM_DENY_TYPES = "xstream.denytypes";
    private static final String XSTREAM_ALLOW_TYPES = "xstream.allowtypes";
    private static final String XSTREAM_ALLOW_TYPE_HIERARCHIES = "xstream.allowtypehierarchies";
    private static final String DEFAULT_STOREPASS = "81uWxplDtB";
    private static ConfigurationController instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationController create() {
        Class<DefaultConfigurationController> clazz = DefaultConfigurationController.class;
        synchronized (DefaultConfigurationController.class) {
            if (instance == null) {
                instance = ExtensionLoader.getInstance().getControllerInstance(ConfigurationController.class);
                if (instance == null) {
                    instance = new DefaultConfigurationController();
                    ((DefaultConfigurationController)instance).initialize();
                } else {
                    try {
                        instance.getClass().getMethod("initialize", new Class[0]).invoke((Object)instance, new Object[0]);
                    }
                    catch (Exception e) {
                        LogManager.getLogger(DefaultConfigurationController.class).error("Error calling initialize method in DefaultConfigurationController", (Throwable)e);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        InputStream versionPropertiesStream = null;
        try {
            Object[] xstreamDenyTypesArray;
            String rhinoLanguageVersionStr;
            Object[] httpsClientProtocolsArray;
            mirthConfigBuilder = PropertiesConfigurationUtil.createBuilder((File)new File(ClassPathResource.getResourceURI("mirth.properties")));
            mirthConfig = (PropertiesConfiguration)mirthConfigBuilder.getConfiguration();
            MigrationController.getInstance().migrateConfiguration(mirthConfig);
            try {
                mirthConfigBuilder.save();
            }
            catch (ConfigurationException e) {
                this.logger.error("Unable to update mirth.properties version during migration.", (Throwable)e);
            }
            versionPropertiesStream = ResourceUtil.getResourceStream(this.getClass(), "version.properties");
            versionConfig = PropertiesConfigurationUtil.create((InputStream)versionPropertiesStream);
            if (mirthConfig.getString(PROPERTY_TEMP_DIR) != null) {
                File tempDataDirFile = new File(mirthConfig.getString(PROPERTY_TEMP_DIR));
                if (!tempDataDirFile.exists()) {
                    if (tempDataDirFile.mkdirs()) {
                        this.logger.debug("created tempdir: " + tempDataDirFile.getAbsolutePath());
                    } else {
                        this.logger.error("error creating tempdir: " + tempDataDirFile.getAbsolutePath());
                    }
                }
                System.setProperty("java.io.tmpdir", tempDataDirFile.getAbsolutePath());
                this.logger.debug("set temp data dir: " + tempDataDirFile.getAbsolutePath());
            }
            File appDataDirFile = null;
            if (mirthConfig.getString(PROPERTY_APP_DATA_DIR) != null) {
                appDataDirFile = new File(mirthConfig.getString(PROPERTY_APP_DATA_DIR));
                if (!appDataDirFile.exists()) {
                    if (appDataDirFile.mkdir()) {
                        this.logger.debug("created app data dir: " + appDataDirFile.getAbsolutePath());
                    } else {
                        this.logger.error("error creating app data dir: " + appDataDirFile.getAbsolutePath());
                    }
                }
            } else {
                appDataDirFile = new File(".");
            }
            this.appDataDir = appDataDirFile.getAbsolutePath();
            this.logger.debug("set app data dir: " + this.appDataDir);
            this.baseDir = new File(ClassPathResource.getResourceURI("mirth.properties")).getParentFile().getParent();
            this.logger.debug("set base dir: " + this.baseDir);
            if (mirthConfig.getString(CHARSET) != null) {
                System.setProperty(CHARSET, mirthConfig.getString(CHARSET));
            }
            this.maxInactiveSessionInterval = NumberUtils.toInt((String)mirthConfig.getString(MAX_INACTIVE_SESSION_INTERVAL), (int)259200);
            if (this.maxInactiveSessionInterval < 60) {
                this.maxInactiveSessionInterval = 60;
            }
            if (ArrayUtils.isNotEmpty((Object[])(httpsClientProtocolsArray = mirthConfig.getStringArray(HTTPS_CLIENT_PROTOCOLS)))) {
                ArrayList<String> httpsClientProtocolsList = new ArrayList<String>();
                for (Object protocol : httpsClientProtocolsArray) {
                    httpsClientProtocolsList.addAll(Arrays.asList(StringUtils.split((String)protocol, (char)',')));
                }
                this.httpsClientProtocols = httpsClientProtocolsList.toArray(new String[httpsClientProtocolsList.size()]);
            } else {
                this.httpsClientProtocols = MirthSSLUtil.DEFAULT_HTTPS_CLIENT_PROTOCOLS;
            }
            Object[] httpsServerProtocolsArray = mirthConfig.getStringArray(HTTPS_SERVER_PROTOCOLS);
            if (ArrayUtils.isNotEmpty((Object[])httpsServerProtocolsArray)) {
                ArrayList<String> httpsServerProtocolsList = new ArrayList<String>();
                for (Object protocol : httpsServerProtocolsArray) {
                    httpsServerProtocolsList.addAll(Arrays.asList(StringUtils.split((String)protocol, (char)',')));
                }
                this.httpsServerProtocols = httpsServerProtocolsList.toArray(new String[httpsServerProtocolsList.size()]);
            } else {
                this.httpsServerProtocols = MirthSSLUtil.DEFAULT_HTTPS_SERVER_PROTOCOLS;
            }
            Object[] httpsCipherSuitesArray = mirthConfig.getStringArray(HTTPS_CIPHER_SUITES);
            if (ArrayUtils.isNotEmpty((Object[])httpsCipherSuitesArray)) {
                ArrayList<String> httpsCipherSuitesList = new ArrayList<String>();
                for (Object cipherSuite : httpsCipherSuitesArray) {
                    httpsCipherSuitesList.addAll(Arrays.asList(StringUtils.split((String)cipherSuite, (char)',')));
                }
                this.httpsCipherSuites = httpsCipherSuitesList.toArray(new String[httpsCipherSuitesList.size()]);
            } else {
                this.httpsCipherSuites = MirthSSLUtil.DEFAULT_HTTPS_CIPHER_SUITES;
            }
            String deploy = String.valueOf(mirthConfig.getProperty(STARTUP_DEPLOY));
            if (StringUtils.isNotBlank((CharSequence)deploy)) {
                this.startupDeploy = Boolean.parseBoolean(deploy);
            }
            File serverIdFile = new File(this.getApplicationDataDir(), "server.id");
            FileBasedConfigurationBuilder serverIdConfigBuilder = PropertiesConfigurationUtil.createBuilder((File)serverIdFile);
            PropertiesConfiguration serverIdConfig = null;
            if (serverIdFile.exists()) {
                serverIdConfig = (PropertiesConfiguration)serverIdConfigBuilder.getConfiguration();
            }
            if (!mirthConfig.getBoolean("server.id.ephemeral", false) && serverIdConfig != null && serverIdConfig.getString("server.id") != null && serverIdConfig.getString("server.id").length() > 0) {
                serverId = serverIdConfig.getString("server.id");
            } else {
                serverId = this.generateGuid();
                this.logger.debug("generated new server id: " + serverId);
                if (!serverIdFile.exists()) {
                    serverIdConfigBuilder.save();
                    serverIdConfig = (PropertiesConfiguration)serverIdConfigBuilder.getConfiguration();
                }
                serverIdConfig.setProperty("server.id", (Object)serverId);
                serverIdConfigBuilder.save();
            }
            this.passwordRequirements = PasswordRequirementsChecker.getInstance().loadPasswordRequirements(mirthConfig);
            apiBypassword = mirthConfig.getString(API_BYPASSWORD);
            if (StringUtils.isNotBlank((CharSequence)apiBypassword)) {
                apiBypassword = new String(Base64.decodeBase64((String)apiBypassword), "US-ASCII");
            }
            statsUpdateInterval = NumberUtils.toInt((String)mirthConfig.getString(STATS_UPDATE_INTERVAL), (int)1000);
            if (Strings.isNullOrEmpty((String)mirthConfig.getString(CONFIGURATION_MAP_LOCATION)) || "file".equals(mirthConfig.getString(CONFIGURATION_MAP_LOCATION))) {
                PropertiesConfiguration configurationMapProperties = PropertiesConfigurationUtil.create();
                this.configurationFile = mirthConfig.getString(CONFIGURATION_MAP_PATH) != null ? mirthConfig.getString(CONFIGURATION_MAP_PATH) : this.getApplicationDataDir() + File.separator + "configuration.properties";
                try {
                    File configFile = new File(this.configurationFile);
                    configurationMapProperties = configFile.exists() ? PropertiesConfigurationUtil.create((File)configFile) : PropertiesConfigurationUtil.create();
                    this.configMapLoaded = true;
                }
                catch (ConfigurationException e) {
                    this.logger.warn("Failed to find configuration map file", (Throwable)e);
                }
                HashMap<String, ConfigurationProperty> configurationMap = new HashMap<String, ConfigurationProperty>();
                Iterator iterator = configurationMapProperties.getKeys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = configurationMapProperties.getString(key);
                    String comment = configurationMapProperties.getLayout().getCanonicalComment(key, false);
                    configurationMap.put(key, new ConfigurationProperty(value, comment));
                }
                this.setConfigurationProperties(configurationMap, false);
            }
            if (StringUtils.isNotBlank((CharSequence)(rhinoLanguageVersionStr = mirthConfig.getString(RHINO_LANGUAGE_VERSION)))) {
                rhinoLanguageVersion = this.getRhinoLanguageVersion(rhinoLanguageVersionStr);
                JavaScriptSharedUtil.setRhinoLanguageVersion(rhinoLanguageVersion);
            }
            startupLockSleep = NumberUtils.toInt((String)mirthConfig.getString(SERVER_STARTUP_LOCK_SLEEP), (int)0);
            Object[] xstreamAllowTypesArray = mirthConfig.getStringArray(XSTREAM_ALLOW_TYPES);
            Object[] xstreamAllowTypeHierarchiesArray = mirthConfig.getStringArray(XSTREAM_ALLOW_TYPE_HIERARCHIES);
            if (ArrayUtils.isNotEmpty((Object[])xstreamAllowTypesArray) || ArrayUtils.isNotEmpty((Object[])xstreamAllowTypeHierarchiesArray)) {
                ArrayList<String> allowTypes = new ArrayList<String>();
                ArrayList<String> allowWildcards = new ArrayList<String>();
                ArrayList<String> typeHierarchies = new ArrayList<String>();
                if (ArrayUtils.isNotEmpty((Object[])xstreamAllowTypesArray)) {
                    for (Object allowTypeElement : xstreamAllowTypesArray) {
                        if (!StringUtils.isNotBlank((CharSequence)allowTypeElement)) continue;
                        for (String allowType : StringUtils.split((String)allowTypeElement, (char)',')) {
                            if (!StringUtils.isNotBlank((CharSequence)allowType)) continue;
                            if (StringUtils.containsAny((CharSequence)allowType, (char[])new char[]{'*', '?'})) {
                                allowWildcards.add(allowType);
                                continue;
                            }
                            allowTypes.add(allowType);
                        }
                    }
                }
                if (ArrayUtils.isNotEmpty((Object[])xstreamAllowTypeHierarchiesArray)) {
                    for (Object allowTypeHierarchyElement : xstreamAllowTypeHierarchiesArray) {
                        if (!StringUtils.isNotBlank((CharSequence)allowTypeHierarchyElement)) continue;
                        for (String allowTypeHierarchy : StringUtils.split((String)allowTypeHierarchyElement, (char)',')) {
                            if (!StringUtils.isNotBlank((CharSequence)allowTypeHierarchy)) continue;
                            typeHierarchies.add(allowTypeHierarchy);
                        }
                    }
                }
                ObjectXMLSerializer.getInstance().allowTypes(allowTypes, allowWildcards, typeHierarchies);
            }
            if (ArrayUtils.isNotEmpty((Object[])(xstreamDenyTypesArray = mirthConfig.getStringArray(XSTREAM_DENY_TYPES)))) {
                ArrayList<String> denyTypes = new ArrayList<String>();
                ArrayList<String> denyWildcards = new ArrayList<String>();
                for (Object denyTypeElement : xstreamDenyTypesArray) {
                    if (!StringUtils.isNotBlank((CharSequence)denyTypeElement)) continue;
                    for (String denyType : StringUtils.split((String)denyTypeElement, (char)',')) {
                        if (!StringUtils.isNotBlank((CharSequence)denyType)) continue;
                        if (StringUtils.containsAny((CharSequence)denyType, (char[])new char[]{'*', '?'})) {
                            denyWildcards.add(denyType);
                            continue;
                        }
                        denyTypes.add(denyType);
                    }
                }
                ObjectXMLSerializer.getInstance().denyTypes(denyTypes, denyWildcards);
            }
            ResourceUtil.closeResourceQuietly(versionPropertiesStream);
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize configuration controller", (Throwable)e);
        }
        finally {
            ResourceUtil.closeResourceQuietly(versionPropertiesStream);
        }
    }

    Integer getRhinoLanguageVersion(String rhinoLanguageVersionStr) {
        switch (rhinoLanguageVersionStr.toUpperCase(Locale.ENGLISH)) {
            case "1.0": {
                return 100;
            }
            case "1.1": {
                return 110;
            }
            case "1.2": {
                return 120;
            }
            case "1.3": {
                return 130;
            }
            case "1.4": {
                return 140;
            }
            case "1.5": {
                return 150;
            }
            case "1.6": {
                return 160;
            }
            case "1.7": {
                return 170;
            }
            case "1.8": {
                return 180;
            }
            case "ES6": {
                return 200;
            }
            case "DEFAULT": {
                return 0;
            }
        }
        this.logger.error("Unknown Rhino version '" + rhinoLanguageVersionStr + "', setting to default");
        return 0;
    }

    @Override
    public String getServerId() {
        return serverId;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getServerTimezone(Locale locale) {
        TimeZone timeZone = TimeZone.getDefault();
        boolean daylight = timeZone.inDaylightTime(new Date());
        Object timeZoneDisplay = timeZone.getDisplayName(daylight, 0, locale);
        int offset = timeZone.getOffset(System.currentTimeMillis()) / 3600000;
        Object offsetDisplay = offset < 0 ? String.valueOf(offset) : "+" + offset;
        timeZoneDisplay = (String)timeZoneDisplay + " (UTC " + (String)offsetDisplay + ")";
        return timeZoneDisplay;
    }

    @Override
    public Calendar getServerTime() {
        return Calendar.getInstance();
    }

    @Override
    public List<String> getAvailableCharsetEncodings() throws ControllerException {
        this.logger.debug("Retrieving avaiable character encodings");
        try {
            SortedMap<String, Charset> avaiablesCharsets = Charset.availableCharsets();
            ArrayList<String> simpleAvaiableCharsets = new ArrayList<String>();
            for (Charset charset : avaiablesCharsets.values()) {
                String charsetName = charset.name();
                try {
                    if (StringUtils.isEmpty((CharSequence)charsetName)) {
                        charsetName = charset.aliases().iterator().next();
                    }
                }
                catch (Exception e) {
                    charsetName = "UNKNOWN";
                }
                simpleAvaiableCharsets.add(charsetName);
            }
            return simpleAvaiableCharsets;
        }
        catch (Exception e) {
            throw new ControllerException("Error retrieving available charset encodings.", (Throwable)e);
        }
    }

    @Override
    public ServerSettings getServerSettings() throws ControllerException {
        String environmentName = this.getProperty(PROPERTIES_CORE, "environment.name");
        this.serverName = this.getProperty("core." + serverId, "server.name");
        Properties serverSettings = this.getPropertiesForGroup(PROPERTIES_CORE);
        return new ServerSettings(environmentName, this.serverName, serverSettings);
    }

    @Override
    public PublicServerSettings getPublicServerSettings() throws ControllerException {
        return new PublicServerSettings(this.getServerSettings());
    }

    @Override
    public EncryptionSettings getEncryptionSettings() throws ControllerException {
        return encryptionConfig;
    }

    @Override
    public DatabaseSettings getDatabaseSettings() throws ControllerException {
        return databaseConfig;
    }

    @Override
    public void setServerSettings(ServerSettings settings) throws ControllerException {
        String serverName;
        Properties properties = settings.getProperties();
        this.validateServerSettings(properties);
        String environmentName = settings.getEnvironmentName();
        if (environmentName != null) {
            this.saveProperty(PROPERTIES_CORE, "environment.name", environmentName);
        }
        if ((serverName = settings.getServerName()) != null) {
            this.saveProperty("core." + serverId, "server.name", serverName);
            this.serverName = serverName;
        }
        for (Object name : properties.keySet()) {
            this.saveProperty(PROPERTIES_CORE, (String)name, (String)properties.get(name));
        }
    }

    public void validateServerSettings(Properties properties) throws ControllerException {
        Boolean autoLogoutEnabled = false;
        Integer autoLogoutTime = null;
        if (properties.getProperty("administratorautologoutinterval.enabled") != null) {
            autoLogoutEnabled = this.intToBooleanObject(properties.getProperty("administratorautologoutinterval.enabled"), false);
        }
        if (autoLogoutEnabled.booleanValue()) {
            try {
                autoLogoutTime = Integer.parseInt(properties.getProperty("administratorautologoutinterval.field"));
                if (autoLogoutTime <= 0 || autoLogoutTime >= 61) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new ControllerException("Invalid auto logout interval, the value should be between 1 and 60.");
            }
        }
    }

    protected Boolean intToBooleanObject(String str, Boolean defaultValue) {
        int i = NumberUtils.toInt((String)str, (int)-1);
        if (i == -1) {
            if (defaultValue == null) {
                return null;
            }
            return defaultValue;
        }
        return BooleanUtils.toBooleanObject((int)i);
    }

    @Override
    public UpdateSettings getUpdateSettings() throws ControllerException {
        return new UpdateSettings(this.getPropertiesForGroup(PROPERTIES_CORE));
    }

    @Override
    public void setUpdateSettings(UpdateSettings settings) throws ControllerException {
        Properties properties = settings.getProperties();
        for (Object name : properties.keySet()) {
            this.saveProperty(PROPERTIES_CORE, (String)name, (String)properties.get(name));
        }
    }

    @Override
    public String generateGuid() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getDatabaseType() {
        return mirthConfig.getString("database");
    }

    @Override
    public Encryptor getEncryptor() {
        return encryptor;
    }

    @Override
    public Digester getDigester() {
        return digester;
    }

    @Override
    public List<DriverInfo> getDatabaseDrivers() throws ControllerException {
        this.logger.debug("retrieving database driver list");
        String databaseDriversXml = this.getProperty(PROPERTIES_CORE, PROPERTIES_DATABASE_DRIVERS);
        List<DriverInfo> drivers = null;
        if (StringUtils.isNotBlank((CharSequence)databaseDriversXml)) {
            drivers = ObjectXMLSerializer.getInstance().deserializeList(databaseDriversXml, DriverInfo.class);
        } else {
            File driversFile = this.getDbDriversFile();
            if (driversFile != null && driversFile.exists()) {
                try (FileInputStream is = new FileInputStream(driversFile);
                     InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                    drivers = this.parseDbdriversXml(reader);
                }
                catch (Exception e) {
                    throw new ControllerException("Error during loading of database drivers file: " + driversFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty(drivers)) {
            drivers = DriverInfo.getDefaultDrivers();
        }
        return drivers;
    }

    File getDbDriversFile() {
        URI uri = ClassPathResource.getResourceURI("dbdrivers.xml");
        if (uri != null) {
            return new File(uri);
        }
        return null;
    }

    List<DriverInfo> parseDbdriversXml(Reader reader) throws Exception {
        ArrayList<DriverInfo> drivers = new ArrayList<DriverInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document document = dbf.newDocumentBuilder().parse(new InputSource(reader));
        Element driversElement = document.getDocumentElement();
        for (int i = 0; i < driversElement.getElementsByTagName("driver").getLength(); ++i) {
            Element driverElement = (Element)driversElement.getElementsByTagName("driver").item(i);
            String name = StringUtils.trimToEmpty((String)driverElement.getAttribute("name"));
            String className = StringUtils.trimToEmpty((String)driverElement.getAttribute("class"));
            String template = StringUtils.trimToEmpty((String)driverElement.getAttribute("template"));
            String selectLimit = StringUtils.trimToEmpty((String)driverElement.getAttribute("selectLimit"));
            String alternativeClasses = StringUtils.trimToEmpty((String)driverElement.getAttribute("alternativeClasses"));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name, className, template})) {
                ArrayList<String> alternativeClassNames = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)alternativeClasses)) {
                    alternativeClassNames.addAll(new ArrayList<String>(Arrays.asList(StringUtils.split((String)alternativeClasses, (char)','))));
                }
                DriverInfo driver = new DriverInfo(name, className, template, selectLimit, alternativeClassNames);
                this.logger.debug("Found database driver: " + String.valueOf(driver));
                drivers.add(driver);
                continue;
            }
            this.logger.error("Error adding database driver: Name, class, or template is blank.");
        }
        return drivers;
    }

    @Override
    public void setDatabaseDrivers(List<DriverInfo> drivers) throws ControllerException {
        this.saveProperty(PROPERTIES_CORE, PROPERTIES_DATABASE_DRIVERS, ObjectXMLSerializer.getInstance().serialize(drivers));
    }

    @Override
    public String getServerVersion() {
        return versionConfig.getString("mirth.version");
    }

    @Override
    public String getBuildDate() {
        return versionConfig.getString("mirth.date");
    }

    @Override
    public int getMaxInactiveSessionInterval() {
        return this.maxInactiveSessionInterval;
    }

    @Override
    public String[] getHttpsClientProtocols() {
        return (String[])ArrayUtils.clone((Object[])this.httpsClientProtocols);
    }

    @Override
    public String[] getHttpsServerProtocols() {
        return (String[])ArrayUtils.clone((Object[])this.httpsServerProtocols);
    }

    @Override
    public String[] getHttpsCipherSuites() {
        return (String[])ArrayUtils.clone((Object[])this.httpsCipherSuites);
    }

    @Override
    public boolean isStartupDeploy() {
        return this.startupDeploy;
    }

    @Override
    public int getStatsUpdateInterval() {
        return statsUpdateInterval;
    }

    @Override
    public Integer getRhinoLanguageVersion() {
        return rhinoLanguageVersion;
    }

    @Override
    public int getStartupLockSleep() {
        return startupLockSleep;
    }

    @Override
    public int getStatus() {
        return this.getStatus(true);
    }

    @Override
    public int getStatus(boolean checkDatabase) {
        this.logger.debug("getting Mirth status");
        if (checkDatabase && !this.isDatabaseRunning() || !ControllerFactory.getFactory().createEngineController().isRunning() && this.status != 2) {
            return 1;
        }
        return this.status;
    }

    @Override
    public ServerConfiguration getServerConfiguration() throws ControllerException {
        ChannelController channelController = ControllerFactory.getFactory().createChannelController();
        AlertController alertController = ControllerFactory.getFactory().createAlertController();
        CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setChannelGroups(channelController.getChannelGroups(null));
        serverConfiguration.setChannels(channelController.getChannels(null));
        Map<String, ChannelMetadata> metadataMap = this.getChannelMetadata();
        for (Channel channel : serverConfiguration.getChannels()) {
            ChannelMetadata metadata = metadataMap.get(channel.getId());
            if (metadata == null) {
                metadata = new ChannelMetadata();
            }
            channel.getExportData().setMetadata(metadata);
        }
        serverConfiguration.setChannelTags(this.getChannelTags());
        serverConfiguration.setAlerts(alertController.getAlerts());
        serverConfiguration.setCodeTemplateLibraries(codeTemplateController.getLibraries(null, true));
        serverConfiguration.setServerSettings(this.getServerSettings());
        serverConfiguration.setUpdateSettings(this.getUpdateSettings());
        serverConfiguration.setGlobalScripts(this.scriptController.getGlobalScripts());
        HashMap<String, Properties> pluginProperties = new HashMap<String, Properties>();
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        for (PluginMetaData pluginMetaData : extensionController.getPluginMetaData().values()) {
            String pluginName = pluginMetaData.getName();
            Properties properties = extensionController.getPluginProperties(pluginName);
            if (!MapUtils.isNotEmpty((Map)properties)) continue;
            pluginProperties.put(pluginName, properties);
        }
        serverConfiguration.setPluginProperties(pluginProperties);
        serverConfiguration.setResourceProperties(ObjectXMLSerializer.getInstance().deserialize(this.getResources(), ResourcePropertiesList.class));
        serverConfiguration.setChannelDependencies(this.getChannelDependencies());
        serverConfiguration.setConfigurationMap(this.getConfigurationProperties());
        return serverConfiguration;
    }

    @Override
    public void setServerConfiguration(ServerConfiguration serverConfiguration, boolean deploy, boolean overwriteConfigMap) throws ControllerException {
        ChannelController channelController = ControllerFactory.getFactory().createChannelController();
        AlertController alertController = ControllerFactory.getFactory().createAlertController();
        CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();
        EngineController engineController = ControllerFactory.getFactory().createEngineController();
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
        ServerConfigurationRestorer restorer = new ServerConfigurationRestorer(this, channelController, alertController, codeTemplateController, engineController, this.scriptController, extensionController, contextFactoryController);
        restorer.restoreServerConfiguration(serverConfiguration, deploy, overwriteConfigMap);
    }

    @Override
    public Map<String, String> getConfigurationMap() {
        this.loadDatabaseConfigPropsIfNecessary();
        return this.configurationMap;
    }

    protected void loadDatabaseConfigPropsIfNecessary() {
        try {
            if (!this.configMapLoaded && "database".equals(mirthConfig.getString(CONFIGURATION_MAP_LOCATION))) {
                String configSerialized = this.getProperty(PROPERTIES_CORE, "configuration.properties");
                this.configMapLoaded = true;
                if (!Strings.isNullOrEmpty((String)configSerialized)) {
                    HashMap configurationMap = ObjectXMLSerializer.getInstance().deserialize(configSerialized, HashMap.class);
                    this.setConfigurationProperties(configurationMap, true);
                }
            }
        }
        catch (ControllerException e) {
            this.logger.error("Failed to load configuration map from database", (Throwable)e);
        }
    }

    @Override
    public synchronized Map<String, ConfigurationProperty> getConfigurationProperties() {
        this.loadDatabaseConfigPropsIfNecessary();
        HashMap<String, ConfigurationProperty> map = new HashMap<String, ConfigurationProperty>();
        for (Map.Entry<String, String> entry : this.configurationMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String comment = this.commentMap.get(key);
            map.put(key, new ConfigurationProperty(value, comment));
        }
        return map;
    }

    @Override
    public synchronized void setConfigurationProperties(Map<String, ConfigurationProperty> map, boolean persist) throws ControllerException {
        if (persist) {
            this.saveConfigurationProperties(map);
        }
        HashMap<String, String> valueMap = new HashMap<String, String>();
        HashMap<String, String> commentMap = new HashMap<String, String>();
        for (Map.Entry<String, ConfigurationProperty> entry : map.entrySet()) {
            valueMap.put(entry.getKey(), entry.getValue().getValue());
            commentMap.put(entry.getKey(), entry.getValue().getComment());
        }
        this.configurationMap = Collections.unmodifiableMap(valueMap);
        this.commentMap = Collections.unmodifiableMap(commentMap);
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public String getApplicationDataDir() {
        return this.appDataDir;
    }

    @Override
    public String getConfigurationDir() {
        return this.baseDir + File.separator + "conf";
    }

    @Override
    public PasswordRequirements getPasswordRequirements() {
        return this.passwordRequirements;
    }

    @Override
    public boolean isBypasswordEnabled() {
        return StringUtils.isNotBlank((CharSequence)apiBypassword);
    }

    @Override
    public boolean checkBypassword(String password) {
        return this.isBypasswordEnabled() && StringUtils.equals((CharSequence)password, (CharSequence)apiBypassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getPropertiesForGroup(String category, Set<String> propertyKeys) {
        this.logger.trace("retrieving properties: category=" + category + " propertyKeys=" + StringUtils.join(propertyKeys, (String)","));
        Properties properties = new Properties();
        StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readLock();
        try {
            List result;
            if (CollectionUtils.isEmpty(propertyKeys)) {
                result = SqlConfig.getInstance().getSqlSessionManager().selectList("Configuration.selectPropertiesForCategory", (Object)category);
            } else {
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("category", category);
                parameterMap.put("propertyKeys", propertyKeys);
                result = SqlConfig.getInstance().getSqlSessionManager().selectList("Configuration.selectFilteredPropertiesForCategory", parameterMap);
            }
            for (KeyValuePair pair : result) {
                properties.setProperty(pair.getKey(), StringUtils.defaultString((String)pair.getValue()));
            }
        }
        catch (Exception e) {
            this.logger.error("Could not retrieve properties: category=" + category + " propertyKeys=" + StringUtils.join(propertyKeys, (String)","), (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readUnlock();
        }
        return properties;
    }

    @Override
    public void removePropertiesForGroup(String category) {
        this.logger.debug("deleting all properties: category=" + category);
        StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readLock();
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("category", category);
            SqlConfig.getInstance().getSqlSessionManager().delete("Configuration.deleteProperty", parameterMap);
        }
        catch (Exception e) {
            this.logger.error("Could not delete properties: category=" + category);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String category, String name) {
        this.logger.trace("retrieving property: category=" + category + ", name=" + name);
        StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readLock();
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("category", category);
            parameterMap.put("name", name);
            String string = (String)SqlConfig.getInstance().getSqlSessionManager().selectOne("Configuration.selectProperty", parameterMap);
            return string;
        }
        catch (Exception e) {
            this.logger.error("Could not retrieve property: category=" + category + ", name=" + name, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProperty(String category, String name, String value) {
        this.logger.debug("storing property: category=" + category + ", name=" + name);
        StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).writeLock();
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("category", category);
            parameterMap.put("name", name);
            parameterMap.put("value", value);
            if (this.getProperty(category, name) == null) {
                SqlConfig.getInstance().getSqlSessionManager().insert("Configuration.insertProperty", parameterMap);
            } else {
                SqlConfig.getInstance().getSqlSessionManager().insert("Configuration.updateProperty", parameterMap);
            }
            if (DatabaseUtil.statementExists(VACUUM_LOCK_STATEMENT_ID)) {
                this.vacuumConfigurationTable();
            }
        }
        catch (Exception e) {
            this.logger.error("Could not store property: category=" + category + ", name=" + name, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).writeUnlock();
        }
    }

    public void vacuumConfigurationTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("Configuration.lockConfigurationTable")) {
                session.update("Configuration.lockConfigurationTable");
            }
            session.update(VACUUM_LOCK_STATEMENT_ID);
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperty(String category, String name) {
        this.logger.debug("deleting property: category=" + category + ", name=" + name);
        StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readLock();
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("category", category);
            parameterMap.put("name", name);
            SqlConfig.getInstance().getSqlSessionManager().delete("Configuration.deleteProperty", parameterMap);
        }
        catch (Exception e) {
            this.logger.error("Could not delete property: category=" + category + ", name=" + name, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public String getResources() {
        String resources = this.getProperty(PROPERTIES_CORE, PROPERTIES_RESOURCES);
        if (StringUtils.isBlank((CharSequence)resources)) {
            ResourcePropertiesList list = new ResourcePropertiesList();
            DirectoryResourceProperties defaultResource = new DirectoryResourceProperties();
            defaultResource.setId("Default Resource");
            defaultResource.setName("[Default Resource]");
            defaultResource.setDescription("Loads libraries from the custom-lib folder in the BridgeLink home directory.");
            defaultResource.setIncludeWithGlobalScripts(true);
            defaultResource.setDirectory("custom-lib");
            list.getList().add((ResourceProperties)defaultResource);
            resources = ObjectXMLSerializer.getInstance().serialize(list);
        }
        return resources;
    }

    @Override
    public void setResources(String resources) {
        this.saveProperty(PROPERTIES_CORE, PROPERTIES_RESOURCES, resources);
    }

    @Override
    public Set<ChannelDependency> getChannelDependencies() {
        String dependenciesXml = this.getProperty(PROPERTIES_CORE, PROPERTIES_DEPENDENCIES);
        Set<ChannelDependency> dependencies = StringUtils.isNotBlank((CharSequence)dependenciesXml) ? ObjectXMLSerializer.getInstance().deserialize(dependenciesXml, Set.class) : new HashSet<ChannelDependency>();
        return dependencies;
    }

    @Override
    public synchronized void setChannelDependencies(Set<ChannelDependency> dependencies) {
        try {
            new ChannelDependencyGraph(dependencies);
        }
        catch (ChannelDependencyException e) {
            this.logger.error("Error saving channel dependencies: " + e.getMessage(), (Throwable)e);
            return;
        }
        this.saveProperty(PROPERTIES_CORE, PROPERTIES_DEPENDENCIES, ObjectXMLSerializer.getInstance().serialize(dependencies));
    }

    @Override
    public Set<ChannelTag> getChannelTags() {
        String channelTagXML = this.getProperty(PROPERTIES_CORE, PROPERTIES_CHANNEL_TAGS);
        Set<ChannelTag> channelTags = StringUtils.isNotBlank((CharSequence)channelTagXML) ? ObjectXMLSerializer.getInstance().deserialize(channelTagXML, Set.class) : new HashSet<ChannelTag>();
        return channelTags;
    }

    @Override
    public synchronized void setChannelTags(Set<ChannelTag> tags) {
        if (tags == null) {
            tags = new HashSet<ChannelTag>();
        } else {
            HashMap<String, ChannelTag> tagMap = new HashMap<String, ChannelTag>();
            for (ChannelTag tag : tags) {
                tag.setName(ChannelTag.fixName(tag.getName()));
                ChannelTag matchingTag = (ChannelTag)tagMap.get(tag.getName().toLowerCase());
                if (matchingTag != null) {
                    matchingTag.getChannelIds().addAll(tag.getChannelIds());
                    continue;
                }
                tagMap.put(tag.getName().toLowerCase(), tag);
            }
            tags = new HashSet(tagMap.values());
        }
        this.saveProperty(PROPERTIES_CORE, PROPERTIES_CHANNEL_TAGS, ObjectXMLSerializer.getInstance().serialize(tags));
    }

    @Override
    public Map<String, ChannelMetadata> getChannelMetadata() {
        String channelMetadataXml = this.getProperty(PROPERTIES_CORE, PROPERTIES_CHANNEL_METADATA);
        Map<String, ChannelMetadata> channelMetadata = StringUtils.isNotBlank((CharSequence)channelMetadataXml) ? ObjectXMLSerializer.getInstance().deserialize(channelMetadataXml, Map.class) : new HashMap<String, ChannelMetadata>();
        return channelMetadata;
    }

    @Override
    public void setChannelMetadata(Map<String, ChannelMetadata> channelMetadata) {
        this.saveProperty(PROPERTIES_CORE, PROPERTIES_CHANNEL_METADATA, ObjectXMLSerializer.getInstance().serialize(channelMetadata));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSecuritySettings() {
        block8: {
            FileInputStream keyStoreFileIs = null;
            FileOutputStream fos = null;
            try {
                encryptionConfig = new EncryptionSettings(ConfigurationConverter.getProperties((Configuration)mirthConfig));
                File keyStoreFile = new File(mirthConfig.getString("keystore.path"));
                char[] keyStorePassword = mirthConfig.getString("keystore.storepass").toCharArray();
                char[] keyPassword = mirthConfig.getString("keystore.keypass").toCharArray();
                Provider provider = (Provider)Class.forName(encryptionConfig.getSecurityProvider()).newInstance();
                KeyStore keyStore = null;
                keyStore = MigrationUtil.compareVersions("2.2.0", this.getServerVersion()) == 1 ? KeyStore.getInstance("JKS") : KeyStore.getInstance(mirthConfig.getString("keystore.type", "JCEKS"));
                if (keyStoreFile.exists()) {
                    keyStoreFileIs = new FileInputStream(keyStoreFile);
                    keyStore.load(keyStoreFileIs, keyStorePassword);
                    this.logger.debug("found and loaded keystore: " + keyStoreFile.getAbsolutePath());
                } else {
                    if (Arrays.equals(keyStorePassword, DEFAULT_STOREPASS.toCharArray()) && Arrays.equals(keyPassword, DEFAULT_STOREPASS.toCharArray())) {
                        String keyStorePasswordStr = this.generateNewPassword();
                        mirthConfig.setProperty("keystore.storepass", (Object)keyStorePasswordStr);
                        keyStorePassword = keyStorePasswordStr.toCharArray();
                        String keyPasswordStr = this.generateNewPassword();
                        mirthConfig.setProperty("keystore.keypass", (Object)keyPasswordStr);
                        keyPassword = keyPasswordStr.toCharArray();
                        this.saveMirthConfig();
                    }
                    keyStore.load(null, keyStorePassword);
                    this.logger.debug("keystore file not found, created new one");
                }
                this.configureEncryption(provider, keyStore, keyPassword);
                this.generateDefaultCertificate(provider, keyStore, keyPassword);
                fos = new FileOutputStream(keyStoreFile);
                keyStore.store(fos, keyStorePassword);
                ResourceUtil.closeResourceQuietly(keyStoreFileIs);
            }
            catch (Exception e) {
                this.logger.error("Could not initialize security settings.", (Throwable)e);
                break block8;
            }
            finally {
                ResourceUtil.closeResourceQuietly(keyStoreFileIs);
                ResourceUtil.closeResourceQuietly(fos);
            }
            ResourceUtil.closeResourceQuietly(fos);
        }
    }

    private String generateNewPassword() {
        String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= 12; ++i) {
            builder.append(characters.charAt(random.nextInt(characters.length())));
        }
        return builder.toString();
    }

    @Override
    public void initializeDatabaseSettings() {
        try {
            databaseConfig = new DatabaseSettings(ConfigurationConverter.getProperties((Configuration)mirthConfig));
            databaseConfig.setDirBase(this.getBaseDir());
            String password = databaseConfig.getDatabasePassword();
            String readOnlyPassword = databaseConfig.getDatabaseReadOnlyPassword();
            if (StringUtils.isNotEmpty((CharSequence)password) || StringUtils.isNotEmpty((CharSequence)readOnlyPassword)) {
                ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
                EncryptionSettings encryptionSettings = configurationController.getEncryptionSettings();
                Encryptor encryptor = configurationController.getEncryptor();
                if (encryptionSettings.getEncryptProperties().booleanValue()) {
                    if (StringUtils.isNotEmpty((CharSequence)password)) {
                        this.updateDatabasePassword(encryptor, password, false);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)readOnlyPassword)) {
                        this.updateDatabasePassword(encryptor, readOnlyPassword, true);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateDatabasePassword(Encryptor encryptor, String password, boolean readOnly) throws FileNotFoundException, ConfigurationException {
        if (StringUtils.startsWith((CharSequence)password, (CharSequence)"{enc}")) {
            String encryptedPassword = StringUtils.removeStart((String)password, (String)"{enc}");
            String decryptedPassword = encryptor.decrypt(encryptedPassword);
            if (readOnly) {
                databaseConfig.setDatabaseReadOnlyPassword(decryptedPassword);
            } else {
                databaseConfig.setDatabasePassword(decryptedPassword);
            }
            if (!StringUtils.startsWith((CharSequence)encryptedPassword, (CharSequence)"{")) {
                mirthConfig.setProperty(readOnly ? "database-readonly.password" : "database.password", (Object)("{enc}" + encryptor.encrypt(decryptedPassword)));
                this.saveMirthConfig();
            }
        } else if (StringUtils.isNotBlank((CharSequence)password)) {
            String encryptedPassword = "{enc}" + encryptor.encrypt(password);
            mirthConfig.setProperty(readOnly ? "database-readonly.password" : "database.password", (Object)encryptedPassword);
            this.saveMirthConfig();
        }
    }

    private void saveMirthConfig() throws FileNotFoundException, ConfigurationException {
        File confDir = new File(ControllerFactory.getFactory().createConfigurationController().getConfigurationDir());
        FileOutputStream os = new FileOutputStream(new File(confDir, "mirth.properties"));
        try {
            PropertiesConfigurationUtil.saveTo((PropertiesConfiguration)mirthConfig, (OutputStream)os);
        }
        finally {
            ResourceUtil.closeResourceQuietly(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrateKeystore() {
        FileOutputStream keyStoreOuputStream;
        InputStream mirthPropsIs;
        block5: {
            PropertiesConfiguration properties = PropertiesConfigurationUtil.create();
            mirthPropsIs = null;
            keyStoreOuputStream = null;
            try {
                DonkeyElement defaultElement;
                if (this.getProperty(PROPERTIES_CORE, "encryption.key") == null) break block5;
                mirthPropsIs = ResourceUtil.getResourceStream(this.getClass(), "mirth.properties");
                properties = PropertiesConfigurationUtil.create((InputStream)mirthPropsIs);
                File keyStoreFile = new File(properties.getString("keystore.path"));
                char[] keyStorePassword = properties.getString("keystore.storepass").toCharArray();
                char[] keyPassword = properties.getString("keystore.keypass").toCharArray();
                keyStoreFile.delete();
                KeyStore keyStore = KeyStore.getInstance("JCEKS");
                keyStore.load(null, keyStorePassword);
                ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
                String xml = this.getProperty(PROPERTIES_CORE, "encryption.key");
                Document document = new DocumentSerializer().fromXML(xml);
                DonkeyElement root = new DonkeyElement(document.getDocumentElement());
                DonkeyElement keyRep = root.getChildElement("java.security.KeyRep");
                if (keyRep != null && (defaultElement = keyRep.getChildElement("default")) != null) {
                    defaultElement.setNodeName("java.security.KeyRep");
                    xml = defaultElement.toXml();
                }
                SecretKey secretKey = serializer.deserialize(xml, SecretKey.class);
                KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKey);
                keyStore.setEntry(SECRET_KEY_ALIAS, entry, new KeyStore.PasswordProtection(keyPassword));
                keyStoreOuputStream = new FileOutputStream(keyStoreFile);
                keyStore.store(keyStoreOuputStream, keyStorePassword);
                this.removeProperty(PROPERTIES_CORE, "encryption.key");
                this.initializeSecuritySettings();
            }
            catch (Exception e) {
                try {
                    this.logger.error("Error migrating encryption key from database to keystore.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ResourceUtil.closeResourceQuietly(mirthPropsIs);
                    ResourceUtil.closeResourceQuietly(keyStoreOuputStream);
                    throw throwable;
                }
                ResourceUtil.closeResourceQuietly(mirthPropsIs);
                ResourceUtil.closeResourceQuietly(keyStoreOuputStream);
            }
        }
        ResourceUtil.closeResourceQuietly(mirthPropsIs);
        ResourceUtil.closeResourceQuietly(keyStoreOuputStream);
    }

    @Override
    public void updatePropertiesConfiguration(PropertiesConfiguration config) {
        config.copy((Configuration)mirthConfig);
    }

    private void configureEncryption(Provider provider, KeyStore keyStore, char[] keyPassword) throws Exception {
        SecretKey secretKey = null;
        if (!keyStore.containsAlias(SECRET_KEY_ALIAS)) {
            this.logger.debug("encryption key not found, generating new one");
            KeyGenerator keyGenerator = KeyGenerator.getInstance(encryptionConfig.getEncryptionBaseAlgorithm(), provider);
            keyGenerator.init(encryptionConfig.getEncryptionKeyLength());
            secretKey = keyGenerator.generateKey();
            KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKey);
            keyStore.setEntry(SECRET_KEY_ALIAS, entry, new KeyStore.PasswordProtection(keyPassword));
        } else {
            this.logger.debug("found encryption key in keystore");
            secretKey = (SecretKey)keyStore.getKey(SECRET_KEY_ALIAS, keyPassword);
        }
        encryptionConfig.setSecretKey(secretKey.getEncoded());
        encryptor = new KeyEncryptor();
        encryptor.setProvider(provider);
        encryptor.setKey((Key)secretKey);
        encryptor.setAlgorithm(encryptionConfig.getEncryptionAlgorithm());
        encryptor.setCharset(encryptionConfig.getEncryptionCharset());
        encryptor.setFallbackAlgorithm(encryptionConfig.getEncryptionFallbackAlgorithm());
        encryptor.setFallbackCharset(encryptionConfig.getEncryptionFallbackCharset());
        encryptor.setFormat(Output.BASE64);
        digester = new Digester();
        digester.setProvider(provider);
        digester.setAlgorithm(encryptionConfig.getDigestAlgorithm());
        digester.setSaltSizeBytes(encryptionConfig.getDigestSaltSize().intValue());
        digester.setIterations(encryptionConfig.getDigestIterations().intValue());
        digester.setUsePBE(encryptionConfig.getDigestUsePBE().booleanValue());
        digester.setKeySizeBits(encryptionConfig.getDigestKeySize().intValue());
        digester.setFallbackAlgorithm(encryptionConfig.getDigestFallbackAlgorithm());
        digester.setFallbackSaltSizeBytes(encryptionConfig.getDigestFallbackSaltSize());
        digester.setFallbackIterations(encryptionConfig.getDigestFallbackIterations());
        digester.setFallbackUsePBE(encryptionConfig.getDigestFallbackUsePBE());
        digester.setFallbackKeySizeBits(encryptionConfig.getDigestFallbackKeySize());
        digester.setFormat(Output.BASE64);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)encryptionConfig.getEncryptionAlgorithm(), (CharSequence[])new CharSequence[]{"AES", "DES", "DESede"})) {
            this.logger.error("Encryption algorithm is currently set to: \"" + encryptionConfig.getEncryptionAlgorithm() + "\"\nYou should update the \"encryption.algorithm\" in mirth.properties to a more secure option, such as \"" + encryptionConfig.getEncryptionAlgorithm() + "/CBC/PKCS5Padding\".\nSupport for the currently set algorithm will be REMOVED in a future version, so if you do not update it, BridgeLink will fail to start.\nPlease see the Security Best Practices -> Encryption Settings section of the User Guide for more information.");
        }
    }

    private void generateDefaultCertificate(Provider provider, KeyStore keyStore, char[] keyPassword) throws Exception {
        String certificateAlias = "mirthconnect";
        if (!keyStore.containsAlias("mirthconnect")) {
            Date startDate = new Date();
            Date expiryDate = DateUtils.addYears((Date)startDate, (int)50);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", provider);
            keyPairGenerator.initialize(2048);
            KeyPair caKeyPair = keyPairGenerator.generateKeyPair();
            this.logger.debug("generated new key pair for CA cert using provider: " + provider.getName());
            X500Name caSubjectName = new X500Name("CN=BridgeLink Certificate Authority");
            SubjectPublicKeyInfo caSubjectKey = SubjectPublicKeyInfo.getInstance((Object)caKeyPair.getPublic().getEncoded());
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(caSubjectName, BigInteger.ONE, startDate, expiryDate, caSubjectName, caSubjectKey);
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA256withRSA").setProvider(provider).build(caKeyPair.getPrivate());
            X509Certificate caCert = new JcaX509CertificateConverter().setProvider(provider).getCertificate(certBuilder.build(sigGen));
            KeyPair sslKeyPair = keyPairGenerator.generateKeyPair();
            this.logger.debug("generated new key pair for SSL cert using provider: " + provider.getName());
            X500Name sslSubjectName = new X500Name("CN=mirth-connect");
            SubjectPublicKeyInfo sslSubjectKey = SubjectPublicKeyInfo.getInstance((Object)sslKeyPair.getPublic().getEncoded());
            X509v3CertificateBuilder sslCertBuilder = new X509v3CertificateBuilder(caSubjectName, new BigInteger(50, new SecureRandom()), startDate, expiryDate, sslSubjectName, sslSubjectKey);
            sslCertBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifier(caCert.getEncoded()));
            sslCertBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(sslKeyPair.getPublic().getEncoded()));
            sigGen = new JcaContentSignerBuilder("SHA256withRSA").setProvider(provider).build(caKeyPair.getPrivate());
            X509Certificate sslCert = new JcaX509CertificateConverter().setProvider(provider).getCertificate(sslCertBuilder.build(sigGen));
            this.logger.debug("generated new certificate with serial number: " + String.valueOf(sslCert.getSerialNumber()));
            keyStore.setKeyEntry("mirthconnect", sslKeyPair.getPrivate(), keyPassword, new Certificate[]{sslCert});
        } else {
            this.logger.debug("found certificate in keystore");
        }
    }

    private boolean isDatabaseRunning() {
        if (!this.testDatabase(false)) {
            return false;
        }
        if (SqlConfig.getInstance().isSplitReadWrite()) {
            return this.testDatabase(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testDatabase(boolean readOnly) {
        boolean bl;
        Statement statement = null;
        Connection connection = null;
        SqlSessionManager manager = readOnly ? SqlConfig.getInstance().getSqlSessionManager() : SqlConfig.getInstance().getSqlSessionManager();
        manager.startManagedSession();
        try {
            connection = manager.getConnection();
            statement = connection.createStatement();
            statement.execute("SELECT 1 FROM CHANNEL");
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                this.logger.warn("could not retrieve status of database", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                DbUtils.closeQuietly((Connection)connection);
                if (manager.isManagedSessionStarted()) {
                    manager.close();
                }
                throw throwable;
            }
            DbUtils.closeQuietly((Statement)statement);
            DbUtils.closeQuietly((Connection)connection);
            if (manager.isManagedSessionStarted()) {
                manager.close();
            }
            return bl2;
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
        if (manager.isManagedSessionStarted()) {
            manager.close();
        }
        return bl;
    }

    private void saveConfigurationProperties(Map<String, ConfigurationProperty> map) throws ControllerException {
        try {
            if (Strings.isNullOrEmpty((String)mirthConfig.getString(CONFIGURATION_MAP_LOCATION)) || "file".equals(mirthConfig.getString(CONFIGURATION_MAP_LOCATION))) {
                PropertiesConfiguration configurationMapProperties = PropertiesConfigurationUtil.create();
                PropertiesConfigurationLayout layout = configurationMapProperties.getLayout();
                TreeMap<String, ConfigurationProperty> sortedMap = new TreeMap<String, ConfigurationProperty>(String.CASE_INSENSITIVE_ORDER);
                sortedMap.putAll(map);
                for (Map.Entry entry : sortedMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = ((ConfigurationProperty)entry.getValue()).getValue();
                    String comment = ((ConfigurationProperty)entry.getValue()).getComment();
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    configurationMapProperties.addProperty(key, (Object)value);
                    layout.setComment(key, StringUtils.isBlank((CharSequence)comment) ? null : comment);
                }
                PropertiesConfigurationUtil.saveTo((PropertiesConfiguration)configurationMapProperties, (File)new File(this.configurationFile));
            } else {
                this.saveProperty(PROPERTIES_CORE, "configuration.properties", ObjectXMLSerializer.getInstance().serialize(map));
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public ConnectionTestResponse sendTestEmail(Properties properties) throws Exception {
        String portString = properties.getProperty("port");
        String encryption = properties.getProperty(SECRET_KEY_ALIAS);
        String host = properties.getProperty("host");
        String timeoutString = properties.getProperty("timeout");
        Boolean authentication = Boolean.parseBoolean(properties.getProperty("authentication"));
        String username = properties.getProperty("username");
        String password = properties.getProperty("password");
        String to = properties.getProperty("toAddress");
        String from = properties.getProperty("fromAddress");
        int port = -1;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            return new ConnectionTestResponse(ConnectionTestResponse.Type.FAILURE, "Invalid port: \"" + portString + "\"");
        }
        SimpleEmail email = new SimpleEmail();
        email.setHostName(host);
        email.setSmtpPort(port);
        try {
            int timeout = Integer.parseInt(timeoutString);
            email.setSocketTimeout(timeout);
            email.setSocketConnectionTimeout(timeout);
        }
        catch (NumberFormatException timeout) {
            // empty catch block
        }
        if ("SSL".equalsIgnoreCase(encryption)) {
            email.setSSLOnConnect(true);
            email.setSslSmtpPort(portString);
        } else if ("TLS".equalsIgnoreCase(encryption)) {
            email.setStartTLSEnabled(true);
        }
        if (authentication.booleanValue()) {
            email.setAuthentication(username, password);
        }
        ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
        String protocols = properties.getProperty("protocols", StringUtils.join((Object[])MirthSSLUtil.getEnabledHttpsProtocols(configurationController.getHttpsClientProtocols()), (char)' '));
        String cipherSuites = properties.getProperty("cipherSuites", StringUtils.join((Object[])MirthSSLUtil.getEnabledHttpsCipherSuites(configurationController.getHttpsCipherSuites()), (char)' '));
        email.getMailSession().getProperties().setProperty("mail.smtp.ssl.protocols", protocols);
        email.getMailSession().getProperties().setProperty("mail.smtp.ssl.ciphersuites", cipherSuites);
        SSLSocketFactory socketFactory = (SSLSocketFactory)properties.get("socketFactory");
        if (socketFactory != null) {
            email.getMailSession().getProperties().put("mail.smtp.ssl.socketFactory", socketFactory);
            if ("SSL".equalsIgnoreCase(encryption)) {
                email.getMailSession().getProperties().put("mail.smtp.socketFactory", socketFactory);
            }
        }
        email.setSubject("BridgeLink Test Email");
        try {
            for (String toAddress : StringUtils.split((String)to, (String)",")) {
                email.addTo(toAddress);
            }
            email.setFrom(from);
            email.setMsg("Receipt of this email confirms that mail originating from this BridgeLink Server is capable of reaching its intended destination.\n\nSMTP Configuration:\n- Host: " + host + "\n- Port: " + port);
            email.send();
            return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Sucessfully sent test email to: " + to);
        }
        catch (EmailException e) {
            return new ConnectionTestResponse(ConnectionTestResponse.Type.FAILURE, e.getMessage());
        }
    }

    static {
        encryptor = null;
        digester = null;
        instance = null;
    }
}

