/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.DebugUsage;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.DebugUsageController;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.log4j.Logger;

public class DefaultDebugUsageController
extends DebugUsageController {
    private static final String VACUUM_LOCK_ID = "DebugUsage.vacuumDebuggerUsageTable";
    private Logger logger = Logger.getLogger(this.getClass());
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private static DebugUsageController instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugUsageController create() {
        Class<DefaultDebugUsageController> clazz = DefaultDebugUsageController.class;
        synchronized (DefaultDebugUsageController.class) {
            if (instance == null) {
                instance = ExtensionLoader.getInstance().getControllerInstance(DebugUsageController.class);
                if (instance == null) {
                    instance = new DefaultDebugUsageController();
                    ((DefaultDebugUsageController)instance).initialize();
                } else {
                    try {
                        instance.getClass().getMethod("initialize", new Class[0]).invoke((Object)instance, new Object[0]);
                    }
                    catch (Exception e) {
                        Logger.getLogger(DefaultDebugUsageController.class).error((Object)"Error calling initialize method in DefaultConfigurationController", (Throwable)e);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
    }

    @Override
    public Map<String, Object> getDebugUsageMap(DebugUsage debugUsage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (debugUsage != null) {
            map.put("serverId", debugUsage.getServerId());
            map.put("duppCount", debugUsage.getDuppCount());
            map.put("attachBatchCount", debugUsage.getAttachBatchCount());
            map.put("sourceConnectorCount", debugUsage.getSourceConnectorCount());
            map.put("sourceFilterTransCount", debugUsage.getSourceFilterTransCount());
            map.put("destinationFilterTransCount", debugUsage.getDestinationFilterTransCount());
            map.put("destinationConnectorCount", debugUsage.getDestinationConnectorCount());
            map.put("responseCount", debugUsage.getResponseCount());
            map.put("invocationCount", debugUsage.getInvocationCount());
        }
        return map;
    }

    @Override
    public synchronized boolean upsertDebugUsage(DebugUsage debugUsage) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_ID).readLock();
        try {
            DebugUsage persistedDebugUsage = this.getDebugUsage(this.configurationController.getServerId());
            if (persistedDebugUsage != null) {
                this.logger.debug((Object)("updating debug usage statistics for serverId" + debugUsage.getServerId()));
                SqlConfig.getInstance().getSqlSessionManager().update("DebugUsage.updateDebugUsageStatistics", this.getDebugUsageMap(debugUsage));
                boolean bl = true;
                return bl;
            }
            this.logger.debug((Object)("inserting debug usage statistics for serverId" + debugUsage.getServerId()));
            SqlConfig.getInstance().getSqlSessionManager().insert("DebugUsage.insertDebugUsageStatistics", this.getDebugUsageMap(debugUsage));
            boolean bl = true;
            return bl;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ID).readUnlock();
        }
    }

    @Override
    public DebugUsage getDebugUsage(String serverId) throws ControllerException {
        this.logger.debug((Object)("getting debug usage for serverId: " + serverId));
        if (serverId == null) {
            throw new ControllerException("Error getting usage for serverId: serverId cannot be null.");
        }
        StatementLock.getInstance(VACUUM_LOCK_ID).readLock();
        try {
            DebugUsage debugUsage = new DebugUsage();
            debugUsage.setServerId(serverId);
            DebugUsage debugUsage2 = (DebugUsage)this.getReadOnlySqlSessionManager().selectOne("DebugUsage.getDebugUsageStatistics", (Object)debugUsage);
            return debugUsage2;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ID).readUnlock();
        }
    }

    @Override
    public List<DebugUsage> getDebugUsages() throws ControllerException {
        this.logger.debug((Object)"getting debug usage for all serverIds");
        StatementLock.getInstance(VACUUM_LOCK_ID).readLock();
        try {
            List list = SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("DebugUsage.getDebugUsageStatistics", null);
            return list;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ID).readUnlock();
        }
    }

    @Override
    public int deleteDebugUsage(String serverId) throws ControllerException {
        this.logger.debug((Object)("deleting debug usage for serverId: " + serverId));
        if (serverId == null) {
            throw new ControllerException("Error getting usage for serverId: serverId cannot be null.");
        }
        StatementLock.getInstance(VACUUM_LOCK_ID).readLock();
        try {
            DebugUsage debugUsage = new DebugUsage();
            debugUsage.setServerId(serverId);
            int n = SqlConfig.getInstance().getSqlSessionManager().delete("DebugUsage.deleteDebugUsageStatistics", (Object)debugUsage);
            return n;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ID).readUnlock();
        }
    }

    protected SqlSessionManager getReadOnlySqlSessionManager() {
        return SqlConfig.getInstance().getReadOnlySqlSessionManager();
    }
}

