/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.VersionMismatchException;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.ExtensionPermission;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginClass;
import com.mirth.connect.model.PluginClassCondition;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.AuthorizationPlugin;
import com.mirth.connect.plugins.ChannelPlugin;
import com.mirth.connect.plugins.CodeTemplateServerPlugin;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.plugins.MultiFactorAuthenticationPlugin;
import com.mirth.connect.plugins.ResourcePlugin;
import com.mirth.connect.plugins.ServerPlugin;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.TransmissionModeProvider;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.AuthorizationController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.extprops.ExtensionStatuses;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.server.util.ServerUUIDGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefaultExtensionController
extends ExtensionController {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private List<ServerPlugin> serverPlugins = new ArrayList<ServerPlugin>();
    private Map<String, ServicePlugin> servicePlugins = new LinkedHashMap<String, ServicePlugin>();
    private Map<String, ChannelPlugin> channelPlugins = new LinkedHashMap<String, ChannelPlugin>();
    private Map<String, CodeTemplateServerPlugin> codeTemplateServerPlugins = new LinkedHashMap<String, CodeTemplateServerPlugin>();
    private Map<String, DataTypeServerPlugin> dataTypePlugins = new LinkedHashMap<String, DataTypeServerPlugin>();
    private Map<String, ResourcePlugin> resourcePlugins = new LinkedHashMap<String, ResourcePlugin>();
    private Map<String, TransmissionModeProvider> transmissionModeProviders = new LinkedHashMap<String, TransmissionModeProvider>();
    private MultiFactorAuthenticationPlugin multiFactorAuthenticationPlugin = null;
    private AuthorizationPlugin authorizationPlugin = null;
    private ExtensionLoader extensionLoader = ExtensionLoader.getInstance();
    private ExtensionStatuses extensionStatuses = ExtensionStatuses.getInstance();
    private static ExtensionController instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionController create() {
        Class<DefaultExtensionController> clazz = DefaultExtensionController.class;
        synchronized (DefaultExtensionController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(ExtensionController.class)) == null) {
                instance = new DefaultExtensionController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    DefaultExtensionController() {
    }

    @Override
    public void removePropertiesForUninstalledExtensions() {
        try {
            File uninstallFile = new File(DefaultExtensionController.getExtensionsPath(), "uninstallProperties");
            if (uninstallFile.exists()) {
                List extensionPaths = FileUtils.readLines((File)uninstallFile);
                for (String extensionPath : extensionPaths) {
                    this.configurationController.removePropertiesForGroup(extensionPath);
                }
                FileUtils.deleteQuietly((File)uninstallFile);
            }
        }
        catch (Exception e) {
            this.logger.error("Error removing properties for uninstalled extensions.", (Throwable)e);
        }
    }

    @Override
    public void setDefaultExtensionStatus() {
        for (MetaData metaData : this.getPluginMetaData().values()) {
            if (this.extensionStatuses.containsKey(metaData.getName())) continue;
            this.extensionStatuses.setEnabled(metaData.getName(), true);
        }
        for (MetaData metaData : this.getConnectorMetaData().values()) {
            if (this.extensionStatuses.containsKey(metaData.getName())) continue;
            this.extensionStatuses.setEnabled(metaData.getName(), true);
        }
        for (String string : this.extensionStatuses.keySet()) {
            if (this.getPluginMetaData().containsKey(string) || this.getConnectorMetaData().containsKey(string)) continue;
            this.extensionStatuses.remove(string);
        }
        this.extensionStatuses.save();
    }

    @Override
    public void initPlugins() {
        HashMap<String, String> pluginNameMap = new HashMap<String, String>();
        TreeMap<Integer, ArrayList<String>> weightedPlugins = new TreeMap<Integer, ArrayList<String>>();
        for (PluginMetaData pmd : this.getPluginMetaData().values()) {
            if (this.isExtensionEnabled(pmd.getName())) {
                if (pmd.getServerClasses() == null) continue;
                for (PluginClass pluginClass : pmd.getServerClasses()) {
                    String clazzName = pluginClass.getName();
                    int weight = pluginClass.getWeight();
                    String conditionClass = pluginClass.getConditionClass();
                    boolean accept = true;
                    if (StringUtils.isNotBlank((CharSequence)conditionClass)) {
                        try {
                            accept = ((PluginClassCondition)Class.forName(conditionClass).newInstance()).accept(pluginClass);
                        }
                        catch (Exception e) {
                            this.logger.warn("Error instantiating plugin condition class \"" + conditionClass + "\".");
                        }
                    }
                    if (!accept) continue;
                    pluginNameMap.put(clazzName, pmd.getName());
                    ArrayList<String> classList = (ArrayList<String>)weightedPlugins.get(weight);
                    if (classList == null) {
                        classList = new ArrayList<String>();
                        weightedPlugins.put(weight, classList);
                    }
                    classList.add(clazzName);
                }
                continue;
            }
            this.logger.warn("Plugin \"" + pmd.getName() + "\" is not enabled.");
        }
        for (List classList : weightedPlugins.descendingMap().values()) {
            for (String clazzName : classList) {
                String pluginName = (String)pluginNameMap.get(clazzName);
                try {
                    ServerPlugin serverPlugin = (ServerPlugin)Class.forName(clazzName).newInstance();
                    if (serverPlugin instanceof ServicePlugin) {
                        ServicePlugin servicePlugin = (ServicePlugin)serverPlugin;
                        Properties currentProperties = this.getPluginProperties(pluginName);
                        Properties defaultProperties = servicePlugin.getDefaultProperties();
                        for (Object key : defaultProperties.keySet()) {
                            if (currentProperties.containsKey(key)) continue;
                            currentProperties.put(key, defaultProperties.get(key));
                        }
                        this.setPluginProperties(pluginName, currentProperties);
                        servicePlugin.init(currentProperties);
                        this.servicePlugins.put(servicePlugin.getPluginPointName(), servicePlugin);
                        this.serverPlugins.add(servicePlugin);
                        this.logger.debug("sucessfully loaded server plugin: " + serverPlugin.getPluginPointName());
                    }
                    if (serverPlugin instanceof ChannelPlugin) {
                        ChannelPlugin channelPlugin = (ChannelPlugin)serverPlugin;
                        this.channelPlugins.put(channelPlugin.getPluginPointName(), channelPlugin);
                        this.serverPlugins.add(channelPlugin);
                        this.logger.debug("sucessfully loaded server channel plugin: " + serverPlugin.getPluginPointName());
                    }
                    if (serverPlugin instanceof CodeTemplateServerPlugin) {
                        CodeTemplateServerPlugin codeTemplateServerPlugin = (CodeTemplateServerPlugin)serverPlugin;
                        this.codeTemplateServerPlugins.put(codeTemplateServerPlugin.getPluginPointName(), codeTemplateServerPlugin);
                        this.serverPlugins.add(codeTemplateServerPlugin);
                        this.logger.debug("sucessfully loaded server code template plugin: " + serverPlugin.getPluginPointName());
                    }
                    if (serverPlugin instanceof DataTypeServerPlugin) {
                        DataTypeServerPlugin dataTypePlugin = (DataTypeServerPlugin)serverPlugin;
                        this.dataTypePlugins.put(dataTypePlugin.getPluginPointName(), dataTypePlugin);
                        this.serverPlugins.add(dataTypePlugin);
                        this.logger.debug("sucessfully loaded server data type plugin: " + serverPlugin.getPluginPointName());
                    }
                    if (serverPlugin instanceof ResourcePlugin) {
                        ResourcePlugin resourcePlugin = (ResourcePlugin)serverPlugin;
                        this.resourcePlugins.put(resourcePlugin.getPluginPointName(), resourcePlugin);
                        this.serverPlugins.add(resourcePlugin);
                        this.logger.debug("Successfully loaded resource plugin: " + resourcePlugin.getPluginPointName());
                    }
                    if (serverPlugin instanceof TransmissionModeProvider) {
                        TransmissionModeProvider transmissionModeProvider = (TransmissionModeProvider)serverPlugin;
                        this.transmissionModeProviders.put(transmissionModeProvider.getPluginPointName(), transmissionModeProvider);
                        this.serverPlugins.add(transmissionModeProvider);
                        this.logger.debug("Successfully loaded transmission mode provider plugin: " + transmissionModeProvider.getPluginPointName());
                    }
                    if (serverPlugin instanceof AuthorizationPlugin) {
                        AuthorizationPlugin authorizationPlugin = (AuthorizationPlugin)serverPlugin;
                        if (this.authorizationPlugin != null) {
                            throw new Exception("Multiple Authorization Plugins are not permitted.");
                        }
                        this.authorizationPlugin = authorizationPlugin;
                        this.serverPlugins.add(authorizationPlugin);
                        this.logger.debug("sucessfully loaded server authorization plugin: " + serverPlugin.getPluginPointName());
                    }
                    if (!(serverPlugin instanceof MultiFactorAuthenticationPlugin)) continue;
                    MultiFactorAuthenticationPlugin multiFactorAuthenticationPlugin = (MultiFactorAuthenticationPlugin)serverPlugin;
                    if (this.multiFactorAuthenticationPlugin != null) {
                        throw new Exception("Multiple Multi-Factor Authentication Plugins are not permitted.");
                    }
                    this.multiFactorAuthenticationPlugin = multiFactorAuthenticationPlugin;
                    this.serverPlugins.add(multiFactorAuthenticationPlugin);
                    this.logger.debug("sucessfully loaded server multi-factor authentication plugin: " + serverPlugin.getPluginPointName());
                }
                catch (Exception e) {
                    this.logger.error("Error instantiating plugin: " + pluginName, (Throwable)e);
                }
            }
        }
    }

    @Override
    public Map<String, ServicePlugin> getServicePlugins() {
        return this.servicePlugins;
    }

    @Override
    public Map<String, ChannelPlugin> getChannelPlugins() {
        return this.channelPlugins;
    }

    @Override
    public Map<String, CodeTemplateServerPlugin> getCodeTemplateServerPlugins() {
        return this.codeTemplateServerPlugins;
    }

    @Override
    public Map<String, DataTypeServerPlugin> getDataTypePlugins() {
        return this.dataTypePlugins;
    }

    @Override
    public Map<String, ResourcePlugin> getResourcePlugins() {
        return this.resourcePlugins;
    }

    @Override
    public Map<String, TransmissionModeProvider> getTransmissionModeProviders() {
        return this.transmissionModeProviders;
    }

    @Override
    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin;
    }

    @Override
    public MultiFactorAuthenticationPlugin getMultiFactorAuthenticationPlugin() {
        return this.multiFactorAuthenticationPlugin;
    }

    @Override
    public void setExtensionEnabled(String extensionName, boolean enabled) throws ControllerException {
        this.extensionStatuses.setEnabled(extensionName, enabled);
        this.extensionStatuses.save();
    }

    @Override
    public boolean isExtensionEnabled(String extensionName) {
        return this.extensionStatuses.isEnabled(extensionName);
    }

    @Override
    public void startPlugins() {
        for (ServerPlugin serverPlugin : this.serverPlugins) {
            serverPlugin.start();
        }
        AuthorizationController authorizationController = ControllerFactory.getFactory().createAuthorizationController();
        for (ServicePlugin plugin : this.servicePlugins.values()) {
            if (plugin.getExtensionPermissions() == null) continue;
            for (ExtensionPermission extensionPermission : plugin.getExtensionPermissions()) {
                authorizationController.addExtensionPermission(extensionPermission);
            }
        }
    }

    @Override
    public void stopPlugins() {
        for (ServerPlugin serverPlugin : this.serverPlugins) {
            serverPlugin.stop();
        }
    }

    @Override
    public void updatePluginProperties(String name, Properties properties) {
        ServicePlugin servicePlugin = this.servicePlugins.get(name);
        if (servicePlugin != null) {
            servicePlugin.update(properties);
        } else {
            this.logger.error("Error setting properties for service plugin that has not been loaded: name=" + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtensionController.InstallationResult extractExtension(InputStream inputStream) {
        ControllerException cause = null;
        HashSet<MetaData> metaDataSet = new HashSet<MetaData>();
        File installTempDir = new File(ExtensionController.getExtensionsPath(), "install_temp");
        if (!installTempDir.exists()) {
            installTempDir.mkdir();
        }
        File tempFile = null;
        FileOutputStream tempFileOutputStream = null;
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            tempFile = File.createTempFile(ServerUUIDGenerator.getUUID(), ".zip", installTempDir);
            try {
                tempFileOutputStream = new FileOutputStream(tempFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)tempFileOutputStream);
            }
            catch (Throwable throwable) {
                ResourceUtil.closeResourceQuietly(tempFileOutputStream);
                throw throwable;
            }
            ResourceUtil.closeResourceQuietly(tempFileOutputStream);
            zipFile = new ZipFile(tempFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith("plugin.xml") && !entryName.endsWith("destination.xml") && !entryName.endsWith("source.xml")) continue;
                MetaData extensionMetaData = this.serializer.deserialize(IOUtils.toString((InputStream)zipFile.getInputStream(entry)), MetaData.class);
                metaDataSet.add(extensionMetaData);
                if (this.extensionLoader.isExtensionCompatible(extensionMetaData) || cause != null) continue;
                cause = new VersionMismatchException("Extension \"" + entry.getName() + "\" is not compatible with this version of BridgeLink.");
            }
            if (cause == null) {
                entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    this.extractZipEntry(entry, installTempDir, zipFile);
                }
            }
        }
        catch (Throwable t) {
            cause = new ControllerException("Error extracting extension. " + t.toString(), t);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception e) {
                    cause = new ControllerException((Throwable)e);
                }
            }
            FileUtils.deleteQuietly((File)tempFile);
        }
        return new ExtensionController.InstallationResult(this, cause, metaDataSet);
    }

    @Override
    public void prepareExtensionForUninstallation(String pluginPath) throws ControllerException {
        this.addExtensionToUninstallFile(pluginPath);
        for (PluginMetaData plugin : this.getPluginMetaData().values()) {
            if (!plugin.getPath().equals(pluginPath)) continue;
            this.addExtensionToUninstallPropertiesFile(plugin.getName());
            if (plugin.getMigratorClass() == null) continue;
            try {
                Migrator migrator = (Migrator)Class.forName(plugin.getMigratorClass()).newInstance();
                migrator.setDatabaseType(ConfigurationController.getInstance().getDatabaseType());
                migrator.setDefaultScriptPath("extensions/" + plugin.getPath());
                this.appendToUninstallScript(migrator.getUninstallStatements());
            }
            catch (Exception e) {
                this.logger.error("Failed to retrieve uninstall database statements for plugin: " + pluginPath, (Throwable)e);
            }
        }
    }

    private List<String> parseUninstallScript(String script) {
        ArrayList<String> scriptList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean blankLine = false;
        Scanner scanner = new Scanner(script);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (StringUtils.isNotBlank((CharSequence)line)) {
                sb.append(line + " ");
            } else {
                blankLine = true;
            }
            if (!blankLine && scanner.hasNextLine()) continue;
            scriptList.add(sb.toString().trim());
            blankLine = false;
            sb.delete(0, sb.length());
        }
        return scriptList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionToUninstallFile(String pluginPath) {
        File uninstallFile = new File(DefaultExtensionController.getExtensionsPath(), "uninstall");
        FileWriter writer = null;
        try {
            writer = new FileWriter(uninstallFile, true);
            writer.write(pluginPath + System.getProperty("line.separator"));
        }
        catch (IOException e) {
            try {
                this.logger.error("Error adding extension to uninstall file: " + pluginPath, (Throwable)e);
            }
            catch (Throwable throwable) {
                ResourceUtil.closeResourceQuietly(writer);
                throw throwable;
            }
            ResourceUtil.closeResourceQuietly(writer);
        }
        ResourceUtil.closeResourceQuietly(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionToUninstallPropertiesFile(String pluginName) {
        File uninstallFile = new File(DefaultExtensionController.getExtensionsPath(), "uninstallProperties");
        FileWriter writer = null;
        try {
            writer = new FileWriter(uninstallFile, true);
            writer.write(pluginName + System.getProperty("line.separator"));
        }
        catch (IOException e) {
            try {
                this.logger.error("Error adding extension to uninstall properties file: " + pluginName, (Throwable)e);
            }
            catch (Throwable throwable) {
                ResourceUtil.closeResourceQuietly(writer);
                throw throwable;
            }
            ResourceUtil.closeResourceQuietly(writer);
        }
        ResourceUtil.closeResourceQuietly(writer);
    }

    private String getUninstallScriptForCurrentDatabase(String pluginSqlScripts) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document document = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(pluginSqlScripts)));
        Element uninstallElement = (Element)document.getElementsByTagName("uninstall").item(0);
        String databaseType = ControllerFactory.getFactory().createConfigurationController().getDatabaseType();
        NodeList scriptNodes = uninstallElement.getElementsByTagName("script");
        String script = null;
        for (int i = 0; i < scriptNodes.getLength(); ++i) {
            Node scriptNode = scriptNodes.item(i);
            Node scriptType = scriptNode.getAttributes().getNamedItem("type");
            String[] databaseTypes = scriptType.getTextContent().split(",");
            for (int j = 0; j < databaseTypes.length; ++j) {
                if (!databaseTypes[j].equals("all") && !databaseTypes[j].equals(databaseType)) continue;
                script = scriptNode.getTextContent().trim();
            }
        }
        return script;
    }

    @Override
    public void setPluginProperties(String pluginName, Properties properties, boolean mergeProperties) throws ControllerException {
        if (!mergeProperties) {
            this.configurationController.removePropertiesForGroup(pluginName);
        }
        for (Object name : properties.keySet()) {
            this.configurationController.saveProperty(pluginName, (String)name, (String)properties.get(name));
        }
    }

    @Override
    public Properties getPluginProperties(String pluginName, Set<String> propertyKeys) throws ControllerException {
        return ControllerFactory.getFactory().createConfigurationController().getPropertiesForGroup(pluginName, propertyKeys);
    }

    @Override
    public Map<String, ConnectorMetaData> getConnectorMetaData() {
        return this.extensionLoader.getConnectorMetaData();
    }

    @Override
    public Map<String, PluginMetaData> getPluginMetaData() {
        return this.extensionLoader.getPluginMetaData();
    }

    @Override
    public ConnectorMetaData getConnectorMetaDataByProtocol(String protocol) {
        return this.extensionLoader.getConnectorProtocols().get(protocol);
    }

    @Override
    public ConnectorMetaData getConnectorMetaDataByTransportName(String transportName) {
        return this.extensionLoader.getConnectorMetaData().get(transportName);
    }

    @Override
    public Map<String, MetaData> getInvalidMetaData() {
        return this.extensionLoader.getInvalidMetaData();
    }

    @Override
    public void uninstallExtensions() {
        try {
            DatabaseUtil.executeScript(this.readUninstallScript(), true);
        }
        catch (Exception e) {
            this.logger.error("Error uninstalling extensions.", (Throwable)e);
        }
        FileUtils.deleteQuietly((File)new File(DefaultExtensionController.getExtensionsPath(), "uninstallScripts"));
    }

    private void appendToUninstallScript(List<String> uninstallStatements) throws IOException {
        if (uninstallStatements != null) {
            List<String> uninstallScripts = this.readUninstallScript();
            uninstallScripts.addAll(uninstallStatements);
            File uninstallScriptsFile = new File(DefaultExtensionController.getExtensionsPath(), "uninstallScripts");
            FileUtils.writeStringToFile((File)uninstallScriptsFile, (String)this.serializer.serialize(uninstallScripts));
        }
    }

    private List<String> readUninstallScript() throws IOException {
        File uninstallScriptsFile = new File(DefaultExtensionController.getExtensionsPath(), "uninstallScripts");
        List<String> scripts = new ArrayList<String>();
        if (uninstallScriptsFile.exists()) {
            scripts = this.serializer.deserializeList(FileUtils.readFileToString((File)uninstallScriptsFile), String.class);
        }
        return scripts;
    }

    @Override
    public List<String> getClientLibraries() {
        ArrayList<String> clientLibFilenames = new ArrayList<String>();
        File clientLibDir = new File("client-lib");
        if (!clientLibDir.exists() || !clientLibDir.isDirectory()) {
            clientLibDir = new File("build/client-lib");
        }
        if (clientLibDir.exists() && clientLibDir.isDirectory()) {
            Collection clientLibs = FileUtils.listFiles((File)clientLibDir, (IOFileFilter)new SuffixFileFilter(".jar"), (IOFileFilter)FileFilterUtils.falseFileFilter());
            for (File clientLib : clientLibs) {
                clientLibFilenames.add(FilenameUtils.getName((String)clientLib.getName()));
            }
        } else {
            this.logger.error("Could not find client-lib directory: " + clientLibDir.getAbsolutePath());
        }
        return clientLibFilenames;
    }

    @Override
    public List<ServerPlugin> getServerPlugins() {
        return this.serverPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void extractZipEntry(ZipEntry entry, File installTempDir, ZipFile zipFile) throws IOException {
        String canonicalDestinationDirPath = installTempDir.getCanonicalPath();
        File destinationfile = new File(installTempDir, entry.getName());
        String canonicalDestinationFile = destinationfile.getCanonicalPath();
        if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator)) {
            throw new ZipException("Zip file is attempting to traverse out of base directory");
        }
        if (entry.isDirectory()) {
            File directory = new File(installTempDir, entry.getName());
            directory.mkdir();
            return;
        }
        InputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream outputStream = null;
        try {
            zipInputStream = zipFile.getInputStream(entry);
            fileOutputStream = new FileOutputStream(new File(installTempDir, entry.getName()));
            outputStream = new BufferedOutputStream(fileOutputStream);
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            ResourceUtil.closeResourceQuietly(outputStream);
            ResourceUtil.closeResourceQuietly(fileOutputStream);
            ResourceUtil.closeResourceQuietly(zipInputStream);
            throw throwable;
        }
        ResourceUtil.closeResourceQuietly(outputStream);
        ResourceUtil.closeResourceQuietly(fileOutputStream);
        ResourceUtil.closeResourceQuietly(zipInputStream);
    }
}

