/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.MigrationController;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.server.migration.ServerMigrator;
import com.mirth.connect.server.util.SqlConfig;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMigrationController
extends MigrationController {
    private static MigrationController instance = null;
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private ServerMigrator serverMigrator;
    private Collection<Migrator> pluginMigrators;
    private Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MigrationController create() {
        Class<DefaultMigrationController> clazz = DefaultMigrationController.class;
        synchronized (DefaultMigrationController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(MigrationController.class)) == null) {
                instance = new DefaultMigrationController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DefaultMigrationController() {
        this.serverMigrator = new ServerMigrator();
    }

    @Override
    public void migrateConfiguration(PropertiesConfiguration configuration) throws MigrationException {
        this.serverMigrator.migrateConfiguration(configuration);
    }

    private void initPluginMigrators() {
        if (this.pluginMigrators == null) {
            this.pluginMigrators = new ArrayList<Migrator>();
            ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
            for (PluginMetaData pluginMetaData : ControllerFactory.getFactory().createExtensionController().getPluginMetaData().values()) {
                String migratorClassName;
                if (!extensionController.isExtensionEnabled(pluginMetaData.getName()) || (migratorClassName = pluginMetaData.getMigratorClass()) == null) continue;
                try {
                    Migrator migrator = (Migrator)Class.forName(migratorClassName).newInstance();
                    migrator.setDefaultScriptPath("extensions/" + pluginMetaData.getPath());
                    this.pluginMigrators.add(migrator);
                }
                catch (Exception e) {
                    this.logger.error("Failed to run migration for plugin: " + pluginMetaData.getName());
                }
            }
        }
    }

    @Override
    public void migrate() throws MigrationException {
        SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
        Connection connection = SqlConfig.getInstance().getSqlSessionManager().getConnection();
        try {
            this.serverMigrator.setConnection(connection);
            this.serverMigrator.setDatabaseType(this.configurationController.getDatabaseType());
            this.serverMigrator.migrate();
        }
        finally {
            if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                SqlConfig.getInstance().getSqlSessionManager().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrateExtensions() {
        this.initPluginMigrators();
        SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
        Connection connection = SqlConfig.getInstance().getSqlSessionManager().getConnection();
        try {
            for (Migrator migrator : this.pluginMigrators) {
                try {
                    migrator.setStartingVersion(this.serverMigrator.getStartingVersion());
                    migrator.setConnection(connection);
                    migrator.setDatabaseType(this.configurationController.getDatabaseType());
                    migrator.migrate();
                }
                catch (MigrationException e) {
                    this.logger.error("Failed to migrate extension", (Throwable)e);
                }
            }
        }
        finally {
            if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                SqlConfig.getInstance().getSqlSessionManager().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrateSerializedData() {
        SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
        Connection connection = SqlConfig.getInstance().getSqlSessionManager().getConnection();
        try {
            this.serverMigrator.setConnection(connection);
            this.serverMigrator.setDatabaseType(this.configurationController.getDatabaseType());
            this.serverMigrator.migrateSerializedData();
            this.initPluginMigrators();
            for (Migrator migrator : this.pluginMigrators) {
                try {
                    migrator.setConnection(connection);
                    migrator.setDatabaseType(this.configurationController.getDatabaseType());
                    migrator.migrateSerializedData();
                }
                catch (MigrationException e) {
                    this.logger.error("Failed to migrate serialized data for plugin", (Throwable)e);
                }
            }
        }
        finally {
            if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                SqlConfig.getInstance().getSqlSessionManager().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkStartupLockTable() {
        int startupLockSleep = this.configurationController.getStartupLockSleep();
        if (startupLockSleep > 0) {
            try {
                boolean insertedStartupLock = false;
                SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
                try {
                    Connection connection = SqlConfig.getInstance().getSqlSessionManager().getConnection();
                    this.serverMigrator.setConnection(connection);
                    this.serverMigrator.setDatabaseType(this.configurationController.getDatabaseType());
                    insertedStartupLock = this.serverMigrator.checkStartupLockTable();
                }
                finally {
                    if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                        SqlConfig.getInstance().getSqlSessionManager().close();
                    }
                }
                if (!insertedStartupLock) {
                    this.logger.warn("Detected startup lock, sleeping " + startupLockSleep + "ms...");
                    Thread.sleep(startupLockSleep);
                }
            }
            catch (Throwable t) {
                this.logger.error("Error checking startup lock table.", t);
            }
        }
    }

    @Override
    public void clearStartupLockTable() {
        int startupLockSleep = this.configurationController.getStartupLockSleep();
        if (startupLockSleep > 0) {
            SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
            try {
                Connection connection = SqlConfig.getInstance().getSqlSessionManager().getConnection();
                this.serverMigrator.setConnection(connection);
                this.serverMigrator.setDatabaseType(this.configurationController.getDatabaseType());
                this.serverMigrator.clearStartupLockTable();
            }
            finally {
                if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                    SqlConfig.getInstance().getSqlSessionManager().close();
                }
            }
        }
    }
}

