/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.Channel;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.builders.JavaScriptBuilder;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptCompileException;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultScriptController
extends ScriptController {
    public static final String VACUUM_LOCK_SCRIPT_STATEMENT_ID = "Script.vacuumScriptTable";
    private Logger logger = LogManager.getLogger(this.getClass());
    private static ScriptController instance = null;

    protected DefaultScriptController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptController create() {
        Class<DefaultScriptController> clazz = DefaultScriptController.class;
        synchronized (DefaultScriptController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(ScriptController.class)) == null) {
                instance = new DefaultScriptController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void putScript(String groupId, String id, String script) throws ControllerException {
        this.logger.debug("adding script: groupId=" + groupId + ", id=" + id);
        StatementLock.getInstance(VACUUM_LOCK_SCRIPT_STATEMENT_ID).readLock();
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("groupId", groupId);
            parameterMap.put("id", id);
            parameterMap.put("script", script);
            if (this.getScript(groupId, id) == null) {
                SqlConfig.getInstance().getSqlSessionManager().insert("Script.insertScript", parameterMap);
            } else {
                SqlConfig.getInstance().getSqlSessionManager().update("Script.updateScript", parameterMap);
            }
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_SCRIPT_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public String getScript(String groupId, String id) throws ControllerException {
        this.logger.debug("retrieving script: groupId=" + groupId + ", id=" + id);
        StatementLock.getInstance(VACUUM_LOCK_SCRIPT_STATEMENT_ID).readLock();
        try {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("groupId", groupId);
            parameterMap.put("id", id);
            String string = (String)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("Script.getScript", parameterMap);
            return string;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_SCRIPT_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public void removeScripts(String groupId) throws ControllerException {
        this.logger.debug("deleting scripts: groupId=" + groupId);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("groupId", groupId);
        StatementLock.getInstance(VACUUM_LOCK_SCRIPT_STATEMENT_ID).writeLock();
        try {
            SqlConfig.getInstance().getSqlSessionManager().delete("Script.deleteScript", parameterMap);
            if (DatabaseUtil.statementExists(VACUUM_LOCK_SCRIPT_STATEMENT_ID)) {
                this.vacuumScriptTable();
            }
        }
        catch (PersistenceException e) {
            throw new ControllerException("Error deleting scripts", (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_SCRIPT_STATEMENT_ID).writeUnlock();
        }
    }

    public void vacuumScriptTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("Script.lockScriptTable")) {
                session.update("Script.lockScriptTable");
            }
            session.update(VACUUM_LOCK_SCRIPT_STATEMENT_ID);
            session.commit();
        }
    }

    @Override
    public void compileGlobalScripts(MirthContextFactory contextFactory, boolean multiServer) {
        Map<String, String> globalScripts = null;
        try {
            globalScripts = this.getGlobalScripts();
        }
        catch (ControllerException e) {
            this.logger.error("Error getting global scripts.", (Throwable)e);
            return;
        }
        try {
            JavaScriptUtil.compileGlobalScripts(contextFactory, globalScripts);
        }
        catch (Exception e) {
            this.logger.error("Error compiling global scripts.", (Throwable)e);
        }
    }

    @Override
    public void compileChannelScripts(MirthContextFactory contextFactory, Channel channel) throws ScriptCompileException {
        JavaScriptUtil.compileChannelScripts(contextFactory, channel);
    }

    @Override
    public void compileChannelScripts(Map<String, MirthContextFactory> contextFactories, Channel channel) throws ScriptCompileException {
        JavaScriptUtil.compileChannelScripts(contextFactories, channel);
    }

    @Override
    public void removeChannelScriptsFromCache(String channelId) {
        JavaScriptUtil.removeChannelScriptsFromCache(channelId);
    }

    @Override
    public void executeGlobalDeployScript() throws Exception {
        JavaScriptUtil.executeGlobalDeployScript("Deploy");
    }

    @Override
    public void executeChannelDebugDeployScript(MirthContextFactory contextFactory, String channelId, String channelName, MirthScopeProvider scopeProvider) throws Exception {
        JavaScriptUtil.executeChannelDebugDeployScript(contextFactory, DefaultScriptController.getScriptId("Deploy", channelId), "Deploy", channelId, channelName, scopeProvider);
    }

    @Override
    public void executeChannelDeployScript(MirthContextFactory contextFactory, String channelId, String channelName) throws Exception {
        JavaScriptUtil.executeChannelDeployScript(contextFactory, DefaultScriptController.getScriptId("Deploy", channelId), "Deploy", channelId, channelName);
    }

    @Override
    public void executeGlobalUndeployScript() throws Exception {
        JavaScriptUtil.executeGlobalUndeployScript("Undeploy");
    }

    @Override
    public void executeChannelUndeployScript(MirthContextFactory contextFactory, String channelId, String channelName) throws Exception {
        JavaScriptUtil.executeChannelUndeployScript(contextFactory, DefaultScriptController.getScriptId("Undeploy", channelId), "Undeploy", channelId, channelName);
    }

    @Override
    public Map<String, String> getGlobalScripts() throws ControllerException {
        HashMap<String, String> scripts = new HashMap<String, String>();
        String deployScript = this.getScript("Global", "Deploy");
        String undeployScript = this.getScript("Global", "Undeploy");
        String preprocessorScript = this.getScript("Global", "Preprocessor");
        String postprocessorScript = this.getScript("Global", "Postprocessor");
        if (StringUtils.isBlank((CharSequence)deployScript)) {
            deployScript = JavaScriptBuilder.generateDefaultKeyScript("Deploy");
        }
        if (StringUtils.isBlank((CharSequence)undeployScript)) {
            undeployScript = JavaScriptBuilder.generateDefaultKeyScript("Undeploy");
        }
        if (StringUtils.isBlank((CharSequence)preprocessorScript)) {
            preprocessorScript = JavaScriptBuilder.generateDefaultKeyScript("Preprocessor");
        }
        if (StringUtils.isBlank((CharSequence)postprocessorScript)) {
            postprocessorScript = JavaScriptBuilder.generateDefaultKeyScript("Postprocessor");
        }
        scripts.put("Deploy", deployScript);
        scripts.put("Undeploy", undeployScript);
        scripts.put("Preprocessor", preprocessorScript);
        scripts.put("Postprocessor", postprocessorScript);
        return scripts;
    }

    @Override
    public void setGlobalScripts(Map<String, String> scripts) throws ControllerException {
        this.putGlobalScriptsToDB(scripts);
        try {
            this.compileGlobalScripts(ControllerFactory.getFactory().createContextFactoryController().getGlobalScriptContextFactory(), true);
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    protected void putGlobalScriptsToDB(Map<String, String> scripts) throws ControllerException {
        for (Map.Entry<String, String> entry : scripts.entrySet()) {
            this.putScript("Global", entry.getKey().toString(), scripts.get(entry.getKey()));
        }
    }

    @Override
    public void executeChannelDebugUndeployScript(MirthContextFactory contextFactory, String channelId, String channelName) throws Exception {
        JavaScriptUtil.executeChannelDebugUndeployScript(contextFactory, DefaultScriptController.getScriptId("Undeploy", channelId), "Undeploy", channelId, channelName, new MirthScopeProvider());
    }
}

