/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.SerializationType;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.server.DeployException;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.DonkeyConfiguration;
import com.mirth.connect.donkey.server.Encryptor;
import com.mirth.connect.donkey.server.StartException;
import com.mirth.connect.donkey.server.StopException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.ChannelProcessLock;
import com.mirth.connect.donkey.server.channel.DefaultChannelProcessLock;
import com.mirth.connect.donkey.server.channel.DestinationChainProvider;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.FilterTransformerExecutor;
import com.mirth.connect.donkey.server.channel.MetaDataReplacer;
import com.mirth.connect.donkey.server.channel.ResponseSelector;
import com.mirth.connect.donkey.server.channel.ResponseTransformerExecutor;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.channel.StorageSettings;
import com.mirth.connect.donkey.server.channel.components.FilterTransformer;
import com.mirth.connect.donkey.server.channel.components.PostProcessor;
import com.mirth.connect.donkey.server.channel.components.PreProcessor;
import com.mirth.connect.donkey.server.channel.components.ResponseTransformer;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.server.data.buffered.BufferedDaoFactory;
import com.mirth.connect.donkey.server.data.passthru.PassthruDaoFactory;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.event.EventDispatcher;
import com.mirth.connect.donkey.server.message.DataType;
import com.mirth.connect.donkey.server.message.ResponseValidator;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.donkey.server.message.batch.ResponseHandler;
import com.mirth.connect.donkey.server.message.batch.SimpleResponseHandler;
import com.mirth.connect.donkey.server.queue.DestinationQueue;
import com.mirth.connect.donkey.server.queue.SourceQueue;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.SerializerProvider;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelProperties;
import com.mirth.connect.model.ChannelStatistics;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.DebugUsage;
import com.mirth.connect.model.DeployedChannelInfo;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.MessageStorageMode;
import com.mirth.connect.model.ServerEventContext;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.model.attachments.AttachmentHandlerType;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.datatype.BatchProperties;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.ChannelPlugin;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.attachments.MirthAttachmentHandlerProvider;
import com.mirth.connect.server.attachments.passthru.PassthruAttachmentHandlerProvider;
import com.mirth.connect.server.builders.JavaScriptBuilder;
import com.mirth.connect.server.channel.ChannelFuture;
import com.mirth.connect.server.channel.ChannelTask;
import com.mirth.connect.server.channel.ChannelTaskHandler;
import com.mirth.connect.server.channel.DelegateErrorTaskHandler;
import com.mirth.connect.server.channel.LoggingTaskHandler;
import com.mirth.connect.server.channel.MirthMessageMaps;
import com.mirth.connect.server.channel.MirthMetaDataReplacer;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.DebugUsageController;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.message.DataTypeFactory;
import com.mirth.connect.server.message.DefaultResponseValidator;
import com.mirth.connect.server.mybatis.MessageSearchResult;
import com.mirth.connect.server.transformers.JavaScriptFilterTransformer;
import com.mirth.connect.server.transformers.JavaScriptInitializationException;
import com.mirth.connect.server.transformers.JavaScriptPostprocessor;
import com.mirth.connect.server.transformers.JavaScriptPreprocessor;
import com.mirth.connect.server.transformers.JavaScriptResponseTransformer;
import com.mirth.connect.server.util.ChannelDependencyServerUtil;
import com.mirth.connect.server.util.GlobalChannelVariableStoreFactory;
import com.mirth.connect.server.util.GlobalVariableStore;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.util.ChannelDependencyException;
import com.mirth.connect.util.ChannelDependencyGraph;
import com.mirth.connect.util.ChannelDependencyUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class DonkeyEngineController
implements EngineController {
    private static EngineController instance = null;
    private Donkey donkey = Donkey.getInstance();
    private Logger logger = LogManager.getLogger(DonkeyEngineController.class);
    protected ConfigurationController configurationController = this.getConfigurationController();
    protected ScriptController scriptController = this.getScriptController();
    protected ChannelController channelController = this.getChannelController();
    protected com.mirth.connect.donkey.server.controllers.ChannelController donkeyChannelController = com.mirth.connect.donkey.server.controllers.ChannelController.getInstance();
    protected EventController eventController = this.getEventController();
    protected ExtensionController extensionController = this.getExtensionController();
    protected ContextFactoryController contextFactoryController = this.getContextFactoryController();
    protected CodeTemplateController codeTemplateController = this.getCodeTemplateController();
    private Map<String, ExecutorService> engineExecutors = new ConcurrentHashMap<String, ExecutorService>();
    private Set<com.mirth.connect.donkey.server.channel.Channel> deployingChannels = Collections.synchronizedSet(new HashSet());
    private Set<com.mirth.connect.donkey.server.channel.Channel> undeployingChannels = Collections.synchronizedSet(new HashSet());
    protected AtomicInteger queueBufferSize = new AtomicInteger(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineController getInstance() {
        Class<DonkeyEngineController> clazz = DonkeyEngineController.class;
        synchronized (DonkeyEngineController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(EngineController.class)) == null) {
                instance = new DonkeyEngineController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected DonkeyEngineController() {
    }

    protected ConfigurationController getConfigurationController() {
        return ControllerFactory.getFactory().createConfigurationController();
    }

    protected ScriptController getScriptController() {
        return ControllerFactory.getFactory().createScriptController();
    }

    protected ChannelController getChannelController() {
        return ControllerFactory.getFactory().createChannelController();
    }

    protected EventController getEventController() {
        return ControllerFactory.getFactory().createEventController();
    }

    protected ExtensionController getExtensionController() {
        return ControllerFactory.getFactory().createExtensionController();
    }

    protected ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected CodeTemplateController getCodeTemplateController() {
        return ControllerFactory.getFactory().createCodeTemplateController();
    }

    protected DebugUsageController getDebugUsageController() {
        return ControllerFactory.getFactory().createDebugUsageController();
    }

    @Override
    public void startEngine() throws StartException, StopException, ControllerException, InterruptedException {
        this.logger.debug("starting donkey engine");
        Integer queueBufferSize = this.configurationController.getServerSettings().getQueueBufferSize();
        if (queueBufferSize != null && queueBufferSize > 0) {
            this.queueBufferSize.set(queueBufferSize);
        }
        final com.mirth.commons.encryption.Encryptor encryptor = this.configurationController.getEncryptor();
        Encryptor donkeyEncryptor = new Encryptor(){

            public String encrypt(String text) {
                return encryptor.encrypt(text);
            }

            public Encryptor.EncryptedData encrypt(byte[] data) {
                Encryptor.EncryptedData result = encryptor.encrypt(data);
                return new Encryptor.EncryptedData(result.getHeader(), result.getEncryptedData());
            }

            public String decrypt(String text) {
                return encryptor.decrypt(text);
            }

            public byte[] decrypt(String header, byte[] data) {
                return encryptor.decrypt(header, data);
            }
        };
        EventDispatcher eventDispatcher = new EventDispatcher(){

            public void dispatchEvent(Event event) {
                DonkeyEngineController.this.eventController.dispatchEvent(event);
            }
        };
        Properties donkeyProperties = this.configurationController.getDatabaseSettings().getProperties();
        donkeyProperties.setProperty("donkey.statsupdateinterval", String.valueOf(this.configurationController.getStatsUpdateInterval()));
        this.donkey.startEngine(new DonkeyConfiguration(this.configurationController.getApplicationDataDir(), donkeyProperties, donkeyEncryptor, eventDispatcher, this.configurationController.getServerId()));
    }

    @Override
    public void stopEngine() throws StopException, InterruptedException {
        this.undeployChannels(this.getDeployedIds(), ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, null);
        this.donkey.stopEngine();
    }

    @Override
    public boolean isRunning() {
        return this.donkey.isRunning();
    }

    @Override
    public void startupDeploy(boolean deployChannels) {
        if (deployChannels) {
            this.deployChannels(this.channelController.getChannelIds(), ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, null, new DebugOptions());
        } else {
            this.logger.info("Property \"server.startupdeploy\" is disabled. Skipping initial deployment of channels...");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deployChannels(Set<String> channelIds, ServerEventContext context, ChannelTaskHandler handler, DebugOptions debugOptions) {
        List<Set<String>> orderedIds;
        Set<String> unorderedIds;
        ChannelDependencyGraph dependencyGraph;
        ArrayList<ChannelTask> unorderedUndeployTasks = new ArrayList<ChannelTask>();
        ArrayList<ChannelTask> unorderedDeployTasks = new ArrayList<ChannelTask>();
        ArrayList orderedUndeployTasks = new ArrayList();
        ArrayList orderedDeployTasks = new ArrayList();
        boolean hasUndeployTasks = false;
        boolean hasDeployTasks = false;
        try {
            dependencyGraph = ChannelDependencyServerUtil.getDependencyGraph();
            ChannelDependencyUtil.OrderedChannels orderedChannels = ChannelDependencyUtil.getOrderedChannels(channelIds, dependencyGraph);
            unorderedIds = orderedChannels.getUnorderedIds();
            orderedIds = orderedChannels.getOrderedIds();
        }
        catch (ChannelDependencyException e) {
            this.logger.error("Error deploying channels: " + e.getMessage(), (Throwable)e);
            return;
        }
        for (String string : unorderedIds) {
            if (this.isDeployed(string)) {
                Channel channel = this.channelController.getChannelById(string);
                unorderedUndeployTasks.add(this.createUndeployTask(string, channel.getUndeployScript(), context, channel));
                hasUndeployTasks = true;
            }
            unorderedDeployTasks.add(this.createDeployTask(string, null, null, context, debugOptions));
            hasDeployTasks = true;
        }
        if (CollectionUtils.isNotEmpty(orderedIds)) {
            for (Set set : orderedIds) {
                ArrayList<UndeployTask> arrayList = new ArrayList<UndeployTask>();
                ArrayList<DeployTask> deployTasks = new ArrayList<DeployTask>();
                for (String channelId : set) {
                    if (this.isDeployed(channelId)) {
                        Channel channelModel = this.channelController.getChannelById(channelId);
                        arrayList.add(this.createUndeployTask(channelId, channelModel.getUndeployScript(), context, channelModel));
                        hasUndeployTasks = true;
                    }
                    deployTasks.add(this.createDeployTask(channelId, null, null, context, debugOptions));
                    hasDeployTasks = true;
                }
                if (!arrayList.isEmpty()) {
                    orderedUndeployTasks.add(arrayList);
                }
                orderedDeployTasks.add(0, deployTasks);
            }
        }
        if (hasUndeployTasks) {
            List<ChannelFuture> unorderedUndeployFutures = null;
            if (CollectionUtils.isNotEmpty(unorderedUndeployTasks)) {
                unorderedUndeployFutures = this.submitTasks(unorderedUndeployTasks, handler);
            }
            if (CollectionUtils.isNotEmpty(orderedUndeployTasks)) {
                for (List list : orderedUndeployTasks) {
                    this.waitForTasks(this.submitTasks(list, handler));
                }
            }
            if (CollectionUtils.isNotEmpty(unorderedUndeployFutures)) {
                this.waitForTasks(unorderedUndeployFutures);
            }
            this.executeChannelPluginOnUndeploy(context);
            this.executeGlobalUndeployScript();
        }
        if (hasDeployTasks) {
            try {
                Integer queueBufferSize = this.configurationController.getServerSettings().getQueueBufferSize();
                if (queueBufferSize != null && queueBufferSize > 0) {
                    this.queueBufferSize.set(queueBufferSize);
                }
            }
            catch (ControllerException queueBufferSize) {
                // empty catch block
            }
            this.executeGlobalDeployScript();
            this.executeChannelPluginOnDeploy(context);
            List<ChannelFuture> unorderedDeployFutures = null;
            if (CollectionUtils.isNotEmpty(unorderedDeployTasks)) {
                unorderedDeployFutures = this.submitTasks(unorderedDeployTasks, handler);
            }
            if (CollectionUtils.isNotEmpty(orderedDeployTasks)) {
                void var15_23;
                boolean bl = false;
                while (var15_23 < orderedDeployTasks.size()) {
                    List list = (List)orderedDeployTasks.get((int)var15_23);
                    DelegateErrorTaskHandler orderedHandler = new DelegateErrorTaskHandler(handler);
                    this.waitForTasks(this.submitTasks(list, orderedHandler));
                    if (orderedHandler.isErrored()) {
                        Map<String, Exception> errorMap = orderedHandler.getErrorMap();
                        HashSet<String> dependentIdsToRemove = new HashSet<String>();
                        for (String channelId : errorMap.keySet()) {
                            Set<String> ids = dependencyGraph.getNode(channelId).getAllDependentElements();
                            if (!CollectionUtils.isNotEmpty(ids)) continue;
                            this.logger.error("Channel " + channelId + " failed to deploy. The following dependent channels will not be deployed:\n\t" + StringUtils.join(ids, (String)"\n\t"));
                            dependentIdsToRemove.addAll(ids);
                        }
                        if (CollectionUtils.isNotEmpty(dependentIdsToRemove)) {
                            for (void j = var15_23 + true; j < orderedDeployTasks.size(); ++j) {
                                List nextTaskList = (List)orderedDeployTasks.get((int)j);
                                Iterator it = nextTaskList.iterator();
                                while (it.hasNext()) {
                                    ChannelTask task = (ChannelTask)it.next();
                                    if (!dependentIdsToRemove.contains(task.getChannelId())) continue;
                                    it.remove();
                                }
                                if (!CollectionUtils.isEmpty((Collection)nextTaskList)) continue;
                                orderedDeployTasks.remove((int)j);
                                --j;
                            }
                        }
                    }
                    ++var15_23;
                }
            }
            if (CollectionUtils.isNotEmpty(unorderedDeployFutures)) {
                this.waitForTasks(unorderedDeployFutures);
            }
        }
    }

    @Override
    public void undeployChannels(Set<String> channelIds, ServerEventContext context, ChannelTaskHandler handler) {
        List<Set<String>> orderedIds;
        Set<String> unorderedIds;
        ArrayList<ChannelTask> unorderedUndeployTasks = new ArrayList<ChannelTask>();
        ArrayList orderedUndeployTasks = new ArrayList();
        try {
            ChannelDependencyUtil.OrderedChannels orderedChannels = ChannelDependencyServerUtil.getOrderedChannels(channelIds);
            unorderedIds = orderedChannels.getUnorderedIds();
            orderedIds = orderedChannels.getOrderedIds();
        }
        catch (ChannelDependencyException e) {
            this.logger.error("Error undeploying channels: " + e.getMessage(), (Throwable)e);
            return;
        }
        for (String string : unorderedIds) {
            Channel channel = this.channelController.getChannelById(string);
            unorderedUndeployTasks.add(this.createUndeployTask(string, channel.getUndeployScript(), context, channel));
        }
        if (CollectionUtils.isNotEmpty(orderedIds)) {
            for (Set set : orderedIds) {
                ArrayList<UndeployTask> arrayList = new ArrayList<UndeployTask>();
                for (String channelId : set) {
                    Channel channelModel = this.channelController.getChannelById(channelId);
                    arrayList.add(this.createUndeployTask(channelId, channelModel.getUndeployScript(), context, channelModel));
                }
                orderedUndeployTasks.add(arrayList);
            }
        }
        if (CollectionUtils.isNotEmpty(unorderedUndeployTasks) || CollectionUtils.isNotEmpty(orderedUndeployTasks)) {
            List<ChannelFuture> unorderedUndeployFutures = null;
            if (CollectionUtils.isNotEmpty(unorderedUndeployTasks)) {
                unorderedUndeployFutures = this.submitTasks(unorderedUndeployTasks, handler);
            }
            if (CollectionUtils.isNotEmpty(orderedUndeployTasks)) {
                for (List list : orderedUndeployTasks) {
                    this.waitForTasks(this.submitTasks(list, handler));
                }
            }
            if (CollectionUtils.isNotEmpty(unorderedUndeployFutures)) {
                this.waitForTasks(unorderedUndeployFutures);
            }
            this.executeChannelPluginOnUndeploy(context);
            this.executeGlobalUndeployScript();
        }
    }

    @Override
    public void redeployAllChannels(ServerEventContext context, ChannelTaskHandler handler) {
        this.undeployChannels(this.getDeployedIds(), context, handler);
        this.clearGlobalMap();
        this.deployChannels(this.channelController.getChannelIds(), context, handler, new DebugOptions());
    }

    @Override
    public void startChannels(Set<String> channelIds, ChannelTaskHandler handler) {
        this.executeChannelStatusTasks(channelIds, handler, StatusTask.START);
    }

    @Override
    public void stopChannels(Set<String> channelIds, ChannelTaskHandler handler) {
        this.executeChannelStatusTasks(channelIds, handler, StatusTask.STOP);
    }

    @Override
    public void pauseChannels(Set<String> channelIds, ChannelTaskHandler handler) {
        this.executeChannelStatusTasks(channelIds, handler, StatusTask.PAUSE);
    }

    @Override
    public void resumeChannels(Set<String> channelIds, ChannelTaskHandler handler) {
        this.executeChannelStatusTasks(channelIds, handler, StatusTask.RESUME);
    }

    /*
     * WARNING - void declaration
     */
    private void executeChannelStatusTasks(Set<String> channelIds, ChannelTaskHandler handler, StatusTask task) {
        List<Set<String>> orderedIds;
        Set<String> unorderedIds;
        ChannelDependencyGraph dependencyGraph;
        ArrayList<ChannelTask> unorderedTasks = new ArrayList<ChannelTask>();
        ArrayList orderedTasks = new ArrayList();
        try {
            dependencyGraph = ChannelDependencyServerUtil.getDependencyGraph();
            ChannelDependencyUtil.OrderedChannels orderedChannels = ChannelDependencyUtil.getOrderedChannels(channelIds, dependencyGraph);
            unorderedIds = orderedChannels.getUnorderedIds();
            orderedIds = orderedChannels.getOrderedIds();
        }
        catch (ChannelDependencyException e) {
            this.logger.error("Error executing channel tasks: " + e.getMessage(), (Throwable)e);
            return;
        }
        for (String string : unorderedIds) {
            unorderedTasks.add(new ChannelStatusTask(string, task));
        }
        if (CollectionUtils.isNotEmpty(orderedIds)) {
            for (Set set : orderedIds) {
                ArrayList<ChannelStatusTask> tasks = new ArrayList<ChannelStatusTask>();
                for (String channelId : set) {
                    tasks.add(new ChannelStatusTask(channelId, task));
                }
                if (task == StatusTask.START || task == StatusTask.RESUME) {
                    orderedTasks.add(0, tasks);
                    continue;
                }
                if (task != StatusTask.STOP && task != StatusTask.PAUSE) continue;
                orderedTasks.add(tasks);
            }
        }
        if (CollectionUtils.isNotEmpty(unorderedTasks) || CollectionUtils.isNotEmpty(orderedTasks)) {
            List<ChannelFuture> unorderedFutures = null;
            if (CollectionUtils.isNotEmpty(unorderedTasks)) {
                unorderedFutures = this.submitTasks(unorderedTasks, handler);
            }
            if (CollectionUtils.isNotEmpty(orderedTasks)) {
                void var10_15;
                boolean bl = false;
                while (var10_15 < orderedTasks.size()) {
                    List taskList = (List)orderedTasks.get((int)var10_15);
                    DelegateErrorTaskHandler orderedHandler = new DelegateErrorTaskHandler(handler);
                    this.waitForTasks(this.submitTasks(taskList, orderedHandler));
                    if (orderedHandler.isErrored()) {
                        Map<String, Exception> errorMap = orderedHandler.getErrorMap();
                        HashSet<String> idsToRemove = new HashSet<String>();
                        for (String channelId : errorMap.keySet()) {
                            Set<String> ids;
                            if (task == StatusTask.START || task == StatusTask.RESUME) {
                                ids = dependencyGraph.getNode(channelId).getAllDependentElements();
                                if (!CollectionUtils.isNotEmpty(ids)) continue;
                                this.logger.error("Channel " + channelId + " failed to " + task.toString().toLowerCase() + ". The following dependent channels will not be " + (task == StatusTask.START ? "started" : "resumed") + ":\n\t" + StringUtils.join(ids, (String)"\n\t"));
                                idsToRemove.addAll(ids);
                                continue;
                            }
                            if (task != StatusTask.STOP && task != StatusTask.PAUSE || !CollectionUtils.isNotEmpty(ids = dependencyGraph.getNode(channelId).getAllDependencyElements())) continue;
                            this.logger.error("Channel " + channelId + " failed to " + task.toString().toLowerCase() + ". The following dependency channels will not be " + (task == StatusTask.STOP ? "stopped" : "paused") + ":\n\t" + StringUtils.join(ids, (String)"\n\t"));
                            idsToRemove.addAll(ids);
                        }
                        if (CollectionUtils.isNotEmpty(idsToRemove)) {
                            for (void j = var10_15 + true; j < orderedTasks.size(); ++j) {
                                List nextTaskList = (List)orderedTasks.get((int)j);
                                Iterator it = nextTaskList.iterator();
                                while (it.hasNext()) {
                                    ChannelTask channelTask = (ChannelTask)it.next();
                                    if (!idsToRemove.contains(channelTask.getChannelId())) continue;
                                    it.remove();
                                }
                                if (!CollectionUtils.isEmpty((Collection)nextTaskList)) continue;
                                orderedTasks.remove((int)j);
                                --j;
                            }
                        }
                    }
                    ++var10_15;
                }
            }
            if (CollectionUtils.isNotEmpty(unorderedFutures)) {
                this.waitForTasks(unorderedFutures);
            }
        }
    }

    @Override
    public void startConnector(Map<String, List<Integer>> connectorInfo, ChannelTaskHandler handler) {
        this.waitForTasks(this.submitTasks(this.buildConnectorStatusTasks(connectorInfo, StatusTask.START), handler));
    }

    @Override
    public void stopConnector(Map<String, List<Integer>> connectorInfo, ChannelTaskHandler handler) {
        this.waitForTasks(this.submitTasks(this.buildConnectorStatusTasks(connectorInfo, StatusTask.STOP), handler));
    }

    @Override
    public void haltChannels(Set<String> channelIds, ChannelTaskHandler handler) {
        this.waitForTasks(this.submitHaltTasks(channelIds, handler));
    }

    @Override
    public void removeChannels(Set<String> channelIds, ServerEventContext context, ChannelTaskHandler handler) {
        ArrayList<ChannelTask> tasks = new ArrayList<ChannelTask>();
        for (Channel channelModel : this.channelController.getChannels(channelIds)) {
            tasks.add(this.createUndeployTask(channelModel.getId(), channelModel.getUndeployScript(), context, channelModel));
            tasks.add(new RemoveTask(channelModel, context));
        }
        if (CollectionUtils.isNotEmpty(tasks)) {
            this.waitForTasks(this.submitTasks(tasks, handler));
            this.executeChannelPluginOnUndeploy(context);
        }
    }

    @Override
    public void removeMessages(String channelId, Map<Long, MessageSearchResult> results, ChannelTaskHandler handler) {
        ArrayList<ChannelTask> tasks = new ArrayList<ChannelTask>();
        tasks.add(new RemoveMessagesTask(channelId, results));
        this.waitForTasks(this.submitTasks(tasks, handler));
    }

    @Override
    public void removeAllMessages(Set<String> channelIds, boolean force, boolean clearStatistics, ChannelTaskHandler handler) {
        ArrayList<ChannelTask> tasks = new ArrayList<ChannelTask>();
        for (String channelId : channelIds) {
            tasks.add(new RemoveAllMessagesTask(channelId, force, clearStatistics));
        }
        this.waitForTasks(this.submitTasks(tasks, handler));
    }

    @Override
    public DashboardStatus getChannelStatus(String channelId) {
        com.mirth.connect.donkey.server.channel.Channel channel = (com.mirth.connect.donkey.server.channel.Channel)this.donkey.getDeployedChannels().get(channelId);
        if (channel != null) {
            return this.getDashboardStatuses(Collections.singleton(channel)).get(0);
        }
        return null;
    }

    @Override
    public List<DashboardStatus> getChannelStatusList() {
        return this.getChannelStatusList(null);
    }

    @Override
    public List<DashboardStatus> getChannelStatusList(Set<String> channelIds) {
        return this.getChannelStatusList(channelIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, com.mirth.connect.donkey.server.channel.Channel> getDashboardChannels(Set<String> channelIds) {
        HashMap<String, com.mirth.connect.donkey.server.channel.Channel> channels = null;
        if (CollectionUtils.isNotEmpty(channelIds)) {
            channels = new HashMap<String, com.mirth.connect.donkey.server.channel.Channel>();
            for (com.mirth.connect.donkey.server.channel.Channel channel : this.donkey.getDeployedChannels().values()) {
                if (!channelIds.contains(channel.getChannelId())) continue;
                channels.put(channel.getChannelId(), channel);
            }
        } else {
            channels = new HashMap(this.donkey.getDeployedChannels());
        }
        Set<com.mirth.connect.donkey.server.channel.Channel> set = this.deployingChannels;
        synchronized (set) {
            for (com.mirth.connect.donkey.server.channel.Channel channel : this.deployingChannels) {
                if (channels.containsKey(channel.getChannelId())) continue;
                channels.put(channel.getChannelId(), channel);
            }
        }
        set = this.undeployingChannels;
        synchronized (set) {
            for (com.mirth.connect.donkey.server.channel.Channel channel : this.undeployingChannels) {
                if (channels.containsKey(channel.getChannelId())) continue;
                channels.put(channel.getChannelId(), channel);
            }
        }
        return channels;
    }

    @Override
    public List<DashboardStatus> getChannelStatusList(Set<String> channelIds, boolean includeUndeployed) {
        ArrayList<DashboardStatus> statusList = new ArrayList<DashboardStatus>();
        Map<String, com.mirth.connect.donkey.server.channel.Channel> dashboardChannels = this.getDashboardChannels(channelIds);
        Map<String, ChannelMetadata> metadataMap = this.configurationController.getChannelMetadata();
        statusList.addAll(this.getDashboardStatuses(dashboardChannels.values(), metadataMap));
        if (includeUndeployed) {
            HashMap<String, Channel> channelModels = new HashMap<String, Channel>();
            for (Channel channelModel : this.channelController.getChannels(null)) {
                if (!CollectionUtils.isEmpty(channelIds) && !channelIds.contains(channelModel.getId()) || dashboardChannels.keySet().contains(channelModel.getId())) continue;
                channelModels.put(channelModel.getId(), channelModel);
            }
            statusList.addAll(this.getUndeployedDashboardStatuses(channelModels.values(), metadataMap));
        }
        return statusList;
    }

    private List<DashboardStatus> getUndeployedDashboardStatuses(Collection<Channel> channelModels, Map<String, ChannelMetadata> metadataMap) {
        ArrayList<DashboardStatus> statuses = new ArrayList<DashboardStatus>();
        Statistics stats = this.channelController.getStatisticsFromStorage(this.configurationController.getServerId());
        Statistics lifetimeStats = this.channelController.getTotalStatisticsFromStorage(this.configurationController.getServerId());
        String serverId = this.configurationController.getServerId();
        for (Channel channelModel : channelModels) {
            if (channelModel instanceof InvalidChannel) continue;
            String channelId = channelModel.getId();
            ChannelMetadata metadata = metadataMap.get(channelId);
            if (metadata == null) {
                metadata = new ChannelMetadata();
            }
            DashboardStatus status = new DashboardStatus();
            status.setStatusType(DashboardStatus.StatusType.CHANNEL);
            status.setChannelId(channelId);
            status.setName(channelModel.getName());
            status.setState(DeployedState.UNDEPLOYED);
            status.setDeployedDate(null);
            status.setDeployedRevisionDelta(0);
            status.setStatistics(stats.getConnectorStats(channelId, null));
            status.setLifetimeStatistics(lifetimeStats.getConnectorStats(channelId, null));
            DashboardStatus sourceStatus = new DashboardStatus();
            sourceStatus.setStatusType(DashboardStatus.StatusType.SOURCE_CONNECTOR);
            sourceStatus.setChannelId(channelId);
            sourceStatus.setMetaDataId(0);
            sourceStatus.setName("Source");
            sourceStatus.setState(DeployedState.UNDEPLOYED);
            sourceStatus.setStatistics(stats.getConnectorStats(channelId, Integer.valueOf(0)));
            sourceStatus.setLifetimeStatistics(lifetimeStats.getConnectorStats(channelId, Integer.valueOf(0)));
            SourceConnectorProperties sourceProps = ((SourceConnectorPropertiesInterface)channelModel.getSourceConnector().getProperties()).getSourceConnectorProperties();
            sourceStatus.setQueueEnabled(!sourceProps.isRespondAfterProcessing());
            if (sourceStatus.isQueueEnabled()) {
                sourceStatus.setQueued(Long.valueOf(this.channelController.getConnectorMessageCount(channelId, serverId, 0, Status.RECEIVED)));
            }
            status.setQueued(sourceStatus.getQueued());
            status.getChildStatuses().add(sourceStatus);
            for (Connector destination : channelModel.getDestinationConnectors()) {
                Integer metaDataId = destination.getMetaDataId();
                DestinationConnectorProperties destProps = ((DestinationConnectorPropertiesInterface)destination.getProperties()).getDestinationConnectorProperties();
                DashboardStatus destinationStatus = new DashboardStatus();
                destinationStatus.setStatusType(DashboardStatus.StatusType.DESTINATION_CONNECTOR);
                destinationStatus.setChannelId(channelId);
                destinationStatus.setMetaDataId(metaDataId);
                destinationStatus.setName(destination.getName());
                destinationStatus.setState(DeployedState.UNDEPLOYED);
                destinationStatus.setStatistics(stats.getConnectorStats(channelId, metaDataId));
                destinationStatus.setLifetimeStatistics(lifetimeStats.getConnectorStats(channelId, metaDataId));
                destinationStatus.setQueueEnabled(destProps.isQueueEnabled());
                destinationStatus.setQueued(Long.valueOf(this.channelController.getConnectorMessageCount(channelId, serverId, metaDataId, Status.QUEUED)));
                status.setQueued(status.getQueued() + destinationStatus.getQueued());
                status.getChildStatuses().add(destinationStatus);
            }
            statuses.add(status);
        }
        return statuses;
    }

    private List<DashboardStatus> getDashboardStatuses(Collection<com.mirth.connect.donkey.server.channel.Channel> channels) {
        return this.getDashboardStatuses(channels, this.configurationController.getChannelMetadata());
    }

    private List<DashboardStatus> getDashboardStatuses(Collection<com.mirth.connect.donkey.server.channel.Channel> channels, Map<String, ChannelMetadata> metadataMap) {
        ArrayList<DashboardStatus> statuses = new ArrayList<DashboardStatus>();
        Map<String, Integer> channelRevisions = null;
        try {
            channelRevisions = this.channelController.getChannelRevisions();
        }
        catch (ControllerException e) {
            this.logger.error("Error retrieving channel revisions", (Throwable)e);
        }
        List<CodeTemplateLibrary> codeTemplateLibraries = null;
        try {
            codeTemplateLibraries = this.codeTemplateController.getLibraries(null, true);
        }
        catch (ControllerException e) {
            this.logger.error("Error retrieving code template libraries", (Throwable)e);
        }
        for (com.mirth.connect.donkey.server.channel.Channel channel : channels) {
            String channelId = channel.getChannelId();
            Channel channelModel = this.channelController.getDeployedChannelById(channelId);
            if (channelModel == null) continue;
            ChannelMetadata metadata = metadataMap.get(channelId);
            if (metadata == null) {
                metadata = new ChannelMetadata();
            }
            Statistics stats = this.channelController.getStatistics();
            Statistics lifetimeStats = this.channelController.getTotalStatistics();
            DashboardStatus status = new DashboardStatus();
            status.setStatusType(DashboardStatus.StatusType.CHANNEL);
            status.setChannelId(channelId);
            status.setName(channel.getName());
            status.setState(channel.getCurrentState());
            status.setDeployedDate(channel.getDeployDate());
            int channelRevision = 0;
            if (channelRevisions != null && channelRevisions.containsKey(channelId)) {
                channelRevision = channelRevisions.get(channelId);
                status.setDeployedRevisionDelta(channelRevision - channelModel.getRevision());
                try {
                    DeployedChannelInfo deployedChannelInfo = this.channelController.getDeployedChannelInfoById(channelId);
                    if (deployedChannelInfo != null && deployedChannelInfo.getCodeTemplateRevisions() != null && !deployedChannelInfo.getCodeTemplateRevisions().equals(this.codeTemplateController.getCodeTemplateRevisionsForChannel(channelId, codeTemplateLibraries))) {
                        status.setCodeTemplatesChanged(true);
                    }
                }
                catch (ControllerException deployedChannelInfo) {
                    // empty catch block
                }
            }
            status.setStatistics(stats.getConnectorStats(channelId, null));
            status.setLifetimeStatistics(lifetimeStats.getConnectorStats(channelId, null));
            DashboardStatus sourceStatus = new DashboardStatus();
            sourceStatus.setStatusType(DashboardStatus.StatusType.SOURCE_CONNECTOR);
            sourceStatus.setChannelId(channelId);
            sourceStatus.setMetaDataId(0);
            sourceStatus.setName("Source");
            sourceStatus.setState(channel.getSourceConnector().getCurrentState());
            sourceStatus.setStatistics(stats.getConnectorStats(channelId, Integer.valueOf(0)));
            sourceStatus.setLifetimeStatistics(lifetimeStats.getConnectorStats(channelId, Integer.valueOf(0)));
            sourceStatus.setQueueEnabled(!channel.getSourceConnector().isRespondAfterProcessing());
            sourceStatus.setQueued(this.getSourceQueueSize(channel));
            status.setQueued(sourceStatus.getQueued());
            status.getChildStatuses().add(sourceStatus);
            for (DestinationChainProvider chainProvider : channel.getDestinationChainProviders()) {
                for (Map.Entry connectorEntry : chainProvider.getDestinationConnectors().entrySet()) {
                    Integer metaDataId = (Integer)connectorEntry.getKey();
                    DestinationConnector connector = (DestinationConnector)connectorEntry.getValue();
                    DashboardStatus destinationStatus = new DashboardStatus();
                    destinationStatus.setStatusType(DashboardStatus.StatusType.DESTINATION_CONNECTOR);
                    destinationStatus.setChannelId(channelId);
                    destinationStatus.setMetaDataId(metaDataId);
                    destinationStatus.setName(connector.getDestinationName());
                    destinationStatus.setState(connector.getCurrentState());
                    destinationStatus.setStatistics(stats.getConnectorStats(channelId, metaDataId));
                    destinationStatus.setLifetimeStatistics(lifetimeStats.getConnectorStats(channelId, metaDataId));
                    destinationStatus.setQueueEnabled(connector.isQueueEnabled());
                    destinationStatus.setQueued(this.getDestinationQueueSize(connector));
                    status.setQueued(status.getQueued() + destinationStatus.getQueued());
                    status.getChildStatuses().add(destinationStatus);
                }
            }
            statuses.add(status);
        }
        Collections.sort(statuses, new Comparator<DashboardStatus>(){

            @Override
            public int compare(DashboardStatus o1, DashboardStatus o2) {
                Calendar c1 = o1.getDeployedDate();
                Calendar c2 = o2.getDeployedDate();
                return ObjectUtils.compare((Comparable)c1, (Comparable)c2);
            }
        });
        return statuses;
    }

    protected Long getSourceQueueSize(com.mirth.connect.donkey.server.channel.Channel channel) {
        return new Long(channel.getSourceQueue().size());
    }

    protected Long getDestinationQueueSize(DestinationConnector destinationConnector) {
        return new Long(destinationConnector.getQueue().size());
    }

    @Override
    public List<ChannelStatistics> getChannelStatisticsList(Set<String> channelIds, boolean includeUndeployed) {
        return this.getChannelStatisticsList(channelIds, includeUndeployed, null, null);
    }

    @Override
    public List<ChannelStatistics> getChannelStatisticsList(Set<String> channelIds, boolean includeUndeployed, Set<Integer> includeMetadataIds, Set<Integer> excludeMetadataIds) {
        ArrayList<ChannelStatistics> statistics = new ArrayList<ChannelStatistics>();
        Map<String, com.mirth.connect.donkey.server.channel.Channel> dashboardChannels = this.getDashboardChannels(channelIds);
        statistics.addAll(this.getDashboardChannelStatistics(dashboardChannels.values(), includeMetadataIds, excludeMetadataIds));
        if (includeUndeployed) {
            HashMap<String, Channel> channelModels = new HashMap<String, Channel>();
            for (Channel channelModel : this.channelController.getChannels(null)) {
                if (!CollectionUtils.isEmpty(channelIds) && !channelIds.contains(channelModel.getId()) || dashboardChannels.keySet().contains(channelModel.getId())) continue;
                channelModels.put(channelModel.getId(), channelModel);
            }
            statistics.addAll(this.getUndeployedChannelStatistics(channelModels.values(), includeMetadataIds, excludeMetadataIds));
        }
        return statistics;
    }

    private List<ChannelStatistics> getDashboardChannelStatistics(Collection<com.mirth.connect.donkey.server.channel.Channel> channels, Set<Integer> includeMetaDataIds, Set<Integer> excludeMetaDataIds) {
        ArrayList<ChannelStatistics> statisticsList = new ArrayList<ChannelStatistics>();
        Statistics stats = this.channelController.getStatistics();
        String serverId = this.configurationController.getServerId();
        for (com.mirth.connect.donkey.server.channel.Channel channel : channels) {
            String channelId = channel.getChannelId();
            Channel channelModel = this.channelController.getDeployedChannelById(channelId);
            if (channelModel == null) continue;
            ChannelStatistics statistics = new ChannelStatistics();
            statistics.setChannelId(channelId);
            statistics.setServerId(serverId);
            if (this.includeConnectorId(0, includeMetaDataIds, excludeMetaDataIds)) {
                Map sourceConnectorStats = stats.getConnectorStats(channelId, Integer.valueOf(0));
                this.addConnectorToChannelStatistics(sourceConnectorStats, statistics, true);
                statistics.setQueued(this.getSourceQueueSize(channel));
            }
            for (DestinationChainProvider chainProvider : channel.getDestinationChainProviders()) {
                for (Map.Entry connectorEntry : chainProvider.getDestinationConnectors().entrySet()) {
                    DestinationConnector connector = (DestinationConnector)connectorEntry.getValue();
                    Integer metaDataId = connector.getMetaDataId();
                    if (!this.includeConnectorId(metaDataId, includeMetaDataIds, excludeMetaDataIds)) continue;
                    Map destinationConnectorStats = stats.getConnectorStats(channelId, metaDataId);
                    this.addConnectorToChannelStatistics(destinationConnectorStats, statistics, false);
                    statistics.setQueued(statistics.getQueued() + this.getDestinationQueueSize(connector));
                }
            }
            statisticsList.add(statistics);
        }
        return statisticsList;
    }

    private List<ChannelStatistics> getUndeployedChannelStatistics(Collection<Channel> channelModels, Set<Integer> includeMetaDataIds, Set<Integer> excludeMetaDataIds) {
        ArrayList<ChannelStatistics> statisticsList = new ArrayList<ChannelStatistics>();
        Statistics stats = this.channelController.getStatisticsFromStorage(this.configurationController.getServerId());
        String serverId = this.configurationController.getServerId();
        for (Channel channelModel : channelModels) {
            if (channelModel instanceof InvalidChannel) continue;
            ChannelStatistics statistics = new ChannelStatistics();
            String channelId = channelModel.getId();
            statistics.setChannelId(channelId);
            statistics.setServerId(serverId);
            if (this.includeConnectorId(0, includeMetaDataIds, excludeMetaDataIds)) {
                Map sourceConnectorStats = stats.getConnectorStats(channelId, Integer.valueOf(0));
                this.addConnectorToChannelStatistics(sourceConnectorStats, statistics, true);
                if (!((SourceConnectorPropertiesInterface)channelModel.getSourceConnector().getProperties()).getSourceConnectorProperties().isRespondAfterProcessing()) {
                    statistics.setQueued(this.channelController.getConnectorMessageCount(channelId, serverId, 0, Status.RECEIVED));
                }
            }
            for (Connector destination : channelModel.getDestinationConnectors()) {
                Integer metaDataId = destination.getMetaDataId();
                if (!this.includeConnectorId(metaDataId, includeMetaDataIds, excludeMetaDataIds)) continue;
                Map destinationConnectorStats = stats.getConnectorStats(channelId, metaDataId);
                this.addConnectorToChannelStatistics(destinationConnectorStats, statistics, false);
                statistics.setQueued(statistics.getQueued() + (long)this.channelController.getConnectorMessageCount(channelId, serverId, metaDataId, Status.QUEUED));
            }
            statisticsList.add(statistics);
        }
        return statisticsList;
    }

    private ChannelStatistics addConnectorToChannelStatistics(Map<Status, Long> stats, ChannelStatistics statistics, boolean sourceConnector) {
        if (statistics == null) {
            statistics = new ChannelStatistics();
        }
        if (sourceConnector) {
            statistics.setReceived(statistics.getReceived() + stats.get(Status.RECEIVED));
        } else {
            statistics.setSent(statistics.getSent() + stats.get(Status.SENT));
        }
        statistics.setError(statistics.getError() + stats.get(Status.ERROR));
        statistics.setFiltered(statistics.getFiltered() + stats.get(Status.FILTERED));
        return statistics;
    }

    private boolean includeConnectorId(Integer metaDataId, Set<Integer> includeMetaDataIds, Set<Integer> excludeMetaDataIds) {
        return !(!CollectionUtils.isEmpty(includeMetaDataIds) && !includeMetaDataIds.contains(metaDataId) || !CollectionUtils.isEmpty(excludeMetaDataIds) && excludeMetaDataIds.contains(metaDataId));
    }

    @Override
    public Set<String> getDeployedIds() {
        return this.donkey.getDeployedChannelIds();
    }

    @Override
    public boolean isDeployed(String channelId) {
        return this.donkey.getDeployedChannels().containsKey(channelId);
    }

    @Override
    public com.mirth.connect.donkey.server.channel.Channel getDeployedChannel(String channelId) {
        return (com.mirth.connect.donkey.server.channel.Channel)this.donkey.getDeployedChannels().get(channelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DispatchResult dispatchRawMessage(String channelId, RawMessage rawMessage, boolean force, boolean canBatch) throws ChannelException, BatchMessageException {
        if (!this.isDeployed(channelId)) {
            ChannelException e = new ChannelException(true);
            this.logger.error("Could not find channel to route to: " + channelId, (Throwable)e);
            throw e;
        }
        SourceConnector sourceConnector = ((com.mirth.connect.donkey.server.channel.Channel)this.donkey.getDeployedChannels().get(channelId)).getSourceConnector();
        if (canBatch && sourceConnector.isProcessBatch()) {
            if (rawMessage.isBinary().booleanValue()) {
                throw new BatchMessageException("Batch processing is not supported for binary data.");
            }
            BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(rawMessage.getRawData()), rawMessage.getSourceMap());
            SimpleResponseHandler responseHandler = new SimpleResponseHandler();
            sourceConnector.dispatchBatchMessage(batchRawMessage, (ResponseHandler)responseHandler, rawMessage.getDestinationMetaDataIds());
            return responseHandler.getResultForResponse();
        }
        DispatchResult dispatchResult = null;
        try {
            dispatchResult = sourceConnector.dispatchRawMessage(rawMessage, force);
            dispatchResult.setAttemptedResponse(true);
        }
        finally {
            sourceConnector.finishDispatch(dispatchResult);
        }
        return dispatchResult;
    }

    protected com.mirth.connect.donkey.server.channel.Channel createChannelFromModel(Channel channelModel, DebugOptions debugOptions) throws Exception {
        String channelId = channelModel.getId();
        ChannelProperties channelProperties = channelModel.getProperties();
        StorageSettings storageSettings = DonkeyEngineController.getStorageSettings(channelProperties.getMessageStorageMode(), channelProperties);
        com.mirth.connect.donkey.server.channel.Channel channel = new com.mirth.connect.donkey.server.channel.Channel();
        channel.setResourceIds(channelModel.getProperties().getResourceIds().keySet());
        MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(channelModel.getProperties().getResourceIds().keySet());
        channel.setContextFactoryId(contextFactory.getId());
        LinkedHashMap<String, Integer> destinationIdMap = new LinkedHashMap<String, Integer>();
        channel.setChannelId(channelId);
        channel.setLocalChannelId(this.donkeyChannelController.getLocalChannelId(channelId).longValue());
        channel.setServerId(ConfigurationController.getInstance().getServerId());
        channel.setName(channelModel.getName());
        channel.setRevision(channelModel.getRevision().intValue());
        channel.setInitialState(channelProperties.getInitialState());
        channel.setDebugOptions(debugOptions);
        channel.setStorageSettings(storageSettings);
        channel.setMetaDataColumns(channelProperties.getMetaDataColumns());
        channel.setAttachmentHandlerProvider(this.createAttachmentHandlerProvider(channel, contextFactory, channelProperties.getAttachmentProperties()));
        channel.setPreProcessor(this.createPreProcessor(channel, channelModel.getPreprocessingScript(), debugOptions));
        channel.setPostProcessor(this.createPostProcessor(channel, channelModel.getPostprocessingScript(), debugOptions));
        channel.setSourceConnector(this.createSourceConnector(channel, channelModel.getSourceConnector(), storageSettings, destinationIdMap, debugOptions));
        channel.setResponseSelector(new ResponseSelector(channel.getSourceConnector().getInboundDataType()));
        channel.setMessageMaps((MessageMaps)new MirthMessageMaps(channelId));
        SourceConnectorProperties sourceConnectorProperties = ((SourceConnectorPropertiesInterface)channelModel.getSourceConnector().getProperties()).getSourceConnectorProperties();
        channel.getResponseSelector().setRespondFromName(sourceConnectorProperties.getResponseVariable());
        SourceQueue sourceQueue = this.getSourceQueue(channelModel);
        if (sourceConnectorProperties.getQueueBufferSize() > 0) {
            sourceQueue.setBufferCapacity(sourceConnectorProperties.getQueueBufferSize());
        } else {
            sourceQueue.setBufferCapacity(this.queueBufferSize.get());
        }
        channel.setSourceQueue(sourceQueue);
        channel.setProcessLock(this.getChannelProcessLock(channelModel));
        if (storageSettings.isEnabled()) {
            SerializerProvider serializerProvider = this.createSerializerProvider(channelModel);
            BufferedDaoFactory bufferedDaoFactory = new BufferedDaoFactory(this.donkey.getDaoFactory(), serializerProvider, (StatisticsUpdater)this.donkey.getStatisticsUpdater());
            bufferedDaoFactory.setEncryptData(channelProperties.isEncryptMessageContent(), channelProperties.isEncryptAttachments(), channelProperties.isEncryptCustomMetaData());
            channel.setDaoFactory((DonkeyDaoFactory)bufferedDaoFactory);
        } else {
            channel.setDaoFactory((DonkeyDaoFactory)new PassthruDaoFactory((StatisticsUpdater)this.donkey.getStatisticsUpdater()));
        }
        DestinationChainProvider chain = this.createDestinationChain(channel);
        for (Connector connectorModel : channelModel.getDestinationConnectors()) {
            if (!connectorModel.isEnabled()) continue;
            if (!connectorModel.isWaitForPrevious() || channel.getDestinationChainProviders().size() == 0) {
                chain = this.createDestinationChain(channel);
                channel.addDestinationChainProvider(chain);
            }
            Integer metaDataId = connectorModel.getMetaDataId();
            destinationIdMap.put(connectorModel.getName(), metaDataId);
            if (metaDataId == null) {
                metaDataId = channelModel.getNextMetaDataId();
                channelModel.setNextMetaDataId(metaDataId + 1);
                connectorModel.setMetaDataId(metaDataId);
            }
            chain.addDestination(connectorModel.getMetaDataId().intValue(), this.createDestinationConnector(channel, channelModel, connectorModel, storageSettings, destinationIdMap, debugOptions));
        }
        return channel;
    }

    protected SourceQueue getSourceQueue(Channel channelModel) {
        return new SourceQueue();
    }

    protected ChannelProcessLock getChannelProcessLock(Channel channelModel) {
        int processingThreads = ((SourceConnectorPropertiesInterface)channelModel.getSourceConnector().getProperties()).getSourceConnectorProperties().getProcessingThreads();
        if (processingThreads < 1) {
            processingThreads = 1;
        }
        return new DefaultChannelProcessLock(processingThreads);
    }

    protected SerializerProvider createSerializerProvider(Channel channelModel) {
        final HashMap<Integer, Set<String>> resourceIdMap = new HashMap<Integer, Set<String>>();
        resourceIdMap.put(null, channelModel.getProperties().getResourceIds().keySet());
        resourceIdMap.put(0, ((SourceConnectorPropertiesInterface)channelModel.getSourceConnector().getProperties()).getSourceConnectorProperties().getResourceIds().keySet());
        for (Connector destinationConnector : channelModel.getDestinationConnectors()) {
            resourceIdMap.put(destinationConnector.getMetaDataId(), ((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().getResourceIds().keySet());
        }
        return new SerializerProvider(){

            public Serializer getSerializer(Integer metaDataId) {
                try {
                    MirthContextFactory contextFactory = DonkeyEngineController.this.contextFactoryController.getContextFactory((Set)resourceIdMap.get(metaDataId));
                    if (contextFactory != null) {
                        return contextFactory.getSerializer();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return ObjectXMLSerializer.getInstance();
            }
        };
    }

    public static StorageSettings getStorageSettings(MessageStorageMode messageStorageMode, ChannelProperties channelProperties) {
        StorageSettings storageSettings = new StorageSettings();
        storageSettings.setRemoveContentOnCompletion(channelProperties.isRemoveContentOnCompletion());
        storageSettings.setRemoveOnlyFilteredOnCompletion(channelProperties.isRemoveOnlyFilteredOnCompletion());
        storageSettings.setRemoveAttachmentsOnCompletion(channelProperties.isRemoveAttachmentsOnCompletion());
        storageSettings.setStoreAttachments(channelProperties.isStoreAttachments());
        switch (messageStorageMode) {
            case PRODUCTION: {
                storageSettings.setStoreProcessedRaw(false);
                storageSettings.setStoreTransformed(false);
                storageSettings.setStoreResponseTransformed(false);
                storageSettings.setStoreProcessedResponse(false);
                break;
            }
            case RAW: {
                storageSettings.setMessageRecoveryEnabled(false);
                storageSettings.setDurable(false);
                storageSettings.setStoreMaps(false);
                storageSettings.setStoreResponseMap(false);
                storageSettings.setStoreMergedResponseMap(false);
                storageSettings.setStoreProcessedRaw(false);
                storageSettings.setStoreTransformed(false);
                storageSettings.setStoreSourceEncoded(false);
                storageSettings.setStoreDestinationEncoded(false);
                storageSettings.setStoreSent(false);
                storageSettings.setStoreResponseTransformed(false);
                storageSettings.setStoreProcessedResponse(false);
                storageSettings.setStoreResponse(false);
                storageSettings.setStoreSentResponse(false);
                break;
            }
            case METADATA: {
                storageSettings.setMessageRecoveryEnabled(false);
                storageSettings.setDurable(false);
                storageSettings.setRawDurable(false);
                storageSettings.setStoreMaps(false);
                storageSettings.setStoreResponseMap(false);
                storageSettings.setStoreMergedResponseMap(false);
                storageSettings.setStoreRaw(false);
                storageSettings.setStoreProcessedRaw(false);
                storageSettings.setStoreTransformed(false);
                storageSettings.setStoreSourceEncoded(false);
                storageSettings.setStoreDestinationEncoded(false);
                storageSettings.setStoreSent(false);
                storageSettings.setStoreResponseTransformed(false);
                storageSettings.setStoreProcessedResponse(false);
                storageSettings.setStoreResponse(false);
                storageSettings.setStoreSentResponse(false);
                break;
            }
            case DISABLED: {
                storageSettings.setEnabled(false);
                storageSettings.setMessageRecoveryEnabled(false);
                storageSettings.setDurable(false);
                storageSettings.setRawDurable(false);
                storageSettings.setStoreCustomMetaData(false);
                storageSettings.setStoreMaps(false);
                storageSettings.setStoreResponseMap(false);
                storageSettings.setStoreMergedResponseMap(false);
                storageSettings.setStoreRaw(false);
                storageSettings.setStoreProcessedRaw(false);
                storageSettings.setStoreTransformed(false);
                storageSettings.setStoreSourceEncoded(false);
                storageSettings.setStoreDestinationEncoded(false);
                storageSettings.setStoreSent(false);
                storageSettings.setStoreResponseTransformed(false);
                storageSettings.setStoreProcessedResponse(false);
                storageSettings.setStoreResponse(false);
                storageSettings.setStoreSentResponse(false);
            }
        }
        return storageSettings;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AttachmentHandlerProvider createAttachmentHandlerProvider(com.mirth.connect.donkey.server.channel.Channel channel, MirthContextFactory contextFactory, AttachmentHandlerProperties attachmentHandlerProperties) throws Exception {
        void var4_7;
        Object var4_4 = null;
        if (AttachmentHandlerType.fromString(attachmentHandlerProperties.getType()) != AttachmentHandlerType.NONE) {
            Class<?> attachmentHandlerProviderClass = Class.forName(attachmentHandlerProperties.getClassName(), true, contextFactory.getApplicationClassLoader());
            if (!MirthAttachmentHandlerProvider.class.isAssignableFrom(attachmentHandlerProviderClass)) throw new Exception(attachmentHandlerProperties.getClassName() + " does not extend " + MirthAttachmentHandlerProvider.class.getName());
            MirthAttachmentHandlerProvider mirthAttachmentHandlerProvider = (MirthAttachmentHandlerProvider)attachmentHandlerProviderClass.getConstructor(MessageController.class).newInstance(MessageController.getInstance());
            mirthAttachmentHandlerProvider.setProperties(channel, attachmentHandlerProperties);
            return var4_7;
        } else {
            PassthruAttachmentHandlerProvider passthruAttachmentHandlerProvider = new PassthruAttachmentHandlerProvider(MessageController.getInstance());
        }
        return var4_7;
    }

    private PreProcessor createPreProcessor(com.mirth.connect.donkey.server.channel.Channel channel, String preProcessingScript, DebugOptions debugOptions) throws JavaScriptInitializationException {
        return new JavaScriptPreprocessor(channel, preProcessingScript, debugOptions);
    }

    private PostProcessor createPostProcessor(com.mirth.connect.donkey.server.channel.Channel channel, String postProcessingScript, DebugOptions debugOptions) throws JavaScriptInitializationException {
        return new JavaScriptPostprocessor(channel, postProcessingScript, debugOptions);
    }

    private SourceConnector createSourceConnector(com.mirth.connect.donkey.server.channel.Channel channel, Connector connectorModel, StorageSettings storageSettings, Map<String, Integer> destinationIdMap, DebugOptions debugOptions) throws Exception {
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        ConnectorProperties connectorProperties = connectorModel.getProperties();
        ConnectorMetaData connectorMetaData = extensionController.getConnectorMetaData().get(connectorProperties.getName());
        SourceConnector sourceConnector = (SourceConnector)Class.forName(connectorMetaData.getServerClassName()).newInstance();
        this.setCommonConnectorProperties(channel.getChannelId(), (com.mirth.connect.donkey.server.channel.Connector)sourceConnector, connectorModel, destinationIdMap);
        sourceConnector.setMetaDataReplacer(this.createMetaDataReplacer(connectorModel));
        sourceConnector.setChannel(channel);
        SourceConnectorProperties sourceConnectorProperties = ((SourceConnectorPropertiesInterface)connectorProperties).getSourceConnectorProperties();
        sourceConnector.setRespondAfterProcessing(sourceConnectorProperties.isRespondAfterProcessing());
        sourceConnector.setResourceIds(sourceConnectorProperties.getResourceIds().keySet());
        DataTypeServerPlugin dataTypePlugin = ExtensionController.getInstance().getDataTypePlugins().get(connectorModel.getTransformer().getInboundDataType());
        DataTypeProperties dataTypeProperties = connectorModel.getTransformer().getInboundProperties();
        SerializerProperties serializerProperties = dataTypeProperties.getSerializerProperties();
        BatchProperties batchProperties = serializerProperties.getBatchProperties();
        if (batchProperties != null && sourceConnectorProperties.isProcessBatch()) {
            BatchAdaptorFactory batchAdaptorFactory = dataTypePlugin.getBatchAdaptorFactory(sourceConnector, serializerProperties);
            batchAdaptorFactory.setUseFirstReponse(sourceConnectorProperties.isFirstResponse());
            sourceConnector.setBatchAdaptorFactory(batchAdaptorFactory);
        }
        sourceConnector.setFilterTransformerExecutor(this.createFilterTransformerExecutor((com.mirth.connect.donkey.server.channel.Connector)sourceConnector, connectorModel, destinationIdMap, debugOptions));
        return sourceConnector;
    }

    private FilterTransformerExecutor createFilterTransformerExecutor(com.mirth.connect.donkey.server.channel.Connector connector, Connector connectorModel, Map<String, Integer> destinationIdMap, DebugOptions debugOptions) throws Exception {
        boolean runFilterTransformer = false;
        String template = null;
        Transformer transformer = connectorModel.getTransformer();
        Filter filter = connectorModel.getFilter();
        DataType inboundDataType = DataTypeFactory.getDataType(transformer.getInboundDataType(), transformer.getInboundProperties(), true);
        DataType outboundDataType = DataTypeFactory.getDataType(transformer.getOutboundDataType(), transformer.getOutboundProperties(), false);
        if (!(filter.getEnabledElements().isEmpty() && transformer.getEnabledElements().isEmpty() && transformer.getInboundDataType().equals(transformer.getOutboundDataType()))) {
            runFilterTransformer = true;
        }
        if (!runFilterTransformer) {
            runFilterTransformer = inboundDataType.getSerializer().isSerializationRequired(true);
        }
        if (!runFilterTransformer) {
            runFilterTransformer = outboundDataType.getSerializer().isSerializationRequired(false);
        }
        if (StringUtils.isNotBlank((CharSequence)transformer.getOutboundTemplate())) {
            DataTypeServerPlugin outboundServerPlugin = ExtensionController.getInstance().getDataTypePlugins().get(transformer.getOutboundDataType());
            IMessageSerializer serializer = outboundServerPlugin.getSerializer(transformer.getOutboundProperties().getSerializerProperties());
            SerializationType templateSerializationType = DataTypeFactory.getSerializationType(outboundServerPlugin, transformer.getOutboundProperties(), true);
            try {
                template = outboundServerPlugin.isBinary() || templateSerializationType == SerializationType.RAW ? transformer.getOutboundTemplate() : (templateSerializationType == SerializationType.JSON ? serializer.toJSON(transformer.getOutboundTemplate()) : serializer.toXML(transformer.getOutboundTemplate()));
            }
            catch (MessageSerializerException e) {
                throw new MessageSerializerException("Error serializing transformer outbound template for connector \"" + connectorModel.getName() + "\": " + e.getMessage(), e.getCause(), e.getFormattedError());
            }
            runFilterTransformer = true;
        }
        FilterTransformerExecutor filterTransformerExecutor = new FilterTransformerExecutor(inboundDataType, outboundDataType);
        if (runFilterTransformer) {
            String script = JavaScriptBuilder.generateFilterTransformerScript(filter, transformer);
            filterTransformerExecutor.setFilterTransformer((FilterTransformer)new JavaScriptFilterTransformer(connector, connectorModel.getName(), script, template, debugOptions));
        }
        return filterTransformerExecutor;
    }

    private ResponseTransformerExecutor createResponseTransformerExecutor(com.mirth.connect.donkey.server.channel.Connector connector, Connector connectorModel, Map<String, Integer> destinationIdMap, DebugOptions debugOptions) throws Exception {
        boolean runResponseTransformer = false;
        String template = null;
        Transformer transformer = connectorModel.getResponseTransformer();
        DataType inboundDataType = DataTypeFactory.getDataType(transformer.getInboundDataType(), transformer.getInboundProperties(), true);
        DataType outboundDataType = DataTypeFactory.getDataType(transformer.getOutboundDataType(), transformer.getOutboundProperties(), false);
        if (!transformer.getEnabledElements().isEmpty() || !transformer.getInboundDataType().equals(transformer.getOutboundDataType())) {
            runResponseTransformer = true;
        }
        if (!runResponseTransformer) {
            runResponseTransformer = inboundDataType.getSerializer().isSerializationRequired(true);
        }
        if (!runResponseTransformer) {
            runResponseTransformer = outboundDataType.getSerializer().isSerializationRequired(false);
        }
        if (StringUtils.isNotBlank((CharSequence)transformer.getOutboundTemplate())) {
            DataTypeServerPlugin outboundServerPlugin = ExtensionController.getInstance().getDataTypePlugins().get(transformer.getOutboundDataType());
            IMessageSerializer serializer = outboundServerPlugin.getSerializer(transformer.getOutboundProperties().getSerializerProperties());
            SerializationType templateSerializationType = DataTypeFactory.getSerializationType(outboundServerPlugin, transformer.getOutboundProperties(), true);
            try {
                template = outboundServerPlugin.isBinary() || templateSerializationType == SerializationType.RAW ? transformer.getOutboundTemplate() : (templateSerializationType == SerializationType.JSON ? serializer.toJSON(transformer.getOutboundTemplate()) : serializer.toXML(transformer.getOutboundTemplate()));
            }
            catch (MessageSerializerException e) {
                throw new MessageSerializerException("Error serializing response transformer outbound template for connector \"" + connectorModel.getName() + "\": " + e.getMessage(), e.getCause(), e.getFormattedError());
            }
            runResponseTransformer = true;
        }
        ResponseTransformerExecutor responseTransformerExecutor = new ResponseTransformerExecutor(inboundDataType, outboundDataType);
        if (runResponseTransformer) {
            String script = JavaScriptBuilder.generateResponseTransformerScript(transformer);
            responseTransformerExecutor.setResponseTransformer((ResponseTransformer)new JavaScriptResponseTransformer(connector, connectorModel.getName(), script, template, debugOptions));
        }
        return responseTransformerExecutor;
    }

    private DestinationChainProvider createDestinationChain(com.mirth.connect.donkey.server.channel.Channel channel) {
        DestinationChainProvider chain = new DestinationChainProvider();
        chain.setChannelId(channel.getChannelId());
        return chain;
    }

    private DestinationConnector createDestinationConnector(com.mirth.connect.donkey.server.channel.Channel channel, Channel channelModel, Connector connectorModel, StorageSettings storageSettings, Map<String, Integer> destinationIdMap, DebugOptions debugOptions) throws Exception {
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        ConnectorProperties connectorProperties = connectorModel.getProperties();
        ConnectorMetaData connectorMetaData = extensionController.getConnectorMetaData().get(connectorProperties.getName());
        String className = connectorMetaData.getServerClassName();
        DestinationConnector destinationConnector = (DestinationConnector)Class.forName(className).newInstance();
        this.setCommonConnectorProperties(channel.getChannelId(), (com.mirth.connect.donkey.server.channel.Connector)destinationConnector, connectorModel, destinationIdMap);
        destinationConnector.setChannel(channel);
        DestinationConnectorProperties destinationConnectorProperties = ((DestinationConnectorPropertiesInterface)connectorProperties).getDestinationConnectorProperties();
        destinationConnector.setResourceIds(destinationConnectorProperties.getResourceIds().keySet());
        destinationConnector.setFilterTransformerExecutor(this.createFilterTransformerExecutor((com.mirth.connect.donkey.server.channel.Connector)destinationConnector, connectorModel, destinationIdMap, debugOptions));
        destinationConnector.setDestinationName(connectorModel.getName());
        destinationConnector.setMetaDataReplacer(channel.getSourceConnector().getMetaDataReplacer());
        destinationConnector.setMetaDataColumns(channel.getMetaDataColumns());
        DataTypeServerPlugin dataTypePlugin = ExtensionController.getInstance().getDataTypePlugins().get(connectorModel.getResponseTransformer().getInboundDataType());
        DataTypeProperties dataTypeProperties = connectorModel.getResponseTransformer().getInboundProperties();
        SerializerProperties serializerProperties = dataTypeProperties.getSerializerProperties();
        ResponseValidator responseValidator = dataTypePlugin.getResponseValidator(serializerProperties.getSerializationProperties(), dataTypeProperties.getResponseValidationProperties());
        if (responseValidator == null) {
            responseValidator = new DefaultResponseValidator();
        }
        destinationConnector.setResponseValidator(responseValidator);
        destinationConnector.setResponseTransformerExecutor(this.createResponseTransformerExecutor((com.mirth.connect.donkey.server.channel.Connector)destinationConnector, connectorModel, destinationIdMap, debugOptions));
        DestinationQueue queue = this.getDestinationQueue(channelModel, connectorModel, destinationConnector, destinationConnectorProperties);
        queue.setRotate(destinationConnector.isQueueRotate());
        if (destinationConnectorProperties.getQueueBufferSize() > 0) {
            queue.setBufferCapacity(destinationConnectorProperties.getQueueBufferSize());
        } else {
            queue.setBufferCapacity(this.queueBufferSize.get());
        }
        destinationConnector.setQueue(queue);
        return destinationConnector;
    }

    protected DestinationQueue getDestinationQueue(Channel channelModel, Connector connectorModel, DestinationConnector destinationConnector, DestinationConnectorProperties destinationConnectorProperties) {
        return new DestinationQueue(destinationConnectorProperties.getThreadAssignmentVariable(), destinationConnectorProperties.getThreadCount(), destinationConnectorProperties.isRegenerateTemplate(), destinationConnector.getSerializer(), destinationConnector.getMessageMaps());
    }

    private void setCommonConnectorProperties(String channelId, com.mirth.connect.donkey.server.channel.Connector connector, Connector connectorModel, Map<String, Integer> destinationIdMap) {
        connector.setChannelId(channelId);
        connector.setMetaDataId(connectorModel.getMetaDataId().intValue());
        connector.setConnectorProperties(connectorModel.getProperties());
        connector.setDestinationIdMap(destinationIdMap);
        Transformer transformerModel = connectorModel.getTransformer();
        connector.setInboundDataType(DataTypeFactory.getDataType(transformerModel.getInboundDataType(), transformerModel.getInboundProperties(), true));
        connector.setOutboundDataType(DataTypeFactory.getDataType(transformerModel.getOutboundDataType(), transformerModel.getOutboundProperties(), false));
    }

    private MetaDataReplacer createMetaDataReplacer(Connector connectorModel) {
        return new MirthMetaDataReplacer();
    }

    private void clearGlobalChannelMap(Channel channelModel) {
        if (channelModel.getProperties().isClearGlobalChannelMap()) {
            this.logger.debug("clearing global channel map for channel: " + channelModel.getId());
            GlobalChannelVariableStoreFactory.getInstance().get(channelModel.getId()).clear();
            GlobalChannelVariableStoreFactory.getInstance().get(channelModel.getId()).clearSync();
        }
    }

    private void clearGlobalMap() {
        try {
            if (this.configurationController.getServerSettings().getClearGlobalMap() == null || this.configurationController.getServerSettings().getClearGlobalMap().booleanValue()) {
                this.logger.debug("clearing global map");
                GlobalVariableStore globalVariableStore = GlobalVariableStore.getInstance();
                globalVariableStore.clear();
                globalVariableStore.clearSync();
            }
        }
        catch (ControllerException e) {
            this.logger.error("Could not clear the global map.", (Throwable)e);
        }
    }

    protected void executeGlobalDeployScript() {
        try {
            this.scriptController.executeGlobalDeployScript();
        }
        catch (Exception e) {
            this.logger.error("Error executing global deploy script.", (Throwable)e);
        }
    }

    protected void executeGlobalUndeployScript() {
        try {
            this.scriptController.executeGlobalUndeployScript();
        }
        catch (Exception e) {
            this.logger.error("Error executing global undeploy script.", (Throwable)e);
        }
    }

    protected void executeChannelPluginOnDeploy(ServerEventContext context) {
        for (ChannelPlugin channelPlugin : this.extensionController.getChannelPlugins().values()) {
            channelPlugin.deploy(context);
        }
    }

    protected void executeChannelPluginOnUndeploy(ServerEventContext context) {
        for (ChannelPlugin channelPlugin : this.extensionController.getChannelPlugins().values()) {
            channelPlugin.undeploy(context);
        }
    }

    protected void shutdownExecutor(String channelId) {
        ExecutorService engineExecutor = this.engineExecutors.get(channelId);
        if (engineExecutor != null) {
            List<Runnable> tasks = engineExecutor.shutdownNow();
            for (Runnable task : tasks) {
                ((Future)((Object)task)).cancel(true);
            }
        }
    }

    protected synchronized void removeExecutor(String channelId) {
        this.shutdownExecutor(channelId);
        this.engineExecutors.remove(channelId);
    }

    private List<ChannelTask> buildConnectorStatusTasks(Map<String, List<Integer>> connectorInfo, StatusTask task) {
        ArrayList<ChannelTask> tasks = new ArrayList<ChannelTask>();
        for (Map.Entry<String, List<Integer>> entry : connectorInfo.entrySet()) {
            String channelId = entry.getKey();
            List<Integer> metaDataIds = entry.getValue();
            for (Integer metaDataId : metaDataIds) {
                tasks.add(new ConnectorStatusTask(channelId, metaDataId, task));
            }
        }
        return tasks;
    }

    @Override
    public synchronized List<ChannelFuture> submitTasks(List<ChannelTask> tasks, ChannelTaskHandler handler) {
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        if (handler == null) {
            handler = new LoggingTaskHandler();
        }
        for (ChannelTask task : tasks) {
            ExecutorService engineExecutor = this.engineExecutors.get(task.getChannelId());
            if (engineExecutor == null) {
                engineExecutor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                this.engineExecutors.put(task.getChannelId(), engineExecutor);
            }
            task.setHandler(handler);
            try {
                futures.add(task.submitTo(engineExecutor));
            }
            catch (RejectedExecutionException e) {
                handler.taskErrored(task.getChannelId(), task.getMetaDataId(), e);
            }
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ChannelFuture> submitHaltTasks(Set<String> channelIds, ChannelTaskHandler handler) {
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        if (handler == null) {
            handler = new LoggingTaskHandler();
        }
        for (String channelId : channelIds) {
            this.shutdownExecutor(channelId);
            DonkeyEngineController donkeyEngineController = this;
            synchronized (donkeyEngineController) {
                this.shutdownExecutor(channelId);
                ThreadPoolExecutor engineExecutor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                this.engineExecutors.put(channelId, engineExecutor);
                HaltTask haltTask = new HaltTask(channelId);
                haltTask.setHandler(handler);
                futures.add(haltTask.submitTo(engineExecutor));
            }
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForTasks(List<ChannelFuture> futures) {
        ArrayList<ChannelFuture> remainingFutures = new ArrayList<ChannelFuture>(futures);
        int attemptsUntilPause = 10;
        while (CollectionUtils.isNotEmpty(remainingFutures)) {
            if (attemptsUntilPause > 0) {
                --attemptsUntilPause;
            } else {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Iterator iterator = remainingFutures.iterator();
            while (iterator.hasNext()) {
                boolean finished = false;
                ChannelFuture future = (ChannelFuture)iterator.next();
                try {
                    if (remainingFutures.size() == 1) {
                        future.get();
                    } else {
                        future.get(50L, TimeUnit.MILLISECONDS);
                    }
                    finished = true;
                }
                catch (TimeoutException timeoutException) {}
                continue;
                finally {
                    if (!finished) continue;
                    iterator.remove();
                }
            }
        }
    }

    protected DeployTask createDeployTask(String channelId, DeployedState initialState, Set<Integer> connectorsToStart, ServerEventContext context, DebugOptions debugOptions) {
        return new DeployTask(channelId, initialState, connectorsToStart, context, debugOptions);
    }

    protected UndeployTask createUndeployTask(String channelId, String unDeployScript, ServerEventContext context, Channel channelModel) {
        return new UndeployTask(channelId, unDeployScript, context, channelModel);
    }

    protected class UndeployTask
    extends ChannelTask {
        private MirthScopeProvider scopeProvider;
        private ServerEventContext context;

        public UndeployTask(String channelId, String unDeployScript, ServerEventContext context, Channel channelModel) {
            super(channelId);
            this.context = context;
            this.scopeProvider = new MirthScopeProvider();
        }

        @Override
        public Void execute() throws Exception {
            com.mirth.connect.donkey.server.channel.Channel channel = DonkeyEngineController.this.getDeployedChannel(this.channelId);
            if (channel != null) {
                this.doUndeploy(channel);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUndeploy(com.mirth.connect.donkey.server.channel.Channel channel) throws Exception {
            if (channel.isActive()) {
                channel.stop();
            }
            try {
                DonkeyEngineController.this.undeployingChannels.add(channel);
                DonkeyEngineController.this.donkey.getDeployedChannels().remove(this.channelId);
                channel.undeploy();
                if (channel.getSourceConnector().getFilterTransformerExecutor().getFilterTransformer() != null) {
                    channel.getSourceConnector().getFilterTransformerExecutor().getFilterTransformer().dispose();
                }
                for (DestinationChainProvider chainProvider : channel.getDestinationChainProviders()) {
                    for (Integer metaDataId : chainProvider.getDestinationConnectors().keySet()) {
                        if (((DestinationConnector)chainProvider.getDestinationConnectors().get(metaDataId)).getFilterTransformerExecutor().getFilterTransformer() != null) {
                            ((DestinationConnector)chainProvider.getDestinationConnectors().get(metaDataId)).getFilterTransformerExecutor().getFilterTransformer().dispose();
                        }
                        if (((DestinationConnector)chainProvider.getDestinationConnectors().get(metaDataId)).getResponseTransformerExecutor().getResponseTransformer() == null) continue;
                        ((DestinationConnector)chainProvider.getDestinationConnectors().get(metaDataId)).getResponseTransformerExecutor().getResponseTransformer().dispose();
                    }
                }
                for (ChannelPlugin channelPlugin : DonkeyEngineController.this.extensionController.getChannelPlugins().values()) {
                    channelPlugin.undeploy(this.channelId, this.context);
                }
                String undeployScriptId = ScriptController.getScriptId("Undeploy", this.getChannelId());
                MirthMain undeployDebugger = null;
                try {
                    DebugOptions debugOptions = channel.getDebugOptions();
                    boolean debug = debugOptions != null && debugOptions.isDeployUndeployPreAndPostProcessorScripts();
                    MirthContextFactory undeployContextFactory = null;
                    if (debug) {
                        undeployContextFactory = DonkeyEngineController.this.contextFactoryController.getDebugContextFactory(channel.getResourceIds(), this.getChannelId(), undeployScriptId);
                        if (JavaScriptUtil.getCompiledScript(undeployScriptId) != null) {
                            undeployDebugger = JavaScriptUtil.getDebugger(undeployContextFactory, this.scopeProvider, channel, undeployScriptId, true);
                        }
                    } else {
                        undeployContextFactory = DonkeyEngineController.this.contextFactoryController.getContextFactory(channel.getResourceIds());
                        if (!channel.getContextFactoryId().equals(undeployContextFactory.getId())) {
                            JavaScriptUtil.recompileChannelScript(undeployContextFactory, this.channelId, "Undeploy");
                            channel.setContextFactoryId(undeployContextFactory.getId());
                        }
                    }
                    DonkeyEngineController.this.scriptController.executeChannelUndeployScript(undeployContextFactory, this.channelId, channel.getName());
                }
                catch (Exception e) {
                    Throwable t = e;
                    if (e instanceof JavaScriptExecutorException) {
                        t = e.getCause();
                    }
                    DonkeyEngineController.this.eventController.dispatchEvent((Event)new ErrorEvent(this.channelId, null, null, ErrorEventType.UNDEPLOY_SCRIPT, null, null, "Error running channel undeploy script", t));
                    DonkeyEngineController.this.logger.error("Error executing undeploy script for channel " + this.channelId + ".", (Throwable)e);
                }
                DonkeyEngineController.this.scriptController.removeChannelScriptsFromCache(this.channelId);
                if (undeployDebugger != null) {
                    DonkeyEngineController.this.contextFactoryController.removeDebugContextFactory(channel.getResourceIds(), channel.getChannelId(), undeployScriptId);
                    undeployDebugger.dispose();
                    undeployDebugger = null;
                }
                JavaScriptUtil.removeDebuggerFromMap(this.channelId);
                DonkeyEngineController.this.channelController.removeDeployedChannelFromCache(this.channelId);
            }
            finally {
                DonkeyEngineController.this.undeployingChannels.remove(channel);
            }
        }
    }

    protected class DeployTask
    extends ChannelTask {
        private DeployedState initialState;
        private Set<Integer> connectorsToStart;
        private ServerEventContext context;
        private DebugOptions debugOptions;
        private MirthScopeProvider scopeProvider;

        public DeployTask(String channelId, DeployedState initialState, Set<Integer> connectorsToStart, ServerEventContext context, DebugOptions debugOptions) {
            super(channelId);
            this.initialState = initialState;
            this.connectorsToStart = connectorsToStart;
            this.context = context;
            this.debugOptions = debugOptions;
            this.scopeProvider = new MirthScopeProvider();
        }

        @Override
        public Void execute() throws Exception {
            this.doDeploy(DonkeyEngineController.this.channelController.getChannelById(this.channelId));
            return null;
        }

        protected boolean checkEnabled(Channel channelModel) {
            ChannelMetadata metadata = DonkeyEngineController.this.configurationController.getChannelMetadata().get(channelModel.getId());
            return metadata == null || metadata.isEnabled();
        }

        protected com.mirth.connect.donkey.server.channel.Channel doDeploy(Channel channelModel) throws Exception {
            if (channelModel == null || channelModel instanceof InvalidChannel) {
                return null;
            }
            if (!this.checkEnabled(channelModel) || DonkeyEngineController.this.isDeployed(this.channelId)) {
                return null;
            }
            com.mirth.connect.donkey.server.channel.Channel channel = null;
            try {
                channel = DonkeyEngineController.this.createChannelFromModel(channelModel, this.debugOptions);
            }
            catch (Exception e) {
                throw new DeployException(e.getMessage(), (Throwable)e);
            }
            try {
                MirthContextFactory contextFactory;
                channel.updateCurrentState(DeployedState.DEPLOYING);
                DonkeyEngineController.this.deployingChannels.add(channel);
                DonkeyEngineController.this.channelController.putDeployedChannelInCache(channelModel);
                try {
                    Boolean debug;
                    if (this.debugOptions != null && !this.debugOptions.isEmpty()) {
                        try {
                            DebugUsage debugUsage = new DebugUsage();
                            debugUsage.setServerId(DonkeyEngineController.this.configurationController.getServerId());
                            if (this.debugOptions.isDeployUndeployPreAndPostProcessorScripts()) {
                                debugUsage.setDuppCount(1);
                            }
                            if (this.debugOptions.isAttachmentBatchScripts()) {
                                debugUsage.setAttachBatchCount(1);
                            }
                            if (this.debugOptions.isSourceConnectorScripts()) {
                                debugUsage.setSourceConnectorCount(1);
                            }
                            if (this.debugOptions.isSourceFilterTransformer()) {
                                debugUsage.setSourceFilterTransCount(1);
                            }
                            if (this.debugOptions.isDestinationFilterTransformer()) {
                                debugUsage.setDestinationFilterTransCount(1);
                            }
                            if (this.debugOptions.isDestinationConnectorScripts()) {
                                debugUsage.setDestinationConnectorCount(1);
                            }
                            if (this.debugOptions.isDestinationResponseTransformer()) {
                                debugUsage.setResponseCount(1);
                            }
                            debugUsage.setInvocationCount(1);
                            DonkeyEngineController.this.getDebugUsageController().upsertDebugUsage(debugUsage);
                        }
                        catch (ControllerException debugUsage) {
                            // empty catch block
                        }
                    }
                    if ((debug = Boolean.valueOf(this.debugOptions != null && this.debugOptions.isDeployUndeployPreAndPostProcessorScripts())).booleanValue()) {
                        String deployScriptId = ScriptController.getScriptId("Deploy", this.getChannelId());
                        contextFactory = DonkeyEngineController.this.contextFactoryController.getDebugContextFactory(channelModel.getProperties().getResourceIds().keySet(), this.getChannelId(), deployScriptId);
                        MirthMain debugger = JavaScriptUtil.getDebugger(contextFactory, this.scopeProvider, channelModel, deployScriptId, true);
                        if (!JavaScriptUtil.compileAndAddScript(this.channelId, contextFactory, deployScriptId, channelModel.getDeployScript(), ContextType.CHANNEL_DEPLOY)) {
                            debugger.dispose();
                        }
                        String undeployScriptId = ScriptController.getScriptId("Undeploy", this.getChannelId());
                        MirthContextFactory undeployContextFactory = DonkeyEngineController.this.contextFactoryController.getDebugContextFactory(channelModel.getProperties().getResourceIds().keySet(), this.getChannelId(), undeployScriptId);
                        MirthMain undeployDebugger = JavaScriptUtil.getDebugger(undeployContextFactory, this.scopeProvider, channelModel, undeployScriptId, false);
                        if (!JavaScriptUtil.compileAndAddScript(this.channelId, undeployContextFactory, undeployScriptId, channelModel.getUndeployScript(), ContextType.CHANNEL_UNDEPLOY)) {
                            undeployDebugger.dispose();
                        }
                        String preprocScriptId = ScriptController.getScriptId("Preprocessor", this.getChannelId());
                        MirthContextFactory preprocContextFactory = DonkeyEngineController.this.contextFactoryController.getDebugContextFactory(channelModel.getProperties().getResourceIds().keySet(), this.getChannelId(), preprocScriptId);
                        MirthMain preprocDebugger = JavaScriptUtil.getDebugger(preprocContextFactory, this.scopeProvider, channelModel, preprocScriptId, false);
                        if (!JavaScriptUtil.compileAndAddScript(this.channelId, preprocContextFactory, preprocScriptId, channelModel.getPreprocessingScript(), ContextType.CHANNEL_PREPROCESSOR)) {
                            preprocDebugger.dispose();
                        }
                        String postprocScriptId = ScriptController.getScriptId("Postprocessor", this.getChannelId());
                        MirthContextFactory postprocContextFactory = DonkeyEngineController.this.contextFactoryController.getDebugContextFactory(channelModel.getProperties().getResourceIds().keySet(), this.getChannelId(), postprocScriptId);
                        MirthMain postprocDebugger = JavaScriptUtil.getDebugger(postprocContextFactory, this.scopeProvider, channelModel, postprocScriptId, false);
                        if (!JavaScriptUtil.compileAndAddScript(this.channelId, postprocContextFactory, postprocScriptId, channelModel.getPostprocessingScript(), ContextType.CHANNEL_POSTPROCESSOR)) {
                            postprocDebugger.dispose();
                        }
                    } else {
                        contextFactory = DonkeyEngineController.this.contextFactoryController.getContextFactory(channelModel.getProperties().getResourceIds().keySet());
                        contextFactory.setContextType(ContextType.CHANNEL_DEPLOY);
                        contextFactory.setScriptText(channelModel.getDeployScript());
                        contextFactory.setDebugType(false);
                        DonkeyEngineController.this.scriptController.compileChannelScripts(contextFactory, channelModel);
                    }
                }
                catch (Exception e) {
                    throw new DeployException("Failed to deploy channel " + this.channelId + ".", (Throwable)e);
                }
                DonkeyEngineController.this.clearGlobalChannelMap(channelModel);
                try {
                    DonkeyEngineController.this.scriptController.executeChannelDeployScript(contextFactory, this.channelId, channel.getName());
                }
                catch (Exception e) {
                    Throwable t = e;
                    if (e instanceof JavaScriptExecutorException) {
                        t = e.getCause();
                    }
                    DonkeyEngineController.this.eventController.dispatchEvent((Event)new ErrorEvent(channelModel.getId(), null, null, ErrorEventType.DEPLOY_SCRIPT, null, null, "Error running channel deploy script", t));
                    throw new DeployException("Failed to deploy channel " + this.channelId + ".", (Throwable)e);
                }
                for (ChannelPlugin channelPlugin : DonkeyEngineController.this.extensionController.getChannelPlugins().values()) {
                    channelPlugin.deploy(channelModel, this.context);
                }
                channel.setRevision(channelModel.getRevision().intValue());
                channel.setDeployDate(Calendar.getInstance());
                DonkeyEngineController.this.donkey.getDeployedChannels().put(this.channelId, channel);
                try {
                    if (this.debugOptions != null) {
                        channel.debugDeploy(this.debugOptions);
                    } else {
                        channel.deploy();
                    }
                }
                catch (DeployException e) {
                    DonkeyEngineController.this.donkey.getDeployedChannels().remove(this.channelId);
                    throw e;
                }
                if (this.initialState == null) {
                    this.initialState = channel.getInitialState();
                }
                if (this.connectorsToStart == null) {
                    this.connectorsToStart = new HashSet<Integer>(channel.getMetaDataIds());
                }
                if (this.initialState == DeployedState.PAUSED) {
                    this.connectorsToStart.remove(0);
                } else if (this.initialState == DeployedState.STOPPED) {
                    this.connectorsToStart.clear();
                }
                if (!this.connectorsToStart.contains(0)) {
                    channel.getSourceConnector().updateCurrentState(DeployedState.STOPPED);
                }
                for (DestinationChainProvider destinationChainProvider : channel.getDestinationChainProviders()) {
                    for (Map.Entry entry : destinationChainProvider.getDestinationConnectors().entrySet()) {
                        if (this.connectorsToStart.contains(entry.getKey())) continue;
                        ((DestinationConnector)entry.getValue()).updateCurrentState(DeployedState.STOPPED);
                    }
                }
                if (this.initialState == DeployedState.STOPPED) {
                    channel.updateCurrentState(DeployedState.STOPPED);
                } else {
                    channel.start(this.connectorsToStart);
                }
                com.mirth.connect.donkey.server.channel.Channel channel2 = channel;
                return channel2;
            }
            catch (DeployException e) {
                DonkeyEngineController.this.channelController.removeDeployedChannelFromCache(this.channelId);
                DonkeyEngineController.this.scriptController.removeChannelScriptsFromCache(this.channelId);
                throw e;
            }
            finally {
                DonkeyEngineController.this.deployingChannels.remove(channel);
            }
        }
    }

    private static enum StatusTask {
        START,
        STOP,
        PAUSE,
        RESUME;

    }

    protected class ChannelStatusTask
    extends ChannelTask {
        private StatusTask task;

        public ChannelStatusTask(String channelId, StatusTask task) {
            super(channelId);
            this.task = task;
        }

        @Override
        public Void execute() throws Exception {
            com.mirth.connect.donkey.server.channel.Channel channel = DonkeyEngineController.this.getDeployedChannel(this.channelId);
            if (channel != null) {
                if (this.task == StatusTask.START) {
                    channel.start(null);
                } else if (this.task == StatusTask.STOP) {
                    channel.stop();
                } else if (this.task == StatusTask.PAUSE) {
                    channel.pause();
                } else if (this.task == StatusTask.RESUME) {
                    channel.resume();
                }
            }
            return null;
        }
    }

    protected class RemoveTask
    extends ChannelTask {
        private Channel channelModel;
        private ServerEventContext context;

        public RemoveTask(Channel channelModel, ServerEventContext context) {
            super(channelModel.getId());
            this.channelModel = channelModel;
            this.context = context;
        }

        @Override
        public Void execute() throws Exception {
            DonkeyEngineController.this.channelController.removeChannel(this.channelModel, this.context);
            DonkeyEngineController.this.removeExecutor(this.channelId);
            return null;
        }
    }

    protected class RemoveMessagesTask
    extends ChannelTask {
        private Map<Long, MessageSearchResult> results;

        public RemoveMessagesTask(String channelId, Map<Long, MessageSearchResult> results) {
            super(channelId);
            this.results = results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void execute() throws Exception {
            HashMap<Long, Set<Integer>> messages = new HashMap<Long, Set<Integer>>();
            for (Map.Entry<Long, MessageSearchResult> entry : this.results.entrySet()) {
                Long messageId = entry.getKey();
                MessageSearchResult result = entry.getValue();
                Set<Integer> metaDataIds = result.getMetaDataIdSet();
                boolean processed = result.isProcessed();
                com.mirth.connect.donkey.server.channel.Channel channel = DonkeyEngineController.this.getDeployedChannel(this.channelId);
                if (channel != null && channel.getCurrentState() != DeployedState.STOPPED && !processed) continue;
                if (metaDataIds.contains(0)) {
                    messages.put(messageId, null);
                    continue;
                }
                messages.put(messageId, metaDataIds);
            }
            com.mirth.connect.donkey.server.channel.Channel.DELETE_PERMIT.acquire();
            try {
                com.mirth.connect.donkey.server.controllers.MessageController.getInstance().deleteMessages(this.channelId, messages);
            }
            finally {
                com.mirth.connect.donkey.server.channel.Channel.DELETE_PERMIT.release();
            }
            return null;
        }
    }

    protected class RemoveAllMessagesTask
    extends ChannelTask {
        private boolean force;
        private boolean clearStatistics;

        public RemoveAllMessagesTask(String channelId, boolean force, boolean clearStatistics) {
            super(channelId);
            this.force = force;
            this.clearStatistics = clearStatistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void execute() throws Exception {
            com.mirth.connect.donkey.server.channel.Channel channel = DonkeyEngineController.this.getDeployedChannel(this.channelId);
            if (channel != null) {
                channel.removeAllMessages(this.force, this.clearStatistics);
            } else {
                Channel channelModel = DonkeyEngineController.this.channelController.getChannelById(this.channelId);
                if (channelModel != null) {
                    DonkeyDao dao = null;
                    boolean commitSuccess = false;
                    try {
                        dao = DonkeyEngineController.this.donkey.getDaoFactory().getDao();
                        dao.deleteAllMessages(this.channelId);
                        if (this.clearStatistics) {
                            Set statuses = Statistics.getTrackedStatuses();
                            dao.resetStatistics(this.channelId, null, statuses);
                            for (Connector connector : channelModel.getDestinationConnectors()) {
                                dao.resetStatistics(this.channelId, connector.getMetaDataId(), statuses);
                            }
                        }
                        dao.commit();
                        commitSuccess = true;
                    }
                    finally {
                        if (dao != null) {
                            if (!commitSuccess) {
                                try {
                                    dao.rollback();
                                }
                                catch (Exception exception) {}
                            }
                            dao.close();
                        }
                    }
                }
            }
            return null;
        }
    }

    protected class ConnectorStatusTask
    extends ChannelTask {
        private StatusTask task;

        public ConnectorStatusTask(String channelId, Integer metaDataId, StatusTask task) {
            super(channelId, metaDataId);
            this.task = task;
        }

        @Override
        public Void execute() throws Exception {
            com.mirth.connect.donkey.server.channel.Channel channel = DonkeyEngineController.this.getDeployedChannel(this.channelId);
            if (channel != null) {
                if (this.task == StatusTask.START) {
                    channel.startConnector(this.metaDataId);
                } else if (this.task == StatusTask.STOP) {
                    channel.stopConnector(this.metaDataId);
                }
            }
            return null;
        }
    }

    protected class HaltTask
    extends ChannelTask {
        public HaltTask(String channelId) {
            super(channelId);
        }

        @Override
        public Void execute() throws Exception {
            com.mirth.connect.donkey.server.channel.Channel channel = DonkeyEngineController.this.getDeployedChannel(this.channelId);
            if (channel != null) {
                channel.halt();
            }
            return null;
        }
    }
}

