/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.controllers.ChannelController;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.message.DataType;
import com.mirth.connect.donkey.util.MapUtil;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.model.filters.elements.ContentSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchElement;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.channel.ErrorTaskHandler;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.mybatis.MessageSearchResult;
import com.mirth.connect.server.mybatis.MessageTextResult;
import com.mirth.connect.server.util.DICOMMessageUtil;
import com.mirth.connect.server.util.ListRangeIterator;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.util.AttachmentUtil;
import com.mirth.connect.util.MessageEncryptionUtil;
import com.mirth.connect.util.MessageExporter;
import com.mirth.connect.util.MessageImporter;
import com.mirth.connect.util.PaginatedList;
import com.mirth.connect.util.messagewriter.AttachmentSource;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import com.mirth.connect.util.messagewriter.MessageWriterFactory;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DonkeyMessageController
extends MessageController {
    private static MessageController instance = null;
    private Donkey donkey = Donkey.getInstance();
    private Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageController create() {
        Class<DonkeyMessageController> clazz = DonkeyMessageController.class;
        synchronized (DonkeyMessageController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(MessageController.class)) == null) {
                instance = new DonkeyMessageController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DonkeyMessageController() {
    }

    private Map<String, Object> getBasicParameters(MessageFilter filter, Long localChannelId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("localChannelId", localChannelId);
        params.put("originalIdLower", filter.getOriginalIdLower());
        params.put("originalIdUpper", filter.getOriginalIdUpper());
        params.put("importIdLower", filter.getImportIdLower());
        params.put("importIdUpper", filter.getImportIdUpper());
        params.put("startDate", filter.getStartDate());
        params.put("endDate", filter.getEndDate());
        params.put("serverId", filter.getServerId());
        params.put("statuses", filter.getStatuses());
        params.put("includedMetaDataIds", filter.getIncludedMetaDataIds());
        params.put("excludedMetaDataIds", filter.getExcludedMetaDataIds());
        params.put("sendAttemptsLower", filter.getSendAttemptsLower());
        params.put("sendAttemptsUpper", filter.getSendAttemptsUpper());
        params.put("attachment", filter.getAttachment());
        params.put("error", filter.getError());
        params.put("textSearch", filter.getTextSearch());
        params.put("textSearchRegex", filter.getTextSearchRegex());
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxMessageId(String channelId, boolean readOnly) {
        try (DonkeyDao dao = this.getDao(readOnly);){
            long l = dao.getMaxMessageId(channelId);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinMessageId(String channelId, boolean readOnly) {
        try (DonkeyDao dao = this.getDao(readOnly);){
            long l = dao.getMinMessageId(channelId);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getMessageCount(MessageFilter filter, String channelId) {
        if (filter.getIncludedMetaDataIds() != null && filter.getIncludedMetaDataIds().isEmpty() && filter.getExcludedMetaDataIds() == null) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        FilterOptions filterOptions = new FilterOptions(filter, channelId, true);
        long maxMessageId = filterOptions.getMaxMessageId();
        long minMessageId = filterOptions.getMinMessageId();
        Long localChannelId = ChannelController.getInstance().getLocalChannelId(channelId, true);
        Map<String, Object> params = this.getBasicParameters(filter, localChannelId);
        try {
            SqlSessionManager session = this.getSqlSessionManager(true);
            long count = 0L;
            long batchSize = 50000L;
            while (maxMessageId >= minMessageId) {
                long currentMinMessageId = Math.max(maxMessageId - batchSize + 1L, minMessageId);
                params.put("maxMessageId", maxMessageId);
                params.put("minMessageId", currentMinMessageId);
                maxMessageId -= batchSize;
                Map<Long, MessageSearchResult> foundMessages = this.searchAll((SqlSession)session, params, filter, localChannelId, false, filterOptions);
                count += (long)foundMessages.size();
            }
            Long l = count;
            return l;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.logger.debug("Count executed in " + (endTime - startTime) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessages(MessageFilter filter, String channelId, Boolean includeContent, Integer offset, Integer limit) {
        includeContent = includeContent == null ? false : includeContent;
        offset = offset == null ? 0 : offset;
        limit = limit == null ? 20 : limit;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (filter.getIncludedMetaDataIds() != null && filter.getIncludedMetaDataIds().isEmpty() && filter.getExcludedMetaDataIds() == null) {
            return messages;
        }
        List<MessageSearchResult> results = this.searchMessages(filter, channelId, offset, limit);
        dao.setDecryptData(includeContent == false);
        try (DonkeyDao dao = this.getDao(true);){
            for (MessageSearchResult result : results) {
                Message message = result.getMessage();
                message.setChannelId(channelId);
                List connectorMessages = dao.getConnectorMessages(channelId, message.getMessageId().longValue(), result.getMetaDataIdSet(), includeContent.booleanValue());
                for (ConnectorMessage connectorMessage : connectorMessages) {
                    message.getConnectorMessages().put(connectorMessage.getMetaDataId(), connectorMessage);
                }
                messages.add(message);
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessageContent(String channelId, Long messageId, List<Integer> metaDataIds) {
        try (DonkeyDao dao = this.getDao(true);){
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("localChannelId", ChannelController.getInstance().getLocalChannelId(channelId, true));
            params.put("messageId", messageId);
            Message message = (Message)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("Message.selectMessageById", params);
            if (message != null) {
                message.setChannelId(channelId);
            }
            Map connectorMessages = dao.getConnectorMessages(channelId, messageId.longValue(), metaDataIds);
            for (Map.Entry connectorMessageEntry : connectorMessages.entrySet()) {
                Integer metaDataId = (Integer)connectorMessageEntry.getKey();
                ConnectorMessage connectorMessage = (ConnectorMessage)connectorMessageEntry.getValue();
                message.getConnectorMessages().put(metaDataId, connectorMessage);
            }
            Message message2 = message;
            return message2;
        }
    }

    @Override
    public List<Attachment> getMessageAttachmentIds(String channelId, Long messageId, boolean readOnly) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("localChannelId", ChannelController.getInstance().getLocalChannelId(channelId, readOnly));
        params.put("messageId", messageId);
        return this.getSqlSessionManager(readOnly).selectList("Message.selectMessageAttachmentIds", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attachment getMessageAttachment(String channelId, String attachmentId, Long messageId, boolean readOnly) {
        try (DonkeyDao dao = this.getDao(readOnly);){
            Attachment attachment = dao.getMessageAttachment(channelId, attachmentId, messageId);
            return attachment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attachment> getMessageAttachment(String channelId, Long messageId, boolean readOnly) {
        try (DonkeyDao dao = this.getDao(readOnly);){
            List list = dao.getMessageAttachment(channelId, messageId.longValue());
            return list;
        }
    }

    @Override
    public void removeMessages(String channelId, MessageFilter filter) {
        Channel channel;
        EngineController engineController = ControllerFactory.getFactory().createEngineController();
        FilterOptions filterOptions = new FilterOptions(filter, channelId, false);
        long minMessageId = filterOptions.getMinMessageId();
        Long localChannelId = ChannelController.getInstance().getLocalChannelId(channelId);
        Map<String, Object> params = this.getBasicParameters(filter, localChannelId);
        params.put("includeProcessed", true);
        SqlSessionManager session = this.getSqlSessionManager(true);
        long batchSize = 50000L;
        for (long maxMessageId = filterOptions.getMaxMessageId(); maxMessageId >= minMessageId; maxMessageId -= batchSize) {
            long currentMinMessageId = Math.max(maxMessageId - batchSize + 1L, minMessageId);
            params.put("maxMessageId", maxMessageId);
            params.put("minMessageId", currentMinMessageId);
            Map<Long, MessageSearchResult> results = this.searchAll((SqlSession)session, params, filter, localChannelId, true, filterOptions);
            ErrorTaskHandler handler = new ErrorTaskHandler();
            engineController.removeMessages(channelId, results, handler);
            if (!handler.isErrored()) continue;
            this.logger.error("Remove messages task terminated due to error or halt.", (Throwable)handler.getError());
            break;
        }
        if ((channel = engineController.getDeployedChannel(channelId)) != null) {
            channel.invalidateQueues();
        }
    }

    @Override
    public void reprocessMessages(String channelId, MessageFilter filter, boolean replace, Collection<Integer> reprocessMetaDataIds) throws ControllerException {
        EngineController engineController = ControllerFactory.getFactory().createEngineController();
        Channel deployedChannel = engineController.getDeployedChannel(channelId);
        if (deployedChannel == null) {
            throw new ControllerException("Channel is no longer deployed!");
        }
        AttachmentHandlerProvider attachmentHandlerProvider = deployedChannel.getAttachmentHandlerProvider();
        DataType dataType = deployedChannel.getSourceConnector().getInboundDataType();
        boolean isBinary = ExtensionController.getInstance().getDataTypePlugins().get(dataType.getType()).isBinary();
        Encryptor encryptor = ConfigurationController.getInstance().getEncryptor();
        FilterOptions filterOptions = new FilterOptions(filter, channelId, false);
        long maxMessageId = filterOptions.getMaxMessageId();
        long minMessageId = filterOptions.getMinMessageId();
        Long localChannelId = ChannelController.getInstance().getLocalChannelId(channelId);
        Map<String, Object> params = this.getBasicParameters(filter, localChannelId);
        params.put("includeImportId", true);
        SqlSessionManager session = this.getSqlSessionManager(true);
        long batchSize = 50000L;
        while (maxMessageId >= minMessageId) {
            long currentMaxMessageId = Math.min(minMessageId + batchSize - 1L, maxMessageId);
            params.put("maxMessageId", currentMaxMessageId);
            params.put("minMessageId", minMessageId);
            minMessageId += batchSize;
            TreeMap<Long, MessageSearchResult> foundMessages = new TreeMap<Long, MessageSearchResult>(this.searchAll((SqlSession)session, params, filter, localChannelId, true, filterOptions));
            for (Map.Entry entry : foundMessages.entrySet()) {
                Long messageId = (Long)entry.getKey();
                Long importId = ((MessageSearchResult)entry.getValue()).getImportId();
                params.put("messageId", messageId);
                List contentList = session.selectList("Message.selectMessageForReprocessing", params);
                MessageContent rawContent = null;
                MessageContent sourceMapContent = null;
                if (contentList != null) {
                    for (MessageContent content : contentList) {
                        if (content.getContentType() == ContentType.RAW) {
                            rawContent = content;
                            continue;
                        }
                        if (content.getContentType() != ContentType.SOURCE_MAP) continue;
                        sourceMapContent = content;
                    }
                }
                if (rawContent != null) {
                    if (rawContent.isEncrypted()) {
                        rawContent.setContent(encryptor.decrypt(rawContent.getContent()));
                        rawContent.setEncrypted(false);
                    }
                    ConnectorMessage connectorMessage = new ConnectorMessage();
                    connectorMessage.setChannelId(channelId);
                    connectorMessage.setMessageId(messageId.longValue());
                    connectorMessage.setMetaDataId(0);
                    connectorMessage.setRaw(rawContent);
                    HashMap remainingAttachments = new HashMap();
                    RawMessage rawMessage = null;
                    rawMessage = isBinary ? new RawMessage(DICOMMessageUtil.getDICOMRawBytes(connectorMessage)) : new RawMessage(StringUtils.newString((byte[])attachmentHandlerProvider.reAttachMessage(rawContent.getContent(), connectorMessage, "UTF-8", false, true, true, remainingAttachments), (String)"UTF-8"));
                    if (MapUtils.isNotEmpty(remainingAttachments)) {
                        rawMessage.setAttachments(new ArrayList(remainingAttachments.values()));
                    }
                    rawMessage.setOverwrite(replace);
                    rawMessage.setImported(importId != null);
                    rawMessage.setOriginalMessageId(messageId);
                    try {
                        Map sourceMap = rawMessage.getSourceMap();
                        if (sourceMapContent != null && sourceMapContent.getContent() != null) {
                            if (sourceMapContent.isEncrypted()) {
                                sourceMapContent.setContent(encryptor.decrypt(sourceMapContent.getContent()));
                                sourceMapContent.setEncrypted(false);
                            }
                            sourceMap.putAll(MapUtil.deserializeMap((Serializer)ObjectXMLSerializer.getInstance(), (String)sourceMapContent.getContent()));
                        }
                        sourceMap.put("reprocessed", true);
                        sourceMap.put("replaced", replace);
                        rawMessage.setDestinationMetaDataIds(reprocessMetaDataIds);
                        engineController.dispatchRawMessage(channelId, rawMessage, true, false);
                        continue;
                    }
                    catch (SerializerException e) {
                        this.logger.error("Could not reprocess message " + messageId + " for channel " + channelId + " because the source map content is invalid.", (Throwable)e);
                        continue;
                    }
                    catch (ChannelException e) {
                        if (!e.isStopped()) continue;
                        this.logger.error("Reprocessing job cancelled because the channel is stopping or stopped.", (Throwable)e);
                        return;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                this.logger.error("Could not reprocess message " + messageId + " for channel " + channelId + " because no source raw content was found. The content may have been pruned or the channel may not be configured to store raw content.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportMessages(final String channelId, final MessageFilter messageFilter, int pageSize, MessageWriterOptions options) throws MessageExporter.MessageExportException, InterruptedException {
        int n;
        final DonkeyMessageController messageController = this;
        PaginatedList<Message> messageList = new PaginatedList<Message>(){

            @Override
            public Long getItemCount() {
                return messageController.getMessageCount(messageFilter, channelId);
            }

            @Override
            protected List<Message> getItems(int offset, int limit) throws Exception {
                return messageController.getMessages(messageFilter, channelId, true, offset, limit);
            }
        };
        messageList.setPageSize(pageSize);
        MessageWriter messageWriter = MessageWriterFactory.getInstance().getMessageWriter(options, ConfigurationController.getInstance().getEncryptor());
        AttachmentSource attachmentSource = null;
        if (options.includeAttachments()) {
            attachmentSource = new AttachmentSource(){

                @Override
                public List<Attachment> getMessageAttachments(Message message) {
                    return MessageController.getInstance().getMessageAttachment(message.getChannelId(), message.getMessageId(), true);
                }
            };
        }
        try {
            int numExported = new MessageExporter().exportMessages(messageList, messageWriter, attachmentSource, options);
            messageWriter.finishWrite();
            n = numExported;
        }
        catch (Throwable throwable) {
            try {
                messageWriter.close();
                throw throwable;
            }
            catch (MessageWriterException e) {
                throw new MessageExporter.MessageExportException(e);
            }
        }
        messageWriter.close();
        return n;
    }

    @Override
    public void exportAttachment(String channelId, String attachmentId, Long messageId, String filePath, boolean binary) throws IOException {
        AttachmentUtil.writeToFile(filePath, this.getMessageAttachment(channelId, attachmentId, messageId, true), binary);
    }

    @Override
    public void importMessage(String channelId, Message message) throws MessageImporter.MessageImportException {
        try {
            MessageEncryptionUtil.decryptMessage(message, ConfigurationController.getInstance().getEncryptor());
            Channel channel = (Channel)this.donkey.getDeployedChannels().get(channelId);
            if (channel == null) {
                throw new MessageImporter.MessageImportException("Failed to import message, channel ID " + channelId + " is not currently deployed");
            }
            channel.importMessage(message);
        }
        catch (DonkeyException e) {
            throw new MessageImporter.MessageImportException(e);
        }
    }

    @Override
    public MessageImportResult importMessagesServer(String channelId, String path, boolean includeSubfolders) throws MessageImporter.MessageImportException, InterruptedException, MessageImporter.MessageImportInvalidPathException {
        Channel channel = (Channel)this.donkey.getDeployedChannels().get(channelId);
        if (channel == null) {
            throw new MessageImporter.MessageImportException("Failed to import message, channel ID " + channelId + " is not currently deployed");
        }
        MessageWriterChannel messageWriter = new MessageWriterChannel(channel);
        return new MessageImporter().importMessages(path, includeSubfolders, messageWriter, System.getProperty("user.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageSearchResult> searchMessages(MessageFilter filter, String channelId, int offset, int limit) {
        long startTime = System.currentTimeMillis();
        FilterOptions filterOptions = new FilterOptions(filter, channelId, true);
        long maxMessageId = filterOptions.getMaxMessageId();
        long minMessageId = filterOptions.getMinMessageId();
        Long localChannelId = ChannelController.getInstance().getLocalChannelId(channelId, true);
        Map<String, Object> params = this.getBasicParameters(filter, localChannelId);
        try {
            TreeMap<Long, MessageSearchResult> messages = new TreeMap<Long, MessageSearchResult>();
            SqlSessionManager session = this.getSqlSessionManager(true);
            int offsetRemaining = offset;
            long batchSize = Math.min(Math.max(limit, 500), 50000);
            long totalSearched = 0L;
            while (messages.size() < limit && maxMessageId >= minMessageId) {
                if (totalSearched >= 100000L && batchSize < 50000L) {
                    batchSize = 50000L;
                } else if (totalSearched >= 10000L && batchSize < 10000L) {
                    batchSize = 10000L;
                } else if (totalSearched >= 1000L && batchSize < 1000L) {
                    batchSize = 1000L;
                }
                long currentMinMessageId = Math.max(maxMessageId - batchSize + 1L, minMessageId);
                params.put("maxMessageId", maxMessageId);
                params.put("minMessageId", currentMinMessageId);
                maxMessageId -= batchSize;
                totalSearched += batchSize;
                Map<Long, MessageSearchResult> foundMessages = this.searchAll((SqlSession)session, params, filter, localChannelId, false, filterOptions);
                if (foundMessages.isEmpty()) continue;
                if (offsetRemaining >= foundMessages.size()) {
                    offsetRemaining -= foundMessages.size();
                    continue;
                }
                if (offsetRemaining == 0) {
                    messages.putAll(foundMessages);
                    continue;
                }
                TreeMap<Long, MessageSearchResult> orderedMessages = new TreeMap<Long, MessageSearchResult>(foundMessages);
                while (offsetRemaining-- > 0) {
                    orderedMessages.pollLastEntry();
                }
                messages.putAll(orderedMessages);
            }
            while (messages.size() > limit) {
                messages.pollFirstEntry();
            }
            ArrayList<MessageSearchResult> results = new ArrayList<MessageSearchResult>(messages.size());
            if (!messages.isEmpty()) {
                Iterator<Long> iterator = messages.descendingKeySet().iterator();
                while (iterator.hasNext()) {
                    HashMap<String, Object> messageParams = new HashMap<String, Object>();
                    messageParams.put("localChannelId", localChannelId);
                    ListRangeIterator listRangeIterator = new ListRangeIterator(iterator, 1000, false, null);
                    while (listRangeIterator.hasNext()) {
                        ListRangeIterator.ListRangeItem item = listRangeIterator.next();
                        List<Long> list = item.getList();
                        Long startRange = item.getStartRange();
                        Long endRange = item.getEndRange();
                        if (list == null && (startRange == null || endRange == null)) continue;
                        if (list != null) {
                            messageParams.remove("minMessageId");
                            messageParams.remove("maxMessageId");
                            messageParams.put("includeMessageList", org.apache.commons.lang3.StringUtils.join(list, (String)","));
                        } else {
                            messageParams.remove("includeMessageList");
                            messageParams.put("minMessageId", endRange);
                            messageParams.put("maxMessageId", startRange);
                        }
                        List currentResults = session.selectList("Message.selectMessagesById", messageParams);
                        for (MessageSearchResult currentResult : currentResults) {
                            currentResult.setMetaDataIdSet(((MessageSearchResult)messages.get(currentResult.getMessageId())).getMetaDataIdSet());
                        }
                        results.addAll(currentResults);
                    }
                }
            }
            ArrayList<MessageSearchResult> arrayList = results;
            return arrayList;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.logger.debug("Search executed in " + (endTime - startTime) + "ms");
        }
    }

    private Map<Long, MessageSearchResult> searchAll(SqlSession session, Map<String, Object> params, MessageFilter filter, Long localChannelId, boolean includeMessageData, FilterOptions filterOptions) {
        HashMap<Long, MessageSearchResult> foundMessages = new HashMap<Long, MessageSearchResult>();
        List messageResults = session.selectList("Message.searchMessageTable", params);
        if (!messageResults.isEmpty()) {
            HashSet<Long> messageIdSet = new HashSet<Long>(messageResults.size());
            for (MessageTextResult messageResult : messageResults) {
                messageIdSet.add(messageResult.getMessageId());
            }
            List metaDataResults = session.selectList("Message.searchMetaDataTable", params);
            HashMap<Long, MessageSearchResult> textMessages = new HashMap<Long, MessageSearchResult>();
            HashMap<Long, MessageSearchResult> potentialMessages = new HashMap<Long, MessageSearchResult>();
            for (MessageTextResult metaDataResult : metaDataResults) {
                if (!messageIdSet.contains(metaDataResult.getMessageId())) continue;
                if (filterOptions.isSearchText() && metaDataResult.isTextFound() != null && metaDataResult.isTextFound().booleanValue()) {
                    this.addMessageToMap(textMessages, metaDataResult.getMessageId(), metaDataResult.getMetaDataId());
                    if (!filterOptions.isSearchCustomMetaData() && !filterOptions.isSearchContent()) continue;
                    this.addMessageToMap(potentialMessages, metaDataResult.getMessageId(), metaDataResult.getMetaDataId());
                    continue;
                }
                if (filterOptions.isSearchCustomMetaData() || filterOptions.isSearchContent() || filterOptions.isSearchText()) {
                    this.addMessageToMap(potentialMessages, metaDataResult.getMessageId(), metaDataResult.getMetaDataId());
                    continue;
                }
                this.addMessageToMap(foundMessages, metaDataResult.getMessageId(), metaDataResult.getMetaDataId());
            }
            metaDataResults = null;
            messageIdSet = null;
            if (!includeMessageData) {
                messageResults = null;
            }
            if (potentialMessages.isEmpty()) {
                foundMessages.putAll(textMessages);
            } else {
                long potentialMin = Long.MAX_VALUE;
                long l = Long.MIN_VALUE;
                Iterator iterator = potentialMessages.keySet().iterator();
                while (iterator.hasNext()) {
                    long key = (Long)iterator.next();
                    if (key < potentialMin) {
                        potentialMin = key;
                    }
                    if (key <= l) continue;
                    l = key;
                }
                HashMap<String, Object> contentParams = new HashMap<String, Object>();
                contentParams.put("localChannelId", localChannelId);
                contentParams.put("includedMetaDataIds", filter.getIncludedMetaDataIds());
                contentParams.put("excludedMetaDataIds", filter.getExcludedMetaDataIds());
                contentParams.put("minMessageId", potentialMin);
                contentParams.put("maxMessageId", l);
                boolean searchCustomMetaData = filterOptions.isSearchCustomMetaData();
                boolean searchContent = filterOptions.isSearchContent();
                boolean searchText = filterOptions.isSearchText();
                HashMap<Long, MessageSearchResult> tempMessages = null;
                if (searchCustomMetaData) {
                    tempMessages = new HashMap<Long, MessageSearchResult>();
                    this.searchCustomMetaData(session, new HashMap<String, Object>(contentParams), potentialMessages, tempMessages, filter.getMetaDataSearch());
                    if (tempMessages.isEmpty()) {
                        searchContent = false;
                        searchText = false;
                    }
                }
                if (searchContent) {
                    HashMap<Long, MessageSearchResult> contentMessages = new HashMap<Long, MessageSearchResult>();
                    this.searchContent(session, new HashMap<String, Object>(contentParams), potentialMessages, contentMessages, filter.getContentSearch());
                    if (tempMessages == null) {
                        tempMessages = contentMessages;
                    } else {
                        this.joinMessages(tempMessages, contentMessages);
                    }
                    if (tempMessages.isEmpty()) {
                        searchText = false;
                    }
                }
                if (searchText) {
                    this.searchText(session, new HashMap<String, Object>(contentParams), potentialMessages, textMessages, filter.getTextSearchRegex(), filter.getTextSearch(), filter.getTextSearchMetaDataColumns());
                    if (tempMessages == null) {
                        tempMessages = textMessages;
                    } else {
                        this.joinMessages(tempMessages, textMessages);
                    }
                }
                foundMessages.putAll(tempMessages);
            }
            if (!foundMessages.isEmpty() && includeMessageData) {
                HashMap<Long, MessageTextResult> messageDataResults = new HashMap<Long, MessageTextResult>(messageResults.size());
                for (MessageTextResult messageTextResult : messageResults) {
                    messageDataResults.put(messageTextResult.getMessageId(), messageTextResult);
                }
                for (Map.Entry entry : foundMessages.entrySet()) {
                    Long messageId = (Long)entry.getKey();
                    MessageSearchResult result = (MessageSearchResult)entry.getValue();
                    MessageTextResult textResult = (MessageTextResult)messageDataResults.get(messageId);
                    if (textResult == null) continue;
                    result.setImportId(textResult.getImportId());
                    result.setProcessed(textResult.getProcessed());
                }
            }
        }
        return foundMessages;
    }

    private void searchCustomMetaData(SqlSession session, Map<String, Object> params, Map<Long, MessageSearchResult> potentialMessages, Map<Long, MessageSearchResult> customMetaDataMessages, List<MetaDataSearchElement> metaDataSearchElements) {
        params.put("metaDataSearch", metaDataSearchElements);
        List results = session.selectList("Message.searchCustomMetaDataTable", params);
        for (MessageTextResult result : results) {
            Set<Integer> allowedMetaDataIds;
            Long messageId = result.getMessageId();
            Integer metaDataId = result.getMetaDataId();
            if (!potentialMessages.containsKey(messageId) || !(allowedMetaDataIds = potentialMessages.get(messageId).getMetaDataIdSet()).contains(metaDataId)) continue;
            this.addMessageToMap(customMetaDataMessages, messageId, metaDataId);
        }
    }

    private void searchContent(SqlSession session, Map<String, Object> params, Map<Long, MessageSearchResult> potentialMessages, Map<Long, MessageSearchResult> contentMessages, List<ContentSearchElement> contentSearchElements) {
        for (int index = 0; !(index >= contentSearchElements.size() || index != 0 && contentMessages.isEmpty()); ++index) {
            Long messageId;
            ContentSearchElement element = contentSearchElements.get(index);
            if (!CollectionUtils.isNotEmpty(element.getSearches())) continue;
            params.put("contentType", element.getContentCode());
            params.put("contents", element.getSearches());
            List results = session.selectList("Message.searchContentTable", params);
            HashMap<Long, MessageSearchResult> tempMessages = new HashMap<Long, MessageSearchResult>();
            for (MessageTextResult result : results) {
                Set<Integer> allowedMetaDataIds;
                messageId = result.getMessageId();
                Integer metaDataId = result.getMetaDataId();
                if (!potentialMessages.containsKey(messageId) || !(allowedMetaDataIds = potentialMessages.get(messageId).getMetaDataIdSet()).contains(metaDataId)) continue;
                if (index == 0) {
                    this.addMessageToMap(contentMessages, messageId, metaDataId);
                    continue;
                }
                this.addMessageToMap(tempMessages, messageId, metaDataId);
            }
            if (ContentType.fromCode((int)element.getContentCode()) == ContentType.RAW) {
                params.put("metaDataId", 0);
                params.put("contentType", ContentType.ENCODED.getContentTypeCode());
                results = session.selectList("Message.searchContentTable", params);
                params.remove("metaDataId");
                for (MessageTextResult result : results) {
                    messageId = result.getMessageId();
                    if (!potentialMessages.containsKey(messageId)) continue;
                    Set<Integer> allowedMetaDataIds = potentialMessages.get(messageId).getMetaDataIdSet();
                    for (Integer allowedMetaDataId : allowedMetaDataIds) {
                        if (allowedMetaDataId == 0) continue;
                        if (index == 0) {
                            this.addMessageToMap(contentMessages, messageId, allowedMetaDataId);
                            continue;
                        }
                        this.addMessageToMap(tempMessages, messageId, allowedMetaDataId);
                    }
                }
            }
            if (index <= 0) continue;
            this.joinMessages(contentMessages, tempMessages);
        }
    }

    private void searchText(SqlSession session, Map<String, Object> params, Map<Long, MessageSearchResult> potentialMessages, Map<Long, MessageSearchResult> textMessages, Boolean textSearchRegex, String text, List<String> textSearchMetaDataColumns) {
        Integer metaDataId;
        Long messageId;
        List results;
        params.put("contents", Collections.singletonList(text));
        params.put("textSearch", text);
        params.put("textSearchRegex", textSearchRegex);
        params.put("textSearchMetaDataColumns", textSearchMetaDataColumns);
        if (CollectionUtils.isNotEmpty(textSearchMetaDataColumns)) {
            results = session.selectList("Message.searchCustomMetaDataTable", params);
            for (MessageTextResult result : results) {
                Set<Integer> allowedMetaDataIds;
                messageId = result.getMessageId();
                metaDataId = result.getMetaDataId();
                if (!potentialMessages.containsKey(messageId) || !(allowedMetaDataIds = potentialMessages.get(messageId).getMetaDataIdSet()).contains(metaDataId)) continue;
                this.addMessageToMap(textMessages, messageId, metaDataId);
            }
        }
        results = session.selectList("Message.searchContentTable", params);
        for (MessageTextResult result : results) {
            messageId = result.getMessageId();
            metaDataId = result.getMetaDataId();
            Integer contentCode = result.getContentType();
            ContentType contentType = ContentType.fromCode((int)contentCode);
            if (!potentialMessages.containsKey(messageId)) continue;
            Set<Integer> allowedMetaDataIds = potentialMessages.get(messageId).getMetaDataIdSet();
            if (metaDataId == 0 && contentType == ContentType.ENCODED) {
                for (Integer allowedMetaDataId : allowedMetaDataIds) {
                    this.addMessageToMap(textMessages, messageId, allowedMetaDataId);
                }
                continue;
            }
            if (!allowedMetaDataIds.contains(metaDataId)) continue;
            this.addMessageToMap(textMessages, messageId, metaDataId);
        }
    }

    private void addMessageToMap(Map<Long, MessageSearchResult> messages, Long messageId, Integer metaDataId) {
        MessageSearchResult result = messages.get(messageId);
        if (result == null) {
            result = new MessageSearchResult();
            result.setMetaDataIdSet(new TreeSet<Integer>());
            messages.put(messageId, result);
        }
        result.getMetaDataIdSet().add(metaDataId);
    }

    private void joinMessages(Map<Long, MessageSearchResult> messages, Map<Long, MessageSearchResult> newMessages) {
        Iterator<Map.Entry<Long, MessageSearchResult>> iterator = messages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, MessageSearchResult> entry = iterator.next();
            Long tempMessageId = entry.getKey();
            if (!newMessages.containsKey(tempMessageId)) {
                iterator.remove();
                continue;
            }
            Set<Integer> firstMetaDataIds = entry.getValue().getMetaDataIdSet();
            firstMetaDataIds.retainAll(newMessages.get(tempMessageId).getMetaDataIdSet());
        }
    }

    private DonkeyDao getDao(boolean readOnly) {
        return (readOnly ? this.donkey.getReadOnlyDaoFactory() : this.donkey.getDaoFactory()).getDao();
    }

    private SqlSessionManager getSqlSessionManager(boolean readOnly) {
        return readOnly ? SqlConfig.getInstance().getReadOnlySqlSessionManager() : SqlConfig.getInstance().getSqlSessionManager();
    }

    private class FilterOptions {
        private long minMessageId;
        private long maxMessageId;
        private boolean searchCustomMetaData;
        private boolean searchContent;
        private boolean searchText;

        public FilterOptions(MessageFilter filter, String channelId, boolean readOnly) {
            if (filter.getMinMessageId() != null && filter.getMaxMessageId() != null && filter.getMinMessageId() > filter.getMaxMessageId()) {
                this.minMessageId = filter.getMinMessageId();
                this.maxMessageId = filter.getMaxMessageId();
            } else {
                this.minMessageId = Math.max(filter.getMinMessageId() == null ? 1L : filter.getMinMessageId(), DonkeyMessageController.this.getMinMessageId(channelId, readOnly));
                this.maxMessageId = filter.getMaxMessageId() != null ? Math.min(filter.getMaxMessageId(), DonkeyMessageController.this.getMaxMessageId(channelId, readOnly)) : DonkeyMessageController.this.getMaxMessageId(channelId, readOnly);
            }
            this.searchCustomMetaData = CollectionUtils.isNotEmpty(filter.getMetaDataSearch());
            this.searchContent = CollectionUtils.isNotEmpty(filter.getContentSearch());
            this.searchText = filter.getTextSearch() != null;
        }

        public long getMinMessageId() {
            return this.minMessageId;
        }

        public long getMaxMessageId() {
            return this.maxMessageId;
        }

        public boolean isSearchCustomMetaData() {
            return this.searchCustomMetaData;
        }

        public boolean isSearchContent() {
            return this.searchContent;
        }

        public boolean isSearchText() {
            return this.searchText;
        }
    }

    private class MessageWriterChannel
    implements MessageWriter {
        private Channel channel;
        private DonkeyDao dao;
        private Encryptor encryptor = ConfigurationController.getInstance().getEncryptor();

        public MessageWriterChannel(Channel channel) {
            this.channel = channel;
            this.dao = channel.getDaoFactory().getDao();
        }

        @Override
        public boolean write(Message message) throws MessageWriterException {
            MessageEncryptionUtil.decryptMessage(message, this.encryptor);
            try {
                this.channel.importMessage(message, this.dao);
            }
            catch (DonkeyException e) {
                throw new MessageWriterException(e);
            }
            return true;
        }

        @Override
        public void finishWrite() {
        }

        @Override
        public void close() throws MessageWriterException {
            try {
                this.dao.commit();
            }
            finally {
                this.dao.close();
            }
        }
    }
}

