/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.logging;

import com.mirth.connect.server.logging.JuliToLog4jHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class JuliToLog4JService {
    private static JuliToLog4JService instance = null;
    private Handler activeHandler;
    private List<Handler> oldHandlers = new ArrayList<Handler>();
    private Level handlerLevel = Level.ALL;
    private Level rootLevel = Level.INFO;

    private JuliToLog4JService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JuliToLog4JService getInstance() {
        Class<JuliToLog4JService> clazz = JuliToLog4JService.class;
        synchronized (JuliToLog4JService.class) {
            if (instance == null) {
                instance = new JuliToLog4JService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void start() {
        try {
            JuliToLog4jHandler.getTargetLogger(JuliToLog4JService.class).info("Redirecting java.util.logging to log4j");
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            for (Handler handler : rootLogger.getHandlers()) {
                this.oldHandlers.add(handler);
                rootLogger.removeHandler(handler);
            }
            this.activeHandler = new JuliToLog4jHandler();
            this.activeHandler.setLevel(this.handlerLevel);
            rootLogger.addHandler(this.activeHandler);
            rootLogger.setLevel(this.rootLevel);
            Logger.getLogger(JuliToLog4JService.class.getName()).info("Sending java.util.logging messages to log4j");
        }
        catch (Exception e) {
            JuliToLog4jHandler.getTargetLogger(JuliToLog4JService.class).error("Failed to start java.util.logging to log4j service.", (Throwable)e);
        }
    }

    public void stop() {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.removeHandler(this.activeHandler);
        for (Handler oldHandler : this.oldHandlers) {
            rootLogger.addHandler(oldHandler);
        }
        Logger.getLogger(JuliToLog4jHandler.class.getName()).info("Stopped java.util.logging to log4j service");
    }

    public String getHandlerLevel() {
        return this.handlerLevel.getName();
    }

    public void setHandlerLevel(String level) {
        String parseThis = level.toUpperCase();
        this.handlerLevel = "DEBUG".equalsIgnoreCase(parseThis) ? Level.FINE : Level.parse(parseThis);
    }
}

