/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.server.migration.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate2_0_0
extends Migrator {
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void migrate() throws MigrationException {
        this.executeScript(this.getDatabaseType() + "-6-7.sql");
        this.migrateGlobalScripts();
        this.migrateServerProperties();
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }

    private void migrateGlobalScripts() throws MigrationException {
        this.migrateGlobalScript("Deploy");
        this.migrateGlobalScript("Shutdown");
        this.migrateGlobalScript("Preprocessor");
        this.migrateGlobalScript("Postprocessor");
    }

    private void migrateGlobalScript(String scriptId) throws MigrationException {
        String globalGroupId = "Global";
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.prepareStatement("SELECT SCRIPT FROM SCRIPT WHERE GROUP_ID = ? AND ID = ?");
            statement.setString(1, "Global");
            statement.setString(2, scriptId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String script = resultSet.getString(1).replaceAll("com.webreach.mirth", "com.mirth.connect");
                resultSet.close();
                statement.close();
                statement = connection.prepareStatement("UPDATE SCRIPT SET SCRIPT = ? WHERE GROUP_ID = ? AND ID = ?");
                statement.setString(1, script);
                statement.setString(2, "Global");
                statement.setString(3, scriptId);
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)resultSet);
        DbUtils.closeQuietly((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void migrateServerProperties() throws MigrationException {
        File propertiesFile = new File(this.getBaseDir() + IOUtils.DIR_SEPARATOR + "server.properties");
        if (propertiesFile.exists()) {
            FileInputStream is;
            block8: {
                is = null;
                try {
                    is = new FileInputStream(propertiesFile);
                    Properties serverProperties = new Properties();
                    serverProperties.load(is);
                    for (Object name : serverProperties.keySet()) {
                        this.updateServerProperty((String)name, serverProperties.getProperty((String)name));
                    }
                    if (propertiesFile.delete()) break block8;
                    this.logger.error("Could not delete existing server.properties file. Please delete it manually.");
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Error loading existing server.properties file.", (Throwable)e);
                    ResourceUtil.closeResourceQuietly(is);
                }
                catch (IOException e2) {
                    this.logger.error("Error loading existing server.properties file.", (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            ResourceUtil.closeResourceQuietly(is);
                            throw throwable;
                        }
                    }
                    ResourceUtil.closeResourceQuietly(is);
                }
            }
            ResourceUtil.closeResourceQuietly(is);
        }
    }

    private String getBaseDir() {
        URL url = this.getClass().getResource("mirth.properties");
        if (url == null) {
            url = this.getClass().getResource("/mirth.properties");
        }
        if (url != null) {
            try {
                return new File(url.toURI()).getParentFile().getParent();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private void updateServerProperty(String name, String value) throws MigrationException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.prepareStatement("UPDATE CONFIGURATION SET VALUE = ? WHERE CATEGORY = 'core' AND NAME = ?");
            statement.setString(1, value);
            statement.setString(2, name);
            if (statement.executeUpdate() == 0) {
                statement.close();
                statement = connection.prepareStatement("INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', ?, ?)");
                statement.setString(1, name);
                statement.setString(2, value);
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(resultSet);
        DbUtils.closeQuietly((Statement)statement);
    }
}

