/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.client.core.Version;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ConfigurationMigrator;
import com.mirth.connect.server.migration.Migrator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Migrate3_0_0
extends Migrator
implements ConfigurationMigrator {
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void migrate() throws MigrationException {
        this.executeScript(this.getDatabaseType() + "-9-3.0.0-1.sql");
        this.migrateChannelTable();
        this.migrateAlertTable();
        this.migrateCodeTemplateTable();
        this.migrateDataPrunerConfiguration();
        this.executeScript(this.getDatabaseType() + "-9-3.0.0-2.sql");
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }

    @Override
    public Map<String, Object> getConfigurationPropertiesToAdd() {
        LinkedHashMap<String, Object> propertiesToAdd = new LinkedHashMap<String, Object>();
        propertiesToAdd.put("database.max-connections", 20);
        return propertiesToAdd;
    }

    @Override
    public String[] getConfigurationPropertiesToRemove() {
        return new String[]{"jmx.port", "jmx.password", "jmx.host"};
    }

    @Override
    public void updateConfiguration(PropertiesConfiguration configuration) {
        if (configuration.getProperty("database").equals("derby")) {
            Object url = (String)configuration.getProperty("database.url");
            if (!StringUtils.contains((CharSequence)url, (CharSequence)";upgrade=")) {
                url = (String)url + ";upgrade=true";
            }
            configuration.setProperty("database.url", url);
        }
    }

    private void migrateDataPrunerConfiguration() {
        PreparedStatement statement = null;
        try {
            statement = this.getConnection().prepareStatement("UPDATE CONFIGURATION SET CATEGORY = ? WHERE CATEGORY = ?");
            statement.setString(1, "Data Pruner");
            statement.setString(2, "Message Pruner");
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.logger.error("Failed to migrate Data Pruner configuration category", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
            DbUtils.closeQuietly((Statement)statement);
        }
        DbUtils.closeQuietly((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateChannelTable() {
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("SELECT ID, NAME, DESCRIPTION, IS_ENABLED, VERSION, REVISION, LAST_MODIFIED, SOURCE_CONNECTOR, DESTINATION_CONNECTORS, PROPERTIES, PREPROCESSING_SCRIPT, POSTPROCESSING_SCRIPT, DEPLOY_SCRIPT, SHUTDOWN_SCRIPT FROM OLD_CHANNEL");
            results = preparedStatement.executeQuery();
            while (results.next()) {
                String channelId = "";
                try {
                    channelId = results.getString(1);
                    String name = results.getString(2);
                    String description = results.getString(3);
                    Boolean isEnabled = results.getBoolean(4);
                    String version = results.getString(5);
                    Integer revision = results.getInt(6);
                    Calendar lastModified = Calendar.getInstance();
                    lastModified.setTimeInMillis(results.getTimestamp(7).getTime());
                    String sourceConnector = results.getString(8);
                    String destinationConnectors = results.getString(9);
                    String properties = results.getString(10);
                    String preprocessingScript = results.getString(11);
                    String postprocessingScript = results.getString(12);
                    String deployScript = results.getString(13);
                    String shutdownScript = results.getString(14);
                    Document document = Migrate3_0_0.getDocument();
                    Element element = document.createElement("channel");
                    document.appendChild(element);
                    DonkeyElement channel = new DonkeyElement(element);
                    channel.addChildElement("id", channelId);
                    channel.addChildElement("name", name);
                    channel.addChildElement("description", description);
                    channel.addChildElement("enabled", Boolean.toString(isEnabled));
                    channel.addChildElement("version", version);
                    DonkeyElement lastModifiedElement = channel.addChildElement("lastModified");
                    lastModifiedElement.addChildElement("time", String.valueOf(lastModified.getTimeInMillis()));
                    lastModifiedElement.addChildElement("timezone", lastModified.getTimeZone().getDisplayName());
                    channel.addChildElement("revision", String.valueOf(revision));
                    channel.addChildElementFromXml(sourceConnector).setNodeName("sourceConnector");
                    channel.addChildElementFromXml(destinationConnectors).setNodeName("destinationConnectors");
                    channel.addChildElementFromXml(properties);
                    channel.addChildElement("preprocessingScript", preprocessingScript);
                    channel.addChildElement("postprocessingScript", postprocessingScript);
                    channel.addChildElement("deployScript", deployScript);
                    channel.addChildElement("shutdownScript", shutdownScript);
                    String serializedChannel = channel.toXml();
                    PreparedStatement updateStatement = null;
                    try {
                        updateStatement = connection.prepareStatement("INSERT INTO CHANNEL (ID, NAME, REVISION, CHANNEL) VALUES (?, ?, ?, ?)");
                        updateStatement.setString(1, channelId);
                        updateStatement.setString(2, name);
                        updateStatement.setInt(3, revision);
                        updateStatement.setString(4, serializedChannel);
                        updateStatement.executeUpdate();
                        updateStatement.close();
                    }
                    finally {
                        DbUtils.closeQuietly((Statement)updateStatement);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error migrating channel " + channelId + ".", (Throwable)e);
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.logger.error("Error migrating channels.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(results);
                DbUtils.closeQuietly(preparedStatement);
                throw throwable;
            }
            DbUtils.closeQuietly(results);
            DbUtils.closeQuietly((Statement)preparedStatement);
        }
        DbUtils.closeQuietly((ResultSet)results);
        DbUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateAlertTable() {
        block19: {
            Logger logger = LogManager.getLogger(this.getClass());
            PreparedStatement statement = null;
            ResultSet results = null;
            try {
                String alertId;
                HashMap<String, ArrayList<String>> alertEmails = new HashMap<String, ArrayList<String>>();
                HashMap<String, ArrayList<String>> alertChannels = new HashMap<String, ArrayList<String>>();
                Connection connection = this.getConnection();
                connection.setAutoCommit(false);
                statement = connection.prepareStatement("SELECT ALERT_ID, EMAIL FROM OLD_ALERT_EMAIL");
                results = statement.executeQuery();
                while (results.next()) {
                    alertId = results.getString(1);
                    String email = results.getString(2);
                    ArrayList<String> emailSet = (ArrayList<String>)alertEmails.get(alertId);
                    if (emailSet == null) {
                        emailSet = new ArrayList<String>();
                        alertEmails.put(alertId, emailSet);
                    }
                    emailSet.add(email);
                }
                DbUtils.closeQuietly((ResultSet)results);
                DbUtils.closeQuietly((Statement)statement);
                statement = connection.prepareStatement("SELECT CHANNEL_ID, ALERT_ID FROM OLD_CHANNEL_ALERT");
                results = statement.executeQuery();
                while (results.next()) {
                    String channelId = results.getString(1);
                    String alertId2 = results.getString(2);
                    ArrayList<String> channelSet = (ArrayList<String>)alertChannels.get(alertId2);
                    if (channelSet == null) {
                        channelSet = new ArrayList<String>();
                        alertChannels.put(alertId2, channelSet);
                    }
                    channelSet.add(channelId);
                }
                DbUtils.closeQuietly((ResultSet)results);
                DbUtils.closeQuietly((Statement)statement);
                statement = connection.prepareStatement("SELECT ID, NAME, IS_ENABLED, EXPRESSION, TEMPLATE, SUBJECT FROM OLD_ALERT");
                results = statement.executeQuery();
                while (results.next()) {
                    alertId = "";
                    try {
                        alertId = results.getString(1);
                        String name = results.getString(2);
                        boolean enabled = results.getBoolean(3);
                        String expression = results.getString(4);
                        String template = results.getString(5);
                        String subject = results.getString(6);
                        Document document = Migrate3_0_0.getDocument();
                        Element alertNode = document.createElement("alert");
                        document.appendChild(alertNode);
                        Element node = document.createElement("id");
                        node.setTextContent(alertId);
                        alertNode.appendChild(node);
                        node = document.createElement("name");
                        node.setTextContent(name);
                        alertNode.appendChild(node);
                        node = document.createElement("expression");
                        node.setTextContent(expression);
                        alertNode.appendChild(node);
                        node = document.createElement("template");
                        node.setTextContent(template);
                        alertNode.appendChild(node);
                        node = document.createElement("enabled");
                        node.setTextContent(Boolean.toString(enabled));
                        alertNode.appendChild(node);
                        node = document.createElement("subject");
                        node.setTextContent(subject);
                        alertNode.appendChild(node);
                        Element channelNode = document.createElement("channels");
                        alertNode.appendChild(channelNode);
                        List channelList = (List)alertChannels.get(alertId);
                        if (channelList != null) {
                            for (String channelId : channelList) {
                                Element stringNode = document.createElement("string");
                                stringNode.setTextContent(channelId);
                                channelNode.appendChild(stringNode);
                            }
                        }
                        Element emailNode = document.createElement("emails");
                        alertNode.appendChild(emailNode);
                        List emailList = (List)alertEmails.get(alertId);
                        if (emailList != null) {
                            for (String email : emailList) {
                                Element stringNode = document.createElement("string");
                                stringNode.setTextContent(email);
                                emailNode.appendChild(stringNode);
                            }
                        }
                        String alert = new DonkeyElement(alertNode).toXml();
                        PreparedStatement updateStatement = null;
                        try {
                            updateStatement = connection.prepareStatement("INSERT INTO ALERT VALUES (?, ?, ?)");
                            updateStatement.setString(1, alertId);
                            updateStatement.setString(2, name);
                            updateStatement.setString(3, alert);
                            updateStatement.executeUpdate();
                            updateStatement.close();
                        }
                        finally {
                            DbUtils.closeQuietly((Statement)updateStatement);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error migrating alert " + alertId + ".", (Throwable)e);
                    }
                }
                connection.commit();
                DbUtils.closeQuietly((ResultSet)results);
            }
            catch (SQLException e) {
                logger.error("Error migrating alerts.", (Throwable)e);
                break block19;
            }
            finally {
                DbUtils.closeQuietly(results);
                DbUtils.closeQuietly(statement);
            }
            DbUtils.closeQuietly((Statement)statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateCodeTemplateTable() {
        Logger logger = LogManager.getLogger(this.getClass());
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("SELECT ID, NAME, CODE_SCOPE, CODE_TYPE, TOOLTIP, CODE FROM OLD_CODE_TEMPLATE");
            results = preparedStatement.executeQuery();
            while (results.next()) {
                String id = "";
                try {
                    id = results.getString(1);
                    String name = results.getString(2);
                    String codeScope = results.getString(3);
                    String codeType = results.getString(4);
                    String toolTip = results.getString(5);
                    String code = results.getString(6);
                    Document document = Migrate3_0_0.getDocument();
                    Element element = document.createElement("codeTemplate");
                    document.appendChild(element);
                    DonkeyElement codeTemplate = new DonkeyElement(element);
                    codeTemplate.addChildElement("id", id);
                    codeTemplate.addChildElement("name", name);
                    codeTemplate.addChildElement("tooltip", toolTip);
                    codeTemplate.addChildElement("code", code);
                    codeTemplate.addChildElement("type", codeType);
                    codeTemplate.addChildElement("scope", codeScope);
                    if (this.getStartingVersion() != null && this.getStartingVersion().ordinal() >= Version.V7.ordinal()) {
                        codeTemplate.addChildElement("version", "2.0");
                    }
                    String serializedCodeTemplate = new DonkeyElement(element).toXml();
                    PreparedStatement updateStatement = null;
                    try {
                        updateStatement = connection.prepareStatement("INSERT INTO CODE_TEMPLATE (ID, CODE_TEMPLATE) VALUES (?, ?)");
                        updateStatement.setString(1, id);
                        updateStatement.setString(2, serializedCodeTemplate);
                        updateStatement.executeUpdate();
                        updateStatement.close();
                    }
                    finally {
                        DbUtils.closeQuietly((Statement)updateStatement);
                    }
                }
                catch (Exception e) {
                    logger.error("Error migrating code template " + id + ".", (Throwable)e);
                }
            }
            connection.commit();
        }
        catch (Exception e) {
            try {
                logger.error("Error migrating code templates.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(results);
                DbUtils.closeQuietly(preparedStatement);
                throw throwable;
            }
            DbUtils.closeQuietly(results);
            DbUtils.closeQuietly((Statement)preparedStatement);
        }
        DbUtils.closeQuietly((ResultSet)results);
        DbUtils.closeQuietly((Statement)preparedStatement);
    }

    private static Document getDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf.newDocumentBuilder().newDocument();
    }
}

