/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ConfigurationMigrator;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.server.tools.ClassPathResource;
import com.mirth.connect.server.util.DatabaseUtil;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class Migrate3_1_0
extends Migrator
implements ConfigurationMigrator {
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void migrate() throws MigrationException {
        this.executeScript(this.getDatabaseType() + "-3.0.3-3.1.0.sql");
        this.migrateLog4jProperties();
        this.migrateMessageSequences();
    }

    private void migrateLog4jProperties() {
        try {
            Logger logger2;
            FileBasedConfigurationBuilder builder = PropertiesConfigurationUtil.createBuilder((File)new File(ClassPathResource.getResourceURI("log4j2.properties")));
            PropertiesConfiguration log4jproperties = (PropertiesConfiguration)builder.getConfiguration();
            String level = (String)log4jproperties.getProperty("logger.shutdown.level");
            if (level != null) {
                log4jproperties.setProperty("logger.undeploy.level", (Object)level);
                log4jproperties.clearProperty("logger.shutdown.level");
                logger2 = LogManager.getLogger((String)"undeploy");
                Configurator.setLevel((String)logger2.getName(), (Level)Level.toLevel((String)level));
            }
            if (StringUtils.isBlank((CharSequence)(level = (String)log4jproperties.getProperty("logger.recoveryTask.level")))) {
                level = "INFO";
                log4jproperties.setProperty("logger.recoveryTask.level", (Object)level);
                logger2 = LogManager.getLogger((String)"com.mirth.connect.donkey.server.channel.RecoveryTask");
                Configurator.setLevel((String)logger2.getName(), (Level)Level.toLevel((String)level));
            }
            builder.save();
        }
        catch (IOException | ConfigurationException e) {
            this.logger.error("Failed to migrate log4j properties.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateMessageSequences() throws MigrationException {
        block5: {
            try {
                if (!this.scriptExists(this.getDatabaseType() + "-3.0.3-3.1.0-create-msg-seq.sql") || !DatabaseUtil.tableExists(this.getConnection(), "D_MESSAGE_SEQUENCES")) break block5;
                this.logger.debug("Migrating message sequences for " + this.getDatabaseType());
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.getConnection().prepareStatement("SELECT LOCAL_CHANNEL_ID, ID FROM D_MESSAGE_SEQUENCES");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        HashMap<String, Object> replacements = new HashMap<String, Object>();
                        replacements.put("localChannelId", resultSet.getLong(1));
                        replacements.put("initialValue", resultSet.getLong(2));
                        this.logger.debug("Migrating message sequence for local channel ID " + String.valueOf(replacements.get("localChannelId")) + ", with initial value of " + String.valueOf(replacements.get("initialValue")));
                        this.executeScript(this.getDatabaseType() + "-3.0.3-3.1.0-create-msg-seq.sql", replacements);
                    }
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(resultSet);
                    DbUtils.closeQuietly((Statement)preparedStatement);
                    throw throwable;
                }
                DbUtils.closeQuietly((ResultSet)resultSet);
                DbUtils.closeQuietly((Statement)preparedStatement);
                this.logger.debug("Finished creating new message sequence tables, dropping old D_MESSAGE_SEQUENCES table");
                this.executeStatement("DROP TABLE D_MESSAGE_SEQUENCES");
            }
            catch (Exception e) {
                throw new MigrationException("An error occurred while migrating message sequences or checking to see if sequences need migration.", e);
            }
        }
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }

    @Override
    public Map<String, Object> getConfigurationPropertiesToAdd() {
        LinkedHashMap<String, Object> propertiesToAdd = new LinkedHashMap<String, Object>();
        propertiesToAdd.put("configurationmap.path", "${dir.appdata}/configuration.properties");
        return propertiesToAdd;
    }

    @Override
    public String[] getConfigurationPropertiesToRemove() {
        return null;
    }

    @Override
    public void updateConfiguration(PropertiesConfiguration configuration) {
    }
}

