/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ConfigurationMigrator;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.util.ColorUtil;
import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate3_5_0
extends Migrator
implements ConfigurationMigrator {
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void migrate() throws MigrationException {
        this.executeScript(this.getDatabaseType() + "-3.4.2-3.5.0.sql");
        this.migrateChannelMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateChannelMetadata() {
        block29: {
            HashMap<String, Pair> tags = new HashMap<String, Pair>();
            PreparedStatement preparedStatement = null;
            ResultSet results = null;
            try {
                Connection connection = this.getConnection();
                connection.setAutoCommit(false);
                DonkeyElement metadataMapElement = new DonkeyElement("<map/>");
                preparedStatement = connection.prepareStatement("SELECT ID, CHANNEL FROM CHANNEL");
                results = preparedStatement.executeQuery();
                while (results.next()) {
                    String channelId = "";
                    try {
                        DonkeyElement tagsElement;
                        channelId = results.getString(1);
                        String channelXml = results.getString(2);
                        DonkeyElement metadataEntry = metadataMapElement.addChildElement("entry");
                        metadataEntry.addChildElement("string", channelId);
                        DonkeyElement metadataElement = metadataEntry.addChildElement("com.mirth.connect.model.ChannelMetadata");
                        DonkeyElement channelElement = new DonkeyElement(channelXml);
                        metadataElement.addChildElement("enabled", channelElement.getChildElement("enabled").getTextContent());
                        DonkeyElement lastModifiedElement = channelElement.getChildElement("lastModified");
                        if (lastModifiedElement != null) {
                            try {
                                metadataElement.addChildElementFromXml(lastModifiedElement.toXml());
                            }
                            catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                                // empty catch block
                            }
                        }
                        DonkeyElement propertiesElement = channelElement.getChildElement("properties");
                        DonkeyElement pruningSettingsElement = metadataElement.addChildElement("pruningSettings");
                        DonkeyElement pruneMetaDataDaysElement = propertiesElement.getChildElement("pruneMetaDataDays");
                        DonkeyElement pruneContentDaysElement = propertiesElement.getChildElement("pruneContentDays");
                        DonkeyElement archiveEnabledElement = propertiesElement.getChildElement("archiveEnabled");
                        if (pruneMetaDataDaysElement != null) {
                            pruningSettingsElement.addChildElement("pruneMetaDataDays", pruneMetaDataDaysElement.getTextContent());
                        }
                        if (pruneContentDaysElement != null) {
                            pruningSettingsElement.addChildElement("pruneContentDays", pruneContentDaysElement.getTextContent());
                        }
                        if (archiveEnabledElement != null) {
                            pruningSettingsElement.addChildElement("archiveEnabled", archiveEnabledElement.getTextContent());
                        }
                        if ((tagsElement = propertiesElement.getChildElement("tags")) == null) continue;
                        try {
                            Set channelTags = ObjectXMLSerializer.getInstance().deserialize(tagsElement.toString(), Set.class);
                            for (String tagName : channelTags) {
                                Pair tagInfo = (Pair)tags.get((tagName = ChannelTag.fixName(tagName)).toLowerCase());
                                if (tagInfo == null) {
                                    tagInfo = new ImmutablePair((Object)tagName, new HashSet());
                                    tags.put(tagName.toLowerCase(), tagInfo);
                                }
                                ((Set)tagInfo.getRight()).add(channelId);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Error migrating metadata for channel " + channelId + ".", (Throwable)e);
                    }
                }
                PreparedStatement updateStatement = null;
                try {
                    updateStatement = connection.prepareStatement("INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'channelMetadata', ?)");
                    updateStatement.setString(1, metadataMapElement.toXml());
                    updateStatement.executeUpdate();
                }
                finally {
                    DbUtils.closeQuietly((Statement)updateStatement);
                }
                DonkeyElement tagsElement = new DonkeyElement("<set/>");
                if (MapUtils.isNotEmpty(tags)) {
                    for (Pair tag : tags.values()) {
                        DonkeyElement tagElement = tagsElement.addChildElement("channelTag");
                        tagElement.addChildElement("id", UUID.randomUUID().toString());
                        tagElement.addChildElement("name", ChannelTag.fixName((String)tag.getLeft()));
                        DonkeyElement channelIds = tagElement.addChildElement("channelIds");
                        for (String channelId : (Set)tag.getRight()) {
                            channelIds.addChildElement("string", channelId);
                        }
                        Color newColor = ColorUtil.getNewColor();
                        DonkeyElement bgColor = tagElement.addChildElement("backgroundColor");
                        bgColor.addChildElement("red", String.valueOf(newColor.getRed()));
                        bgColor.addChildElement("blue", String.valueOf(newColor.getBlue()));
                        bgColor.addChildElement("green", String.valueOf(newColor.getGreen()));
                        bgColor.addChildElement("alpha", String.valueOf(newColor.getAlpha()));
                    }
                }
                updateStatement = null;
                try {
                    updateStatement = connection.prepareStatement("INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'channelTags', ?)");
                    updateStatement.setString(1, tagsElement.toXml());
                    updateStatement.executeUpdate();
                }
                finally {
                    DbUtils.closeQuietly((Statement)updateStatement);
                }
                connection.commit();
                DbUtils.closeQuietly((ResultSet)results);
            }
            catch (Exception e) {
                this.logger.error("Error migrating channel metadata.", (Throwable)e);
                break block29;
            }
            finally {
                DbUtils.closeQuietly(results);
                DbUtils.closeQuietly(preparedStatement);
            }
            DbUtils.closeQuietly((Statement)preparedStatement);
        }
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }

    @Override
    public Map<String, Object> getConfigurationPropertiesToAdd() {
        LinkedHashMap<String, Object> propertiesToAdd = new LinkedHashMap<String, Object>();
        propertiesToAdd.put("server.api.accesscontrolalloworigin", new MutablePair((Object)"*", (Object)"CORS headers"));
        propertiesToAdd.put("server.api.accesscontrolallowcredentials", "false");
        propertiesToAdd.put("server.api.accesscontrolallowmethods", "GET, POST, DELETE, PUT");
        propertiesToAdd.put("server.api.accesscontrolallowheaders", "Content-Type");
        propertiesToAdd.put("server.api.accesscontrolexposeheaders", "");
        propertiesToAdd.put("server.api.accesscontrolmaxage", "");
        propertiesToAdd.put("https.ephemeraldhkeysize", new MutablePair((Object)"2048", (Object)"Ephemeral Diffie-Hellman key size"));
        return propertiesToAdd;
    }

    @Override
    public String[] getConfigurationPropertiesToRemove() {
        return null;
    }

    @Override
    public void updateConfiguration(PropertiesConfiguration configuration) {
        Object[] cipherSuites = configuration.getStringArray("https.ciphersuites");
        if (ArrayUtils.isNotEmpty((Object[])cipherSuites)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Object cipherSuite : cipherSuites) {
                set.addAll(Arrays.asList(StringUtils.split((String)cipherSuite, (char)',')));
            }
            set.removeAll(Arrays.asList("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"));
            String oldValue = StringUtils.join((Object[])cipherSuites, (String)",");
            String newValue = StringUtils.join(set, (String)",");
            if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue)) {
                if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_DSS_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_DSS_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_RSA_WITH_AES_256_CBC_SHA256,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256,TLS_DHE_DSS_WITH_AES_256_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDH_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_DSS_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDH_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA,TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA,TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA,TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA,TLS_EMPTY_RENEGOTIATION_INFO_SCSV")) {
                    configuration.setProperty("https.ciphersuites.old", (Object)oldValue);
                    configuration.getLayout().setBlancLinesBefore("https.ciphersuites.old", 1);
                    configuration.getLayout().setComment("https.ciphersuites.old", "In version 3.5.0, Triple DES cipher suites were removed automatically due to known vulnerabilities. The old value for https.ciphersuites, in case you need it, is below.\nIf you no longer need it, you can delete this property.");
                }
                configuration.setProperty("https.ciphersuites", (Object)newValue);
            }
        }
    }
}

