/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.migration.Migrator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate3_8_0
extends Migrator {
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void migrate() throws MigrationException {
        ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
        try {
            List<DriverInfo> drivers = configurationController.getDatabaseDrivers();
            Iterator<DriverInfo> it = drivers.iterator();
            while (it.hasNext()) {
                DriverInfo driver = it.next();
                if (StringUtils.equals((CharSequence)driver.getClassName(), (CharSequence)"com.mysql.jdbc.Driver")) {
                    this.logger.info("Updating MySQL JDBC driver from \"com.mysql.jdbc.Driver\" to \"com.mysql.cj.jdbc.Driver\"");
                    driver.setClassName("com.mysql.cj.jdbc.Driver");
                    driver.setAlternativeClassNames(new ArrayList<String>(Arrays.asList("com.mysql.jdbc.Driver")));
                }
                if (!StringUtils.equals((CharSequence)driver.getClassName(), (CharSequence)"sun.jdbc.odbc.JdbcOdbcDriver")) continue;
                this.logger.info("Removing JDBC-ODBC driver which was removed in Java 7");
                it.remove();
            }
            configurationController.setDatabaseDrivers(drivers);
        }
        catch (ControllerException e) {
            throw new MigrationException(e);
        }
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }
}

