/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.client.core.Version;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ConfigurationMigrator;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.server.util.DatabaseUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate4_3_0
extends Migrator
implements ConfigurationMigrator {
    private Logger logger = LogManager.getLogger(this.getClass());
    protected static String OLD_DEFAULT_CIPHERSUITES = "TLS_CHACHA20_POLY1305_SHA256,TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256,TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256,TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256,TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_DSS_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_DSS_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384,TLS_DHE_DSS_WITH_AES_256_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDH_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_DSS_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDH_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
    protected static String NEW_DEFAULT_CIPHERSUITES = "TLS_CHACHA20_POLY1305_SHA256,TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256,TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256,TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256,TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_DSS_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_DSS_WITH_AES_128_GCM_SHA256,TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
    protected static List<String> CIPHERSUITES_TO_REMOVE = Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA");

    @Override
    public Map<String, Object> getConfigurationPropertiesToAdd() {
        return null;
    }

    @Override
    public String[] getConfigurationPropertiesToRemove() {
        return null;
    }

    @Override
    public void updateConfiguration(PropertiesConfiguration configuration) {
        if (this.getStartingVersion() == null || this.getStartingVersion().ordinal() < Version.v4_3_0.ordinal()) {
            this.updateConfiguration(configuration, "https.ciphersuites", OLD_DEFAULT_CIPHERSUITES, NEW_DEFAULT_CIPHERSUITES, CIPHERSUITES_TO_REMOVE);
            this.logger.error("In version 4.3.0, the following cipher suites have been disabled by default to reflect the lastest security best practices: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384, TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256, TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256, TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDH_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
            this.updateSecurityConfiguration(configuration);
        }
    }

    private void updateConfiguration(PropertiesConfiguration configuration, String key, String oldDefault, String newDefault, List<String> valuesToRemove) {
        String currentValueStr;
        Object[] currentValue = configuration.getStringArray(key);
        boolean hasCustomValue = false;
        if (ArrayUtils.isNotEmpty((Object[])currentValue) && (currentValue.length > 1 || StringUtils.isNotBlank((CharSequence)currentValue[0])) && !StringUtils.equals((CharSequence)(currentValueStr = StringUtils.join((Object[])currentValue, (char)',')), (CharSequence)newDefault) && !StringUtils.equals((CharSequence)currentValueStr, (CharSequence)oldDefault)) {
            hasCustomValue = true;
            configuration.setProperty(key + ".old", (Object)currentValueStr);
            configuration.getLayout().setBlancLinesBefore(key + ".old", 1);
            configuration.getLayout().setComment(key + ".old", "In version 4.3.0 the default protocols / cipher suites were updated to reflect the latest security best practices. The old value for " + key + ", in case you need it, is below.\nIf you no longer need it, you can delete this property.");
            this.logger.error("In version 4.3.0 the default protocols / cipher suites were updated to reflect the latest security best practices. The old value for " + key + " is still present in mirth.properties in case you need it. If you no longer need it, you can delete this property.");
        }
        if (hasCustomValue) {
            LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
            for (Object value : currentValue) {
                valueSet.addAll(Arrays.asList(StringUtils.split((String)value, (char)',')));
            }
            valueSet.removeAll(valuesToRemove);
            configuration.setProperty(key, (Object)StringUtils.join(valueSet, (char)','));
        } else {
            configuration.setProperty(key, (Object)newDefault);
        }
    }

    void updateSecurityConfiguration(PropertiesConfiguration configuration) {
        if (this.getStartingVersion() == null || this.getStartingVersion().ordinal() < Version.v4_3_0.ordinal()) {
            String encryptionAlgorithm = configuration.getString("encryption.algorithm");
            String encryptionFallbackAlgorithm = (String)StringUtils.defaultIfBlank((CharSequence)encryptionAlgorithm, (CharSequence)"AES");
            if (StringUtils.contains((CharSequence)encryptionFallbackAlgorithm, (CharSequence)"/")) {
                encryptionFallbackAlgorithm = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.substring((String)encryptionFallbackAlgorithm, (int)0, (int)StringUtils.indexOf((CharSequence)encryptionFallbackAlgorithm, (int)47)), (CharSequence)"AES");
            }
            configuration.setProperty("encryption.fallback.algorithm", (Object)encryptionFallbackAlgorithm);
            configuration.getLayout().setBlancLinesBefore("encryption.fallback.algorithm", 1);
            configuration.getLayout().setComment("encryption.fallback.algorithm", "The algorithm to use when decrypting old message content.");
            String defaultCharset = this.getDefaultCharset();
            if (!StringUtils.equals((CharSequence)defaultCharset, (CharSequence)StandardCharsets.UTF_8.name())) {
                configuration.setProperty("encryption.fallback.charset", (Object)defaultCharset);
                configuration.getLayout().setBlancLinesBefore("encryption.fallback.charset", 1);
                configuration.getLayout().setComment("encryption.fallback.charset", "The character set encoding to use when decrypting old message content");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate() throws MigrationException {
        block5: {
            try {
                if (!this.scriptExists(this.getDatabaseType() + "-4.2.0-4.3.0-attachment-table.sql") || !DatabaseUtil.tableExists(this.getConnection(), "D_CHANNELS")) break block5;
                this.logger.debug("Migrating message attachment tables for " + this.getDatabaseType());
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.getConnection().prepareStatement("SELECT LOCAL_CHANNEL_ID FROM D_CHANNELS");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        HashMap<String, Object> replacements = new HashMap<String, Object>();
                        replacements.put("localChannelId", resultSet.getLong(1));
                        this.logger.debug("Migrating message attachment table for local channel ID " + String.valueOf(replacements.get("localChannelId")));
                        this.executeScript(this.getDatabaseType() + "-4.2.0-4.3.0-attachment-table.sql", replacements);
                    }
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(resultSet);
                    DbUtils.closeQuietly((Statement)preparedStatement);
                    throw throwable;
                }
                DbUtils.closeQuietly((ResultSet)resultSet);
                DbUtils.closeQuietly((Statement)preparedStatement);
            }
            catch (Exception e) {
                throw new MigrationException("An error occurred while migrating message attachment tables.", e);
            }
        }
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    String getDefaultCharset() {
        return Charset.defaultCharset().name();
    }
}

