/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.client.core.Version;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class Migrator {
    private Version startingVersion;
    private Connection connection;
    private String databaseType;
    private String defaultScriptPath;

    public abstract void migrate() throws MigrationException;

    public abstract void migrateSerializedData() throws MigrationException;

    public Version getStartingVersion() {
        return this.startingVersion;
    }

    public void setStartingVersion(Version startingVersion) {
        this.startingVersion = startingVersion;
    }

    public Connection getConnection() throws SQLException {
        this.connection.setAutoCommit(true);
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDefaultScriptPath() {
        return this.defaultScriptPath;
    }

    public void setDefaultScriptPath(String defaultScriptPath) {
        this.defaultScriptPath = defaultScriptPath;
    }

    public List<String> getUninstallStatements() throws MigrationException {
        return null;
    }

    protected void executeScript(String scriptFile) throws MigrationException {
        this.executeScript(scriptFile, null);
    }

    protected void executeScript(String scriptFile, Map<String, Object> replacements) throws MigrationException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            List<String> statements = this.readStatements(scriptFile, replacements);
            this.connection.setAutoCommit(true);
            statement = this.connection.createStatement();
            for (String statementString : statements) {
                statement.execute(statementString);
            }
        }
        catch (Exception e) {
            try {
                throw new MigrationException("Failed to execute script: " + scriptFile, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                DbUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeStatement(String statementString) throws SQLException {
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            int n = statement.executeUpdate(statementString);
            return n;
        }
        finally {
            DbUtils.close((Statement)statement);
        }
    }

    protected boolean scriptExists(String scriptResourceName) {
        if (((String)scriptResourceName).charAt(0) != '/' && this.defaultScriptPath != null) {
            scriptResourceName = this.defaultScriptPath + "/" + (String)scriptResourceName;
        }
        try {
            ResourceUtil.getResourceStream(this.getClass(), (String)scriptResourceName);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    protected List<String> readStatements(String scriptResourceName) throws IOException {
        return this.readStatements(scriptResourceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> readStatements(String scriptResourceName, Map<String, Object> replacements) throws IOException {
        ArrayList<String> script = new ArrayList<String>();
        Scanner scanner = null;
        if (((String)scriptResourceName).charAt(0) != '/' && this.defaultScriptPath != null) {
            scriptResourceName = this.defaultScriptPath + "/" + (String)scriptResourceName;
        }
        try {
            scanner = new Scanner(IOUtils.toString((InputStream)ResourceUtil.getResourceStream(this.getClass(), (String)scriptResourceName)));
            while (scanner.hasNextLine()) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean blankLine = false;
                while (scanner.hasNextLine() && !blankLine) {
                    String temp = scanner.nextLine();
                    if (temp.trim().length() > 0) {
                        stringBuilder.append(temp + " ");
                        continue;
                    }
                    blankLine = true;
                }
                String statementString = StringUtils.removeEnd((String)stringBuilder.toString().trim(), (String)";");
                if (statementString.length() <= 0) continue;
                if (replacements != null && !replacements.isEmpty()) {
                    for (String key : replacements.keySet()) {
                        statementString = StringUtils.replace((String)statementString, (String)("${" + key + "}"), (String)replacements.get(key).toString());
                    }
                }
                script.add(statementString);
            }
            ArrayList<String> arrayList = script;
            return arrayList;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }
}

