/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.client.core.Version;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ExportClearable;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ConfigurationMigrator;
import com.mirth.connect.server.migration.LegacyMigrator;
import com.mirth.connect.server.migration.Migrate2_0_0;
import com.mirth.connect.server.migration.Migrate2_2_0;
import com.mirth.connect.server.migration.Migrate3_0_0;
import com.mirth.connect.server.migration.Migrate3_0_2;
import com.mirth.connect.server.migration.Migrate3_11_0;
import com.mirth.connect.server.migration.Migrate3_12_0;
import com.mirth.connect.server.migration.Migrate3_1_0;
import com.mirth.connect.server.migration.Migrate3_1_1;
import com.mirth.connect.server.migration.Migrate3_2_0;
import com.mirth.connect.server.migration.Migrate3_2_2;
import com.mirth.connect.server.migration.Migrate3_3_0;
import com.mirth.connect.server.migration.Migrate3_4_0;
import com.mirth.connect.server.migration.Migrate3_5_0;
import com.mirth.connect.server.migration.Migrate3_7_0;
import com.mirth.connect.server.migration.Migrate3_8_0;
import com.mirth.connect.server.migration.Migrate4_0_0;
import com.mirth.connect.server.migration.Migrate4_1_0;
import com.mirth.connect.server.migration.Migrate4_3_0;
import com.mirth.connect.server.migration.Migrate4_4_0;
import com.mirth.connect.server.migration.Migrate4_5_2;
import com.mirth.connect.server.migration.Migrate4_6_0;
import com.mirth.connect.server.migration.Migrator;
import com.mirth.connect.server.util.DatabaseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerMigrator
extends Migrator {
    private Logger logger = LogManager.getLogger(this.getClass());

    public ServerMigrator() {
        this.setDefaultScriptPath("/deltas");
    }

    @Override
    public void migrate() throws MigrationException {
        Connection connection;
        try {
            connection = this.getConnection();
        }
        catch (SQLException e) {
            throw new MigrationException(e);
        }
        this.initDatabase(connection);
        Version startingVersion = this.getCurrentVersion();
        if (startingVersion == null) {
            startingVersion = Version.values()[0];
        }
        this.setStartingVersion(startingVersion);
        for (Version version = startingVersion.getNextVersion(); version != null; version = version.getNextVersion()) {
            Migrator migrator = this.getMigrator(version);
            if (migrator != null) {
                this.logger.info("Migrating server to version " + String.valueOf(version));
                migrator.setStartingVersion(startingVersion);
                migrator.setConnection(connection);
                migrator.setDatabaseType(this.getDatabaseType());
                migrator.setDefaultScriptPath(this.getDefaultScriptPath());
                migrator.migrate();
            }
            this.updateVersion(version);
        }
    }

    @Override
    public void migrateSerializedData() {
        this.migrateSerializedData("SELECT ID, CHANNEL FROM CHANNEL", "UPDATE CHANNEL SET CHANNEL = ? WHERE ID = ?", Channel.class);
        this.migrateSerializedData("SELECT ID, ALERT FROM ALERT", "UPDATE ALERT SET ALERT = ? WHERE ID = ?", AlertModel.class);
        this.migrateSerializedData("SELECT ID, LIBRARY FROM CODE_TEMPLATE_LIBRARY", "UPDATE CODE_TEMPLATE_LIBRARY SET LIBRARY = ? WHERE ID = ?", CodeTemplateLibrary.class);
        this.migrateSerializedData("SELECT ID, CODE_TEMPLATE FROM CODE_TEMPLATE", "UPDATE CODE_TEMPLATE SET CODE_TEMPLATE = ? WHERE ID = ?", CodeTemplate.class);
    }

    public void migrateConfiguration(PropertiesConfiguration mirthConfig) throws MigrationException {
        Version startingVersion = Version.fromString((String)mirthConfig.getString("version"));
        for (Version version = Version.values()[1]; version != null; version = version.getNextVersion()) {
            Migrator migrator = this.getMigrator(version);
            if (migrator == null || !(migrator instanceof ConfigurationMigrator)) continue;
            migrator.setStartingVersion(startingVersion);
            this.runConfigurationMigrator((ConfigurationMigrator)((Object)migrator), mirthConfig, version);
        }
        mirthConfig.setProperty("version", (Object)Version.getLatest().toString());
        mirthConfig.getLayout().setBlancLinesBefore("version", 1);
        mirthConfig.getLayout().setComment("version", "Only used for migration purposes, do not modify");
    }

    private void runConfigurationMigrator(ConfigurationMigrator configurationMigrator, PropertiesConfiguration mirthConfig, Version version) {
        configurationMigrator.updateConfiguration(mirthConfig);
        LinkedHashMap<String, Object> addedProperties = new LinkedHashMap<String, Object>();
        Map<String, Object> propertiesToAdd = configurationMigrator.getConfigurationPropertiesToAdd();
        if (propertiesToAdd != null) {
            for (Map.Entry<String, Object> propertyToAdd : propertiesToAdd.entrySet()) {
                Object value;
                if (mirthConfig.containsKey(propertyToAdd.getKey())) continue;
                PropertiesConfigurationLayout layout = mirthConfig.getLayout();
                String key = propertyToAdd.getKey();
                Object comment = "";
                if (propertyToAdd.getValue() instanceof Pair) {
                    Pair pair = (Pair)propertyToAdd.getValue();
                    value = pair.getLeft();
                    comment = (String)pair.getRight();
                } else {
                    value = propertyToAdd.getValue();
                }
                mirthConfig.setProperty(key, value);
                if (addedProperties.isEmpty()) {
                    if (StringUtils.isNotEmpty((CharSequence)comment)) {
                        comment = "\n\n" + (String)comment;
                    }
                    comment = "The following properties were automatically added on startup for version " + String.valueOf(version) + (String)comment;
                }
                if (StringUtils.isNotEmpty((CharSequence)comment)) {
                    layout.setBlancLinesBefore(key, 1);
                    layout.setComment(key, (String)comment);
                }
                addedProperties.put(key, value);
            }
        }
        ArrayList<String> removedProperties = new ArrayList<String>();
        String[] propertiesToRemove = configurationMigrator.getConfigurationPropertiesToRemove();
        if (propertiesToRemove != null) {
            for (String propertyToRemove : propertiesToRemove) {
                if (!mirthConfig.containsKey(propertyToRemove)) continue;
                mirthConfig.clearProperty(propertyToRemove);
                removedProperties.add(propertyToRemove);
            }
        }
        if (!addedProperties.isEmpty() || !removedProperties.isEmpty()) {
            if (!addedProperties.isEmpty()) {
                this.logger.info("Adding properties in mirth.properties: " + String.valueOf(addedProperties));
            }
            if (!removedProperties.isEmpty()) {
                this.logger.info("Removing properties in mirth.properties: " + String.valueOf(removedProperties));
            }
        }
    }

    private Migrator getMigrator(Version version) {
        switch (version) {
            case V0: {
                return new LegacyMigrator(0);
            }
            case V1: {
                return new LegacyMigrator(1);
            }
            case V2: {
                return new LegacyMigrator(2);
            }
            case V3: {
                return new LegacyMigrator(3);
            }
            case V4: {
                return new LegacyMigrator(4);
            }
            case V5: {
                return new LegacyMigrator(5);
            }
            case V6: {
                return new LegacyMigrator(6);
            }
            case V7: {
                return new Migrate2_0_0();
            }
            case V8: {
                return new LegacyMigrator(8);
            }
            case V9: {
                return new Migrate2_2_0();
            }
            case V3_0_0: {
                return new Migrate3_0_0();
            }
            case V3_0_1: {
                return null;
            }
            case V3_0_2: {
                return new Migrate3_0_2();
            }
            case V3_0_3: {
                return null;
            }
            case V3_1_0: {
                return new Migrate3_1_0();
            }
            case V3_1_1: {
                return new Migrate3_1_1();
            }
            case V3_2_0: {
                return new Migrate3_2_0();
            }
            case V3_2_1: {
                return null;
            }
            case V3_2_2: {
                return new Migrate3_2_2();
            }
            case V3_3_0: {
                return new Migrate3_3_0();
            }
            case V3_3_1: {
                return null;
            }
            case V3_3_2: {
                return null;
            }
            case V3_4_0: {
                return new Migrate3_4_0();
            }
            case V3_4_1: {
                return null;
            }
            case V3_4_2: {
                return null;
            }
            case V3_5_0: {
                return new Migrate3_5_0();
            }
            case V3_5_1: {
                return null;
            }
            case V3_5_2: {
                return null;
            }
            case V3_6_0: {
                return null;
            }
            case V3_6_1: {
                return null;
            }
            case V3_6_2: {
                return null;
            }
            case V3_7_0: {
                return new Migrate3_7_0();
            }
            case V3_7_1: {
                return null;
            }
            case V3_8_0: {
                return new Migrate3_8_0();
            }
            case V3_8_1: {
                return null;
            }
            case V3_9_0: {
                return null;
            }
            case v3_9_1: {
                return null;
            }
            case v3_10_0: {
                return null;
            }
            case v3_10_1: {
                return null;
            }
            case v3_11_0: {
                return new Migrate3_11_0();
            }
            case v3_11_1: {
                return null;
            }
            case v3_12_0: {
                return new Migrate3_12_0();
            }
            case v4_0_0: {
                return new Migrate4_0_0();
            }
            case v4_0_1: {
                return null;
            }
            case v4_1_0: {
                return new Migrate4_1_0();
            }
            case v4_1_1: {
                return null;
            }
            case v4_2_0: {
                return null;
            }
            case v4_3_0: {
                return new Migrate4_3_0();
            }
            case v4_4_0: {
                return new Migrate4_4_0();
            }
            case v4_4_1: {
                return null;
            }
            case v4_5_0: {
                return null;
            }
            case v4_5_1: {
                return null;
            }
            case v4_5_2: {
                return new Migrate4_5_2();
            }
            case v4_5_3: {
                return new Migrate4_5_2();
            }
            case v4_5_4: {
                return null;
            }
            case v4_6_0: {
                return new Migrate4_6_0();
            }
            case v4_6_1: {
                return null;
            }
        }
        return null;
    }

    private void initDatabase(Connection connection) throws MigrationException {
        block4: {
            if (DatabaseUtil.tableExists(connection, "CONFIGURATION")) break block4;
            this.executeScript("/" + this.getDatabaseType() + "/" + this.getDatabaseType() + "-database.sql");
            PreparedStatement statement = null;
            try {
                statement = this.getConnection().prepareStatement("UPDATE PERSON_PASSWORD SET PASSWORD_DATE = ?");
                statement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                statement.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new MigrationException(e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Statement)statement);
            this.updateVersion(Version.getLatest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkStartupLockTable() {
        try {
            try {
                this.executeScript("/" + this.getDatabaseType() + "/" + this.getDatabaseType() + "-create-startup-lock-table.sql");
            }
            catch (Exception e) {
                this.logger.debug("Unable to create startup lock table.", (Throwable)e);
            }
            Connection connection = this.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = connection.prepareStatement("INSERT INTO STARTUP_LOCK (ID) VALUES (1)");
                int result = stmt.executeUpdate();
                if (result != 1) {
                    throw new SQLException("Got insert result: " + result);
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                this.logger.debug("Unable to insert into startup lock table.", (Throwable)e);
                return false;
            }
            finally {
                DbUtils.closeQuietly((Statement)stmt);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error checking startup lock table.", t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStartupLockTable() {
        try {
            Connection connection = this.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = connection.prepareStatement("DELETE FROM STARTUP_LOCK WHERE ID = 1");
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.logger.debug("Unable to delete row from startup lock table.", (Throwable)e);
            }
            finally {
                DbUtils.closeQuietly((Statement)stmt);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error clearing startup lock table.", t);
        }
    }

    private Version getCurrentVersion() throws MigrationException {
        Version version;
        ResultSet resultSet;
        Statement statement;
        block5: {
            statement = null;
            resultSet = null;
            statement = this.getConnection().createStatement();
            resultSet = statement.executeQuery("SELECT VERSION FROM SCHEMA_INFO");
            if (!resultSet.next()) break block5;
            Version version2 = Version.fromString((String)resultSet.getString(1));
            DbUtils.closeQuietly((ResultSet)resultSet);
            DbUtils.closeQuietly((Statement)statement);
            return version2;
        }
        try {
            version = null;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly((Statement)statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)resultSet);
        DbUtils.closeQuietly((Statement)statement);
        return version;
    }

    private void updateVersion(Version version) throws MigrationException {
        PreparedStatement statement = null;
        try {
            statement = this.getCurrentVersion() == null ? this.getConnection().prepareStatement("INSERT INTO SCHEMA_INFO (VERSION) VALUES (?)") : this.getConnection().prepareStatement("UPDATE SCHEMA_INFO SET VERSION = ?");
            statement.setString(1, version.getSchemaVersion());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("Failed to update database version information.", e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateSerializedData(String selectSql, String updateSql, Class<?> expectedClass) {
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        Connection connection = null;
        Statement selectStatement = null;
        PreparedStatement updateStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            selectStatement = connection.createStatement();
            resultSet = selectStatement.executeQuery(selectSql);
            while (resultSet.next()) {
                try {
                    String migratedData;
                    String id = resultSet.getString(1);
                    String serializedData = resultSet.getString(2);
                    Object obj = serializer.deserialize(serializedData, expectedClass);
                    if (obj instanceof ExportClearable) {
                        ((ExportClearable)obj).clearExportData();
                    }
                    if ((migratedData = serializer.serialize(obj)).equals(serializedData)) continue;
                    updateStatement = connection.prepareStatement(updateSql);
                    updateStatement.setString(1, migratedData);
                    updateStatement.setString(2, id);
                    updateStatement.executeUpdate();
                }
                catch (Exception e) {
                    this.logger.error("Failed to migrate serialized data", (Throwable)e);
                }
                finally {
                    DbUtils.closeQuietly(updateStatement);
                }
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error("Failed to migrate serialized data", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly((Statement)selectStatement);
                DbUtils.closeQuietly(updateStatement);
                throw throwable;
            }
            DbUtils.closeQuietly((ResultSet)resultSet);
            DbUtils.closeQuietly((Statement)selectStatement);
            DbUtils.closeQuietly(updateStatement);
        }
        DbUtils.closeQuietly((ResultSet)resultSet);
        DbUtils.closeQuietly((Statement)selectStatement);
        DbUtils.closeQuietly(updateStatement);
    }
}

