/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.servlets;

import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.model.ExtensionLibrary;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.tools.ClassPathResource;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.util.MirthSSLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;
import org.eclipse.jetty.io.RuntimeIOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebStartServlet
extends HttpServlet {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();

    protected long getLastModified(HttpServletRequest arg0) {
        return System.currentTimeMillis();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        try {
            response.setContentType("application/x-java-jnlp-file");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("X-Content-Type-Options", "nosniff");
            PrintWriter out = response.getWriter();
            Document jnlpDocument = null;
            PropertiesConfiguration mirthProperties = this.getMirthProperties();
            String contextPathProp = this.getContextPathProp(mirthProperties);
            if ((request.getRequestURI().equals(contextPathProp + "/webstart.jnlp") || request.getRequestURI().equals(contextPathProp + "/webstart")) && this.isWebstartRequestValid(request)) {
                jnlpDocument = this.getAdministratorJnlp(request);
                response.setHeader("Content-Disposition", "attachment; filename = \"webstart.jnlp\"");
            } else if (request.getServletPath().equals("/webstart/extensions") && this.isWebstartExtensionsRequestValid(request, contextPathProp)) {
                String extensionPath = this.getExtensionPath(request);
                jnlpDocument = this.getExtensionJnlp(this.getExtensionPath(request));
                response.setHeader("Content-Disposition", "attachment; filename = \"" + extensionPath + ".jnlp\"");
            } else {
                response.setContentType("");
            }
            DocumentSerializer docSerializer = new DocumentSerializer(true);
            docSerializer.toXML(jnlpDocument, out);
        }
        catch (RuntimeIOException rio) {
            this.logger.debug((Object)rio);
        }
        catch (Throwable t) {
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)t));
            throw new ServletException(t);
        }
    }

    private boolean isWebstartRequestValid(HttpServletRequest request) {
        Enumeration parameterNameIter = request.getParameterNames();
        while (parameterNameIter.hasMoreElements()) {
            String parameterName = (String)parameterNameIter.nextElement();
            if (!"maxHeapSize".equals(parameterName) && !"time".equals(parameterName)) {
                return false;
            }
            if ("maxHeapSize".equals(parameterName) && !request.getParameter(parameterName).matches("\\d+[kKmMgGtT]")) {
                return false;
            }
            if (!"time".equals(parameterName) || request.getParameter(parameterName).matches("\\d+")) continue;
            return false;
        }
        return true;
    }

    private boolean isWebstartExtensionsRequestValid(HttpServletRequest request, String contextPathProp) {
        return request.getParameterMap().isEmpty() && (contextPathProp + request.getServletPath() + "/" + this.getExtensionPath(request)).equals(StringUtils.removeEnd((String)request.getRequestURI(), (String)".jnlp"));
    }

    private String getExtensionPath(HttpServletRequest request) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)request.getPathInfo(), (String)"/"), (String)".jnlp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getAdministratorJnlp(HttpServletRequest request) throws Exception {
        String environmentName;
        Document document;
        InputStream clientJnlpIs = null;
        try {
            clientJnlpIs = ResourceUtil.getResourceStream(((Object)((Object)this)).getClass(), "mirth-client.jnlp");
            DocumentBuilderFactory dbf = WebStartServlet.getSecureDocumentBuilderFactory();
            document = dbf.newDocumentBuilder().parse(clientJnlpIs);
        }
        catch (Throwable throwable) {
            ResourceUtil.closeResourceQuietly(clientJnlpIs);
            throw throwable;
        }
        ResourceUtil.closeResourceQuietly(clientJnlpIs);
        Element jnlpElement = document.getDocumentElement();
        PropertiesConfiguration versionProperties = PropertiesConfigurationUtil.create();
        InputStream versionPropsIs = null;
        try {
            versionPropsIs = ResourceUtil.getResourceStream(((Object)((Object)this)).getClass(), "version.properties");
            versionProperties = PropertiesConfigurationUtil.create((InputStream)versionPropsIs);
        }
        catch (Throwable throwable) {
            ResourceUtil.closeResourceQuietly(versionPropsIs);
            throw throwable;
        }
        ResourceUtil.closeResourceQuietly(versionPropsIs);
        String version = versionProperties.getString("mirth.version");
        jnlpElement.setAttribute("version", version);
        Element informationElement = (Element)jnlpElement.getElementsByTagName("information").item(0);
        Element title = (Element)informationElement.getElementsByTagName("title").item(0);
        String titleText = title.getTextContent() + " " + version;
        String serverName = this.configurationController.getServerSettings().getServerName();
        if (StringUtils.isNotBlank((CharSequence)serverName)) {
            titleText = serverName + " - " + titleText;
        }
        if (StringUtils.isNotBlank((CharSequence)(environmentName = this.configurationController.getServerSettings().getEnvironmentName()))) {
            titleText = environmentName + " - " + titleText;
        }
        title.setTextContent(titleText);
        String scheme = request.getScheme();
        String serverHostname = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        PropertiesConfiguration mirthProperties = this.getMirthProperties();
        String codebase = mirthProperties.getString("codebase.webstart.url", scheme + "://" + serverHostname + ":" + serverPort + contextPath);
        jnlpElement.setAttribute("codebase", codebase);
        Object server = null;
        if (StringUtils.isNotBlank((CharSequence)mirthProperties.getString("server.url"))) {
            server = mirthProperties.getString("server.url");
        } else {
            int httpsPort = mirthProperties.getInt("https.port", 8443);
            String contextPathProp = this.getContextPathProp(mirthProperties);
            server = "https://" + serverHostname + ":" + httpsPort + contextPathProp;
        }
        Element resourcesElement = (Element)jnlpElement.getElementsByTagName("resources").item(0);
        String maxHeapSize = request.getParameter("maxHeapSize");
        if (StringUtils.isBlank((CharSequence)maxHeapSize)) {
            maxHeapSize = mirthProperties.getString("administrator.maxheapsize");
        }
        if (StringUtils.isNotBlank((CharSequence)maxHeapSize)) {
            NodeList j2seList = resourcesElement.getElementsByTagName("j2se");
            for (int i = 0; i < j2seList.getLength(); ++i) {
                Element j2se = (Element)j2seList.item(i);
                j2se.setAttribute("max-heap-size", maxHeapSize);
            }
        }
        ArrayList<String> defaultClientLibs = new ArrayList<String>();
        defaultClientLibs.add("mirth-client.jar");
        defaultClientLibs.add("mirth-client-core.jar");
        defaultClientLibs.add("mirth-crypto.jar");
        defaultClientLibs.add("mirth-vocab.jar");
        File clientLibDirectory = new File(WebStartServlet.getClientLibPath());
        for (String string : defaultClientLibs) {
            Element jarElement = document.createElement("jar");
            jarElement.setAttribute("download", "eager");
            jarElement.setAttribute("href", "webstart/client-lib/" + string);
            if (string.equals("mirth-client.jar")) {
                jarElement.setAttribute("main", "true");
            }
            jarElement.setAttribute("sha256", this.getDigest(clientLibDirectory, string));
            resourcesElement.appendChild(jarElement);
        }
        List<String> clientLibs = ControllerFactory.getFactory().createExtensionController().getClientLibraries();
        for (String clientLib : clientLibs) {
            if (defaultClientLibs.contains(clientLib)) continue;
            Iterator jarElement = document.createElement("jar");
            jarElement.setAttribute("download", "eager");
            jarElement.setAttribute("href", "webstart/client-lib/" + clientLib);
            jarElement.setAttribute("sha256", this.getDigest(clientLibDirectory, clientLib));
            resourcesElement.appendChild((Node)((Object)jarElement));
        }
        ArrayList<MetaData> arrayList = new ArrayList<MetaData>();
        arrayList.addAll(ControllerFactory.getFactory().createExtensionController().getConnectorMetaData().values());
        arrayList.addAll(ControllerFactory.getFactory().createExtensionController().getPluginMetaData().values());
        HashSet<String> extensionPathsToAddToJnlp = new HashSet<String>();
        for (MetaData extension : arrayList) {
            if (!this.extensionController.isExtensionEnabled(extension.getName()) || !this.doesExtensionHaveClientOrSharedLibraries(extension)) continue;
            extensionPathsToAddToJnlp.add(extension.getPath());
        }
        for (String extensionPath : extensionPathsToAddToJnlp) {
            Element extensionElement = document.createElement("extension");
            extensionElement.setAttribute("href", "webstart/extensions/" + extensionPath + ".jnlp");
            resourcesElement.appendChild(extensionElement);
        }
        Element applicationDescElement = (Element)jnlpElement.getElementsByTagName("application-desc").item(0);
        Element serverArgumentElement = document.createElement("argument");
        serverArgumentElement.setTextContent((String)server);
        applicationDescElement.appendChild(serverArgumentElement);
        Element versionArgumentElement = document.createElement("argument");
        versionArgumentElement.setTextContent(version);
        applicationDescElement.appendChild(versionArgumentElement);
        Object[] protocols = this.configurationController.getHttpsClientProtocols();
        Object[] cipherSuites = this.configurationController.getHttpsCipherSuites();
        if (!Arrays.areEqual((Object[])protocols, (Object[])MirthSSLUtil.DEFAULT_HTTPS_CLIENT_PROTOCOLS) || !Arrays.areEqual((Object[])cipherSuites, (Object[])MirthSSLUtil.DEFAULT_HTTPS_CIPHER_SUITES)) {
            Element sslArgumentElement = document.createElement("argument");
            sslArgumentElement.setTextContent("-ssl");
            applicationDescElement.appendChild(sslArgumentElement);
            Element protocolsArgumentElement = document.createElement("argument");
            protocolsArgumentElement.setTextContent(StringUtils.join((Object[])protocols, (char)','));
            applicationDescElement.appendChild(protocolsArgumentElement);
            Element cipherSuitesArgumentElement = document.createElement("argument");
            cipherSuitesArgumentElement.setTextContent(StringUtils.join((Object[])cipherSuites, (char)','));
            applicationDescElement.appendChild(cipherSuitesArgumentElement);
        }
        return document;
    }

    public static String getClientLibPath() {
        if (ClassPathResource.getResourceURI("client-lib") != null) {
            return ClassPathResource.getResourceURI("client-lib").getPath() + File.separator;
        }
        return ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "client-lib" + File.separator;
    }

    private boolean doesExtensionHaveClientOrSharedLibraries(MetaData extension) {
        for (ExtensionLibrary lib : extension.getLibraries()) {
            if (!lib.getType().equals((Object)ExtensionLibrary.Type.CLIENT) && !lib.getType().equals((Object)ExtensionLibrary.Type.SHARED)) continue;
            return true;
        }
        return false;
    }

    protected Document getExtensionJnlp(String extensionPath) throws Exception {
        ArrayList<MetaData> allExtensions = new ArrayList<MetaData>();
        allExtensions.addAll(ControllerFactory.getFactory().createExtensionController().getConnectorMetaData().values());
        allExtensions.addAll(ControllerFactory.getFactory().createExtensionController().getPluginMetaData().values());
        HashSet<String> librariesToAddToJnlp = new HashSet<String>();
        ArrayList<String> extensionsWithThePath = new ArrayList<String>();
        for (MetaData metaData : allExtensions) {
            if (!metaData.getPath().equals(extensionPath)) continue;
            extensionsWithThePath.add(metaData.getName());
            for (ExtensionLibrary library : metaData.getLibraries()) {
                if (!library.getType().equals((Object)ExtensionLibrary.Type.CLIENT) && !library.getType().equals((Object)ExtensionLibrary.Type.SHARED)) continue;
                librariesToAddToJnlp.add(library.getPath());
            }
        }
        if (extensionsWithThePath.isEmpty()) {
            throw new Exception("Extension metadata could not be located for the path: " + extensionPath);
        }
        DocumentBuilderFactory dbf = WebStartServlet.getSecureDocumentBuilderFactory();
        Document document = dbf.newDocumentBuilder().newDocument();
        Element jnlpElement = document.createElement("jnlp");
        Element informationElement = document.createElement("information");
        Element titleElement = document.createElement("title");
        titleElement.setTextContent("BridgeLink Extension - [" + StringUtils.join(extensionsWithThePath, (String)",") + "]");
        informationElement.appendChild(titleElement);
        Element vendorElement = document.createElement("vendor");
        vendorElement.setTextContent("NextGen Healthcare");
        informationElement.appendChild(vendorElement);
        jnlpElement.appendChild(informationElement);
        Element securityElement = document.createElement("security");
        securityElement.appendChild(document.createElement("all-permissions"));
        jnlpElement.appendChild(securityElement);
        Element resourcesElement = document.createElement("resources");
        File extensionDirectory = new File(ExtensionController.getExtensionsPath() + extensionPath);
        for (String library : librariesToAddToJnlp) {
            Element jarElement = document.createElement("jar");
            jarElement.setAttribute("download", "eager");
            jarElement.setAttribute("href", "libs/" + extensionPath + "/" + library);
            jarElement.setAttribute("sha256", this.getDigest(extensionDirectory, library));
            resourcesElement.appendChild(jarElement);
        }
        jnlpElement.appendChild(resourcesElement);
        jnlpElement.appendChild(document.createElement("component-desc"));
        document.appendChild(jnlpElement);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDigest(File directory, String filePath) throws Exception {
        String string;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            String canonicalDirPath = directory.getCanonicalPath();
            File file = new File(directory, filePath);
            String canonicalFilePath = file.getCanonicalPath();
            if (!StringUtils.startsWith((CharSequence)canonicalFilePath, (CharSequence)(canonicalDirPath + File.separator))) {
                throw new Exception("File " + filePath + " does not reside within directory " + String.valueOf(directory));
            }
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[4096];
            int c = 0;
            while ((c = bis.read(buffer)) != -1) {
                digest.update(buffer, 0, c);
            }
            string = Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (Throwable throwable) {
            ResourceUtil.closeResourceQuietly(bis);
            ResourceUtil.closeResourceQuietly(fis);
            throw throwable;
        }
        ResourceUtil.closeResourceQuietly(bis);
        ResourceUtil.closeResourceQuietly(fis);
        return string;
    }

    protected PropertiesConfiguration getMirthProperties() throws FileNotFoundException, ConfigurationException {
        PropertiesConfiguration mirthProperties = PropertiesConfigurationUtil.create();
        InputStream mirthPropsIs = null;
        try {
            mirthPropsIs = ResourceUtil.getResourceStream(((Object)((Object)this)).getClass(), "mirth.properties");
            mirthProperties = PropertiesConfigurationUtil.create((InputStream)mirthPropsIs);
        }
        catch (Throwable throwable) {
            ResourceUtil.closeResourceQuietly(mirthPropsIs);
            throw throwable;
        }
        ResourceUtil.closeResourceQuietly(mirthPropsIs);
        return mirthProperties;
    }

    private String getContextPathProp(PropertiesConfiguration mirthProperties) {
        Object contextPathProp = mirthProperties.getString("http.contextpath", "");
        if (!((String)contextPathProp).startsWith("/")) {
            contextPathProp = "/" + (String)contextPathProp;
        }
        if (((String)contextPathProp).endsWith("/")) {
            contextPathProp = ((String)contextPathProp).substring(0, ((String)contextPathProp).length() - 1);
        }
        return contextPathProp;
    }

    private static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf;
    }
}

