/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.transformers;

import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.components.PostProcessor;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.transformers.JavaScriptInitializationException;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptPostprocessor
implements PostProcessor {
    private Logger logger = LogManager.getLogger(this.getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Channel channel;
    private String scriptId;
    private volatile String contextFactoryId;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();
    private MirthMain debugger;
    private String postProcessingScript;
    private Boolean debug = false;

    public JavaScriptPostprocessor(Channel channel, String postProcessingScript, DebugOptions debugOptions) throws JavaScriptInitializationException {
        this.channel = channel;
        this.postProcessingScript = postProcessingScript;
        this.scriptId = ScriptController.getScriptId("Postprocessor", channel.getChannelId());
        this.debug = debugOptions != null && debugOptions.isDeployUndeployPreAndPostProcessorScripts();
        if (!this.debug.booleanValue()) {
            try {
                MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(channel.getResourceIds());
                this.contextFactoryId = contextFactory.getId();
                JavaScriptUtil.compileAndAddScript(channel.getChannelId(), contextFactory, this.scriptId, postProcessingScript, ContextType.CHANNEL_POSTPROCESSOR);
            }
            catch (Exception e2) {
                MirthJavascriptTransformerException e2;
                this.logger.error("Error compiling postprocessor script " + this.scriptId + ".", (Throwable)e2);
                if (e2 instanceof RhinoException) {
                    e2 = new MirthJavascriptTransformerException((RhinoException)e2, channel.getChannelId(), null, 0, ErrorEventType.POSTPROCESSOR_SCRIPT.toString(), null);
                }
                this.logger.error(ErrorMessageBuilder.buildErrorMessage(ErrorEventType.POSTPROCESSOR_SCRIPT.toString(), null, e2));
                throw new JavaScriptInitializationException("Error initializing JavaScript Postprocessor", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPostProcess(Message message) throws DonkeyException, InterruptedException {
        try {
            MirthContextFactory contextFactory;
            block13: {
                try {
                    HashMap<String, MirthContextFactory> contextFactories = new HashMap<String, MirthContextFactory>();
                    if (this.debug.booleanValue()) {
                        String postProcessingScriptId = ScriptController.getScriptId("Postprocessor", this.channel.getChannelId());
                        contextFactory = this.getContextFactory();
                        this.contextFactoryId = contextFactory.getId();
                        contextFactory.setContextType(ContextType.CHANNEL_POSTPROCESSOR);
                        contextFactory.setScriptText(this.postProcessingScript);
                        contextFactory.setDebugType(true);
                        contextFactories.put(postProcessingScriptId, contextFactory);
                        if (JavaScriptUtil.getCompiledScript(this.scriptId) != null) {
                            this.debugger = JavaScriptUtil.getDebugger(contextFactory, this.scopeProvider, this.channel, this.scriptId, true);
                        }
                        break block13;
                    }
                    contextFactory = this.getContextFactory();
                    if (this.contextFactoryId.equals(contextFactory.getId())) break block13;
                    JavaScriptPostprocessor javaScriptPostprocessor = this;
                    synchronized (javaScriptPostprocessor) {
                        contextFactory = this.getContextFactory();
                        if (!this.contextFactoryId.equals(contextFactory.getId())) {
                            JavaScriptUtil.recompileGeneratedScript(contextFactory, this.scriptId);
                            this.contextFactoryId = contextFactory.getId();
                        }
                    }
                }
                catch (Exception e2) {
                    MirthJavascriptTransformerException e2;
                    this.logger.error("Error compiling postprocessor script " + this.scriptId + ".", (Throwable)e2);
                    if (e2 instanceof RhinoException) {
                        e2 = new MirthJavascriptTransformerException((RhinoException)e2, this.channel.getChannelId(), null, 0, ErrorEventType.POSTPROCESSOR_SCRIPT.toString(), null);
                    }
                    this.logger.error(ErrorMessageBuilder.buildErrorMessage(ErrorEventType.POSTPROCESSOR_SCRIPT.toString(), null, e2));
                    throw new JavaScriptInitializationException("Error initializing JavaScript Postprocessor", e2);
                }
            }
            return JavaScriptUtil.executeJavaScriptPostProcessorTask(new JavaScriptPostProcessorTask(contextFactory, message), message.getChannelId());
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof JavaScriptExecutorException) {
                t = e.getCause();
            }
            this.eventController.dispatchEvent((Event)new ErrorEvent(message.getChannelId(), null, message.getMessageId(), ErrorEventType.POSTPROCESSOR_SCRIPT, null, null, "Error running postprocessor scripts", t));
            throw new DonkeyException(t, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.POSTPROCESSOR_SCRIPT.toString(), "Error running postprocessor scripts", t));
        }
    }

    protected MirthContextFactory getContextFactory() throws Exception {
        if (this.debug.booleanValue()) {
            return this.contextFactoryController.getDebugContextFactory(this.channel.getResourceIds(), this.channel.getChannelId(), this.scriptId);
        }
        return this.contextFactoryController.getContextFactory(this.channel.getResourceIds());
    }

    private class JavaScriptPostProcessorTask
    extends JavaScriptTask<Object> {
        private Message message;

        public JavaScriptPostProcessorTask(MirthContextFactory contextFactory, Message message) {
            super(contextFactory, "Postprocessor", JavaScriptPostprocessor.this.channel.getChannelId(), JavaScriptPostprocessor.this.channel.getName());
            this.message = message;
        }

        @Override
        public Object doCall() throws Exception {
            if (JavaScriptPostprocessor.this.debug.booleanValue() && JavaScriptPostprocessor.this.debugger != null) {
                JavaScriptPostprocessor.this.debugger.doBreak();
                if (!JavaScriptPostprocessor.this.debugger.isVisible()) {
                    JavaScriptPostprocessor.this.debugger.setVisible(true);
                }
            }
            return JavaScriptUtil.executePostprocessorScripts(this, this.message);
        }
    }
}

